# Test the limits of bytecode generation.

import sys

# Tune the test parameters based on the target's bytecode generator.
if hasattr(sys.implementation, "_mpy"):
    # Target can load .mpy files so generated bytecode uses 1 byte per qstr.
    number_of_body_copies = (433, 432, 431, 399)
else:
    # Target can't load .mpy files so generated bytecode uses 2 bytes per qstr.
    number_of_body_copies = (401, 400, 399, 398)

body = " with f()()() as a:\n  try:\n   f()()()\n  except Exception:\n   pass\n"

# Test overflow of jump offset.
# Print results at the end in case an intermediate value of n fails with MemoryError.
results = []
for n in number_of_body_copies:
    try:
        exec("cond = 0\nif cond:\n" + body * n + "else:\n print('cond false')\n")
        results.append("ok")
    except MemoryError:
        print("SKIP")
        raise SystemExit
    except RuntimeError as er:
        results.append(repr(er))
print(results)

# Test changing size of code info (source line/bytecode mapping) due to changing
# bytecode size in the final passes.  This test is very specific to how the
# code info is encoded, and how jump offsets shrink in the final passes.  This
# test should fail if the bytecode emitter doesn't correctly handle shrinking of
# the code info section.
exec(
    """
x = 0
if x:
"""
    + body * 13
    + """
x = [1 if x else 123]






print(x)
"""
)
