
#define COL_WHITE_BIT           0x01
#define COL_BLUE_BIT            0x02
#define COL_BLACK_BIT           0x04
#define COL_RED_BIT             0x08
#define COL_GREEN_BIT           0x10
#define COL_GOLD_BIT            0x20
#define COL_ARTIFACT_BIT        0x40
#define COL_LAND_BIT            0x80

struct cardbase {
    int num_cards;
    struct cardinfo *cards;
    int num_extras;
    struct cardinfo **extras;
};

struct cardinfo {
    char *name;
    int location;
    unsigned char color;
    char *expansion;
    char *cardtype;
    char *cost;
    char *pow_tgh;
    char *text;
    char *flavor;
    struct cardart *art;
};

struct cardbase *cardbase_new_from_dat (const char *filename);
struct cardbase *cardbase_new_from_ort (const char *filename);
int cardbase_find_globalid (struct cardbase *db, const char *name);
struct cardinfo *cardbase_get_card (struct cardbase *db, int globalid);
int cardbase_add_card (struct cardbase *db, const char *, char *, int);
