#include <sys/types.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include "random.h"

static int random_fd = -1;

void initialize_random_numbers (void)
{
    random_fd = open("/dev/random", O_NONBLOCK | O_RDONLY);
    srand (time (NULL) * getpid ());
}

int random_number (int max)
{
    int n_max;
    unsigned char byte;

    if ((max <= 255) && (random_fd >= 0)) {
	n_max = max * ((int) (256 / max));
	while (read (random_fd, &byte, 1) == 1) {
	    if (byte < n_max)
		return (byte % max);
	}
    }
    return (((unsigned short) rand ()) % max);
}
