
#include "mindless.h"

struct deck {
    char *name;
    char *filename;
    int size;
    int alloced;
    int *cardlist;
    int sb_size;
    int sb_alloced;
    int *sb_cardlist;
    int tk_size;
    int tk_alloced;
    int *tk_cardlist;
    int security_code;
};

struct deck *deck_new (void);
struct deck *deck_read_file (const char *filename, struct cardbase *db);
void deck_set_card (struct deck *deck, int idx, int qty, int globalid);
void deck_set_sb_card (struct deck *deck, int idx, int qty, int globalid);
void deck_set_token (struct deck *deck, int idx, int qty, int globalid);
int deck_lookup (struct deck *deck, int cid);
void deck_remove_tokens (struct deck *deck);
void deck_destroy (struct deck *);
void deck_write_file (const char *filename, struct deck *, struct cardbase *);
