#define UNTAP_PHASE	0
#define UPKEEP_PHASE	1
#define DRAW_PHASE	2
#define MAIN_PHASE	3
#define COMBAT_PHASE	4
#define CLEANUP_PHASE	5
#define NUM_PHASES	6

struct game {
    struct cardbase *cardbase;
    struct expansions *expansions;
    struct prefs *prefs;
    int num_players;
    int local_player;
    int current_player;
    struct player **player;
    struct playarea *playarea;
    int turn_number;
    int phase_number;
    int no_view_sideboard;
    struct opponent *opponent;

    GtkWidget *main_window;
    GtkWidget *message_box, *entry_box;
    GtkWidget *phase_button[NUM_PHASES];
    GtkWidget *player_vbox;
    GtkWidget *new_game_dialog;
    GtkWidget *view_card_dialog;
};

struct point {
    int x;
    int y;
};

struct table_card {
    int cid;
    int xpos;
    int ypos;
    int flags;
    int color;
    int counters;
    int controller;
};

#define CARD_TAPPED_FLAG	0x01
#define CARD_ATTACK_FLAG	0x02
#define CARD_NO_UNTAP_FLAG	0x04
#define CARD_PHASED_FLAG	0x08
#define CARD_FLIPPED_FLAG	0x10

struct card_move {
    int pid;
    int srcznum;
    int idx;
    int dstznum;
    int bottom;
    int cid;
};

extern char *color_names[];
extern GtkTargetEntry target_table[];
extern int num_targets;

extern const char *oracle_name_key;
extern const char *cardinfo_name_key;
extern const char *player_name_key;
extern const char *deck_name_key;
extern const char *starting_life_key;
extern const char *starting_hand_size_key;
extern const char *starting_message_key;
extern const char *card_pic_type_key;
extern const char *zoom_ratio_key;
extern const char *background_key;
extern const char *background_type_key;

struct game *game_new (void);
void game_empty_all_zones (struct game *game);
struct cardinfo *game_get_cardinfo (struct game *, int);
char *game_get_card_name (struct game *, int);
int owner_of_card (struct game *, int);
int controller_of_card (struct game *game, int cid);
int find_card_zone (struct game *, int, int *, int *, int *);
int widget_to_zone (struct game *, GtkWidget *w, int *pidp);
char *name_of_zone (int);
void game_draw_cards (struct game *game, int pid, int qty);
void game_play_card (struct game *, struct table_card *, int, int, int, int);
void game_unplay_card (struct game *, int, int, int, int, int);
void game_move_card (struct game *, struct card_move *);
void game_move_card_message (struct game *, struct card_move *);
void game_rearrange_message (struct game *, int, int, int);
void game_inform_peeking (struct game *, int, int, int, int, int);
int game_create_card (struct game *, int, char *, int, int, char *, int);
void game_make_transient (struct game *game, GtkWidget *dialog);
void display_message (struct game *, char *, ...);
void strcat_current_time (char *message);
void game_flip_coin (struct game *, int, int);
void game_roll_die (struct game *, int, int, int);
void set_card_controller (struct game *, struct table_card *, int, int);
void set_card_counters (struct game *, struct table_card *, int);
void set_table_card_flag (struct game *, struct table_card *, int, int, int);
void set_table_card_color (struct game *, struct table_card *, int, int);
void set_game_phase (struct game *, int);
void set_game_turn (struct game *, int);
void set_player_life (struct game *, int, int);
void set_player_name (struct game *, int, const char *);
void set_card_location (struct game *, int, int, int, int, int, int, int);
void game_show_random (struct game *game, int pid, int cid);
int color_name_to_number (char *ctext);
int color_bits_to_number (int cbits);
int pid_of_single_opponent (struct game *game);
void game_save_deck (struct game *game, int pid);
void game_load_expansions (struct game *game);

#include "kplayer.h"
