#include <gtk/gtk.h>
#include "images.h"
#include "_images.c"

void add_stock_images (GtkWidget *widget)
{
    GtkIconFactory *factory;
    GtkStyle *style;
    GdkPixbuf *pixbuf;
    GtkIconSet *iconset;

    factory = gtk_icon_factory_new ();
    style = gtk_widget_get_style (widget);

    iconset = gtk_style_lookup_icon_set (style, GTK_STOCK_REFRESH);
    gtk_icon_factory_add (factory, M_NEW_ICON, iconset);

    iconset = gtk_style_lookup_icon_set (style, GTK_STOCK_UNDO);
    gtk_icon_factory_add (factory, M_UNTAP_ICON, iconset);

    iconset = gtk_style_lookup_icon_set (style, GTK_STOCK_GO_DOWN);
    gtk_icon_factory_add (factory, M_DRAW_ICON, iconset);

    pixbuf = gdk_pixbuf_new_from_inline (-1, lifeset_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_LIFESET_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    iconset = gtk_style_lookup_icon_set (style, GTK_STOCK_REMOVE);
    gtk_icon_factory_add (factory, M_LIFEMINUS_ICON, iconset);

    iconset = gtk_style_lookup_icon_set (style, GTK_STOCK_ADD);
    gtk_icon_factory_add (factory, M_LIFEPLUS_ICON, iconset);

    pixbuf = gdk_pixbuf_new_from_inline (-1, ping_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_PING_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, deck_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_DECK_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, graveyard_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_GRAVEYARD_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, removed_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_REMOVED_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, coin_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_COIN_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, die_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_DIE_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, hand_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_HAND_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, phaseuntap_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_UNTAP_PHASE_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, phaseupkeep_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_UPKEEP_PHASE_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, phasedraw_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_DRAW_PHASE_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, phasemain_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_MAIN_PHASE_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, phasecombat_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_COMBAT_PHASE_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    pixbuf = gdk_pixbuf_new_from_inline (-1, phasecleanup_image, FALSE, NULL);
    iconset = gtk_icon_set_new_from_pixbuf (pixbuf);
    gtk_icon_factory_add (factory, M_CLEANUP_PHASE_ICON, iconset);
    g_object_unref (G_OBJECT (pixbuf));

    gtk_icon_factory_add_default (factory);
}
