
struct zone {
    struct game *game;
    int size;
    int alloced;
    int *cardlist;
    int flags;
    GtkWidget *box;
    GtkWidget *list;
    GtkWidget *dialog;
    GtkWidget *label;
    int top_cards_requested;

    /* Information about the card being dragged */
    int drag_beginning;
    int drag_from_list;
    int x, y;
};

#define ZONE_DISPLAY_HAND	0x01
#define ZONE_PRIVATE		0x02
#define ZONE_SHUFFLE_CLOSE	0x04
#define ZONE_SHOW_ORDER		0x08

struct zone *zone_new (struct game *game);
void zone_add_deck (struct zone *zone, int offset, int size);
void zone_shuffle (struct zone *zone);
void zone_add_card (struct zone *zone, int card, int bottom);
int zone_remove_card (struct zone *zone, int idx);
int zone_move_card (struct zone *zone, int idx, int other);
void zone_reset (struct zone *zone);
void zone_destroy (struct zone *zone);

void zone_set_label (struct zone *zone, GtkWidget *label);
GtkWidget *zone_create_clist (struct zone *zone, int qty);
void zone_set_list (struct zone *zone, GtkWidget *list);
void zone_set_box (struct zone *zone, GtkWidget *box, int sourcep);
int zone_dragged_card_idx (struct zone *zone);
void zone_refresh_list_display (struct zone *zone);
