/* __gmp_fprintf_funs -- support for formatted output to FILEs.

   THE FUNCTIONS IN THIS FILE ARE FOR INTERNAL USE ONLY.  THEY'RE ALMOST
   CERTAIN TO BE SUBJECT TO INCOMPATIBLE CHANGES OR DISAPPEAR COMPLETELY IN
   FUTURE GNU MP RELEASES.

Copyright 2001 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA. */

#include "config.h"

#if HAVE_STDARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include <stdio.h>
#include <string.h>

#include "mpir.h"
#include "gmp-impl.h"

/* SunOS 4 stdio.h doesn't provide a prototype for this */
#if ! HAVE_DECL_VFPRINTF
int vfprintf _PROTO ((FILE *fp, const char *fmt, va_list ap));
#endif


static int
gmp_fprintf_memory (FILE *fp, const char *str, size_t len)
{
  return fwrite (str, 1, len, fp);
}

/* glibc putc is a function, at least when it's in multi-threaded mode or
   some such, so fwrite chunks instead of making many calls. */
static int
gmp_fprintf_reps (FILE *fp, int c, int reps)
{
  char  buf[256];
  int   i, piece, ret;
  ASSERT (reps >= 0);

  memset (buf, c, MIN (reps, sizeof (buf)));
  for (i = reps; i > 0; i -= sizeof (buf))
    {
      piece = MIN (i, sizeof (buf));
      ret = fwrite (buf, 1, piece, fp);
      if (ret == -1)
        return ret;
      ASSERT (ret == piece);
    }

  return reps;
}

const struct doprnt_funs_t  __gmp_fprintf_funs = {
  (doprnt_format_t) vfprintf,
  (doprnt_memory_t) gmp_fprintf_memory,
  (doprnt_reps_t)   gmp_fprintf_reps,
};
