/* Copyright (c) 2012, Peter A. Bigot
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

	.section .text.sjlj
	
/* Preserve 20-bit register values if SR20 is enabled for at least
 * interrupts.  Use a 20-bit return if -mc20 was specified.  Keep
 * these checks consistent with msp430-libc's setjmp.S source file. */
	
#if __MSP430X__ & (__MSP430_CPUX_TARGET_SR20__ | __MSP430_CPUX_TARGET_ISR20__)
#define SAVEREG_SIZE 4
#define	MOVX	mova
#else /* any SR20 */
#define SAVEREG_SIZE 2
#define	MOVX	mov
#endif /* any SR20 */
#if __MSP430X__ & __MSP430_CPUX_TARGET_C20__
#define	BRX	bra
#else /* C20 */
#define	BRX	br
#endif /* C20 */

#if __MSP430X__ - 0	
	.cpux_target	bits=__MSP430X__ ; Encode build options for link-time validation
#endif /* __MSP430X__ */	

	.global	setjmp
	.type	setjmp, @function
	.func	setjmp
setjmp:
#if __MSP430X__ & __MSP430_CPUX_TARGET_C20__
	popx.a	r14
	mova	r14, 10*SAVEREG_SIZE(r15)
#else /* C20 */
	pop	r14
	mov	r14, 10*SAVEREG_SIZE(r15)
#endif /* C20 */
	MOVX	r1, 0*SAVEREG_SIZE(r15)
	MOVX	r2, 1*SAVEREG_SIZE(r15)
	MOVX	r4, 2*SAVEREG_SIZE(r15)
	MOVX	r5, 3*SAVEREG_SIZE(r15)
	MOVX	r6, 4*SAVEREG_SIZE(r15)
	MOVX	r7, 5*SAVEREG_SIZE(r15)
	MOVX	r8, 6*SAVEREG_SIZE(r15)
	MOVX	r9, 7*SAVEREG_SIZE(r15)
	MOVX	r10, 8*SAVEREG_SIZE(r15)
	MOVX	r11, 9*SAVEREG_SIZE(r15)
	clr	r15
	BRX	r14
.endfunc
        
	.global longjmp
	.type	longjmp, @function
	.func	longjmp
longjmp:
#if __MSP430X__
	mova	r15, r13	; Preserve all available bits of env pointer
#else
	mov	r15, r13
#endif
	mov	r14, r15	; Return value is int
	MOVX	@r13+, r1
	MOVX	@r13+, r2
	MOVX	@r13+, r4
	MOVX	@r13+, r5
	MOVX	@r13+, r6
	MOVX	@r13+, r7
	MOVX	@r13+, r8
	MOVX	@r13+, r9
	MOVX	@r13+, r10
	MOVX	@r13+, r11
	BRX	@r13
.endfunc
