/* Generated by re2c 0.14.3 on Wed May 23 14:18:41 2018 */
/**

	MultiMarkdown 6 -- Lightweight markup processor to produce HTML, LaTeX, and more.

	@file lexer.re

	@brief Description of the regular expressions used to define tokens, 
	used by re2c to create a lexer/tokenizer.


	@author	Fletcher T. Penney
	@bug	

**/

/*

	Copyright © 2016 - 2017 Fletcher T. Penney.


	The `MultiMarkdown 6` project is released under the MIT License..
	
	GLibFacade.c and GLibFacade.h are from the MultiMarkdown v4 project:
	
		https://github.com/fletcher/MultiMarkdown-4/
	
	MMD 4 is released under both the MIT License and GPL.
	
	
	CuTest is released under the zlib/libpng license. See CuTest.c for the text
	of the license.
	
	
	## The MIT License ##
	
	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:
	
	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.

*/

#include "lexer.h"
#include "libMultiMarkdown.h"
#include "parser.h"


// Basic scanner struct

#define YYCTYPE		unsigned char
#define YYCURSOR	s->cur
#define YYMARKER	s->ptr
#define YYCTXMARKER	s->ctx

int scan(Scanner * s, const char * stop) {

	scan:

	if (s->cur >= stop) {
		return 0;
	}

	s->start = s->cur;

	
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;

	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case 0x01:
	case 0x02:
	case 0x03:
	case 0x04:
	case 0x05:
	case 0x06:
	case 0x07:
	case 0x08:
	case '\v':
	case '\f':
	case 0x0E:
	case 0x0F:
	case 0x10:
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
	case 0x15:
	case 0x16:
	case 0x17:
	case 0x18:
	case 0x19:
	case 0x1A:
	case 0x1B:
	case 0x1C:
	case 0x1D:
	case 0x1E:
	case 0x1F:
	case ',':
	case ';':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0x7F:	goto yy66;
	case '\t':	goto yy51;
	case '\n':	goto yy3;
	case '\r':	goto yy5;
	case ' ':	goto yy6;
	case '!':	goto yy25;
	case '"':	goto yy34;
	case '#':	goto yy53;
	case '$':	goto yy47;
	case '%':	goto yy55;
	case '&':	goto yy41;
	case '\'':	goto yy36;
	case '(':	goto yy26;
	case ')':	goto yy28;
	case '*':	goto yy58;
	case '+':	goto yy11;
	case '-':	goto yy13;
	case '.':	goto yy38;
	case '/':	goto yy43;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy57;
	case ':':	goto yy39;
	case '<':	goto yy15;
	case '=':	goto yy19;
	case '>':	goto yy30;
	case '[':	goto yy21;
	case '\\':	goto yy45;
	case ']':	goto yy23;
	case '^':	goto yy49;
	case '_':	goto yy60;
	case '`':	goto yy62;
	case '{':	goto yy9;
	case '|':	goto yy64;
	case '}':	goto yy32;
	case '~':	goto yy17;
	case 0xC2:	goto yy8;
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy67;
	case 0xE0:	goto yy68;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy69;
	case 0xF0:	goto yy70;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy71;
	case 0xF4:	goto yy72;
	default:	goto yy2;
	}
yy2:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0: 	goto yy4;
	case 1: 	goto yy7;
	case 2: 	goto yy10;
	case 3: 	goto yy12;
	case 4: 	goto yy16;
	case 5: 	goto yy18;
	case 6: 	goto yy20;
	case 7: 	goto yy42;
	case 8: 	goto yy54;
	case 9: 	goto yy81;
	case 10: 	goto yy89;
	case 11: 	goto yy96;
	case 12: 	goto yy105;
	case 13: 	goto yy112;
	case 14: 	goto yy121;
	case 15: 	goto yy128;
	case 16: 	goto yy284;
	case 17: 	goto yy307;
	case 18: 	goto yy314;
	default:	goto yy326;
	}
yy3:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy333;
	default:	goto yy4;
	}
yy4:
	{ return TEXT_NL; }
yy5:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy3;
	case ' ':	goto yy333;
	default:	goto yy4;
	}
yy6:
	YYCTXMARKER = YYCURSOR + 1;
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy309;
	case '\n':	goto yy331;
	case '\r':	goto yy332;
	case ' ':	goto yy306;
	case 0xC2:	goto yy308;
	default:	goto yy7;
	}
yy7:
	{ goto scan; }
yy8:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy66;
	case 0xA0:	goto yy305;
	default:	goto yy2;
	}
yy9:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '+':	goto yy288;
	case '-':	goto yy287;
	case '=':	goto yy281;
	case '>':	goto yy286;
	case '{':	goto yy283;
	case '~':	goto yy285;
	default:	goto yy10;
	}
yy10:
	{ return TEXT_BRACE_LEFT; }
yy11:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '+':	goto yy278;
	default:	goto yy12;
	}
yy12:
	{ return PLUS; }
yy13:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '-':	goto yy270;
	default:	goto yy14;
	}
yy14:
	{ return DASH_N; }
yy15:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '!':	goto yy263;
	case '<':	goto yy264;
	default:	goto yy16;
	}
yy16:
	{ return ANGLE_LEFT; }
yy17:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '>':	goto yy259;
	case '~':	goto yy258;
	default:	goto yy18;
	}
yy18:
	{ return SUBSCRIPT; }
yy19:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '=':	goto yy255;
	default:	goto yy20;
	}
yy20:
	{ return EQUAL; }
yy21:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '#':	goto yy251;
	case '%':	goto yy245;
	case '>':	goto yy253;
	case '?':	goto yy247;
	case '^':	goto yy249;
	default:	goto yy22;
	}
yy22:
	{ return BRACKET_LEFT; }
yy23:
	++YYCURSOR;
	{ return BRACKET_RIGHT; }
yy25:
	yych = *++YYCURSOR;
	switch (yych) {
	case '[':	goto yy243;
	default:	goto yy7;
	}
yy26:
	++YYCURSOR;
	{ return PAREN_LEFT; }
yy28:
	++YYCURSOR;
	{ return PAREN_RIGHT; }
yy30:
	++YYCURSOR;
	{ return ANGLE_RIGHT; }
yy32:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '}':	goto yy241;
	default:	goto yy33;
	}
yy33:
	{ return TEXT_BRACE_RIGHT; }
yy34:
	++YYCURSOR;
	{ return QUOTE_DOUBLE; }
yy36:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\'':	goto yy239;
	default:	goto yy37;
	}
yy37:
	{ return QUOTE_SINGLE; }
yy38:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy231;
	case '.':	goto yy232;
	default:	goto yy7;
	}
yy39:
	++YYCURSOR;
	{ return COLON; }
yy41:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '#':	goto yy215;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy212;
	case 'A':
	case 'a':	goto yy214;
	default:	goto yy42;
	}
yy42:
	{ return AMPERSAND; }
yy43:
	++YYCURSOR;
	{ return SLASH; }
yy45:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy135;
	case '\r':	goto yy137;
	case ' ':	goto yy140;
	case '!':	goto yy200;
	case '"':	goto yy190;
	case '#':	goto yy170;
	case '$':	goto yy168;
	case '%':	goto yy166;
	case '&':	goto yy154;
	case '\'':	goto yy188;
	case '(':	goto yy182;
	case ')':	goto yy180;
	case '*':	goto yy146;
	case '+':	goto yy164;
	case ',':	goto yy196;
	case '-':	goto yy162;
	case '.':	goto yy202;
	case '/':	goto yy150;
	case ':':	goto yy192;
	case ';':	goto yy194;
	case '<':	goto yy158;
	case '=':	goto yy160;
	case '>':	goto yy156;
	case '?':	goto yy198;
	case '@':	goto yy152;
	case '[':	goto yy174;
	case '\\':	goto yy138;
	case ']':	goto yy172;
	case '^':	goto yy148;
	case '_':	goto yy144;
	case '`':	goto yy186;
	case '{':	goto yy178;
	case '|':	goto yy142;
	case '}':	goto yy176;
	case '~':	goto yy184;
	default:	goto yy46;
	}
yy46:
	{ return TEXT_BACKSLASH; }
yy47:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '$':	goto yy133;
	default:	goto yy48;
	}
yy48:
	{ return MATH_DOLLAR_SINGLE; }
yy49:
	++YYCURSOR;
	{ return SUPERSCRIPT; }
yy51:
	++YYCURSOR;
	{ return INDENT_TAB; }
yy53:
	YYCTXMARKER = YYCURSOR + 1;
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 0x00:
	case '\t':
	case '\n':
	case '\r':
	case ' ':
	case 0xC2:	goto yy88;
	case '#':	goto yy86;
	default:	goto yy54;
	}
yy54:
	{ return TEXT_HASH; }
yy55:
	++YYCURSOR;
	{ return TEXT_PERCENT; }
yy57:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy77;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy78;
	default:	goto yy7;
	}
yy58:
	++YYCURSOR;
	{ return STAR; }
yy60:
	++YYCURSOR;
	{ return UL; }
yy62:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy76;
yy63:
	{ return BACKTICK; }
yy64:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy74;
yy65:
	{ return PIPE; }
yy66:
	yych = *++YYCURSOR;
	goto yy7;
yy67:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy66;
	default:	goto yy2;
	}
yy68:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy67;
	default:	goto yy2;
	}
yy69:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy67;
	default:	goto yy2;
	}
yy70:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy69;
	default:	goto yy2;
	}
yy71:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy69;
	default:	goto yy2;
	}
yy72:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy69;
	default:	goto yy2;
	}
yy73:
	++YYCURSOR;
	yych = *YYCURSOR;
yy74:
	switch (yych) {
	case '|':	goto yy73;
	default:	goto yy65;
	}
yy75:
	++YYCURSOR;
	yych = *YYCURSOR;
yy76:
	switch (yych) {
	case '`':	goto yy75;
	default:	goto yy63;
	}
yy77:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy83;
	case '\n':	goto yy80;
	case '\r':	goto yy82;
	case 0xC2:	goto yy85;
	default:	goto yy2;
	}
yy78:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case '.':	goto yy77;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy78;
	default:	goto yy2;
	}
yy80:
	++YYCURSOR;
yy81:
	YYCURSOR = YYCTXMARKER;
	{ return TEXT_NUMBER_POSS_LIST; }
yy82:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy80;
	default:	goto yy81;
	}
yy83:
	yyaccept = 9;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy83;
	case 0xC2:	goto yy85;
	default:	goto yy81;
	}
yy85:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy83;
	default:	goto yy2;
	}
yy86:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case '\n':
	case '\r':
	case ' ':
	case 0xC2:	goto yy95;
	case '#':	goto yy101;
	default:	goto yy2;
	}
yy87:
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
yy88:
	switch (yych) {
	case 0x00:
	case '\n':	goto yy91;
	case '\t':
	case ' ':	goto yy87;
	case '\r':	goto yy93;
	case 0xC2:	goto yy90;
	default:	goto yy89;
	}
yy89:
	{ return HASH1; }
yy90:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy87;
	default:	goto yy2;
	}
yy91:
	++YYCURSOR;
yy92:
	YYCURSOR = YYCTXMARKER;
	{ return HASH1; }
yy93:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy91;
	default:	goto yy92;
	}
yy94:
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
yy95:
	switch (yych) {
	case 0x00:
	case '\n':	goto yy98;
	case '\t':
	case ' ':	goto yy94;
	case '\r':	goto yy100;
	case 0xC2:	goto yy97;
	default:	goto yy96;
	}
yy96:
	{ return HASH2; }
yy97:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy94;
	default:	goto yy2;
	}
yy98:
	++YYCURSOR;
yy99:
	YYCURSOR = YYCTXMARKER;
	{ return HASH2; }
yy100:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy98;
	default:	goto yy99;
	}
yy101:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case '\n':
	case '\r':
	case ' ':
	case 0xC2:	goto yy104;
	case '#':	goto yy102;
	default:	goto yy2;
	}
yy102:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case '\n':
	case '\r':
	case ' ':
	case 0xC2:	goto yy111;
	case '#':	goto yy117;
	default:	goto yy2;
	}
yy103:
	yyaccept = 12;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
yy104:
	switch (yych) {
	case 0x00:
	case '\n':	goto yy107;
	case '\t':
	case ' ':	goto yy103;
	case '\r':	goto yy109;
	case 0xC2:	goto yy106;
	default:	goto yy105;
	}
yy105:
	{ return HASH3; }
yy106:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy103;
	default:	goto yy2;
	}
yy107:
	++YYCURSOR;
yy108:
	YYCURSOR = YYCTXMARKER;
	{ return HASH3; }
yy109:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy107;
	default:	goto yy108;
	}
yy110:
	yyaccept = 13;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
yy111:
	switch (yych) {
	case 0x00:
	case '\n':	goto yy114;
	case '\t':
	case ' ':	goto yy110;
	case '\r':	goto yy116;
	case 0xC2:	goto yy113;
	default:	goto yy112;
	}
yy112:
	{ return HASH4; }
yy113:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy110;
	default:	goto yy2;
	}
yy114:
	++YYCURSOR;
yy115:
	YYCURSOR = YYCTXMARKER;
	{ return HASH4; }
yy116:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy114;
	default:	goto yy115;
	}
yy117:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case '\n':
	case '\r':
	case ' ':
	case 0xC2:	goto yy120;
	case '#':	goto yy118;
	default:	goto yy2;
	}
yy118:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case '\n':
	case '\r':
	case ' ':
	case 0xC2:	goto yy127;
	default:	goto yy2;
	}
yy119:
	yyaccept = 14;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
yy120:
	switch (yych) {
	case 0x00:
	case '\n':	goto yy123;
	case '\t':
	case ' ':	goto yy119;
	case '\r':	goto yy125;
	case 0xC2:	goto yy122;
	default:	goto yy121;
	}
yy121:
	{ return HASH5; }
yy122:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy119;
	default:	goto yy2;
	}
yy123:
	++YYCURSOR;
yy124:
	YYCURSOR = YYCTXMARKER;
	{ return HASH5; }
yy125:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy123;
	default:	goto yy124;
	}
yy126:
	yyaccept = 15;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
yy127:
	switch (yych) {
	case 0x00:
	case '\n':	goto yy130;
	case '\t':
	case ' ':	goto yy126;
	case '\r':	goto yy132;
	case 0xC2:	goto yy129;
	default:	goto yy128;
	}
yy128:
	{ return HASH6; }
yy129:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy126;
	default:	goto yy2;
	}
yy130:
	++YYCURSOR;
yy131:
	YYCURSOR = YYCTXMARKER;
	{ return HASH6; }
yy132:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy130;
	default:	goto yy131;
	}
yy133:
	++YYCURSOR;
	{ return MATH_DOLLAR_DOUBLE; }
yy135:
	++YYCURSOR;
yy136:
	{ return TEXT_LINEBREAK; }
yy137:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy135;
	default:	goto yy136;
	}
yy138:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '(':	goto yy204;
	case ')':	goto yy206;
	case '[':	goto yy208;
	case ']':	goto yy210;
	default:	goto yy139;
	}
yy139:
	{ return ESCAPED_CHARACTER; }
yy140:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy142:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy144:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy146:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy148:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy150:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy152:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy154:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy156:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy158:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy160:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy162:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy164:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy166:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy168:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy170:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy172:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy174:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy176:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy178:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy180:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy182:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy184:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy186:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy188:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy190:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy192:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy194:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy196:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy198:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy200:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy202:
	++YYCURSOR;
	{ return ESCAPED_CHARACTER; }
yy204:
	++YYCURSOR;
	{ return MATH_PAREN_OPEN; }
yy206:
	++YYCURSOR;
	{ return MATH_PAREN_CLOSE; }
yy208:
	++YYCURSOR;
	{ return MATH_BRACKET_OPEN; }
yy210:
	++YYCURSOR;
	{ return MATH_BRACKET_CLOSE; }
yy212:
	++YYCURSOR;
	yych = *YYCURSOR;
yy213:
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy212;
	case ';':	goto yy226;
	default:	goto yy2;
	}
yy214:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy225;
	default:	goto yy213;
	}
yy215:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy217;
	case 'X':
	case 'x':	goto yy216;
	default:	goto yy2;
	}
yy216:
	yych = *++YYCURSOR;
	switch (yych) {
	case ';':	goto yy2;
	default:	goto yy222;
	}
yy217:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy217;
	case ';':	goto yy219;
	default:	goto yy2;
	}
yy219:
	++YYCURSOR;
	{ return HTML_ENTITY; }
yy221:
	++YYCURSOR;
	yych = *YYCURSOR;
yy222:
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy221;
	case ';':	goto yy223;
	default:	goto yy2;
	}
yy223:
	++YYCURSOR;
	{ return HTML_ENTITY; }
yy225:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy228;
	default:	goto yy213;
	}
yy226:
	++YYCURSOR;
	{ return HTML_ENTITY; }
yy228:
	yych = *++YYCURSOR;
	switch (yych) {
	case ';':	goto yy229;
	default:	goto yy213;
	}
yy229:
	++YYCURSOR;
	{ return AMPERSAND_LONG; }
yy231:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy235;
	default:	goto yy2;
	}
yy232:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy233;
	default:	goto yy2;
	}
yy233:
	++YYCURSOR;
	{ return ELLIPSIS; }
yy235:
	yych = *++YYCURSOR;
	switch (yych) {
	case ' ':	goto yy236;
	default:	goto yy2;
	}
yy236:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy237;
	default:	goto yy2;
	}
yy237:
	++YYCURSOR;
	{ return ELLIPSIS; }
yy239:
	++YYCURSOR;
	{ return QUOTE_RIGHT_ALT; }
yy241:
	++YYCURSOR;
	{ return BRACE_DOUBLE_RIGHT; }
yy243:
	++YYCURSOR;
	{ return BRACKET_IMAGE_LEFT; }
yy245:
	++YYCURSOR;
	{ return BRACKET_VARIABLE_LEFT; }
yy247:
	++YYCURSOR;
	{ return BRACKET_GLOSSARY_LEFT; }
yy249:
	++YYCURSOR;
	{ return BRACKET_FOOTNOTE_LEFT; }
yy251:
	++YYCURSOR;
	{ return BRACKET_CITATION_LEFT; }
yy253:
	++YYCURSOR;
	{ return BRACKET_ABBREVIATION_LEFT; }
yy255:
	yych = *++YYCURSOR;
	switch (yych) {
	case '}':	goto yy256;
	default:	goto yy2;
	}
yy256:
	++YYCURSOR;
	{ return CRITIC_HI_CLOSE; }
yy258:
	yych = *++YYCURSOR;
	switch (yych) {
	case '}':	goto yy261;
	default:	goto yy2;
	}
yy259:
	++YYCURSOR;
	{ return CRITIC_SUB_DIV; }
yy261:
	++YYCURSOR;
	{ return CRITIC_SUB_CLOSE; }
yy263:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy267;
	default:	goto yy2;
	}
yy264:
	yych = *++YYCURSOR;
	switch (yych) {
	case '}':	goto yy265;
	default:	goto yy2;
	}
yy265:
	++YYCURSOR;
	{ return CRITIC_COM_CLOSE; }
yy267:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy268;
	default:	goto yy2;
	}
yy268:
	++YYCURSOR;
	{ return HTML_COMMENT_START; }
yy270:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '-':	goto yy276;
	case '>':	goto yy274;
	case '}':	goto yy272;
	default:	goto yy271;
	}
yy271:
	{ return DASH_N; }
yy272:
	++YYCURSOR;
	{ return CRITIC_DEL_CLOSE; }
yy274:
	++YYCURSOR;
	{ return HTML_COMMENT_STOP; }
yy276:
	++YYCURSOR;
	{ return DASH_M; }
yy278:
	yych = *++YYCURSOR;
	switch (yych) {
	case '}':	goto yy279;
	default:	goto yy2;
	}
yy279:
	++YYCURSOR;
	{ return CRITIC_ADD_CLOSE; }
yy281:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '=':	goto yy303;
	default:	goto yy282;
	}
yy282:
	{ return RAW_FILTER_LEFT; }
yy283:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'T':	goto yy297;
	default:	goto yy284;
	}
yy284:
	{ return BRACE_DOUBLE_LEFT; }
yy285:
	yych = *++YYCURSOR;
	switch (yych) {
	case '~':	goto yy295;
	default:	goto yy2;
	}
yy286:
	yych = *++YYCURSOR;
	switch (yych) {
	case '>':	goto yy293;
	default:	goto yy2;
	}
yy287:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy291;
	default:	goto yy2;
	}
yy288:
	yych = *++YYCURSOR;
	switch (yych) {
	case '+':	goto yy289;
	default:	goto yy2;
	}
yy289:
	++YYCURSOR;
	{ return CRITIC_ADD_OPEN; }
yy291:
	++YYCURSOR;
	{ return CRITIC_DEL_OPEN; }
yy293:
	++YYCURSOR;
	{ return CRITIC_COM_OPEN; }
yy295:
	++YYCURSOR;
	{ return CRITIC_SUB_OPEN; }
yy297:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':	goto yy298;
	default:	goto yy2;
	}
yy298:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':	goto yy299;
	default:	goto yy2;
	}
yy299:
	yych = *++YYCURSOR;
	switch (yych) {
	case '}':	goto yy300;
	default:	goto yy2;
	}
yy300:
	yych = *++YYCURSOR;
	switch (yych) {
	case '}':	goto yy301;
	default:	goto yy2;
	}
yy301:
	++YYCURSOR;
	{ return TOC; }
yy303:
	++YYCURSOR;
	{ return CRITIC_HI_OPEN; }
yy305:
	YYCTXMARKER = YYCURSOR + 1;
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy309;
	case ' ':	goto yy306;
	case 0xC2:	goto yy308;
	default:	goto yy7;
	}
yy306:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy313;
	case '\r':	goto yy315;
	case ' ':	goto yy311;
	case 0xC2:	goto yy312;
	default:	goto yy307;
	}
yy307:
	{ return NON_INDENT_SPACE; }
yy308:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy306;
	default:	goto yy2;
	}
yy309:
	++YYCURSOR;
	YYCURSOR = YYCTXMARKER;
	{ return NON_INDENT_SPACE; }
yy311:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy313;
	case '\r':	goto yy315;
	case ' ':	goto yy325;
	case 0xC2:	goto yy327;
	default:	goto yy307;
	}
yy312:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy311;
	default:	goto yy2;
	}
yy313:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy316;
	default:	goto yy314;
	}
yy314:
	{ return TEXT_LINEBREAK; }
yy315:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy313;
	case ' ':	goto yy316;
	default:	goto yy314;
	}
yy316:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case 0x01:
	case 0x02:
	case 0x03:
	case 0x04:
	case 0x05:
	case 0x06:
	case 0x07:
	case 0x08:
	case '\v':
	case '\f':
	case 0x0E:
	case 0x0F:
	case 0x10:
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
	case 0x15:
	case 0x16:
	case 0x17:
	case 0x18:
	case 0x19:
	case 0x1A:
	case 0x1B:
	case 0x1C:
	case 0x1D:
	case 0x1E:
	case 0x1F:
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case '{':
	case '|':
	case '}':
	case '~':
	case 0x7F:	goto yy317;
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy319;
	case 0xE0:	goto yy320;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy321;
	case 0xF0:	goto yy322;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy323;
	case 0xF4:	goto yy324;
	default:	goto yy2;
	}
yy317:
	++YYCURSOR;
	YYCURSOR = YYCTXMARKER;
	{ return TEXT_LINEBREAK_SP; }
yy319:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy317;
	default:	goto yy2;
	}
yy320:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy319;
	default:	goto yy2;
	}
yy321:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy319;
	default:	goto yy2;
	}
yy322:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy321;
	default:	goto yy2;
	}
yy323:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy321;
	default:	goto yy2;
	}
yy324:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy321;
	default:	goto yy2;
	}
yy325:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy313;
	case '\r':	goto yy315;
	case ' ':	goto yy328;
	case 0xC2:	goto yy330;
	default:	goto yy326;
	}
yy326:
	{ return INDENT_SPACE; }
yy327:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy325;
	default:	goto yy2;
	}
yy328:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy313;
	case '\r':	goto yy315;
	case ' ':	goto yy328;
	case 0xC2:	goto yy330;
	default:	goto yy2;
	}
yy330:
	++YYCURSOR;
	yych = *YYCURSOR;
	switch (yych) {
	case 0xA0:	goto yy328;
	default:	goto yy2;
	}
yy331:
	yych = *++YYCURSOR;
	goto yy4;
yy332:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy331;
	default:	goto yy4;
	}
yy333:
	YYCTXMARKER = YYCURSOR + 1;
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case 0x01:
	case 0x02:
	case 0x03:
	case 0x04:
	case 0x05:
	case 0x06:
	case 0x07:
	case 0x08:
	case '\v':
	case '\f':
	case 0x0E:
	case 0x0F:
	case 0x10:
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
	case 0x15:
	case 0x16:
	case 0x17:
	case 0x18:
	case 0x19:
	case 0x1A:
	case 0x1B:
	case 0x1C:
	case 0x1D:
	case 0x1E:
	case 0x1F:
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case '{':
	case '|':
	case '}':
	case '~':
	case 0x7F:	goto yy334;
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy336;
	case 0xE0:	goto yy337;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy338;
	case 0xF0:	goto yy339;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy340;
	case 0xF4:	goto yy341;
	default:	goto yy2;
	}
yy334:
	++YYCURSOR;
	YYCURSOR = YYCTXMARKER;
	{ return TEXT_NL_SP; }
yy336:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy334;
	default:	goto yy2;
	}
yy337:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy336;
	default:	goto yy2;
	}
yy338:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy336;
	default:	goto yy2;
	}
yy339:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy338;
	default:	goto yy2;
	}
yy340:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy338;
	default:	goto yy2;
	}
yy341:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy338;
	default:	goto yy2;
	}
}

}
