/* Generated by re2c 1.3 on Tue Sep 28 18:26:56 2021 */
/**

	MultiMarkdown -- Lightweight markup processor to produce HTML, LaTeX, and more.

	@file opml-lexer.c

	@brief Tokenize OPML file for parsing


	@author	Fletcher T. Penney
	@bug

**/

/*

	Copyright © 2016 - 2019 Fletcher T. Penney.


	The `MultiMarkdown 6` project is released under the MIT License..

	GLibFacade.c and GLibFacade.h are from the MultiMarkdown v4 project:

		https://github.com/fletcher/MultiMarkdown-4/

	MMD 4 is released under both the MIT License and GPL.


	CuTest is released under the zlib/libpng license. See CuTest.c for the
	text of the license.

	uthash library:
		Copyright (c) 2005-2016, Troy D. Hanson

		Licensed under Revised BSD license

	miniz library:
		Copyright 2013-2014 RAD Game Tools and Valve Software
		Copyright 2010-2014 Rich Geldreich and Tenacious Software LLC

		Licensed under the MIT license

	argtable3 library:
		Copyright (C) 1998-2001,2003-2011,2013 Stewart Heitmann
		<sheitmann@users.sourceforge.net>
		All rights reserved.

		Licensed under the Revised BSD License


	## The MIT License ##

	Permission is hereby granted, free of charge, to any person obtaining
	a copy of this software and associated documentation files (the
	"Software"), to deal in the Software without restriction, including
	without limitation the rights to use, copy, modify, merge, publish,
	distribute, sublicense, and/or sell copies of the Software, and to
	permit persons to whom the Software is furnished to do so, subject to
	the following conditions:

	The above copyright notice and this permission notice shall be
	included in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
	EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
	CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
	TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


	## Revised BSD License ##

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are
	met:
	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above
	      copyright notice, this list of conditions and the following
	      disclaimer in the documentation and/or other materials provided
	      with the distribution.
	    * Neither the name of the <organization> nor the
	      names of its contributors may be used to endorse or promote
	      products derived from this software without specific prior
	      written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
	A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT
	HOLDER> BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES LOSS OF USE, DATA, OR
	PROFITS OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
	LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
	NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/

#include <stdlib.h>

#include "itmz-lexer.h"
#include "itmz-parser.h"


// Basic scanner struct

#define YYCTYPE		unsigned char
#define YYCURSOR	s->cur
#define YYMARKER	s->ptr
#define YYCTXMARKER	s->ctx

int itmz_scan(Scanner * s, const char * stop) {

scan:

	if (s->cur >= stop) {
		return 0;
	}

	s->start = s->cur;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy4;

			case '<':
				goto yy7;

			default:
				goto yy2;
		}

yy2:
		++YYCURSOR;
yy3: {
			goto scan;
		}
yy4:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy4;

			default:
				goto yy6;
		}

yy6: {
			return ITMZ_WSNL;
		}
yy7:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '/':
				goto yy8;

			case 'I':
			case 'i':
				goto yy10;

			case 'R':
			case 'r':
				goto yy11;

			case 'T':
			case 't':
				goto yy12;

			default:
				goto yy3;
		}

yy8:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy13;

			case 'R':
			case 'r':
				goto yy14;

			case 'T':
			case 't':
				goto yy15;

			default:
				goto yy9;
		}

yy9:
		YYCURSOR = YYMARKER;

		switch (yyaccept) {
			case 0:
				goto yy3;

			case 1:
				goto yy51;

			default:
				goto yy62;
		}

yy10:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy16;

			default:
				goto yy9;
		}

yy11:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy17;

			default:
				goto yy9;
		}

yy12:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy18;

			default:
				goto yy9;
		}

yy13:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy19;

			default:
				goto yy9;
		}

yy14:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy20;

			default:
				goto yy9;
		}

yy15:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy21;

			default:
				goto yy9;
		}

yy16:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy22;

			default:
				goto yy9;
		}

yy17:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy23;

			default:
				goto yy9;
		}

yy18:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy24;

			default:
				goto yy9;
		}

yy19:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy25;

			default:
				goto yy9;
		}

yy20:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy26;

			default:
				goto yy9;
		}

yy21:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy27;

			default:
				goto yy9;
		}

yy22:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy28;

			default:
				goto yy9;
		}

yy23:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy29;

			default:
				goto yy9;
		}

yy24:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy30;

			default:
				goto yy9;
		}

yy25:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy31;

			default:
				goto yy9;
		}

yy26:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy32;

			default:
				goto yy9;
		}

yy27:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy33;

			default:
				goto yy9;
		}

yy28:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'U':
			case 'u':
				goto yy34;

			default:
				goto yy9;
		}

yy29:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy35;

			default:
				goto yy9;
		}

yy30:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'C':
			case 'c':
				goto yy36;

			default:
				goto yy9;
		}

yy31:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'U':
			case 'u':
				goto yy37;

			default:
				goto yy9;
		}

yy32:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy38;

			default:
				goto yy9;
		}

yy33:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'C':
			case 'c':
				goto yy39;

			default:
				goto yy9;
		}

yy34:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy40;

			default:
				goto yy9;
		}

yy35:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy41;

			default:
				goto yy9;
		}

yy36:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy44;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case 'S':
			case 's':
				goto yy52;

			case 'T':
			case 't':
				goto yy53;

			default:
				goto yy43;
		}

yy37:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy54;

			default:
				goto yy9;
		}

yy38:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy55;

			default:
				goto yy9;
		}

yy39:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy56;

			case 'S':
			case 's':
				goto yy58;

			default:
				goto yy9;
		}

yy40:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy59;

			default:
				goto yy9;
		}

yy41:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy60;

			default:
				goto yy9;
		}

yy42:
		yych = *++YYCURSOR;
yy43:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy44:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy44;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy53;

			default:
				goto yy42;
		}

yy46:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '/':
				goto yy46;

			case '>':
				goto yy61;

			default:
				goto yy42;
		}

yy48:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy46;

			case '=':
				goto yy65;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy67;

			default:
				goto yy42;
		}

yy50:
		++YYCURSOR;
yy51: {
			return ITMZ_TOPIC_OPEN;
		}
yy52:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy65;

			case '>':
				goto yy69;

			case 'T':
			case 't':
				goto yy67;

			default:
				goto yy43;
		}

yy53:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy65;

			case 'E':
			case 'e':
				goto yy71;

			case 'T':
			case 't':
				goto yy67;

			default:
				goto yy43;
		}

yy54:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy72;

			default:
				goto yy9;
		}

yy55:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy73;

			default:
				goto yy9;
		}

yy56:
		++YYCURSOR;
		{
			return ITMZ_TOPIC_CLOSE;
		}
yy58:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy74;

			default:
				goto yy9;
		}

yy59:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy76;

			default:
				goto yy9;
		}

yy60:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'N':
			case 'n':
				goto yy77;

			default:
				goto yy9;
		}

yy61:
		++YYCURSOR;
yy62: {
			return ITMZ_TOPIC_SELF_CLOSE;
		}
yy63:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '=':
				goto yy65;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy80;

			default:
				goto yy42;
		}

yy65:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy65;

			case '"':
				goto yy81;

			case '\'':
				goto yy83;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy67:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy46;

			case '=':
				goto yy65;

			case '>':
				goto yy50;

			case 'E':
			case 'e':
				goto yy85;

			case 'T':
			case 't':
				goto yy67;

			default:
				goto yy42;
		}

yy69:
		++YYCURSOR;
		{
			return ITMZ_TOPICS_OPEN;
		}
yy71:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy65;

			case 'T':
			case 't':
				goto yy67;

			case 'X':
			case 'x':
				goto yy86;

			default:
				goto yy43;
		}

yy72:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy9;
		}

yy73:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'N':
			case 'n':
				goto yy88;

			default:
				goto yy9;
		}

yy74:
		++YYCURSOR;
		{
			return ITMZ_TOPICS_CLOSE;
		}
yy76:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'S':
			case 's':
				goto yy89;

			default:
				goto yy9;
		}

yy77:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'S':
			case 's':
				goto yy91;

			default:
				goto yy9;
		}

yy78:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '/':
				goto yy46;

			case '=':
				goto yy94;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy96;

			default:
				goto yy42;
		}

yy80:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '=':
				goto yy94;

			case 'E':
			case 'e':
				goto yy98;

			case 'T':
			case 't':
				goto yy96;

			default:
				goto yy43;
		}

yy81:
		yych = *++YYCURSOR;
yy82:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy99;

			case '/':
				goto yy101;

			case '>':
				goto yy103;

			default:
				goto yy81;
		}

yy83:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy99;

			case '/':
				goto yy104;

			case '>':
				goto yy106;

			default:
				goto yy83;
		}

yy85:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy46;

			case '=':
				goto yy65;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy67;

			case 'X':
			case 'x':
				goto yy107;

			default:
				goto yy42;
		}

yy86:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy65;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy43;
		}

yy87:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'S':
			case 's':
				goto yy109;

			default:
				goto yy9;
		}

yy88:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'S':
			case 's':
				goto yy110;

			default:
				goto yy9;
		}

yy89:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '>':
				goto yy111;

			default:
				goto yy89;
		}

yy91:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy113;

			default:
				goto yy9;
		}

yy92:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '/':
				goto yy46;

			case '=':
				goto yy94;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy114;

			default:
				goto yy42;
		}

yy94:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy94;

			case '"':
				goto yy115;

			case '\'':
				goto yy117;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy96:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '/':
				goto yy46;

			case '=':
				goto yy94;

			case '>':
				goto yy50;

			case 'E':
			case 'e':
				goto yy119;

			case 'T':
			case 't':
				goto yy96;

			default:
				goto yy42;
		}

yy98:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy78;

			case '=':
				goto yy94;

			case 'T':
			case 't':
				goto yy96;

			case 'X':
			case 'x':
				goto yy120;

			default:
				goto yy43;
		}

yy99:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy99;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy80;

			default:
				goto yy42;
		}

yy101:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy99;

			case '/':
				goto yy101;

			case '>':
				goto yy121;

			default:
				goto yy81;
		}

yy103:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy123;
yy104:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy99;

			case '/':
				goto yy104;

			case '>':
				goto yy126;

			default:
				goto yy83;
		}

yy106:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy128;
yy107:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy63;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy46;

			case '=':
				goto yy65;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy129;

			default:
				goto yy42;
		}

yy108:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy130;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy132;

			case 'E':
			case 'e':
				goto yy85;

			case 'T':
			case 't':
				goto yy67;

			default:
				goto yy43;
		}

yy109:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy134;

			default:
				goto yy9;
		}

yy110:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy136;

			default:
				goto yy9;
		}

yy111:
		++YYCURSOR;
		{
			return ITMZ_ITHOUGHTS_OPEN;
		}
yy113:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy137;

			default:
				goto yy9;
		}

yy114:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy138;

			default:
				goto yy43;
		}

yy115:
		yych = *++YYCURSOR;
yy116:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy139;

			case '/':
				goto yy141;

			case '>':
				goto yy143;

			default:
				goto yy115;
		}

yy117:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy139;

			case '/':
				goto yy144;

			case '>':
				goto yy146;

			default:
				goto yy117;
		}

yy119:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy78;

			case '/':
				goto yy46;

			case '=':
				goto yy94;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy96;

			case 'X':
			case 'x':
				goto yy147;

			default:
				goto yy42;
		}

yy120:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '=':
				goto yy94;

			case 'T':
			case 't':
				goto yy148;

			default:
				goto yy43;
		}

yy121:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy123;
yy122:
		yych = *++YYCURSOR;
yy123:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy124;

			default:
				goto yy122;
		}

yy124:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy124;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case 'T':
			case 't':
				goto yy151;

			default:
				goto yy9;
		}

yy126:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy128;
yy127:
		yych = *++YYCURSOR;
yy128:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy124;

			default:
				goto yy127;
		}

yy129:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy152;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy46;

			case '=':
				goto yy154;

			case '>':
				goto yy50;

			case 'E':
			case 'e':
				goto yy85;

			case 'T':
			case 't':
				goto yy67;

			default:
				goto yy42;
		}

yy130:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy130;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '=':
				goto yy132;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy80;

			default:
				goto yy42;
		}

yy132:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy132;

			case '"':
				goto yy156;

			case '\'':
				goto yy83;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy134:
		++YYCURSOR;
		{
			return ITMZ_ITHOUGHTS_CLOSE;
		}
yy136:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy157;

			default:
				goto yy9;
		}

yy137:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy158;

			default:
				goto yy9;
		}

yy138:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'X':
			case 'x':
				goto yy159;

			default:
				goto yy43;
		}

yy139:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy139;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy114;

			default:
				goto yy42;
		}

yy141:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy139;

			case '/':
				goto yy141;

			case '>':
				goto yy160;

			default:
				goto yy115;
		}

yy143:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy162;
yy144:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy139;

			case '/':
				goto yy144;

			case '>':
				goto yy165;

			default:
				goto yy117;
		}

yy146:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy167;
yy147:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy92;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '/':
				goto yy46;

			case '=':
				goto yy94;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy168;

			default:
				goto yy42;
		}

yy148:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy169;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '=':
				goto yy171;

			case 'E':
			case 'e':
				goto yy119;

			case 'T':
			case 't':
				goto yy96;

			default:
				goto yy43;
		}

yy149:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy173;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case '=':
				goto yy175;

			case 'T':
			case 't':
				goto yy177;

			default:
				goto yy9;
		}

yy151:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case 'E':
			case 'e':
				goto yy179;

			case 'T':
			case 't':
				goto yy177;

			default:
				goto yy174;
		}

yy152:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy152;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '=':
				goto yy154;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy80;

			default:
				goto yy42;
		}

yy154:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy154;

			case '"':
				goto yy180;

			case '\'':
				goto yy83;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy156:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy181;

			default:
				goto yy82;
		}

yy157:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy182;

			default:
				goto yy9;
		}

yy158:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'S':
			case 's':
				goto yy183;

			default:
				goto yy9;
		}

yy159:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy184;

			default:
				goto yy43;
		}

yy160:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy162;
yy161:
		yych = *++YYCURSOR;
yy162:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy163;

			default:
				goto yy161;
		}

yy163:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy163;

			case 'T':
			case 't':
				goto yy186;

			default:
				goto yy9;
		}

yy165:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy167;
yy166:
		yych = *++YYCURSOR;
yy167:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy163;

			default:
				goto yy166;
		}

yy168:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy187;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy78;

			case '/':
				goto yy46;

			case '=':
				goto yy189;

			case '>':
				goto yy50;

			case 'E':
			case 'e':
				goto yy119;

			case 'T':
			case 't':
				goto yy96;

			default:
				goto yy42;
		}

yy169:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy169;

			case '/':
				goto yy46;

			case '=':
				goto yy171;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy114;

			default:
				goto yy42;
		}

yy171:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy171;

			case '"':
				goto yy191;

			case '\'':
				goto yy117;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy173:
		yych = *++YYCURSOR;
yy174:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy173;

			case '=':
				goto yy175;

			case 'T':
			case 't':
				goto yy186;

			default:
				goto yy9;
		}

yy175:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy175;

			case '"':
				goto yy161;

			case '\'':
				goto yy166;

			default:
				goto yy9;
		}

yy177:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy173;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case '=':
				goto yy175;

			case 'E':
			case 'e':
				goto yy192;

			case 'T':
			case 't':
				goto yy177;

			default:
				goto yy9;
		}

yy179:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy149;

			case 'T':
			case 't':
				goto yy177;

			case 'X':
			case 'x':
				goto yy193;

			default:
				goto yy174;
		}

yy180:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy194;

			default:
				goto yy82;
		}

yy181:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy195;

			default:
				goto yy82;
		}

yy182:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'S':
			case 's':
				goto yy196;

			default:
				goto yy9;
		}

yy183:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy197;

			default:
				goto yy9;
		}

yy184:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy184;

			case '/':
				goto yy46;

			case '=':
				goto yy199;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy186:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy201;

			default:
				goto yy9;
		}

yy187:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy187;

			case '/':
				goto yy46;

			case '=':
				goto yy189;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy114;

			default:
				goto yy42;
		}

yy189:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy189;

			case '"':
				goto yy202;

			case '\'':
				goto yy117;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy191:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy203;

			default:
				goto yy116;
		}

yy192:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy173;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy149;

			case '=':
				goto yy175;

			case 'T':
			case 't':
				goto yy177;

			case 'X':
			case 'x':
				goto yy204;

			default:
				goto yy9;
		}

yy193:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case 'T':
			case 't':
				goto yy205;

			default:
				goto yy174;
		}

yy194:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy206;

			default:
				goto yy82;
		}

yy195:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy207;

			default:
				goto yy82;
		}

yy196:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy208;

			default:
				goto yy9;
		}

yy197:
		++YYCURSOR;
		{
			return ITMZ_RELATIONSHIPS_OPEN;
		}
yy199:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy199;

			case '"':
				goto yy210;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy201:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'X':
			case 'x':
				goto yy211;

			default:
				goto yy9;
		}

yy202:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy212;

			default:
				goto yy116;
		}

yy203:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy213;

			default:
				goto yy116;
		}

yy204:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy173;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case '=':
				goto yy175;

			case 'T':
			case 't':
				goto yy214;

			default:
				goto yy9;
		}

yy205:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case 'E':
			case 'e':
				goto yy192;

			case 'T':
			case 't':
				goto yy177;

			default:
				goto yy216;
		}

yy206:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy219;

			default:
				goto yy82;
		}

yy207:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy220;

			default:
				goto yy82;
		}

yy208:
		++YYCURSOR;
		{
			return ITMZ_RELATIONSHIPS_CLOSE;
		}
yy210:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy221;

			default:
				goto yy43;
		}

yy211:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy222;

			default:
				goto yy9;
		}

yy212:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy224;

			default:
				goto yy116;
		}

yy213:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy225;

			default:
				goto yy116;
		}

yy214:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy226;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy149;

			case '=':
				goto yy228;

			case 'E':
			case 'e':
				goto yy192;

			case 'T':
			case 't':
				goto yy177;

			default:
				goto yy9;
		}

yy215:
		yych = *++YYCURSOR;
yy216:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy215;

			case '=':
				goto yy217;

			case 'T':
			case 't':
				goto yy186;

			default:
				goto yy9;
		}

yy217:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy217;

			case '"':
				goto yy230;

			case '\'':
				goto yy166;

			default:
				goto yy9;
		}

yy219:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy231;

			default:
				goto yy82;
		}

yy220:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy232;

			default:
				goto yy82;
		}

yy221:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy233;

			default:
				goto yy43;
		}

yy222:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy222;

			case '=':
				goto yy234;

			default:
				goto yy9;
		}

yy224:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy236;

			default:
				goto yy116;
		}

yy225:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy237;

			default:
				goto yy116;
		}

yy226:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy226;

			case '=':
				goto yy228;

			case 'T':
			case 't':
				goto yy186;

			default:
				goto yy9;
		}

yy228:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy228;

			case '"':
				goto yy238;

			case '\'':
				goto yy166;

			default:
				goto yy9;
		}

yy230:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy239;

			default:
				goto yy162;
		}

yy231:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy240;

			default:
				goto yy82;
		}

yy232:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy241;

			default:
				goto yy82;
		}

yy233:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy242;

			default:
				goto yy43;
		}

yy234:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy234;

			case '"':
				goto yy243;

			default:
				goto yy9;
		}

yy236:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy244;

			default:
				goto yy116;
		}

yy237:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy245;

			default:
				goto yy116;
		}

yy238:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy246;

			default:
				goto yy162;
		}

yy239:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy247;

			default:
				goto yy162;
		}

yy240:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy248;

			default:
				goto yy82;
		}

yy241:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy249;

			default:
				goto yy82;
		}

yy242:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy250;

			default:
				goto yy43;
		}

yy243:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy251;

			default:
				goto yy9;
		}

yy244:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy252;

			default:
				goto yy116;
		}

yy245:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy253;

			default:
				goto yy116;
		}

yy246:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy254;

			default:
				goto yy162;
		}

yy247:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy255;

			default:
				goto yy162;
		}

yy248:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy256;

			default:
				goto yy82;
		}

yy249:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy257;

			default:
				goto yy82;
		}

yy250:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy258;

			default:
				goto yy43;
		}

yy251:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy259;

			default:
				goto yy9;
		}

yy252:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy260;

			default:
				goto yy116;
		}

yy253:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy261;

			default:
				goto yy116;
		}

yy254:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy262;

			default:
				goto yy162;
		}

yy255:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy263;

			default:
				goto yy162;
		}

yy256:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy264;

			default:
				goto yy82;
		}

yy257:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy265;

			case 'P':
			case 'p':
				goto yy266;

			default:
				goto yy82;
		}

yy258:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy267;

			default:
				goto yy43;
		}

yy259:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy268;

			default:
				goto yy9;
		}

yy260:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy269;

			default:
				goto yy116;
		}

yy261:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy270;

			default:
				goto yy116;
		}

yy262:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy271;

			default:
				goto yy162;
		}

yy263:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy272;

			default:
				goto yy162;
		}

yy264:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy273;

			case 'P':
			case 'p':
				goto yy274;

			default:
				goto yy82;
		}

yy265:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy275;

			default:
				goto yy82;
		}

yy266:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy276;

			default:
				goto yy82;
		}

yy267:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy277;

			default:
				goto yy43;
		}

yy268:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy278;

			default:
				goto yy9;
		}

yy269:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy279;

			default:
				goto yy116;
		}

yy270:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy280;

			case 'P':
			case 'p':
				goto yy281;

			default:
				goto yy116;
		}

yy271:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy282;

			default:
				goto yy162;
		}

yy272:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy283;

			default:
				goto yy162;
		}

yy273:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy284;

			default:
				goto yy82;
		}

yy274:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy285;

			default:
				goto yy82;
		}

yy275:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy286;

			default:
				goto yy82;
		}

yy276:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy287;

			default:
				goto yy82;
		}

yy277:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy288;

			default:
				goto yy43;
		}

yy278:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy289;

			default:
				goto yy9;
		}

yy279:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy290;

			case 'P':
			case 'p':
				goto yy291;

			default:
				goto yy116;
		}

yy280:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy292;

			default:
				goto yy116;
		}

yy281:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy293;

			default:
				goto yy116;
		}

yy282:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy294;

			default:
				goto yy162;
		}

yy283:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy295;

			default:
				goto yy162;
		}

yy284:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy296;

			default:
				goto yy82;
		}

yy285:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy297;

			default:
				goto yy82;
		}

yy286:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy298;

			default:
				goto yy82;
		}

yy287:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy299;

			default:
				goto yy82;
		}

yy288:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy300;

			case 'P':
			case 'p':
				goto yy301;

			default:
				goto yy43;
		}

yy289:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy302;

			default:
				goto yy9;
		}

yy290:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy303;

			default:
				goto yy116;
		}

yy291:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy304;

			default:
				goto yy116;
		}

yy292:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy305;

			default:
				goto yy116;
		}

yy293:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy306;

			default:
				goto yy116;
		}

yy294:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy307;

			default:
				goto yy162;
		}

yy295:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy308;

			default:
				goto yy162;
		}

yy296:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy309;

			default:
				goto yy82;
		}

yy297:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy310;

			default:
				goto yy82;
		}

yy298:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy311;

			default:
				goto yy82;
		}

yy299:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy312;

			default:
				goto yy82;
		}

yy300:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy313;

			default:
				goto yy43;
		}

yy301:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy314;

			default:
				goto yy43;
		}

yy302:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy315;

			default:
				goto yy9;
		}

yy303:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy316;

			default:
				goto yy116;
		}

yy304:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy317;

			default:
				goto yy116;
		}

yy305:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy318;

			default:
				goto yy116;
		}

yy306:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy319;

			default:
				goto yy116;
		}

yy307:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy320;

			default:
				goto yy162;
		}

yy308:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy321;

			case 'P':
			case 'p':
				goto yy322;

			default:
				goto yy162;
		}

yy309:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy323;

			default:
				goto yy82;
		}

yy310:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy324;

			default:
				goto yy82;
		}

yy311:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy325;

			default:
				goto yy82;
		}

yy312:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy326;

			default:
				goto yy82;
		}

yy313:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy327;

			default:
				goto yy43;
		}

yy314:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy328;

			default:
				goto yy43;
		}

yy315:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy329;

			default:
				goto yy9;
		}

yy316:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy330;

			default:
				goto yy116;
		}

yy317:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy331;

			default:
				goto yy116;
		}

yy318:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy332;

			default:
				goto yy116;
		}

yy319:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy333;

			default:
				goto yy116;
		}

yy320:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy334;

			case 'P':
			case 'p':
				goto yy335;

			default:
				goto yy162;
		}

yy321:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy336;

			default:
				goto yy162;
		}

yy322:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy337;

			default:
				goto yy162;
		}

yy323:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy338;

			default:
				goto yy82;
		}

yy324:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy339;

			default:
				goto yy82;
		}

yy325:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy340;

			default:
				goto yy82;
		}

yy326:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy341;

			default:
				goto yy82;
		}

yy327:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy342;

			default:
				goto yy43;
		}

yy328:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy343;

			default:
				goto yy43;
		}

yy329:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy344;

			case 'P':
			case 'p':
				goto yy345;

			default:
				goto yy9;
		}

yy330:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy346;

			default:
				goto yy116;
		}

yy331:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy347;

			default:
				goto yy116;
		}

yy332:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy348;

			default:
				goto yy116;
		}

yy333:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy349;

			default:
				goto yy116;
		}

yy334:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy350;

			default:
				goto yy162;
		}

yy335:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy351;

			default:
				goto yy162;
		}

yy336:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy352;

			default:
				goto yy162;
		}

yy337:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy353;

			default:
				goto yy162;
		}

yy338:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy354;

			default:
				goto yy82;
		}

yy339:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy355;

			default:
				goto yy82;
		}

yy340:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy356;

			default:
				goto yy82;
		}

yy341:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy357;

			default:
				goto yy82;
		}

yy342:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy358;

			default:
				goto yy43;
		}

yy343:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy359;

			default:
				goto yy43;
		}

yy344:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy360;

			default:
				goto yy9;
		}

yy345:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy361;

			default:
				goto yy9;
		}

yy346:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy362;

			default:
				goto yy116;
		}

yy347:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy363;

			default:
				goto yy116;
		}

yy348:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy364;

			default:
				goto yy116;
		}

yy349:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy365;

			default:
				goto yy116;
		}

yy350:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy366;

			default:
				goto yy162;
		}

yy351:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy367;

			default:
				goto yy162;
		}

yy352:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy368;

			default:
				goto yy162;
		}

yy353:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy369;

			default:
				goto yy162;
		}

yy354:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy370;

			default:
				goto yy82;
		}

yy355:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy371;

			default:
				goto yy82;
		}

yy356:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy372;

			default:
				goto yy82;
		}

yy357:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy373;

			default:
				goto yy82;
		}

yy358:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy374;

			default:
				goto yy43;
		}

yy359:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy375;

			default:
				goto yy43;
		}

yy360:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy376;

			default:
				goto yy9;
		}

yy361:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy377;

			default:
				goto yy9;
		}

yy362:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy378;

			default:
				goto yy116;
		}

yy363:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy379;

			default:
				goto yy116;
		}

yy364:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy380;

			default:
				goto yy116;
		}

yy365:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy381;

			default:
				goto yy116;
		}

yy366:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy382;

			default:
				goto yy162;
		}

yy367:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy383;

			default:
				goto yy162;
		}

yy368:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy384;

			default:
				goto yy162;
		}

yy369:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy385;

			default:
				goto yy162;
		}

yy370:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy386;

			default:
				goto yy82;
		}

yy371:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy387;

			default:
				goto yy82;
		}

yy372:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy388;

			default:
				goto yy82;
		}

yy373:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy389;

			default:
				goto yy82;
		}

yy374:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy390;

			default:
				goto yy43;
		}

yy375:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy391;

			default:
				goto yy43;
		}

yy376:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy392;

			default:
				goto yy9;
		}

yy377:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy393;

			default:
				goto yy9;
		}

yy378:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy394;

			default:
				goto yy116;
		}

yy379:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy395;

			default:
				goto yy116;
		}

yy380:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy396;

			default:
				goto yy116;
		}

yy381:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy397;

			default:
				goto yy116;
		}

yy382:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy398;

			default:
				goto yy162;
		}

yy383:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy399;

			default:
				goto yy162;
		}

yy384:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy400;

			default:
				goto yy162;
		}

yy385:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy401;

			default:
				goto yy162;
		}

yy386:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy402;

			default:
				goto yy82;
		}

yy387:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy403;

			default:
				goto yy82;
		}

yy388:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy404;

			default:
				goto yy82;
		}

yy389:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy405;

			default:
				goto yy82;
		}

yy390:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy406;

			default:
				goto yy43;
		}

yy391:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy407;

			default:
				goto yy43;
		}

yy392:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy408;

			default:
				goto yy9;
		}

yy393:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy409;

			default:
				goto yy9;
		}

yy394:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy410;

			default:
				goto yy116;
		}

yy395:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy411;

			default:
				goto yy116;
		}

yy396:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy412;

			default:
				goto yy116;
		}

yy397:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy413;

			default:
				goto yy116;
		}

yy398:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy414;

			default:
				goto yy162;
		}

yy399:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy415;

			default:
				goto yy162;
		}

yy400:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy416;

			default:
				goto yy162;
		}

yy401:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy417;

			default:
				goto yy162;
		}

yy402:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy418;

			default:
				goto yy82;
		}

yy403:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy419;

			default:
				goto yy82;
		}

yy404:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy420;

			default:
				goto yy82;
		}

yy405:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy421;

			default:
				goto yy82;
		}

yy406:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy422;

			default:
				goto yy43;
		}

yy407:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy423;

			default:
				goto yy43;
		}

yy408:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy424;

			default:
				goto yy9;
		}

yy409:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy425;

			default:
				goto yy9;
		}

yy410:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy426;

			default:
				goto yy116;
		}

yy411:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy427;

			default:
				goto yy116;
		}

yy412:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy428;

			default:
				goto yy116;
		}

yy413:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy429;

			default:
				goto yy116;
		}

yy414:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy430;

			default:
				goto yy162;
		}

yy415:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy431;

			default:
				goto yy162;
		}

yy416:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy432;

			default:
				goto yy162;
		}

yy417:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy433;

			default:
				goto yy162;
		}

yy418:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy434;

			default:
				goto yy82;
		}

yy419:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy435;

			default:
				goto yy82;
		}

yy420:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy436;

			default:
				goto yy82;
		}

yy421:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy437;

			default:
				goto yy82;
		}

yy422:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy438;

			default:
				goto yy43;
		}

yy423:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy439;

			default:
				goto yy43;
		}

yy424:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy440;

			default:
				goto yy9;
		}

yy425:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy441;

			default:
				goto yy9;
		}

yy426:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy442;

			default:
				goto yy116;
		}

yy427:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy443;

			default:
				goto yy116;
		}

yy428:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy444;

			default:
				goto yy116;
		}

yy429:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy445;

			default:
				goto yy116;
		}

yy430:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy446;

			default:
				goto yy162;
		}

yy431:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy447;

			default:
				goto yy162;
		}

yy432:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy448;

			default:
				goto yy162;
		}

yy433:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy449;

			default:
				goto yy162;
		}

yy434:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy450;

			default:
				goto yy82;
		}

yy435:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy451;

			default:
				goto yy82;
		}

yy436:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy452;

			default:
				goto yy82;
		}

yy437:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy453;

			default:
				goto yy82;
		}

yy438:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy454;

			default:
				goto yy43;
		}

yy439:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy455;

			default:
				goto yy43;
		}

yy440:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy456;

			default:
				goto yy9;
		}

yy441:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy457;

			default:
				goto yy9;
		}

yy442:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy458;

			default:
				goto yy116;
		}

yy443:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy459;

			default:
				goto yy116;
		}

yy444:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy460;

			default:
				goto yy116;
		}

yy445:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy461;

			default:
				goto yy116;
		}

yy446:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy462;

			default:
				goto yy162;
		}

yy447:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy463;

			default:
				goto yy162;
		}

yy448:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy464;

			default:
				goto yy162;
		}

yy449:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy465;

			default:
				goto yy162;
		}

yy450:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy466;

			default:
				goto yy82;
		}

yy451:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy467;

			default:
				goto yy82;
		}

yy452:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy468;

			default:
				goto yy82;
		}

yy453:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy469;

			default:
				goto yy82;
		}

yy454:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy470;

			default:
				goto yy43;
		}

yy455:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy471;

			default:
				goto yy43;
		}

yy456:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy472;

			default:
				goto yy9;
		}

yy457:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy473;

			default:
				goto yy9;
		}

yy458:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy474;

			default:
				goto yy116;
		}

yy459:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy475;

			default:
				goto yy116;
		}

yy460:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy476;

			default:
				goto yy116;
		}

yy461:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy477;

			default:
				goto yy116;
		}

yy462:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy478;

			default:
				goto yy162;
		}

yy463:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy479;

			default:
				goto yy162;
		}

yy464:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy480;

			default:
				goto yy162;
		}

yy465:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy481;

			default:
				goto yy162;
		}

yy466:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy482;

			default:
				goto yy82;
		}

yy467:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy483;

			default:
				goto yy82;
		}

yy468:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy484;

			default:
				goto yy82;
		}

yy469:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy485;

			default:
				goto yy82;
		}

yy470:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy486;

			default:
				goto yy43;
		}

yy471:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy487;

			default:
				goto yy43;
		}

yy472:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy488;

			default:
				goto yy9;
		}

yy473:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy489;

			default:
				goto yy9;
		}

yy474:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy490;

			default:
				goto yy116;
		}

yy475:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy491;

			default:
				goto yy116;
		}

yy476:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy492;

			default:
				goto yy116;
		}

yy477:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy493;

			default:
				goto yy116;
		}

yy478:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy494;

			default:
				goto yy162;
		}

yy479:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy495;

			default:
				goto yy162;
		}

yy480:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy496;

			default:
				goto yy162;
		}

yy481:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy497;

			default:
				goto yy162;
		}

yy482:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy498;

			default:
				goto yy82;
		}

yy483:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy499;

			default:
				goto yy82;
		}

yy484:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy500;

			default:
				goto yy82;
		}

yy485:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy501;

			default:
				goto yy82;
		}

yy486:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy502;

			default:
				goto yy43;
		}

yy487:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy503;

			default:
				goto yy43;
		}

yy488:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy504;

			default:
				goto yy9;
		}

yy489:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy505;

			default:
				goto yy9;
		}

yy490:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy506;

			default:
				goto yy116;
		}

yy491:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy507;

			default:
				goto yy116;
		}

yy492:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy508;

			default:
				goto yy116;
		}

yy493:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy509;

			default:
				goto yy116;
		}

yy494:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy510;

			default:
				goto yy162;
		}

yy495:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy511;

			default:
				goto yy162;
		}

yy496:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy512;

			default:
				goto yy162;
		}

yy497:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy513;

			default:
				goto yy162;
		}

yy498:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy514;

			default:
				goto yy82;
		}

yy499:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy515;

			default:
				goto yy82;
		}

yy500:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy516;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy518;

			case '>':
				goto yy520;

			default:
				goto yy43;
		}

yy501:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy522;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy524;

			case '>':
				goto yy526;

			default:
				goto yy43;
		}

yy502:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy528;

			default:
				goto yy43;
		}

yy503:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy529;

			default:
				goto yy43;
		}

yy504:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy530;

			default:
				goto yy9;
		}

yy505:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy531;

			default:
				goto yy9;
		}

yy506:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy532;

			default:
				goto yy116;
		}

yy507:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy533;

			default:
				goto yy116;
		}

yy508:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy534;

			default:
				goto yy116;
		}

yy509:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy515;

			default:
				goto yy116;
		}

yy510:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy535;

			default:
				goto yy162;
		}

yy511:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy536;

			default:
				goto yy162;
		}

yy512:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy537;

			default:
				goto yy162;
		}

yy513:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy538;

			default:
				goto yy162;
		}

yy514:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy539;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '>':
				goto yy543;

			case 'T':
			case 't':
				goto yy545;

			default:
				goto yy43;
		}

yy515:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy546;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy548;

			case '>':
				goto yy550;

			default:
				goto yy43;
		}

yy516:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy516;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy518;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy518:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy552;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy518;

			case '/':
				goto yy46;

			case '=':
				goto yy554;

			case '>':
				goto yy520;

			default:
				goto yy42;
		}

yy520:
		++YYCURSOR;
		{
			return ITMZ_TOPIC_METADATA;
		}
yy522:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy522;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy524;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy524:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy556;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy524;

			case '/':
				goto yy46;

			case '=':
				goto yy558;

			case '>':
				goto yy526;

			default:
				goto yy42;
		}

yy526:
		++YYCURSOR;
		{
			return ITMZ_TOPIC_PREAMBLE;
		}
yy528:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy560;

			default:
				goto yy43;
		}

yy529:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy561;

			default:
				goto yy43;
		}

yy530:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy562;

			default:
				goto yy9;
		}

yy531:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy563;

			default:
				goto yy9;
		}

yy532:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy564;

			default:
				goto yy116;
		}

yy533:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy565;

			default:
				goto yy116;
		}

yy534:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy566;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '>':
				goto yy543;

			default:
				goto yy43;
		}

yy535:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy568;

			default:
				goto yy162;
		}

yy536:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy569;

			default:
				goto yy162;
		}

yy537:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy570;

			default:
				goto yy162;
		}

yy538:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy571;

			default:
				goto yy162;
		}

yy539:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy539;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy545;

			default:
				goto yy42;
		}

yy541:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy572;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '/':
				goto yy46;

			case '=':
				goto yy574;

			case '>':
				goto yy543;

			default:
				goto yy42;
		}

yy543:
		++YYCURSOR;
		{
			return ITMZ_TOPIC_METADATA;
		}
yy545:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy572;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '=':
				goto yy574;

			case '>':
				goto yy543;

			case 'E':
			case 'e':
				goto yy576;

			default:
				goto yy43;
		}

yy546:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy546;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy548;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy548:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy577;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy548;

			case '/':
				goto yy46;

			case '=':
				goto yy579;

			case '>':
				goto yy550;

			default:
				goto yy42;
		}

yy550:
		++YYCURSOR;
		{
			return ITMZ_TOPIC_PREAMBLE;
		}
yy552:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy552;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy518;

			case '=':
				goto yy554;

			case '>':
				goto yy520;

			default:
				goto yy42;
		}

yy554:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy554;

			case '"':
				goto yy581;

			case '\'':
				goto yy583;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy556:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy556;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy524;

			case '=':
				goto yy558;

			case '>':
				goto yy526;

			default:
				goto yy42;
		}

yy558:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy558;

			case '"':
				goto yy585;

			case '\'':
				goto yy587;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy560:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy589;

			default:
				goto yy43;
		}

yy561:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy565;

			default:
				goto yy43;
		}

yy562:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy590;

			default:
				goto yy9;
		}

yy563:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy591;

			default:
				goto yy9;
		}

yy564:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy592;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '>':
				goto yy596;

			case 'T':
			case 't':
				goto yy598;

			default:
				goto yy43;
		}

yy565:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy599;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy601;

			case '>':
				goto yy603;

			default:
				goto yy43;
		}

yy566:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy566;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy568:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy605;

			default:
				goto yy162;
		}

yy569:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy162;
		}

yy570:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy607;

			default:
				goto yy162;
		}

yy571:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy608;

			default:
				goto yy162;
		}

yy572:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy572;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '=':
				goto yy574;

			case '>':
				goto yy543;

			default:
				goto yy42;
		}

yy574:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy574;

			case '"':
				goto yy609;

			case '\'':
				goto yy611;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy576:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy572;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy541;

			case '=':
				goto yy574;

			case '>':
				goto yy543;

			case 'X':
			case 'x':
				goto yy613;

			default:
				goto yy43;
		}

yy577:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy577;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy548;

			case '=':
				goto yy579;

			case '>':
				goto yy550;

			default:
				goto yy42;
		}

yy579:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy579;

			case '"':
				goto yy614;

			case '\'':
				goto yy616;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy581:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy618;

			case '/':
				goto yy620;

			case '>':
				goto yy622;

			default:
				goto yy581;
		}

yy583:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy618;

			case '/':
				goto yy623;

			case '>':
				goto yy625;

			default:
				goto yy583;
		}

yy585:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy626;

			case '/':
				goto yy628;

			case '>':
				goto yy630;

			default:
				goto yy585;
		}

yy587:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy626;

			case '/':
				goto yy631;

			case '>':
				goto yy633;

			default:
				goto yy587;
		}

yy589:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy634;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '>':
				goto yy596;

			default:
				goto yy43;
		}

yy590:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy636;

			default:
				goto yy9;
		}

yy591:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy637;

			default:
				goto yy9;
		}

yy592:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy592;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '>':
				goto yy50;

			case 'T':
			case 't':
				goto yy598;

			default:
				goto yy42;
		}

yy594:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy638;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '/':
				goto yy46;

			case '=':
				goto yy640;

			case '>':
				goto yy596;

			default:
				goto yy42;
		}

yy596:
		++YYCURSOR;
		{
			return ITMZ_TOPIC_METADATA;
		}
yy598:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy638;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '=':
				goto yy640;

			case '>':
				goto yy596;

			case 'E':
			case 'e':
				goto yy642;

			default:
				goto yy43;
		}

yy599:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy599;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy601;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy601:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy643;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy601;

			case '/':
				goto yy46;

			case '=':
				goto yy645;

			case '>':
				goto yy603;

			default:
				goto yy42;
		}

yy603:
		++YYCURSOR;
		{
			return ITMZ_TOPIC_PREAMBLE;
		}
yy605:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy647;

			default:
				goto yy162;
		}

yy606:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy648;

			default:
				goto yy162;
		}

yy607:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy649;

			default:
				goto yy162;
		}

yy608:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy650;

			default:
				goto yy162;
		}

yy609:
		yych = *++YYCURSOR;
yy610:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy651;

			case '/':
				goto yy653;

			case '>':
				goto yy655;

			default:
				goto yy609;
		}

yy611:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy651;

			case '/':
				goto yy656;

			case '>':
				goto yy658;

			default:
				goto yy611;
		}

yy613:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy572;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '=':
				goto yy574;

			case '>':
				goto yy543;

			case 'T':
			case 't':
				goto yy659;

			default:
				goto yy43;
		}

yy614:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy660;

			case '/':
				goto yy662;

			case '>':
				goto yy664;

			default:
				goto yy614;
		}

yy616:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy660;

			case '/':
				goto yy665;

			case '>':
				goto yy667;

			default:
				goto yy616;
		}

yy618:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy618;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy518;

			case '>':
				goto yy520;

			default:
				goto yy42;
		}

yy620:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy618;

			case '/':
				goto yy620;

			case '>':
				goto yy668;

			default:
				goto yy581;
		}

yy622:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy670;
yy623:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy618;

			case '/':
				goto yy623;

			case '>':
				goto yy673;

			default:
				goto yy583;
		}

yy625:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy675;
yy626:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy626;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy524;

			case '>':
				goto yy526;

			default:
				goto yy42;
		}

yy628:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy626;

			case '/':
				goto yy628;

			case '>':
				goto yy676;

			default:
				goto yy585;
		}

yy630:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy678;
yy631:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy626;

			case '/':
				goto yy631;

			case '>':
				goto yy681;

			default:
				goto yy587;
		}

yy633:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy683;
yy634:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy634;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy636:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy684;

			default:
				goto yy9;
		}

yy637:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy685;

			default:
				goto yy9;
		}

yy638:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy638;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '=':
				goto yy640;

			case '>':
				goto yy596;

			default:
				goto yy42;
		}

yy640:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy640;

			case '"':
				goto yy686;

			case '\'':
				goto yy688;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy642:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy638;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy594;

			case '=':
				goto yy640;

			case '>':
				goto yy596;

			case 'X':
			case 'x':
				goto yy690;

			default:
				goto yy43;
		}

yy643:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy643;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy601;

			case '=':
				goto yy645;

			case '>':
				goto yy603;

			default:
				goto yy42;
		}

yy645:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy645;

			case '"':
				goto yy691;

			case '\'':
				goto yy693;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy647:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy695;

			default:
				goto yy162;
		}

yy648:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy696;

			default:
				goto yy162;
		}

yy649:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy543;

			default:
				goto yy698;
		}

yy650:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy550;

			default:
				goto yy702;
		}

yy651:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy651;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '>':
				goto yy543;

			default:
				goto yy42;
		}

yy653:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy651;

			case '/':
				goto yy653;

			case '>':
				goto yy705;

			default:
				goto yy609;
		}

yy655:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy707;
yy656:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy651;

			case '/':
				goto yy656;

			case '>':
				goto yy710;

			default:
				goto yy611;
		}

yy658:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy712;
yy659:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy713;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '=':
				goto yy715;

			case '>':
				goto yy543;

			default:
				goto yy43;
		}

yy660:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy660;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy548;

			case '>':
				goto yy550;

			default:
				goto yy42;
		}

yy662:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy660;

			case '/':
				goto yy662;

			case '>':
				goto yy717;

			default:
				goto yy614;
		}

yy664:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy719;
yy665:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy660;

			case '/':
				goto yy665;

			case '>':
				goto yy722;

			default:
				goto yy616;
		}

yy667:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy724;
yy668:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy670;
yy669:
		yych = *++YYCURSOR;
yy670:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy671;

			default:
				goto yy669;
		}

yy671:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy671;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy725;

			case '>':
				goto yy520;

			default:
				goto yy9;
		}

yy673:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy675;
yy674:
		yych = *++YYCURSOR;
yy675:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy671;

			default:
				goto yy674;
		}

yy676:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy678;
yy677:
		yych = *++YYCURSOR;
yy678:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy679;

			default:
				goto yy677;
		}

yy679:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy679;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy727;

			case '>':
				goto yy526;

			default:
				goto yy9;
		}

yy681:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy683;
yy682:
		yych = *++YYCURSOR;
yy683:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy679;

			default:
				goto yy682;
		}

yy684:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy729;

			default:
				goto yy9;
		}

yy685:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy696;

			default:
				goto yy9;
		}

yy686:
		yych = *++YYCURSOR;
yy687:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy730;

			case '/':
				goto yy732;

			case '>':
				goto yy734;

			default:
				goto yy686;
		}

yy688:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy730;

			case '/':
				goto yy735;

			case '>':
				goto yy737;

			default:
				goto yy688;
		}

yy690:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy638;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '=':
				goto yy640;

			case '>':
				goto yy596;

			case 'T':
			case 't':
				goto yy738;

			default:
				goto yy43;
		}

yy691:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy739;

			case '/':
				goto yy741;

			case '>':
				goto yy743;

			default:
				goto yy691;
		}

yy693:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy739;

			case '/':
				goto yy744;

			case '>':
				goto yy746;

			default:
				goto yy693;
		}

yy695:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy596;

			default:
				goto yy748;
		}

yy696:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy603;

			default:
				goto yy753;
		}

yy697:
		yych = *++YYCURSOR;
yy698:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy697;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy699;

			default:
				goto yy9;
		}

yy699:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy756;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy699;

			case '=':
				goto yy758;

			case '>':
				goto yy543;

			default:
				goto yy9;
		}

yy701:
		yych = *++YYCURSOR;
yy702:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy701;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy703;

			default:
				goto yy9;
		}

yy703:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy760;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy703;

			case '=':
				goto yy762;

			case '>':
				goto yy550;

			default:
				goto yy9;
		}

yy705:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy707;
yy706:
		yych = *++YYCURSOR;
yy707:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy708;

			default:
				goto yy706;
		}

yy708:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy708;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy699;

			case '>':
				goto yy543;

			default:
				goto yy9;
		}

yy710:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy712;
yy711:
		yych = *++YYCURSOR;
yy712:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy708;

			default:
				goto yy711;
		}

yy713:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy713;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy541;

			case '=':
				goto yy715;

			case '>':
				goto yy543;

			default:
				goto yy42;
		}

yy715:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy715;

			case '"':
				goto yy764;

			case '\'':
				goto yy611;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy717:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy719;
yy718:
		yych = *++YYCURSOR;
yy719:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy720;

			default:
				goto yy718;
		}

yy720:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy720;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy703;

			case '>':
				goto yy550;

			default:
				goto yy9;
		}

yy722:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy724;
yy723:
		yych = *++YYCURSOR;
yy724:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy720;

			default:
				goto yy723;
		}

yy725:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy765;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy725;

			case '=':
				goto yy767;

			case '>':
				goto yy520;

			default:
				goto yy9;
		}

yy727:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy769;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy727;

			case '=':
				goto yy771;

			case '>':
				goto yy526;

			default:
				goto yy9;
		}

yy729:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy596;

			default:
				goto yy774;
		}

yy730:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy730;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '>':
				goto yy596;

			default:
				goto yy42;
		}

yy732:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy730;

			case '/':
				goto yy732;

			case '>':
				goto yy775;

			default:
				goto yy686;
		}

yy734:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy777;
yy735:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy730;

			case '/':
				goto yy735;

			case '>':
				goto yy780;

			default:
				goto yy688;
		}

yy737:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy782;
yy738:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy783;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '=':
				goto yy785;

			case '>':
				goto yy596;

			default:
				goto yy43;
		}

yy739:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy739;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy601;

			case '>':
				goto yy603;

			default:
				goto yy42;
		}

yy741:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy739;

			case '/':
				goto yy741;

			case '>':
				goto yy787;

			default:
				goto yy691;
		}

yy743:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy789;
yy744:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy739;

			case '/':
				goto yy744;

			case '>':
				goto yy792;

			default:
				goto yy693;
		}

yy746:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy51;
		}

		goto yy794;
yy747:
		yych = *++YYCURSOR;
yy748:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy747;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy749;

			case 'T':
			case 't':
				goto yy751;

			default:
				goto yy9;
		}

yy749:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy795;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy749;

			case '=':
				goto yy797;

			case '>':
				goto yy596;

			default:
				goto yy9;
		}

yy751:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy749;

			case 'E':
			case 'e':
				goto yy799;

			default:
				goto yy796;
		}

yy752:
		yych = *++YYCURSOR;
yy753:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy752;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy754;

			default:
				goto yy9;
		}

yy754:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy800;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy754;

			case '=':
				goto yy802;

			case '>':
				goto yy603;

			default:
				goto yy9;
		}

yy756:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy756;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy699;

			case '=':
				goto yy758;

			case '>':
				goto yy543;

			default:
				goto yy9;
		}

yy758:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy758;

			case '"':
				goto yy706;

			case '\'':
				goto yy711;

			default:
				goto yy9;
		}

yy760:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy760;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy703;

			case '=':
				goto yy762;

			case '>':
				goto yy550;

			default:
				goto yy9;
		}

yy762:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy762;

			case '"':
				goto yy718;

			case '\'':
				goto yy723;

			default:
				goto yy9;
		}

yy764:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy804;

			default:
				goto yy610;
		}

yy765:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy765;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy725;

			case '=':
				goto yy767;

			case '>':
				goto yy520;

			default:
				goto yy9;
		}

yy767:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy767;

			case '"':
				goto yy669;

			case '\'':
				goto yy674;

			default:
				goto yy9;
		}

yy769:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy769;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy727;

			case '=':
				goto yy771;

			case '>':
				goto yy526;

			default:
				goto yy9;
		}

yy771:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy771;

			case '"':
				goto yy677;

			case '\'':
				goto yy682;

			default:
				goto yy9;
		}

yy773:
		yych = *++YYCURSOR;
yy774:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy773;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy749;

			default:
				goto yy9;
		}

yy775:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy777;
yy776:
		yych = *++YYCURSOR;
yy777:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy778;

			default:
				goto yy776;
		}

yy778:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy778;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy749;

			case '>':
				goto yy596;

			default:
				goto yy9;
		}

yy780:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy782;
yy781:
		yych = *++YYCURSOR;
yy782:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy778;

			default:
				goto yy781;
		}

yy783:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy783;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy594;

			case '=':
				goto yy785;

			case '>':
				goto yy596;

			default:
				goto yy42;
		}

yy785:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy785;

			case '"':
				goto yy805;

			case '\'':
				goto yy688;

			case '/':
				goto yy46;

			case '>':
				goto yy50;

			default:
				goto yy42;
		}

yy787:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy789;
yy788:
		yych = *++YYCURSOR;
yy789:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy790;

			default:
				goto yy788;
		}

yy790:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy790;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy754;

			case '>':
				goto yy603;

			default:
				goto yy9;
		}

yy792:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy62;
		}

		goto yy794;
yy793:
		yych = *++YYCURSOR;
yy794:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy790;

			default:
				goto yy793;
		}

yy795:
		yych = *++YYCURSOR;
yy796:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy795;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy749;

			case '=':
				goto yy797;

			case '>':
				goto yy596;

			default:
				goto yy9;
		}

yy797:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy797;

			case '"':
				goto yy776;

			case '\'':
				goto yy781;

			default:
				goto yy9;
		}

yy799:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy749;

			case 'X':
			case 'x':
				goto yy806;

			default:
				goto yy796;
		}

yy800:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy800;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy754;

			case '=':
				goto yy802;

			case '>':
				goto yy603;

			default:
				goto yy9;
		}

yy802:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy802;

			case '"':
				goto yy788;

			case '\'':
				goto yy793;

			default:
				goto yy9;
		}

yy804:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy807;

			default:
				goto yy610;
		}

yy805:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy808;

			default:
				goto yy687;
		}

yy806:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy749;

			case 'T':
			case 't':
				goto yy809;

			default:
				goto yy796;
		}

yy807:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy810;

			default:
				goto yy610;
		}

yy808:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy811;

			default:
				goto yy687;
		}

yy809:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy749;

			default:
				goto yy813;
		}

yy810:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy816;

			default:
				goto yy610;
		}

yy811:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy817;

			default:
				goto yy687;
		}

yy812:
		yych = *++YYCURSOR;
yy813:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy812;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy749;

			case '=':
				goto yy814;

			case '>':
				goto yy596;

			default:
				goto yy9;
		}

yy814:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy814;

			case '"':
				goto yy818;

			case '\'':
				goto yy781;

			default:
				goto yy9;
		}

yy816:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy819;

			default:
				goto yy610;
		}

yy817:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy820;

			default:
				goto yy687;
		}

yy818:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy821;

			default:
				goto yy777;
		}

yy819:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy822;

			default:
				goto yy610;
		}

yy820:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy823;

			default:
				goto yy687;
		}

yy821:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy824;

			default:
				goto yy777;
		}

yy822:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy825;

			default:
				goto yy610;
		}

yy823:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy826;

			default:
				goto yy687;
		}

yy824:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy827;

			default:
				goto yy777;
		}

yy825:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy828;

			default:
				goto yy610;
		}

yy826:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy829;

			default:
				goto yy687;
		}

yy827:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy830;

			default:
				goto yy777;
		}

yy828:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy831;

			default:
				goto yy610;
		}

yy829:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy832;

			default:
				goto yy687;
		}

yy830:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy833;

			default:
				goto yy777;
		}

yy831:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy834;

			default:
				goto yy610;
		}

yy832:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy835;

			default:
				goto yy687;
		}

yy833:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy836;

			default:
				goto yy777;
		}

yy834:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy837;

			default:
				goto yy610;
		}

yy835:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy838;

			default:
				goto yy687;
		}

yy836:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy839;

			default:
				goto yy777;
		}

yy837:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy840;

			default:
				goto yy610;
		}

yy838:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy841;

			default:
				goto yy687;
		}

yy839:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy842;

			default:
				goto yy777;
		}

yy840:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy843;

			default:
				goto yy610;
		}

yy841:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy844;

			default:
				goto yy687;
		}

yy842:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy845;

			default:
				goto yy777;
		}

yy843:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy846;

			default:
				goto yy610;
		}

yy844:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy847;

			default:
				goto yy687;
		}

yy845:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy848;

			default:
				goto yy777;
		}

yy846:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy849;

			default:
				goto yy610;
		}

yy847:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy850;

			default:
				goto yy687;
		}

yy848:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy851;

			default:
				goto yy777;
		}

yy849:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy852;

			default:
				goto yy610;
		}

yy850:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy853;

			default:
				goto yy687;
		}

yy851:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy854;

			default:
				goto yy777;
		}

yy852:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy855;

			default:
				goto yy610;
		}

yy853:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy856;

			default:
				goto yy687;
		}

yy854:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy857;

			default:
				goto yy777;
		}

yy855:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy858;

			default:
				goto yy610;
		}

yy856:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy859;

			default:
				goto yy687;
		}

yy857:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy860;

			default:
				goto yy777;
		}

yy858:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy861;

			default:
				goto yy610;
		}

yy859:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy862;

			default:
				goto yy687;
		}

yy860:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy863;

			default:
				goto yy777;
		}

yy861:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy864;

			default:
				goto yy610;
		}

yy862:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy865;

			default:
				goto yy687;
		}

yy863:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy866;

			default:
				goto yy777;
		}

yy864:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy867;

			default:
				goto yy610;
		}

yy865:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy868;

			default:
				goto yy687;
		}

yy866:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy869;

			default:
				goto yy777;
		}

yy867:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy870;

			default:
				goto yy610;
		}

yy868:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy871;

			default:
				goto yy687;
		}

yy869:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy872;

			default:
				goto yy777;
		}

yy870:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy873;

			default:
				goto yy610;
		}

yy871:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy874;

			default:
				goto yy687;
		}

yy872:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy875;

			default:
				goto yy777;
		}

yy873:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy876;

			default:
				goto yy610;
		}

yy874:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy877;

			default:
				goto yy687;
		}

yy875:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy878;

			default:
				goto yy777;
		}

yy876:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy879;

			default:
				goto yy610;
		}

yy877:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy880;

			default:
				goto yy687;
		}

yy878:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy881;

			default:
				goto yy777;
		}

yy879:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy882;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy548;

			case '>':
				goto yy550;

			default:
				goto yy43;
		}

yy880:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy884;

			default:
				goto yy687;
		}

yy881:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy885;

			default:
				goto yy777;
		}

yy882:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy882;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy548;

			case '>':
				goto yy543;

			default:
				goto yy42;
		}

yy884:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy886;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy601;

			case '>':
				goto yy603;

			default:
				goto yy43;
		}

yy885:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy888;

			default:
				goto yy777;
		}

yy886:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy886;

			case '/':
				goto yy46;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy601;

			case '>':
				goto yy596;

			default:
				goto yy42;
		}

yy888:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy889;

			default:
				goto yy777;
		}

yy889:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy890;

			default:
				goto yy777;
		}

yy890:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy603;

			default:
				goto yy892;
		}

yy891:
		yych = *++YYCURSOR;
yy892:

		switch (yych) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':
				goto yy891;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy754;

			case '>':
				goto yy596;

			default:
				goto yy9;
		}
	}

}

