#!/bin/sh

#  $Id: set_template.sh,v 1.2 2004/09/29 17:27:32 alien-science Exp $

[ $# -eq 1 ] || { cat << EOUSE ; exit 1 ; }

   Usage : $0 template

Generates a target for the given template substituting variables
in the form:
%%varname%% 
with the values coming in stdin  with the form:
varname=some value

EOUSE

template=$1

# Extract the target name
target=`echo $template | sed -e 's/\.tmpl$//'`

# Build a sed script
sed_script='.my_sed'

cat | sed -e 's/[^ _a-zA-Z0-9%]/_BSLASH&/g' \
          -e 's/_BSLASH/\\/g'     \
    | awk -F\= '{printf "s/%%%%%s%%%%/%s/\n", $1, $2}' \
         > $sed_script

# Run the sed script
sed -f $sed_script $template > $target

