
/* $Id: pipe.h,v 1.4 2005/03/11 23:16:02 alien-science Exp $ */

#ifndef PIPE_H
#define PIPE_H

#include "prog_config.h"

/** Internal pipes -- not Unix pipes 
    eg. compress | encrypt            **/

struct pipe {
   struct config  *conf;
   int            done_init;
   size_t         have_compressed;
   char           *scratch_buf;
   size_t         scratch_len;
   void           *compressor;
};

extern void 
pipe_alloc(struct pipe *, size_t, struct config *);

extern int
pipe_encrypt_init(struct pipe *, char *, size_t , char *, size_t *);

extern int 
pipe_encrypt(struct pipe *, char *, size_t, char *, size_t, size_t *);

extern int 
pipe_decrypt(struct pipe *, char *, size_t, char *, size_t, size_t *);

extern int 
pipe_enc_end(struct pipe *, char *, size_t, size_t *);

extern int 
pipe_dec_end(struct pipe *, char *, size_t, size_t *);

extern void 
pipe_free(struct pipe *);

#endif
