
/* $Id: prog_config.h,v 1.5 2005/03/11 23:16:02 alien-science Exp $ */

#ifndef PROG_CONFIG_H
#define PROG_CONFIG_H

#include <openssl/evp.h>

#define PASSPHRASE_MAXLEN        40
#define COMPRESS_HEADER_MAXLEN   64
#define KEYWORD_MAXLEN           32
#define FILENAME_MAXLEN          1024
#define BLOCKSIZE_MAXKB          16384

/* The structure holding encryption algorithm details */
struct cipher {
   char           *name;
   const EVP_CIPHER *type;
   EVP_CIPHER_CTX *ctx;
   size_t         keylen;
   size_t         ivlen;
   char           *key;
   char           *iv;
   char           *digest_name;
   const EVP_MD   *digest_type;
};


/* The structure holding program configuration options */
struct config {
   int            is_compressing;
   int            is_encrypting;
   int            noprompt;
   int            addkey;
   size_t         max_block_size;
   unsigned       entropy_bits;
   unsigned       magic_sum;
   char           salt[9];
   char           compress_header[COMPRESS_HEADER_MAXLEN];
   size_t         compress_header_len;
   char           *keyword;
   char           *keyfile;
   struct cipher  *cipher;
};

extern int conf_cipher(struct config *, char *, char *);

#endif
