/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mvndaemon.mvnd.common.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsUtils.class);
    private static final long KB = 1024L;
    private static final String UNITS = "Bkmgt";

    private OsUtils() {
    }

    public static String bytesToHumanReadable(long bytes) {
        int unit;
        for (unit = 0; bytes >= 1024L && unit < UNITS.length() - 1; bytes /= 1024L, ++unit) {
        }
        String bytesString = String.valueOf(bytes);
        return bytesString + UNITS.charAt(unit);
    }

    public static String kbToHumanReadable(long kb) {
        int unit;
        for (unit = 1; kb >= 1024L && unit < UNITS.length() - 1; kb /= 1024L, ++unit) {
        }
        String kbString = String.valueOf(kb);
        return kbString + UNITS.charAt(unit);
    }

    public static long findProcessRssInKb(long pid) {
        Os os = Os.current();
        if (os.isUnixLike()) {
            CharSequence[] cmd = new String[]{"ps", "-o", "rss=", "-p", String.valueOf(pid)};
            ArrayList<String> output = new ArrayList<String>(1);
            OsUtils.exec((String[])cmd, output);
            if (output.size() == 1) {
                try {
                    return Long.parseLong(((String)output.get(0)).trim());
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse the output of {} as a long:\n{}", (Object)String.join((CharSequence)" ", cmd), (Object)String.join((CharSequence)"\n", output));
                }
            } else {
                LOGGER.warn("Unexpected output of {}:\n{}", (Object)String.join((CharSequence)" ", cmd), (Object)String.join((CharSequence)"\n", output));
            }
            return -1L;
        }
        if (os == Os.WINDOWS) {
            CharSequence[] cmd = new String[]{"wmic", "process", "where", "processid=" + pid, "get", "WorkingSetSize"};
            ArrayList<String> output = new ArrayList<String>(1);
            OsUtils.exec((String[])cmd, output);
            List nonEmptyLines = output.stream().filter(l -> !l.isEmpty()).collect(Collectors.toList());
            if (nonEmptyLines.size() >= 2) {
                try {
                    return Long.parseLong(((String)nonEmptyLines.get(1)).trim()) / 1024L;
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse the second line of {} output as a long:\n{}", (Object)String.join((CharSequence)" ", cmd), (Object)String.join((CharSequence)"\n", nonEmptyLines));
                }
            } else {
                LOGGER.warn("Unexpected output of {}:\n{}", (Object)String.join((CharSequence)" ", cmd), (Object)String.join((CharSequence)"\n", output));
            }
            return -1L;
        }
        return -1L;
    }

    public static String findJavaHomeFromJavaExecutable(String javaExecutable) {
        String[] cmd = new String[]{javaExecutable, "-XshowSettings:properties", "-version"};
        ArrayList<String> output = new ArrayList<String>();
        OsUtils.exec(cmd, output);
        return output.stream().filter(l -> l.contains(" java.home = ")).map(l -> l.substring(l.indexOf(61) + 1).trim()).findFirst().orElse(null);
    }

    private static void exec(String[] cmd, List<String> output) {
        ProcessBuilder builder = new ProcessBuilder(cmd).redirectErrorStream(true);
        try (CommandProcess ps = new CommandProcess(builder.start(), output::add);){
            int exitCode = ps.waitFor(1000L);
            if (exitCode != 0) {
                LOGGER.warn("{} exited with {}:\n{}", new Object[]{String.join((CharSequence)" ", cmd), exitCode, String.join((CharSequence)"\n", output)});
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not execute {}", (Object)String.join((CharSequence)" ", cmd));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static class CommandProcess
    implements AutoCloseable {
        public static final int TIMEOUT_EXIT_CODE = -2147483606;
        private final Process process;
        private final Thread shutDownHook;
        private final StreamGobbler stdOut;

        public CommandProcess(Process process, Consumer<String> outputConsumer) {
            this.process = process;
            this.stdOut = new StreamGobbler(process.getInputStream(), outputConsumer);
            this.stdOut.start();
            this.shutDownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    stdOut.cancel();
                    process.destroy();
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }

        @Override
        public void close() {
            this.process.destroy();
        }

        public int waitFor(long timeoutMs) throws InterruptedException, IOException {
            long deadline = System.currentTimeMillis() + timeoutMs;
            boolean timeouted = !this.process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
            timeoutMs = Math.max(0L, deadline - System.currentTimeMillis());
            this.stdOut.join(timeoutMs);
            this.stdOut.assertSuccess();
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int exitCode = timeouted ? -2147483606 : this.process.exitValue();
            return exitCode;
        }

        static class StreamGobbler
        extends Thread {
            private volatile boolean cancelled;
            private IOException exception;
            private final InputStream in;
            private final Consumer<String> out;

            private StreamGobbler(InputStream in, Consumer<String> out) {
                this.in = in;
                this.out = out;
            }

            public void assertSuccess() throws IOException {
                if (this.exception != null) {
                    throw this.exception;
                }
            }

            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public void run() {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));){
                    String line;
                    while (!this.cancelled && (line = r.readLine()) != null) {
                        this.out.accept(line);
                    }
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
    }
}

