/*
	For testing nccmp with netcdf file with nans.

	gcc make_nans.c -L/net2/rsz/linux/netcdf/netcdf-3.6.1/lib -lnetcdf -o make_nans
	./make_nans out.nc 1

	20141120 rsz Created.
 */

#include <stdlib.h>
#include <stdio.h>
#include <netcdf.h>
#include <math.h>

#define handle_error(status) {											\
	if (status != NC_NOERR) {											\
		fprintf(stderr, "%s\n", nc_strerror(status));					\
		exit(-1);														\
	}																	\
}

#define LEN 8
#define TWO 2

int main(int argc, char *argv[])
{
	int nan = 0;
	int nanVarAtt = 0;
	int nanGlobalAtt = 0;
	int cdfid, varid1, varid2, status, recdimid, i;
	int dimids[4];
	float fp[LEN];
	double dp[LEN];
	float fpAtt[TWO];
	double dpAtt[TWO];
	size_t start[2], count[2];
	char* filename;

	if (argc == 3)
    {
        filename = argv[1];

		switch( atoi(argv[2]) )
		{
		case 1:
			nan = 1;
			break;
		case 2:
			nanGlobalAtt = 1;
			break;
		case 3:
			nanVarAtt = 1;
			break;
		default:
			break;
		}

    }	else
    {
        fprintf(stderr, "usage: %s <out.nc> [0=noNAN,1=nanVar,2=nanGlobalAtt,3=nanVarAtt]\n", argv[0]);
        fprintf(stderr, "\nexample: %s tmp.nc 1\n", argv[0]);
        return 1;
    }
        
	for(i=0; i < LEN; ++i) 
    {
		fp[i] = (float)i;
		dp[i] = (double)i;
    }
    
    if (nan) 
    {
        #ifndef NAN
        fprintf(stderr, "WARN: NAN not supported.\n");
        #endif
        
        fp[1] = fp[LEN-1] = NAN;
        dp[1] = dp[LEN-1] = NAN;
    }

	if (nanGlobalAtt || nanVarAtt )
    {
        #ifndef NAN
        fprintf(stderr, "WARN: NAN not supported.\n");
        #endif

        fpAtt[0] = 0;
        fpAtt[1] = NAN;

        dpAtt[0] = 0;
        dpAtt[1] = NAN;
    }
    
	status = nc_create(filename, NC_CLOBBER, &cdfid);
	handle_error(status);

	status = nc_def_dim(cdfid, "dim1", LEN, &dimids[1]); 
	handle_error(status);

	status = nc_def_dim(cdfid, "rec", NC_UNLIMITED, &recdimid); 
	handle_error(status);

	dimids[0] = recdimid;

	status = nc_def_var(cdfid, "test1", NC_FLOAT, 1, dimids+1, &varid1);
	handle_error(status);

	status = nc_def_var(cdfid, "test2", NC_DOUBLE, 2, dimids, &varid2);
	handle_error(status);

	if( nanGlobalAtt )
	{
		status = nc_put_att_float(cdfid, NC_GLOBAL, "globalAtt1", NC_FLOAT, TWO, fpAtt);
		handle_error(status);

		status = nc_put_att_double(cdfid, NC_GLOBAL, "globalAtt2", NC_DOUBLE, TWO, dpAtt);
		handle_error(status);
	}

	if ( nanVarAtt )
	{
		status = nc_put_att_float(cdfid, varid1, "varAtt1", NC_FLOAT, TWO, fpAtt);
		handle_error(status);

		status = nc_put_att_double(cdfid, varid2, "varAtt2", NC_DOUBLE, TWO, dpAtt);
		handle_error(status);
	}

	status = nc_enddef(cdfid);
	handle_error(status);

	status = nc_put_var_float(cdfid, varid1, fp);
	handle_error(status);

	start[0] = 0;
	start[1] = 0;
	count[0] = 1;
	count[1] = LEN;
	status = nc_put_vara_float(cdfid, varid2, start, count, fp);
	handle_error(status);

	start[0] = 1;
	status = nc_put_vara_double(cdfid, varid2, start, count, dp);
	handle_error(status);

	status = nc_close(cdfid);
	handle_error(status);

	return 0;
}
