/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

/*
 * This structure saves informations about
 * */

#ifndef _CLASSES_H_
#define _CLASSES_H_ 1

/* define class prototypes */

class Server;
class Screen;
class User;
class Messages;
class Parameter;
class UserDB;
class SigHandler;

#include "server.h"
#include "screen.h"
#include "user.h"
#include "messages.h"
#include "parameter.h"
#include "userdb.h"
#include "signals.h"

struct ClassPointers {
	Server     * Connection;
	Screen     * IrcScreen;
	User       * IrcUser;
	Messages   * MsgDB;
	Parameter  * TmpParameter;
	UserDB     * IrcUserDB;
	SigHandler * Signals;
};

#ifdef _MAIN_CC_

ClassPointers Classes;

#else

extern struct ClassPointers Classes;

#endif /* ifdef _MAIN_CC_    */

#endif /* ifndef _CLASSES_H_ */
