/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

/* This is a class to store temporary parameters
 * every entry has a unique index number from 0 to (PARAMETER_MAX_PARAMS-1)*/

#ifndef _PARAMETER_H_
#define _PARAMETER_H_ 1

#include "config.h"
#include "classes.h"
#include "functions.h"

class Parameter {
private:
	char ** param_list_ptr;
	int num_parameters;
	int last_parameter;
public:
	Parameter(void);
	~Parameter(void);
	void Init_Reset_Parameters(void);
	int Add_Parameter(char * parameter_str); /* ret value: index number or -1 ond error */
	void Remove_Parameter(int parameter_index);
	char * Read_Parameter(int parameter_index);
	char * GetFirstElement(void);
	char * GetNextElement(void); /* get the next real element */
	int Get_Num_Parameter(void);
	int Get_Last_Parameter(void);
};

#endif
