# Recognizing Contributors

The project looks to recognize and thank contributors for their contributions
as one of the ways we can help them continue to contribute to the project.

This document captures some of the processes we have in place to do that.

Some of the benefits we hope to achieve through these programs include:

* Ensuring people know that the project appreciates their work
* Encouraging people to repeat/grow their contributions
* Helping people demonstrate to their managers the value of the
  contributions they are making, which in terms helps their manager support
  their employer investing in the project (unfortunately this is
  something that matters)
* Highlighting the new features in Node.js and showing that they are
  being added by individuals like those mentioned. This should encourage
  other people to get involved and make similar contributions.
* Highlighting those leading efforts/initiatives and they are being
  done by individuals or teams like those mentioned. This should
  encourage other people to get involved and make similar contributions

## Sponsorship link on nodejs/node README.md

Collaborators may add a single link beside their name on the nodejs/node
[`README.md`](../../README.md) file in the section titled `Collaborators`
named `Support me`. This link may be:

1. a direct link to one of the sponsorship platforms listed below,
2. a page that has text explaining how to support the collaborator
   including zero or more links to the sponsorship platforms listed below.
   The page should not have any outgoing links other than to the
   sponsorship platforms. We expect and trust collaborators to ensure that
   the text is professional and respectful.

The sponsorship platforms to which links can be made currently
includes (in alphabetical order):

* [GitHub Sponsors](https://github.com/sponsors)
* [Polar](https://polar.sh/)
* [thanks.dev](https://thanks.dev)

## Amplification of posts announcing talks by collaborators

When a collaborator is speaking at a public event they may request amplification
by the Node.js social media accounts. They can request that a post highlighting
that they are speaking at the event be amplified by the Node.js accounts by
making a request in the #nodejs-social channel in the OpenJS Foundation slack.
We trust that collaborators will only request amplification when they believe
the event is revelant to the Node.js community and the content of the post is
in line with the norms of the project.

## Bi-monthly contributor spotlight

The contributor spotlight program showcases individual(s) or teams who have
made signification contributions to the project. Anybody who is not
a member of the Technical Steering Committee (TSC) and has made a
notable contribution to the project can be nominated. They DO NOT need
to be a collaborator, team member etc.

The work of the team or individual(s) will be showcased on the
Node.js social channels and, if warranted, through a blog post created by the
OpenJS marketing staff along with the team or individual(s) which will
be published on [openjsf.org](https://openjsf.org/).

Nominations can be made through this web form:
[Contributor Spotlight nomination](https://forms.gle/dXBXZn8yu83HLJ57A)

Nominations will be reviewed/approved by the Technical Steering Committee (TSC)
on a regular basis as scheduled by the TSC chair. The TSC will also
recommend the order in which approved nominations are processed
by the OpenJS marketing staff.

Before any work proceeds on an approved nomination the individual(s)
or team will be contacted to confirm they want to participate. Social
content and or spotlight blog post will only be published after the
team or individual(s) have confirmed they are happy with the content.
