#!/usr/bin/env perl
# Copyright (C) 2008-2011, The Perl Foundation.

use strict;
use warnings;
use v5.10;

use Config;
use File::Spec;

binmode STDOUT, ':utf8';

my ($prefix, $thirdPartyJars) = @ARGV;

my $cpsep = $^O eq 'MSWin32' ? ';' : ':';
my $jardir = ".";
my $libdir = ".";
my $slash = File::Spec->catdir('', '');

if ($prefix ne '.') {
    $jardir = File::Spec->catdir($prefix, qw<share nqp runtime>);
    $libdir = File::Spec->catdir($prefix, qw<share nqp lib>);
	my @jars = grep { s/^.*\Q${slash}\E// } split($cpsep, $thirdPartyJars);
	$thirdPartyJars = join($cpsep, grep { s/^/${jardir}${slash}/ } @jars);
}

$thirdPartyJars .= "${cpsep}${jardir}${slash}nqp-runtime.jar${cpsep}${libdir}${slash}nqp.jar";

s/\\/\\\\/g for ($prefix, $thirdPartyJars, $libdir);

# We extract information from Perl's config to know how to compile shared
# libraries (which is needed for nativecall stuff). If this has to be tweaked
# in the future, I found this to be an invaluable reference:
# http://perl5.git.perl.org/perl.git/blob/HEAD:/Porting/Glossary
my $ccdlflags = "$Config{cccdlflags} $Config{ccdlflags}";
my $ldout = $^O eq 'MSWin32'? '-out:' : '-o';

print <<"END";
# This file automatically generated by $0

prefix=${prefix}
runtime.bootclasspath=-Xbootclasspath/a:.${cpsep}${thirdPartyJars}
runtime.classpath=${libdir}
runtime.jars=${thirdPartyJars}
nativecall.o=$Config{_o}
nativecall.so=$Config{so}
nativecall.cc=$Config{cc}
nativecall.ccflags=$Config{ccflags}
nativecall.ccdlflags=$ccdlflags
nativecall.ld=$Config{ld}
nativecall.ldout=$ldout
nativecall.ldflags=$Config{ldflags}
nativecall.lddlflags=$Config{lddlflags}
nativecall.libs=$Config{libs}
nativecall.perllibs=$Config{perllibs}
END
