package directx_d3d11

foreign import "system:d3d11.lib"

import "../dxgi"
import "../d3d_compiler"

IUnknown        :: dxgi.IUnknown
IUnknown_VTable :: dxgi.IUnknown_VTable

HANDLE  :: dxgi.HANDLE
HMODULE :: dxgi.HMODULE
HRESULT :: dxgi.HRESULT
GUID    :: dxgi.GUID
IID     :: dxgi.IID
SIZE_T  :: dxgi.SIZE_T
BOOL    :: dxgi.BOOL

RECT :: dxgi.RECT
SIZE :: dxgi.SIZE

IModuleInstance :: d3d_compiler.ID3D11ModuleInstance
IBlob           :: d3d_compiler.ID3DBlob
IModule         :: d3d_compiler.ID3D11Module

@(default_calling_convention="stdcall", link_prefix="D3D11")
foreign d3d11 {
	CreateDevice :: proc(
		pAdapter:           ^dxgi.IAdapter,
		DriverType:         DRIVER_TYPE,
		Software:           HMODULE,
		Flags:              CREATE_DEVICE_FLAGS,
		pFeatureLevels:     ^FEATURE_LEVEL,
		FeatureLevels:      u32,
		SDKVersion:         u32,
		ppDevice:           ^^IDevice,
		pFeatureLevel:      ^FEATURE_LEVEL,
		ppImmediateContext: ^^IDeviceContext,
	) -> HRESULT ---
	CreateDeviceAndSwapChain :: proc(
		pAdapter:           ^dxgi.IAdapter,
		DriverType:         DRIVER_TYPE,
		Software:           HMODULE,
		Flags:              u32,
		pFeatureLevels:     ^FEATURE_LEVEL,
		FeatureLevels:      u32,
		SDKVersion:         u32,
		pSwapChainDesc:     ^dxgi.SWAP_CHAIN_DESC,
		ppSwapChain:        ^^dxgi.ISwapChain,
		ppDevice:           ^^IDevice,
		pFeatureLevel:      ^FEATURE_LEVEL,
		ppImmediateContext: ^^IDeviceContext,
	) -> HRESULT ---
}

foreign d3d11 {
	WKPDID_D3DDebugObjectNameW: GUID
	WKPDID_CommentStringW:      GUID
}

@(link_prefix="D3D_")
foreign d3d11 {
	TEXTURE_LAYOUT_ROW_MAJOR:             GUID
	TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE: GUID
}

@(link_prefix="D3D11_")
foreign d3d11 {
	DECODER_PROFILE_MPEG2_MOCOMP:                      GUID
	DECODER_PROFILE_MPEG2_IDCT:                        GUID
	DECODER_PROFILE_MPEG2_VLD:                         GUID
	DECODER_PROFILE_MPEG1_VLD:                         GUID
	DECODER_PROFILE_MPEG2and1_VLD:                     GUID
	DECODER_PROFILE_H264_MOCOMP_NOFGT:                 GUID
	DECODER_PROFILE_H264_MOCOMP_FGT:                   GUID
	DECODER_PROFILE_H264_IDCT_NOFGT:                   GUID
	DECODER_PROFILE_H264_IDCT_FGT:                     GUID
	DECODER_PROFILE_H264_VLD_NOFGT:                    GUID
	DECODER_PROFILE_H264_VLD_FGT:                      GUID
	DECODER_PROFILE_H264_VLD_WITHFMOASO_NOFGT:         GUID
	DECODER_PROFILE_H264_VLD_STEREO_PROGRESSIVE_NOFGT: GUID
	DECODER_PROFILE_H264_VLD_STEREO_NOFGT:             GUID
	DECODER_PROFILE_H264_VLD_MULTIVIEW_NOFGT:          GUID
	DECODER_PROFILE_WMV8_POSTPROC:                     GUID
	DECODER_PROFILE_WMV8_MOCOMP:                       GUID
	DECODER_PROFILE_WMV9_POSTPROC:                     GUID
	DECODER_PROFILE_WMV9_MOCOMP:                       GUID
	DECODER_PROFILE_WMV9_IDCT:                         GUID
	DECODER_PROFILE_VC1_POSTPROC:                      GUID
	DECODER_PROFILE_VC1_MOCOMP:                        GUID
	DECODER_PROFILE_VC1_IDCT:                          GUID
	DECODER_PROFILE_VC1_VLD:                           GUID
	DECODER_PROFILE_VC1_D2010:                         GUID
	DECODER_PROFILE_MPEG4PT2_VLD_SIMPLE:               GUID
	DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_NOGMC:      GUID
	DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_GMC:        GUID
	DECODER_PROFILE_HEVC_VLD_MAIN:                     GUID
	DECODER_PROFILE_HEVC_VLD_MAIN10:                   GUID
	DECODER_PROFILE_VP9_VLD_PROFILE0:                  GUID
	DECODER_PROFILE_VP9_VLD_10BIT_PROFILE2:            GUID
	DECODER_PROFILE_VP8_VLD:                           GUID

	CRYPTO_TYPE_AES128_CTR:                 GUID
	DECODER_ENCRYPTION_HW_CENC:             GUID
	DECODER_BITSTREAM_ENCRYPTION_TYPE_CENC: GUID
	DECODER_BITSTREAM_ENCRYPTION_TYPE_CBCS: GUID
	KEY_EXCHANGE_HW_PROTECTION:             GUID

	AUTHENTICATED_QUERY_PROTECTION:                                   GUID
	AUTHENTICATED_QUERY_CHANNEL_TYPE:                                 GUID
	AUTHENTICATED_QUERY_DEVICE_HANDLE:                                GUID
	AUTHENTICATED_QUERY_CRYPTO_SESSION:                               GUID
	AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT:     GUID
	AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS:           GUID
	AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT: GUID
	AUTHENTICATED_QUERY_OUTPUT_ID_COUNT:                              GUID
	AUTHENTICATED_QUERY_OUTPUT_ID:                                    GUID
	AUTHENTICATED_QUERY_ACCESSIBILITY_ATTRIBUTES:                     GUID
	AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID_COUNT:        GUID
	AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID:              GUID
	AUTHENTICATED_QUERY_CURRENT_ENCRYPTION_WHEN_ACCESSIBLE:           GUID
	AUTHENTICATED_CONFIGURE_INITIALIZE:                               GUID
	AUTHENTICATED_CONFIGURE_PROTECTION:                               GUID
	AUTHENTICATED_CONFIGURE_CRYPTO_SESSION:                           GUID
	AUTHENTICATED_CONFIGURE_SHARED_RESOURCE:                          GUID
	AUTHENTICATED_CONFIGURE_ENCRYPTION_WHEN_ACCESSIBLE:               GUID

	KEY_EXCHANGE_RSAES_OAEP: GUID
}

FL9_1_REQ_TEXTURE1D_U_DIMENSION        :: 2048
FL9_3_REQ_TEXTURE1D_U_DIMENSION        :: 4096
FL9_1_REQ_TEXTURE2D_U_OR_V_DIMENSION   :: 2048
FL9_3_REQ_TEXTURE2D_U_OR_V_DIMENSION   :: 4096
FL9_1_REQ_TEXTURECUBE_DIMENSION        :: 512
FL9_3_REQ_TEXTURECUBE_DIMENSION        :: 4096
FL9_1_REQ_TEXTURE3D_U_V_OR_W_DIMENSION :: 256
FL9_1_DEFAULT_MAX_ANISOTROPY           :: 2
FL9_1_IA_PRIMITIVE_MAX_COUNT           :: 65535
FL9_2_IA_PRIMITIVE_MAX_COUNT           :: 1048575
FL9_1_SIMULTANEOUS_RENDER_TARGET_COUNT :: 1
FL9_3_SIMULTANEOUS_RENDER_TARGET_COUNT :: 4
FL9_1_MAX_TEXTURE_REPEAT               :: 128
FL9_2_MAX_TEXTURE_REPEAT               :: 2048
FL9_3_MAX_TEXTURE_REPEAT               :: 8192

_8BIT_INDEX_STRIP_CUT_VALUE  :: 0xff
_16BIT_INDEX_STRIP_CUT_VALUE :: 0xffff
_32BIT_INDEX_STRIP_CUT_VALUE :: 0xffffffff

ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT :: 9

CLIP_OR_CULL_DISTANCE_COUNT         :: 8
CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT :: 2

COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT                        :: 14
COMMONSHADER_CONSTANT_BUFFER_COMPONENTS                            :: 4
COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT                   :: 32
COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT                         :: 15
COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT :: 16
COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS                   :: 4
COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT                        :: 15
COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST               :: 1
COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS                   :: 1
COMMONSHADER_FLOWCONTROL_NESTING_LIMIT                             :: 64
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS         :: 4
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT              :: 1
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST     :: 1
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS         :: 1
COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT                   :: 32
COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS                    :: 1
COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT                         :: 128
COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST                :: 1
COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS                    :: 1
COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT                             :: 128
COMMONSHADER_SAMPLER_REGISTER_COMPONENTS                           :: 1
COMMONSHADER_SAMPLER_REGISTER_COUNT                                :: 16
COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST                       :: 1
COMMONSHADER_SAMPLER_REGISTER_READ_PORTS                           :: 1
COMMONSHADER_SAMPLER_SLOT_COUNT                                    :: 16
COMMONSHADER_SUBROUTINE_NESTING_LIMIT                              :: 32
COMMONSHADER_TEMP_REGISTER_COMPONENTS                              :: 4
COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT                     :: 32
COMMONSHADER_TEMP_REGISTER_COUNT                                   :: 4096
COMMONSHADER_TEMP_REGISTER_READS_PER_INST                          :: 3
COMMONSHADER_TEMP_REGISTER_READ_PORTS                              :: 3
COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX                          :: 10
COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN                          :: -10
COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE                             :: -8
COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE                             :: 7

CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 256
CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP          :: 64
CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 240
CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP          :: 68
CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 224
CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP          :: 72
CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 208
CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP          :: 76
CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 192
CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP          :: 84
CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 176
CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP          :: 92
CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 160
CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP          :: 100
CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 144
CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP          :: 112
CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 128
CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP          :: 128
CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 112
CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP          :: 144
CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 96
CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP          :: 168
CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 80
CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP          :: 204
CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 64
CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP          :: 256
CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 48
CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP          :: 340
CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 32
CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP          :: 512
CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 16
CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP          :: 768
CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION   :: 1
CS_4_X_RAW_UAV_BYTE_ALIGNMENT                      :: 256
CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP          :: 768
CS_4_X_THREAD_GROUP_MAX_X                          :: 768
CS_4_X_THREAD_GROUP_MAX_Y                          :: 768
CS_4_X_UAV_REGISTER_COUNT                          :: 1

CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION :: 65535
CS_TGSM_REGISTER_COUNT :: 8192
CS_TGSM_REGISTER_READS_PER_INST :: 1
CS_TGSM_RESOURCE_REGISTER_COMPONENTS :: 1
CS_TGSM_RESOURCE_REGISTER_READ_PORTS :: 1
CS_THREADGROUPID_REGISTER_COMPONENTS :: 3
CS_THREADGROUPID_REGISTER_COUNT :: 1
CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS :: 1
CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT :: 1
CS_THREADIDINGROUP_REGISTER_COMPONENTS :: 3
CS_THREADIDINGROUP_REGISTER_COUNT :: 1
CS_THREADID_REGISTER_COMPONENTS :: 3
CS_THREADID_REGISTER_COUNT :: 1
CS_THREAD_GROUP_MAX_THREADS_PER_GROUP :: 1024
CS_THREAD_GROUP_MAX_X :: 1024
CS_THREAD_GROUP_MAX_Y :: 1024
CS_THREAD_GROUP_MAX_Z :: 64
CS_THREAD_GROUP_MIN_X :: 1
CS_THREAD_GROUP_MIN_Y :: 1
CS_THREAD_GROUP_MIN_Z :: 1
CS_THREAD_LOCAL_TEMP_REGISTER_POOL :: 16384

DEFAULT_BLEND_FACTOR_ALPHA :: 1.0
DEFAULT_BLEND_FACTOR_BLUE :: 1.0
DEFAULT_BLEND_FACTOR_GREEN :: 1.0
DEFAULT_BLEND_FACTOR_RED :: 1.0
DEFAULT_BORDER_COLOR_COMPONENT :: 0.0
DEFAULT_DEPTH_BIAS :: 0
DEFAULT_DEPTH_BIAS_CLAMP :: 0.0
DEFAULT_MAX_ANISOTROPY :: 16
DEFAULT_MIP_LOD_BIAS :: 0.0
DEFAULT_RENDER_TARGET_ARRAY_INDEX :: 0
DEFAULT_SAMPLE_MASK :: 0xffffffff
DEFAULT_SCISSOR_ENDX :: 0
DEFAULT_SCISSOR_ENDY :: 0
DEFAULT_SCISSOR_STARTX :: 0
DEFAULT_SCISSOR_STARTY :: 0
DEFAULT_SLOPE_SCALED_DEPTH_BIAS :: 0.0
DEFAULT_STENCIL_READ_MASK :: 0xff
DEFAULT_STENCIL_REFERENCE :: 0
DEFAULT_STENCIL_WRITE_MASK :: 0xff
DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX :: 0
DEFAULT_VIEWPORT_HEIGHT :: 0
DEFAULT_VIEWPORT_MAX_DEPTH :: 0.0
DEFAULT_VIEWPORT_MIN_DEPTH :: 0.0
DEFAULT_VIEWPORT_TOPLEFTX :: 0
DEFAULT_VIEWPORT_TOPLEFTY :: 0
DEFAULT_VIEWPORT_WIDTH :: 0

DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS            :: 3968
DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS           :: 4
DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT  :: 32
DS_INPUT_CONTROL_POINT_REGISTER_COUNT                :: 32
DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST       :: 2
DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS           :: 1
DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS            :: 3
DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT   :: 32
DS_INPUT_DOMAIN_POINT_REGISTER_COUNT                 :: 1
DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST        :: 2
DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS            :: 1
DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS          :: 4
DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT :: 32
DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT               :: 32
DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST      :: 2
DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS          :: 1
DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS            :: 1
DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT   :: 32
DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT                 :: 1
DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST        :: 2
DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS            :: 1
DS_OUTPUT_REGISTER_COMPONENTS                        :: 4
DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT               :: 32
DS_OUTPUT_REGISTER_COUNT                             :: 32

FLOAT16_FUSED_TOLERANCE_IN_ULP :: 0.6
FLOAT32_MAX :: 3.402823466e+38
FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP :: 0.6
FLOAT_TO_SRGB_EXPONENT_DENOMINATOR :: 2.4
FLOAT_TO_SRGB_EXPONENT_NUMERATOR :: 1.0
FLOAT_TO_SRGB_OFFSET :: 0.055
FLOAT_TO_SRGB_SCALE_1 :: 12.92
FLOAT_TO_SRGB_SCALE_2 :: 1.055
FLOAT_TO_SRGB_THRESHOLD :: 0.0031308
FTOI_INSTRUCTION_MAX_INPUT :: 2147483647.999
FTOI_INSTRUCTION_MIN_INPUT :: -2147483648.999
FTOU_INSTRUCTION_MAX_INPUT :: 4294967295.999
FTOU_INSTRUCTION_MIN_INPUT :: 0.0
GS_INPUT_INSTANCE_ID_READS_PER_INST :: 2
GS_INPUT_INSTANCE_ID_READ_PORTS :: 1
GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS :: 1
GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_INPUT_INSTANCE_ID_REGISTER_COUNT :: 1
GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS :: 1
GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_INPUT_PRIM_CONST_REGISTER_COUNT :: 1
GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST :: 2
GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS :: 1
GS_INPUT_REGISTER_COMPONENTS :: 4
GS_INPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_INPUT_REGISTER_COUNT :: 32
GS_INPUT_REGISTER_READS_PER_INST :: 2
GS_INPUT_REGISTER_READ_PORTS :: 1
GS_INPUT_REGISTER_VERTICES :: 32
GS_MAX_INSTANCE_COUNT :: 32
GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES :: 1024
GS_OUTPUT_ELEMENTS :: 32
GS_OUTPUT_REGISTER_COMPONENTS :: 4
GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_OUTPUT_REGISTER_COUNT :: 32
HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT :: 32
HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT :: 32
HS_CONTROL_POINT_REGISTER_COMPONENTS :: 4
HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_CONTROL_POINT_REGISTER_READS_PER_INST :: 2
HS_CONTROL_POINT_REGISTER_READ_PORTS :: 1
HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND :: 0xffffffff
HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS :: 1
HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT :: 1
HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST :: 2
HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS :: 1
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS :: 1
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT :: 1
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST :: 2
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS :: 1
HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS :: 1
HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT :: 1
HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST :: 2
HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS :: 1
HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND :: 0xffffffff
HS_MAXTESSFACTOR_LOWER_BOUND :: 1.0
HS_MAXTESSFACTOR_UPPER_BOUND :: 64.0
HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS :: 3968
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS :: 1
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT :: 1
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST :: 2
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS :: 1
HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS :: 4
HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT :: 32
HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST :: 2
HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS :: 1
HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS :: 128
IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES :: 0
IA_DEFAULT_PRIMITIVE_TOPOLOGY :: 0
IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES :: 0
IA_INDEX_INPUT_RESOURCE_SLOT_COUNT :: 1
IA_INSTANCE_ID_BIT_COUNT :: 32
IA_INTEGER_ARITHMETIC_BIT_COUNT :: 32
IA_PATCH_MAX_CONTROL_POINT_COUNT :: 32
IA_PRIMITIVE_ID_BIT_COUNT :: 32
IA_VERTEX_ID_BIT_COUNT :: 32
IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT :: 32
IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS :: 128
IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT :: 32
INTEGER_DIVIDE_BY_ZERO_QUOTIENT :: 0xffffffff
INTEGER_DIVIDE_BY_ZERO_REMAINDER :: 0xffffffff
KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL :: 0xffffffff
KEEP_UNORDERED_ACCESS_VIEWS :: 0xffffffff
LINEAR_GAMMA :: 1.0
MAJOR_VERSION :: 11
MAX_BORDER_COLOR_COMPONENT :: 1.0
MAX_DEPTH :: 1.0
MAX_MAXANISOTROPY :: 16
MAX_MULTISAMPLE_SAMPLE_COUNT :: 32
MAX_POSITION_VALUE :: 3.402823466e+34
MAX_TEXTURE_DIMENSION_2_TO_EXP :: 17
MINOR_VERSION :: 0
MIN_BORDER_COLOR_COMPONENT :: 0.0
MIN_DEPTH :: 0.0
MIN_MAXANISOTROPY :: 0
MIP_LOD_BIAS_MAX :: 15.99
MIP_LOD_BIAS_MIN :: -16.0
MIP_LOD_FRACTIONAL_BIT_COUNT :: 8
MIP_LOD_RANGE_BIT_COUNT :: 8
MULTISAMPLE_ANTIALIAS_LINE_WIDTH :: 1.4
NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT :: 0
PIXEL_ADDRESS_RANGE_BIT_COUNT :: 15
PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT :: 16
PS_CS_UAV_REGISTER_COMPONENTS :: 1
PS_CS_UAV_REGISTER_COUNT :: 8
PS_CS_UAV_REGISTER_READS_PER_INST :: 1
PS_CS_UAV_REGISTER_READ_PORTS :: 1
PS_FRONTFACING_DEFAULT_VALUE :: 0xffffffff
PS_FRONTFACING_FALSE_VALUE :: 0
PS_FRONTFACING_TRUE_VALUE :: 0xffffffff
PS_INPUT_REGISTER_COMPONENTS :: 4
PS_INPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_INPUT_REGISTER_COUNT :: 32
PS_INPUT_REGISTER_READS_PER_INST :: 2
PS_INPUT_REGISTER_READ_PORTS :: 1
PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT :: 0.0
PS_OUTPUT_DEPTH_REGISTER_COMPONENTS :: 1
PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_OUTPUT_DEPTH_REGISTER_COUNT :: 1
PS_OUTPUT_MASK_REGISTER_COMPONENTS :: 1
PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_OUTPUT_MASK_REGISTER_COUNT :: 1
PS_OUTPUT_REGISTER_COMPONENTS :: 4
PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_OUTPUT_REGISTER_COUNT :: 8
PS_PIXEL_CENTER_FRACTIONAL_COMPONENT :: 0.5
RAW_UAV_SRV_BYTE_ALIGNMENT :: 16
REQ_BLEND_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP :: 27
REQ_CONSTANT_BUFFER_ELEMENT_COUNT :: 4096
REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP :: 32
REQ_DRAW_VERTEX_COUNT_2_TO_EXP :: 32
REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION :: 16384
REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT :: 1024
REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT :: 4096
REQ_MAXANISOTROPY :: 16
REQ_MIP_LEVELS :: 15
REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES :: 2048
REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_RENDER_TO_BUFFER_WINDOW_WIDTH :: 16384
REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM :: 128
REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM :: 0.25
REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM :: 2048
REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP :: 20
REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION :: 2048
REQ_TEXTURE1D_U_DIMENSION :: 16384
REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION :: 2048
REQ_TEXTURE2D_U_OR_V_DIMENSION :: 16384
REQ_TEXTURE3D_U_V_OR_W_DIMENSION :: 2048
REQ_TEXTURECUBE_DIMENSION :: 16384
RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL :: 0
SHADER_MAJOR_VERSION :: 5
SHADER_MAX_INSTANCES :: 65535
SHADER_MAX_INTERFACES :: 253
SHADER_MAX_INTERFACE_CALL_SITES :: 4096
SHADER_MAX_TYPES :: 65535
SHADER_MINOR_VERSION :: 0
SHIFT_INSTRUCTION_PAD_VALUE :: 0
SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT :: 5
SIMULTANEOUS_RENDER_TARGET_COUNT :: 8
SO_BUFFER_MAX_STRIDE_IN_BYTES :: 2048
SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES :: 512
SO_BUFFER_SLOT_COUNT :: 4
SO_DDI_REGISTER_INDEX_DENOTING_GAP :: 0xffffffff
SO_NO_RASTERIZED_STREAM :: 0xffffffff
SO_OUTPUT_COMPONENT_COUNT :: 128
SO_STREAM_COUNT :: 4
SPEC_DATE_DAY :: 16
SPEC_DATE_YEAR :: 2011
SPEC_VERSION :: 1.07
SRGB_GAMMA :: 2.2
SRGB_TO_FLOAT_DENOMINATOR_1 :: 12.92
SRGB_TO_FLOAT_DENOMINATOR_2 :: 1.055
SRGB_TO_FLOAT_EXPONENT :: 2.4
SRGB_TO_FLOAT_OFFSET :: 0.055
SRGB_TO_FLOAT_THRESHOLD :: 0.04045
SRGB_TO_FLOAT_TOLERANCE_IN_ULP :: 0.5
STANDARD_COMPONENT_BIT_COUNT :: 32
STANDARD_COMPONENT_BIT_COUNT_DOUBLED :: 64
STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE :: 4
STANDARD_PIXEL_COMPONENT_COUNT :: 128
STANDARD_PIXEL_ELEMENT_COUNT :: 32
STANDARD_VECTOR_SIZE :: 4
STANDARD_VERTEX_ELEMENT_COUNT :: 32
STANDARD_VERTEX_TOTAL_COMPONENT_COUNT :: 64
SUBPIXEL_FRACTIONAL_BIT_COUNT :: 8
SUBTEXEL_FRACTIONAL_BIT_COUNT :: 8
TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR :: 64
TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR :: 64
TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR :: 63
TESSELLATOR_MAX_TESSELLATION_FACTOR :: 64
TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR :: 2
TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR :: 1
TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR :: 1
TEXEL_ADDRESS_RANGE_BIT_COUNT :: 16
UNBOUND_MEMORY_ACCESS_RESULT :: 0
VIEWPORT_AND_SCISSORRECT_MAX_INDEX :: 15
VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE :: 16
VIEWPORT_BOUNDS_MAX :: 32767
VIEWPORT_BOUNDS_MIN :: -32768
VS_INPUT_REGISTER_COMPONENTS :: 4
VS_INPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
VS_INPUT_REGISTER_COUNT :: 32
VS_INPUT_REGISTER_READS_PER_INST :: 2
VS_INPUT_REGISTER_READ_PORTS :: 1
VS_OUTPUT_REGISTER_COMPONENTS :: 4
VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
VS_OUTPUT_REGISTER_COUNT :: 32
WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT :: 10
WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP :: 25
WHQL_DRAW_VERTEX_COUNT_2_TO_EXP :: 25
_1_UAV_SLOT_COUNT :: 64
_2_TILED_RESOURCE_TILE_SIZE_IN_BYTES :: 65536
_4_VIDEO_DECODER_MAX_HISTOGRAM_COMPONENTS :: 4
_4_VIDEO_DECODER_HISTOGRAM_OFFSET_ALIGNMENT :: 256

_FACD3D11 :: 0x87c

APPEND_ALIGNED_ELEMENT :: 0xffffffff
FILTER_REDUCTION_TYPE_MASK :: 0x3
FILTER_REDUCTION_TYPE_SHIFT :: 7
FILTER_TYPE_MASK :: 0x3
MIN_FILTER_SHIFT :: 4
MAG_FILTER_SHIFT :: 2
MIP_FILTER_SHIFT :: 0
COMPARISON_FILTERING_BIT :: 0x80
ANISOTROPIC_FILTERING_BIT :: 0x40
SDK_VERSION :: 7
RETURN_PARAMETER_INDEX :: -1

COMPONENT_MASK :: enum u32 { // TODO: make bit_set
	X = 1,
	Y = 2,
	Z = 4,
	W = 8,
}

SHADER_REQUIRES :: enum u32 { // TODO: make bit_set
	DOUBLES                      = 0x00000001,
	EARLY_DEPTH_STENCIL          = 0x00000002,
	UAVS_AT_EVERY_STAGE          = 0x00000004,
	_64_UAVS                     = 0x00000008,
	MINIMUM_PRECISION            = 0x00000010,
	_11_1_DOUBLE_EXTENSIONS      = 0x00000020,
	_11_1_SHADER_EXTENSIONS      = 0x00000040,
	LEVEL_9_COMPARISON_FILTERING = 0x00000080,
	TILED_RESOURCES              = 0x00000100,
}

DRIVER_TYPE :: enum i32 {
	UNKNOWN   = 0,
	HARDWARE  = 1,
	REFERENCE = 2,
	NULL      = 3,
	SOFTWARE  = 4,
	WARP      = 5,
}

FEATURE_LEVEL :: enum i32 {
	_1_0_CORE = 4096,
	_9_1      = 37120,
	_9_2      = 37376,
	_9_3      = 37632,
	_10_0     = 40960,
	_10_1     = 41216,
	_11_0     = 45056,
	_11_1     = 45312,
	_12_0     = 49152,
	_12_1     = 49408,
}

PRIMITIVE_TOPOLOGY :: enum i32 {
	UNDEFINED                   = 0,
	POINTLIST                   = 1,
	LINELIST                    = 2,
	LINESTRIP                   = 3,
	TRIANGLELIST                = 4,
	TRIANGLESTRIP               = 5,
	LINELIST_ADJ                = 10,
	LINESTRIP_ADJ               = 11,
	TRIANGLELIST_ADJ            = 12,
	TRIANGLESTRIP_ADJ           = 13,
	_1_CONTROL_POINT_PATCHLIST  = 33,
	_2_CONTROL_POINT_PATCHLIST  = 34,
	_3_CONTROL_POINT_PATCHLIST  = 35,
	_4_CONTROL_POINT_PATCHLIST  = 36,
	_5_CONTROL_POINT_PATCHLIST  = 37,
	_6_CONTROL_POINT_PATCHLIST  = 38,
	_7_CONTROL_POINT_PATCHLIST  = 39,
	_8_CONTROL_POINT_PATCHLIST  = 40,
	_9_CONTROL_POINT_PATCHLIST  = 41,
	_10_CONTROL_POINT_PATCHLIST = 42,
	_11_CONTROL_POINT_PATCHLIST = 43,
	_12_CONTROL_POINT_PATCHLIST = 44,
	_13_CONTROL_POINT_PATCHLIST = 45,
	_14_CONTROL_POINT_PATCHLIST = 46,
	_15_CONTROL_POINT_PATCHLIST = 47,
	_16_CONTROL_POINT_PATCHLIST = 48,
	_17_CONTROL_POINT_PATCHLIST = 49,
	_18_CONTROL_POINT_PATCHLIST = 50,
	_19_CONTROL_POINT_PATCHLIST = 51,
	_20_CONTROL_POINT_PATCHLIST = 52,
	_21_CONTROL_POINT_PATCHLIST = 53,
	_22_CONTROL_POINT_PATCHLIST = 54,
	_23_CONTROL_POINT_PATCHLIST = 55,
	_24_CONTROL_POINT_PATCHLIST = 56,
	_25_CONTROL_POINT_PATCHLIST = 57,
	_26_CONTROL_POINT_PATCHLIST = 58,
	_27_CONTROL_POINT_PATCHLIST = 59,
	_28_CONTROL_POINT_PATCHLIST = 60,
	_29_CONTROL_POINT_PATCHLIST = 61,
	_30_CONTROL_POINT_PATCHLIST = 62,
	_31_CONTROL_POINT_PATCHLIST = 63,
	_32_CONTROL_POINT_PATCHLIST = 64,
}

PRIMITIVE :: enum i32 {
	UNDEFINED               = 0,
	POINT                   = 1,
	LINE                    = 2,
	TRIANGLE                = 3,
	LINE_ADJ                = 6,
	TRIANGLE_ADJ            = 7,
	_1_CONTROL_POINT_PATCH  = 8,
	_2_CONTROL_POINT_PATCH  = 9,
	_3_CONTROL_POINT_PATCH  = 10,
	_4_CONTROL_POINT_PATCH  = 11,
	_5_CONTROL_POINT_PATCH  = 12,
	_6_CONTROL_POINT_PATCH  = 13,
	_7_CONTROL_POINT_PATCH  = 14,
	_8_CONTROL_POINT_PATCH  = 15,
	_9_CONTROL_POINT_PATCH  = 16,
	_10_CONTROL_POINT_PATCH = 17,
	_11_CONTROL_POINT_PATCH = 18,
	_12_CONTROL_POINT_PATCH = 19,
	_13_CONTROL_POINT_PATCH = 20,
	_14_CONTROL_POINT_PATCH = 21,
	_15_CONTROL_POINT_PATCH = 22,
	_16_CONTROL_POINT_PATCH = 23,
	_17_CONTROL_POINT_PATCH = 24,
	_18_CONTROL_POINT_PATCH = 25,
	_19_CONTROL_POINT_PATCH = 26,
	_20_CONTROL_POINT_PATCH = 27,
	_21_CONTROL_POINT_PATCH = 28,
	_22_CONTROL_POINT_PATCH = 29,
	_23_CONTROL_POINT_PATCH = 30,
	_24_CONTROL_POINT_PATCH = 31,
	_25_CONTROL_POINT_PATCH = 32,
	_26_CONTROL_POINT_PATCH = 33,
	_27_CONTROL_POINT_PATCH = 34,
	_28_CONTROL_POINT_PATCH = 35,
	_29_CONTROL_POINT_PATCH = 36,
	_30_CONTROL_POINT_PATCH = 37,
	_31_CONTROL_POINT_PATCH = 38,
	_32_CONTROL_POINT_PATCH = 39,
}

SRV_DIMENSION :: enum i32 {
	UNKNOWN          = 0,
	BUFFER           = 1,
	TEXTURE1D        = 2,
	TEXTURE1DARRAY   = 3,
	TEXTURE2D        = 4,
	TEXTURE2DARRAY   = 5,
	TEXTURE2DMS      = 6,
	TEXTURE2DMSARRAY = 7,
	TEXTURE3D        = 8,
	TEXTURECUBE      = 9,
	TEXTURECUBEARRAY = 10,
	BUFFEREX         = 11,
}

PFN_DESTRUCTION_CALLBACK :: #type proc "c" (a0: rawptr)


ID3DDestructionNotifier_UUID_STRING :: "A06EB39A-50DA-425B-8C31-4EECD6C270F3"
ID3DDestructionNotifier_UUID := &IID{0xA06EB39A, 0x50DA, 0x425B, {0x8C, 0x31, 0x4E, 0xEC, 0xD6, 0xC2, 0x70, 0xF3}}
ID3DDestructionNotifier :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3ddestructionnotifier_vtable: ^ID3DDestructionNotifier_VTable,
}
ID3DDestructionNotifier_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	RegisterDestructionCallback: proc "stdcall" (this: ^ID3DDestructionNotifier, callbackFn: PFN_DESTRUCTION_CALLBACK, pData: rawptr, pCallbackID: ^u32) -> HRESULT,
	UnregisterDestructionCallback: proc "stdcall" (this: ^ID3DDestructionNotifier, callbackID: u32) -> HRESULT,
}


SHADER_VARIABLE_CLASS :: enum i32 {
	SCALAR                = 0,
	VECTOR                = 1,
	MATRIX_ROWS           = 2,
	MATRIX_COLUMNS        = 3,
	OBJECT                = 4,
	STRUCT                = 5,
	INTERFACE_CLASS       = 6,
	INTERFACE_POINTER     = 7,
}

SHADER_VARIABLE_FLAGS :: enum u32 { // TODO: make bit_set
	USERPACKED              = 0x1,
	USED                    = 0x2,
	INTERFACE_POINTER       = 0x4,
	INTERFACE_PARAMETER     = 0x8,
}

SHADER_VARIABLE_TYPE :: enum i32 {
	VOID                          = 0,
	BOOL                          = 1,
	INT                           = 2,
	FLOAT                         = 3,
	STRING                        = 4,
	TEXTURE                       = 5,
	TEXTURE1D                     = 6,
	TEXTURE2D                     = 7,
	TEXTURE3D                     = 8,
	TEXTURECUBE                   = 9,
	SAMPLER                       = 10,
	SAMPLER1D                     = 11,
	SAMPLER2D                     = 12,
	SAMPLER3D                     = 13,
	SAMPLERCUBE                   = 14,
	PIXELSHADER                   = 15,
	VERTEXSHADER                  = 16,
	PIXELFRAGMENT                 = 17,
	VERTEXFRAGMENT                = 18,
	UINT                          = 19,
	UINT8                         = 20,
	GEOMETRYSHADER                = 21,
	RASTERIZER                    = 22,
	DEPTHSTENCIL                  = 23,
	BLEND                         = 24,
	BUFFER                        = 25,
	CBUFFER                       = 26,
	TBUFFER                       = 27,
	TEXTURE1DARRAY                = 28,
	TEXTURE2DARRAY                = 29,
	RENDERTARGETVIEW              = 30,
	DEPTHSTENCILVIEW              = 31,
	TEXTURE2DMS                   = 32,
	TEXTURE2DMSARRAY              = 33,
	TEXTURECUBEARRAY              = 34,
	HULLSHADER                    = 35,
	DOMAINSHADER                  = 36,
	INTERFACE_POINTER             = 37,
	COMPUTESHADER                 = 38,
	DOUBLE                        = 39,
	RWTEXTURE1D                   = 40,
	RWTEXTURE1DARRAY              = 41,
	RWTEXTURE2D                   = 42,
	RWTEXTURE2DARRAY              = 43,
	RWTEXTURE3D                   = 44,
	RWBUFFER                      = 45,
	BYTEADDRESS_BUFFER            = 46,
	RWBYTEADDRESS_BUFFER          = 47,
	STRUCTURED_BUFFER             = 48,
	RWSTRUCTURED_BUFFER           = 49,
	APPEND_STRUCTURED_BUFFER      = 50,
	CONSUME_STRUCTURED_BUFFER     = 51,
	MIN8FLOAT                     = 52,
	MIN10FLOAT                    = 53,
	MIN16FLOAT                    = 54,
	MIN12INT                      = 55,
	MIN16INT                      = 56,
	MIN16UINT                     = 57,
}

SHADER_INPUT_FLAGS :: enum u32 { // TODO: make bit_set
	USERPACKED          = 0x1,
	COMPARISON_SAMPLER  = 0x2,
	TEXTURE_COMPONENT_0 = 0x4,
	TEXTURE_COMPONENT_1 = 0x8,
	TEXTURE_COMPONENTS  = 0xc,
	UNUSED              = 0x10,
}

SHADER_INPUT_TYPE :: enum i32 {
	CBUFFER                       = 0,
	TBUFFER                       = 1,
	TEXTURE                       = 2,
	SAMPLER                       = 3,
	UAV_RWTYPED                   = 4,
	STRUCTURED                    = 5,
	UAV_RWSTRUCTURED              = 6,
	BYTEADDRESS                   = 7,
	UAV_RWBYTEADDRESS             = 8,
	UAV_APPEND_STRUCTURED         = 9,
	UAV_CONSUME_STRUCTURED        = 10,
	UAV_RWSTRUCTURED_WITH_COUNTER = 11,
	RTACCELERATIONSTRUCTURE       = 12,
	UAV_FEEDBACKTEXTURE           = 13,
}

SHADER_CBUFFER_FLAGS :: enum u32 { // TODO: make bit_set
	USERPACKED = 0x1,
}

CBUFFER_TYPE :: enum i32 {
	CBUFFER            = 0,
	TBUFFER            = 1,
	INTERFACE_POINTERS = 2,
	RESOURCE_BIND_INFO = 3,
}

NAME :: enum i32 {
	UNDEFINED                     = 0,
	POSITION                      = 1,
	CLIP_DISTANCE                 = 2,
	CULL_DISTANCE                 = 3,
	RENDER_TARGET_ARRAY_INDEX     = 4,
	VIEWPORT_ARRAY_INDEX          = 5,
	VERTEX_ID                     = 6,
	PRIMITIVE_ID                  = 7,
	INSTANCE_ID                   = 8,
	IS_FRONT_FACE                 = 9,
	SAMPLE_INDEX                  = 10,
	FINAL_QUAD_EDGE_TESSFACTOR    = 11,
	FINAL_QUAD_INSIDE_TESSFACTOR  = 12,
	FINAL_TRI_EDGE_TESSFACTOR     = 13,
	FINAL_TRI_INSIDE_TESSFACTOR   = 14,
	FINAL_LINE_DETAIL_TESSFACTOR  = 15,
	FINAL_LINE_DENSITY_TESSFACTOR = 16,
	BARYCENTRICS                  = 23,
	SHADINGRATE                   = 24,
	CULLPRIMITIVE                 = 25,
	TARGET                        = 64,
	DEPTH                         = 65,
	COVERAGE                      = 66,
	DEPTH_GREATER_EQUAL           = 67,
	DEPTH_LESS_EQUAL              = 68,
	STENCIL_REF                   = 69,
	INNER_COVERAGE                = 70,
}

RESOURCE_RETURN_TYPE :: enum i32 {
	UNORM     = 1,
	SNORM     = 2,
	SINT      = 3,
	UINT      = 4,
	FLOAT     = 5,
	MIXED     = 6,
	DOUBLE    = 7,
	CONTINUED = 8,
}

REGISTER_COMPONENT_TYPE :: enum i32 {
	UNKNOWN = 0,
	UINT32  = 1,
	SINT32  = 2,
	FLOAT32 = 3,
}

TESSELLATOR_DOMAIN :: enum i32 {
	UNDEFINED = 0,
	ISOLINE   = 1,
	TRI       = 2,
	QUAD      = 3,
}

TESSELLATOR_PARTITIONING :: enum i32 {
	UNDEFINED       = 0,
	INTEGER         = 1,
	POW2            = 2,
	FRACTIONAL_ODD  = 3,
	FRACTIONAL_EVEN = 4,
}

TESSELLATOR_OUTPUT_PRIMITIVE :: enum i32 {
	UNDEFINED    = 0,
	POINT        = 1,
	LINE         = 2,
	TRIANGLE_CW  = 3,
	TRIANGLE_CCW = 4,
}

MIN_PRECISION :: enum i32 {
	DEFAULT   = 0,
	FLOAT_16  = 1,
	FLOAT_2_8 = 2,
	RESERVED  = 3,
	SINT_16   = 4,
	UINT_16   = 5,
	ANY_16    = 240,
	ANY_10    = 241,
}

INTERPOLATION_MODE :: enum i32 {
	UNDEFINED                     = 0,
	CONSTANT                      = 1,
	LINEAR                        = 2,
	LINEAR_CENTROID               = 3,
	LINEAR_NOPERSPECTIVE          = 4,
	LINEAR_NOPERSPECTIVE_CENTROID = 5,
	LINEAR_SAMPLE                 = 6,
	LINEAR_NOPERSPECTIVE_SAMPLE   = 7,
}

PARAMETER_FLAGS :: enum u32 { // TODO: make bit_set
	NONE = 0x0,
	IN   = 0x1,
	OUT  = 0x2,
}

CDEFAULT :: struct {
	_: u8,
}

INPUT_CLASSIFICATION :: enum i32 {
	VERTEX_DATA   = 0,
	INSTANCE_DATA = 1,
}

INPUT_ELEMENT_DESC :: struct {
	SemanticName:         cstring,
	SemanticIndex:        u32,
	Format:               dxgi.FORMAT,
	InputSlot:            u32,
	AlignedByteOffset:    u32,
	InputSlotClass:       INPUT_CLASSIFICATION,
	InstanceDataStepRate: u32,
}

FILL_MODE :: enum i32 {
	WIREFRAME = 2,
	SOLID     = 3,
}

CULL_MODE :: enum i32 {
	NONE  = 1,
	FRONT = 2,
	BACK  = 3,
}

SO_DECLARATION_ENTRY :: struct {
	Stream:         u32,
	SemanticName:   cstring,
	SemanticIndex:  u32,
	StartComponent: u8,
	ComponentCount: u8,
	OutputSlot:     u8,
}

VIEWPORT :: struct {
	TopLeftX: f32,
	TopLeftY: f32,
	Width:    f32,
	Height:   f32,
	MinDepth: f32,
	MaxDepth: f32,
}

DRAW_INSTANCED_INDIRECT_ARGS :: struct {
	VertexCountPerInstance: u32,
	InstanceCount:          u32,
	StartVertexLocation:    u32,
	StartInstanceLocation:  u32,
}

DRAW_INDEXED_INSTANCED_INDIRECT_ARGS :: struct {
	IndexCountPerInstance: u32,
	InstanceCount:         u32,
	StartIndexLocation:    u32,
	BaseVertexLocation:    i32,
	StartInstanceLocation: u32,
}

RESOURCE_DIMENSION :: enum i32 {
	UNKNOWN   = 0,
	BUFFER    = 1,
	TEXTURE1D = 2,
	TEXTURE2D = 3,
	TEXTURE3D = 4,
}

DSV_DIMENSION :: enum i32 {
	UNKNOWN          = 0,
	TEXTURE1D        = 1,
	TEXTURE1DARRAY   = 2,
	TEXTURE2D        = 3,
	TEXTURE2DARRAY   = 4,
	TEXTURE2DMS      = 5,
	TEXTURE2DMSARRAY = 6,
}

RTV_DIMENSION :: enum i32 {
	UNKNOWN          = 0,
	BUFFER           = 1,
	TEXTURE1D        = 2,
	TEXTURE1DARRAY   = 3,
	TEXTURE2D        = 4,
	TEXTURE2DARRAY   = 5,
	TEXTURE2DMS      = 6,
	TEXTURE2DMSARRAY = 7,
	TEXTURE3D        = 8,
}

UAV_DIMENSION :: enum i32 {
	UNKNOWN        = 0,
	BUFFER         = 1,
	TEXTURE1D      = 2,
	TEXTURE1DARRAY = 3,
	TEXTURE2D      = 4,
	TEXTURE2DARRAY = 5,
	TEXTURE3D      = 8,
}

USAGE :: enum i32 {
	DEFAULT   = 0,
	IMMUTABLE = 1,
	DYNAMIC   = 2,
	STAGING   = 3,
}

BIND_FLAG :: enum u32 { // TODO: make bit_set
	VERTEX_BUFFER    = 0x1,
	INDEX_BUFFER     = 0x2,
	CONSTANT_BUFFER  = 0x4,
	SHADER_RESOURCE  = 0x8,
	STREAM_OUTPUT    = 0x10,
	RENDER_TARGET    = 0x20,
	DEPTH_STENCIL    = 0x40,
	UNORDERED_ACCESS = 0x80,
	DECODER          = 0x200,
	VIDEO_ENCODER    = 0x400,
}

CPU_ACCESS_FLAG :: enum u32 { // TODO: make bit_set
	WRITE = 0x10000,
	READ  = 0x20000,

}

RESOURCE_MISC_FLAG :: enum u32 { // TODO: make bit_set
	GENERATE_MIPS                   = 0x1,
	SHARED                          = 0x2,
	TEXTURECUBE                     = 0x4,
	DRAWINDIRECT_ARGS               = 0x10,
	BUFFER_ALLOW_RAW_VIEWS          = 0x20,
	BUFFER_STRUCTURED               = 0x40,
	RESOURCE_CLAMP                  = 0x80,
	SHARED_KEYEDMUTEX               = 0x100,
	GDI_COMPATIBLE                  = 0x200,
	SHARED_NTHANDLE                 = 0x800,
	RESTRICTED_CONTENT              = 0x1000,
	RESTRICT_SHARED_RESOURCE        = 0x2000,
	RESTRICT_SHARED_RESOURCE_DRIVER = 0x4000,
	GUARDED                         = 0x8000,
	TILE_POOL                       = 0x20000,
	TILED                           = 0x40000,
	HW_PROTECTED                    = 0x80000,
}

MAP :: enum i32 {
	READ               = 1,
	WRITE              = 2,
	READ_WRITE         = 3,
	WRITE_DISCARD      = 4,
	WRITE_NO_OVERWRITE = 5,
}

MAP_FLAG :: enum u32 { // TODO: make bit_set
	DO_NOT_WAIT = 0x100000,
}

RAISE_FLAG :: enum u32 { // TODO: make bit_set
	DRIVER_INTERNAL_ERROR = 0x1,
}

CLEAR_FLAG :: enum u32 { // TODO: make bit_set
	DEPTH   = 0x1,
	STENCIL = 0x2,
}


CRECT :: struct {
	using d3d11_rect: RECT,
}

BOX :: struct {
	left:   u32,
	top:    u32,
	front:  u32,
	right:  u32,
	bottom: u32,
	back:   u32,
}

CBOX :: struct {
	using d3d11_box: BOX,
}


IDeviceChild_UUID_STRING :: "1841E5C8-16B0-489B-BCC8-44CFB0D5DEAE"
IDeviceChild_UUID := &IID{0x1841E5C8, 0x16B0, 0x489B, {0xBC, 0xC8, 0x44, 0xCF, 0xB0, 0xD5, 0xDE, 0xAE}}
IDeviceChild :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11devicechild_vtable: ^IDeviceChild_VTable,
}
IDeviceChild_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	GetDevice:               proc "stdcall" (this: ^IDeviceChild, ppDevice: ^^IDevice),
	GetPrivateData:          proc "stdcall" (this: ^IDeviceChild, guid: ^GUID, pDataSize: ^u32, pData: rawptr) -> HRESULT,
	SetPrivateData:          proc "stdcall" (this: ^IDeviceChild, guid: ^GUID, DataSize: u32, pData: rawptr) -> HRESULT,
	SetPrivateDataInterface: proc "stdcall" (this: ^IDeviceChild, guid: ^GUID, pData: ^IUnknown) -> HRESULT,
}


COMPARISON_FUNC :: enum i32 {
	NEVER         = 1,
	LESS          = 2,
	EQUAL         = 3,
	LESS_EQUAL    = 4,
	GREATER       = 5,
	NOT_EQUAL     = 6,
	GREATER_EQUAL = 7,
	ALWAYS        = 8,
}

DEPTH_WRITE_MASK :: enum i32 {
	ZERO = 0,
	ALL  = 1,
}

STENCIL_OP :: enum i32 {
	KEEP     = 1,
	ZERO     = 2,
	REPLACE  = 3,
	INCR_SAT = 4,
	DECR_SAT = 5,
	INVERT   = 6,
	INCR     = 7,
	DECR     = 8,
}

DEPTH_STENCILOP_DESC :: struct {
	StencilFailOp:      STENCIL_OP,
	StencilDepthFailOp: STENCIL_OP,
	StencilPassOp:      STENCIL_OP,
	StencilFunc:        COMPARISON_FUNC,
}

DEPTH_STENCIL_DESC :: struct {
	DepthEnable:      BOOL,
	DepthWriteMask:   DEPTH_WRITE_MASK,
	DepthFunc:        COMPARISON_FUNC,
	StencilEnable:    BOOL,
	StencilReadMask:  u8,
	StencilWriteMask: u8,
	FrontFace:        DEPTH_STENCILOP_DESC,
	BackFace:         DEPTH_STENCILOP_DESC,
}

CDEPTH_STENCIL_DESC :: struct {
	using d3d11_depth_stencil_desc: DEPTH_STENCIL_DESC,
}


IDepthStencilState_UUID_STRING :: "03823EFB-8D8F-4E1C-9AA2-F64BB2CBFDF1"
IDepthStencilState_UUID := &IID{0x03823EFB, 0x8D8F, 0x4E1C, {0x9A, 0xA2, 0xF6, 0x4B, 0xB2, 0xCB, 0xFD, 0xF1}}
IDepthStencilState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11depthstencilstate_vtable: ^IDepthStencilState_VTable,
}
IDepthStencilState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "stdcall" (this: ^IDepthStencilState, pDesc: ^DEPTH_STENCIL_DESC),
}


BLEND :: enum i32 {
	ZERO             = 1,
	ONE              = 2,
	SRC_COLOR        = 3,
	INV_SRC_COLOR    = 4,
	SRC_ALPHA        = 5,
	INV_SRC_ALPHA    = 6,
	DEST_ALPHA       = 7,
	INV_DEST_ALPHA   = 8,
	DEST_COLOR       = 9,
	INV_DEST_COLOR   = 10,
	SRC_ALPHA_SAT    = 11,
	BLEND_FACTOR     = 14,
	INV_BLEND_FACTOR = 15,
	SRC1_COLOR       = 16,
	INV_SRC1_COLOR   = 17,
	SRC1_ALPHA       = 18,
	INV_SRC1_ALPHA   = 19,
}

BLEND_OP :: enum i32 {
	ADD          = 1,
	SUBTRACT     = 2,
	REV_SUBTRACT = 3,
	MIN          = 4,
	MAX          = 5,
}

COLOR_WRITE_ENABLE :: enum i32 { // TODO: make bit_set
	RED   = 1,
	GREEN = 2,
	BLUE  = 4,
	ALPHA = 8,
	ALL   = 15,
}

RENDER_TARGET_BLEND_DESC :: struct {
	BlendEnable:           BOOL,
	SrcBlend:              BLEND,
	DestBlend:             BLEND,
	BlendOp:               BLEND_OP,
	SrcBlendAlpha:         BLEND,
	DestBlendAlpha:        BLEND,
	BlendOpAlpha:          BLEND_OP,
	RenderTargetWriteMask: u8,
}

BLEND_DESC :: struct {
	AlphaToCoverageEnable:  BOOL,
	IndependentBlendEnable: BOOL,
	RenderTarget:           [8]RENDER_TARGET_BLEND_DESC,
}

CBLEND_DESC :: struct {
	using d3d11_blend_desc: BLEND_DESC,
}


IBlendState_UUID_STRING :: "75B68FAA-347D-4159-8F45-A0640F01CD9A"
IBlendState_UUID := &IID{0x75B68FAA, 0x347D, 0x4159, {0x8F, 0x45, 0xA0, 0x64, 0x0F, 0x01, 0xCD, 0x9A}}
IBlendState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11blendstate_vtable: ^IBlendState_VTable,
}
IBlendState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "stdcall" (this: ^IBlendState, pDesc: ^BLEND_DESC),
}


RASTERIZER_DESC :: struct {
	FillMode:              FILL_MODE,
	CullMode:              CULL_MODE,
	FrontCounterClockwise: BOOL,
	DepthBias:             i32,
	DepthBiasClamp:        f32,
	SlopeScaledDepthBias:  f32,
	DepthClipEnable:       BOOL,
	ScissorEnable:         BOOL,
	MultisampleEnable:     BOOL,
	AntialiasedLineEnable: BOOL,
}

CRASTERIZER_DESC :: struct {
	using d3d11_rasterizer_desc: RASTERIZER_DESC,
}


IRasterizerState_UUID_STRING :: "9BB4AB81-AB1A-4D8F-B506-FC04200B6EE7"
IRasterizerState_UUID := &IID{0x9BB4AB81, 0xAB1A, 0x4D8F, {0xB5, 0x06, 0xFC, 0x04, 0x20, 0x0B, 0x6E, 0xE7}}
IRasterizerState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11rasterizerstate_vtable: ^IRasterizerState_VTable,
}
IRasterizerState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "stdcall" (this: ^IRasterizerState, pDesc: ^RASTERIZER_DESC),
}


SUBRESOURCE_DATA :: struct {
	pSysMem:          rawptr,
	SysMemPitch:      u32,
	SysMemSlicePitch: u32,
}

MAPPED_SUBRESOURCE :: struct {
	pData:      rawptr,
	RowPitch:   u32,
	DepthPitch: u32,
}


IResource_UUID_STRING :: "DC8E63F3-D12B-4952-B47B-5E45026A862D"
IResource_UUID := &IID{0xDC8E63F3, 0xD12B, 0x4952, {0xB4, 0x7B, 0x5E, 0x45, 0x02, 0x6A, 0x86, 0x2D}}
IResource :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11resource_vtable: ^IResource_VTable,
}
IResource_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetType:             proc "stdcall" (this: ^IResource, pResourceDimension: ^RESOURCE_DIMENSION),
	SetEvictionPriority: proc "stdcall" (this: ^IResource, EvictionPriority: u32),
	GetEvictionPriority: proc "stdcall" (this: ^IResource) -> u32,
}


BUFFER_DESC :: struct {
	ByteWidth:           u32,
	Usage:               USAGE,
	BindFlags:           BIND_FLAG,
	CPUAccessFlags:      CPU_ACCESS_FLAG,
	MiscFlags:           RESOURCE_MISC_FLAG,
	StructureByteStride: u32,
}

CBUFFER_DESC :: struct {
	using d3d11_buffer_desc: BUFFER_DESC,
}


IBuffer_UUID_STRING :: "48570B85-D1EE-4FCD-A250-EB350722B037"
IBuffer_UUID := &IID{0x48570B85, 0xD1EE, 0x4FCD, {0xA2, 0x50, 0xEB, 0x35, 0x07, 0x22, 0xB0, 0x37}}
IBuffer :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11buffer_vtable: ^IBuffer_VTable,
}
IBuffer_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "stdcall" (this: ^IBuffer, pDesc: ^BUFFER_DESC),
}


TEXTURE1D_DESC :: struct {
	Width:          u32,
	MipLevels:      u32,
	ArraySize:      u32,
	Format:         dxgi.FORMAT,
	Usage:          USAGE,
	BindFlags:      BIND_FLAG,
	CPUAccessFlags: CPU_ACCESS_FLAG,
	MiscFlags:      RESOURCE_MISC_FLAG,
}

CTEXTURE1D_DESC :: struct {
	using d3d11_texture1d_desc: TEXTURE1D_DESC,
}


ITexture1D_UUID_STRING :: "F8FB5C27-C6B3-4F75-A4C8-439AF2EF564C"
ITexture1D_UUID := &IID{0xF8FB5C27, 0xC6B3, 0x4F75, {0xA4, 0xC8, 0x43, 0x9A, 0xF2, 0xEF, 0x56, 0x4C}}
ITexture1D :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11texture1d_vtable: ^ITexture1D_VTable,
}
ITexture1D_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "stdcall" (this: ^ITexture1D, pDesc: ^TEXTURE1D_DESC),
}


TEXTURE2D_DESC :: struct {
	Width:          u32,
	Height:         u32,
	MipLevels:      u32,
	ArraySize:      u32,
	Format:         dxgi.FORMAT,
	SampleDesc:     dxgi.SAMPLE_DESC,
	Usage:          USAGE,
	BindFlags:      BIND_FLAG,
	CPUAccessFlags: CPU_ACCESS_FLAG,
	MiscFlags:      RESOURCE_MISC_FLAG,
}

CTEXTURE2D_DESC :: struct {
	using d3d11_texture2d_desc: TEXTURE2D_DESC,
}


ITexture2D_UUID_STRING :: "6F15AAF2-D208-4E89-9AB4-489535D34F9C"
ITexture2D_UUID := &IID{0x6F15AAF2, 0xD208, 0x4E89, {0x9A, 0xB4, 0x48, 0x95, 0x35, 0xD3, 0x4F, 0x9C}}
ITexture2D :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11texture2d_vtable: ^ITexture2D_VTable,
}
ITexture2D_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "stdcall" (this: ^ITexture2D, pDesc: ^TEXTURE2D_DESC),
}


TEXTURE3D_DESC :: struct {
	Width:          u32,
	Height:         u32,
	Depth:          u32,
	MipLevels:      u32,
	Format:         dxgi.FORMAT,
	Usage:          USAGE,
	BindFlags:      BIND_FLAG,
	CPUAccessFlags: CPU_ACCESS_FLAG,
	MiscFlags:      RESOURCE_MISC_FLAG,
}

CTEXTURE3D_DESC :: struct {
	using d3d11_texture3d_desc: TEXTURE3D_DESC,
}


ITexture3D_UUID_STRING :: "037E866E-F56D-4357-A8AF-9DABBE6E250E"
ITexture3D_UUID := &IID{0x037E866E, 0xF56D, 0x4357, {0xA8, 0xAF, 0x9D, 0xAB, 0xBE, 0x6E, 0x25, 0x0E}}
ITexture3D :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11texture3d_vtable: ^ITexture3D_VTable,
}
ITexture3D_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "stdcall" (this: ^ITexture3D, pDesc: ^TEXTURE3D_DESC),
}


TEXTURECUBE_FACE :: enum i32 {
	POSITIVE_X = 0,
	NEGATIVE_X = 1,
	POSITIVE_Y = 2,
	NEGATIVE_Y = 3,
	POSITIVE_Z = 4,
	NEGATIVE_Z = 5,
}


IView_UUID_STRING :: "839D1216-BB2E-412B-B7F4-A9DBEBE08ED1"
IView_UUID := &IID{0x839D1216, 0xBB2E, 0x412B, {0xB7, 0xF4, 0xA9, 0xDB, 0xEB, 0xE0, 0x8E, 0xD1}}
IView :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11view_vtable: ^IView_VTable,
}
IView_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetResource: proc "stdcall" (this: ^IView, ppResource: ^^IResource),
}


BUFFER_SRV :: struct {
	using _: struct #raw_union {
		FirstElement:  u32,
		ElementOffset: u32,
	},
	using _: struct #raw_union {
		NumElements:  u32,
		ElementWidth: u32,
	},
}

BUFFEREX_SRV_FLAG :: enum u32 { // TODO: make bit_set
	RAW = 0x1,
}

BUFFEREX_SRV :: struct {
	FirstElement: u32,
	NumElements:  u32,
	Flags:        u32,
}

TEX1D_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEX1D_ARRAY_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEX2D_ARRAY_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX3D_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEXCUBE_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEXCUBE_ARRAY_SRV :: struct {
	MostDetailedMip:  u32,
	MipLevels:        u32,
	First2DArrayFace: u32,
	NumCubes:         u32,
}

TEX2DMS_SRV :: struct {
	UnusedField_NothingToDefine: u32,
}

TEX2DMS_ARRAY_SRV :: struct {
	FirstArraySlice: u32,
	ArraySize:       u32,
}

SHADER_RESOURCE_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: SRV_DIMENSION,
	using _: struct #raw_union {
		Buffer:           BUFFER_SRV,
		Texture1D:        TEX1D_SRV,
		Texture1DArray:   TEX1D_ARRAY_SRV,
		Texture2D:        TEX2D_SRV,
		Texture2DArray:   TEX2D_ARRAY_SRV,
		Texture2DMS:      TEX2DMS_SRV,
		Texture2DMSArray: TEX2DMS_ARRAY_SRV,
		Texture3D:        TEX3D_SRV,
		TextureCube:      TEXCUBE_SRV,
		TextureCubeArray: TEXCUBE_ARRAY_SRV,
		BufferEx:         BUFFEREX_SRV,
	},
}

CSHADER_RESOURCE_VIEW_DESC :: struct {
	using d3d11_shader_resource_view_desc: SHADER_RESOURCE_VIEW_DESC,
}


IShaderResourceView_UUID_STRING :: "B0E06FE0-8192-4E1A-B1CA-36D7414710B2"
IShaderResourceView_UUID := &IID{0xB0E06FE0, 0x8192, 0x4E1A, {0xB1, 0xCA, 0x36, 0xD7, 0x41, 0x47, 0x10, 0xB2}}
IShaderResourceView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11shaderresourceview_vtable: ^IShaderResourceView_VTable,
}
IShaderResourceView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "stdcall" (this: ^IShaderResourceView, pDesc: ^SHADER_RESOURCE_VIEW_DESC),
}


BUFFER_RTV :: struct {
	using _: struct #raw_union {
		FirstElement:  u32,
		ElementOffset: u32,
	},
	using _: struct #raw_union {
		NumElements:  u32,
		ElementWidth: u32,
	},
}

TEX1D_RTV :: struct {
	MipSlice: u32,
}

TEX1D_ARRAY_RTV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_RTV :: struct {
	MipSlice: u32,
}

TEX2DMS_RTV :: struct {
	UnusedField_NothingToDefine: u32,
}

TEX2D_ARRAY_RTV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2DMS_ARRAY_RTV :: struct {
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX3D_RTV :: struct {
	MipSlice:    u32,
	FirstWSlice: u32,
	WSize:       u32,
}

RENDER_TARGET_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: RTV_DIMENSION,
	using _: struct #raw_union {
		Buffer:           BUFFER_RTV,
		Texture1D:        TEX1D_RTV,
		Texture1DArray:   TEX1D_ARRAY_RTV,
		Texture2D:        TEX2D_RTV,
		Texture2DArray:   TEX2D_ARRAY_RTV,
		Texture2DMS:      TEX2DMS_RTV,
		Texture2DMSArray: TEX2DMS_ARRAY_RTV,
		Texture3D:        TEX3D_RTV,
	},
}

CRENDER_TARGET_VIEW_DESC :: struct {
	using d3d11_render_target_view_desc: RENDER_TARGET_VIEW_DESC,
}


IRenderTargetView_UUID_STRING :: "DFDBA067-0B8D-4865-875B-D7B4516CC164"
IRenderTargetView_UUID := &IID{0xDFDBA067, 0x0B8D, 0x4865, {0x87, 0x5B, 0xD7, 0xB4, 0x51, 0x6C, 0xC1, 0x64}}
IRenderTargetView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11rendertargetview_vtable: ^IRenderTargetView_VTable,
}
IRenderTargetView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "stdcall" (this: ^IRenderTargetView, pDesc: ^RENDER_TARGET_VIEW_DESC),
}


CVIEWPORT :: struct {
	using d3d11_viewport: VIEWPORT,
}

TEX1D_DSV :: struct {
	MipSlice: u32,
}

TEX1D_ARRAY_DSV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_DSV :: struct {
	MipSlice: u32,
}

TEX2D_ARRAY_DSV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2DMS_DSV :: struct {
	UnusedField_NothingToDefine: u32,
}

TEX2DMS_ARRAY_DSV :: struct {
	FirstArraySlice: u32,
	ArraySize:       u32,
}

DSV_FLAG :: enum u32 { // TODO: make bit_set
	DEPTH   = 0x1,
	STENCIL = 0x2,
}

DEPTH_STENCIL_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: DSV_DIMENSION,
	Flags:         u32,
	using _: struct #raw_union {
		Texture1D:        TEX1D_DSV,
		Texture1DArray:   TEX1D_ARRAY_DSV,
		Texture2D:        TEX2D_DSV,
		Texture2DArray:   TEX2D_ARRAY_DSV,
		Texture2DMS:      TEX2DMS_DSV,
		Texture2DMSArray: TEX2DMS_ARRAY_DSV,
	},
}

CDEPTH_STENCIL_VIEW_DESC :: struct {
	using d3d11_depth_stencil_view_desc: DEPTH_STENCIL_VIEW_DESC,
}


IDepthStencilView_UUID_STRING :: "9FDAC92A-1876-48C3-AFAD-25B94F84A9B6"
IDepthStencilView_UUID := &IID{0x9FDAC92A, 0x1876, 0x48C3, {0xAF, 0xAD, 0x25, 0xB9, 0x4F, 0x84, 0xA9, 0xB6}}
IDepthStencilView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11depthstencilview_vtable: ^IDepthStencilView_VTable,
}
IDepthStencilView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "stdcall" (this: ^IDepthStencilView, pDesc: ^DEPTH_STENCIL_VIEW_DESC),
}


BUFFER_UAV_FLAG :: enum u32 { // TODO: make bit_set
	RAW     = 0x1,
	APPEND  = 0x2,
	COUNTER = 0x4,
}

BUFFER_UAV :: struct {
	FirstElement: u32,
	NumElements:  u32,
	Flags:        u32,
}

TEX1D_UAV :: struct {
	MipSlice: u32,
}

TEX1D_ARRAY_UAV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_UAV :: struct {
	MipSlice: u32,
}

TEX2D_ARRAY_UAV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX3D_UAV :: struct {
	MipSlice:    u32,
	FirstWSlice: u32,
	WSize:       u32,
}

UNORDERED_ACCESS_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: UAV_DIMENSION,
	using _: struct #raw_union {
		Buffer:         BUFFER_UAV,
		Texture1D:      TEX1D_UAV,
		Texture1DArray: TEX1D_ARRAY_UAV,
		Texture2D:      TEX2D_UAV,
		Texture2DArray: TEX2D_ARRAY_UAV,
		Texture3D:      TEX3D_UAV,
	},
}

CUNORDERED_ACCESS_VIEW_DESC :: struct {
	using d3d11_unordered_access_view_desc: UNORDERED_ACCESS_VIEW_DESC,
}


IUnorderedAccessView_UUID_STRING :: "28ACF509-7F5C-48F6-8611-F316010A6380"
IUnorderedAccessView_UUID := &IID{0x28ACF509, 0x7F5C, 0x48F6, {0x86, 0x11, 0xF3, 0x16, 0x01, 0x0A, 0x63, 0x80}}
IUnorderedAccessView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11unorderedaccessview_vtable: ^IUnorderedAccessView_VTable,
}
IUnorderedAccessView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "stdcall" (this: ^IUnorderedAccessView, pDesc: ^UNORDERED_ACCESS_VIEW_DESC),
}



IVertexShader_UUID_STRING :: "3B301D64-D678-4289-8897-22F8928B72F3"
IVertexShader_UUID := &IID{0x3B301D64, 0xD678, 0x4289, {0x88, 0x97, 0x22, 0xF8, 0x92, 0x8B, 0x72, 0xF3}}
IVertexShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IHullShader_UUID_STRING :: "8E5C6061-628A-4C8E-8264-BBE45CB3D5DD"
IHullShader_UUID := &IID{0x8E5C6061, 0x628A, 0x4C8E, {0x82, 0x64, 0xBB, 0xE4, 0x5C, 0xB3, 0xD5, 0xDD}}
IHullShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IDomainShader_UUID_STRING :: "F582C508-0F36-490C-9977-31EECE268CFA"
IDomainShader_UUID := &IID{0xF582C508, 0x0F36, 0x490C, {0x99, 0x77, 0x31, 0xEE, 0xCE, 0x26, 0x8C, 0xFA}}
IDomainShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IGeometryShader_UUID_STRING :: "38325B96-EFFB-4022-BA02-2E795B70275C"
IGeometryShader_UUID := &IID{0x38325B96, 0xEFFB, 0x4022, {0xBA, 0x02, 0x2E, 0x79, 0x5B, 0x70, 0x27, 0x5C}}
IGeometryShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IPixelShader_UUID_STRING :: "EA82E40D-51DC-4F33-93D4-DB7C9125AE8C"
IPixelShader_UUID := &IID{0xEA82E40D, 0x51DC, 0x4F33, {0x93, 0xD4, 0xDB, 0x7C, 0x91, 0x25, 0xAE, 0x8C}}
IPixelShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IComputeShader_UUID_STRING :: "4F5B196E-C2BD-495E-BD01-1FDED38E4969"
IComputeShader_UUID := &IID{0x4F5B196E, 0xC2BD, 0x495E, {0xBD, 0x01, 0x1F, 0xDE, 0xD3, 0x8E, 0x49, 0x69}}
IComputeShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IInputLayout_UUID_STRING :: "E4819DDC-4CF0-4025-BD26-5DE82A3E07B7"
IInputLayout_UUID := &IID{0xE4819DDC, 0x4CF0, 0x4025, {0xBD, 0x26, 0x5D, 0xE8, 0x2A, 0x3E, 0x07, 0xB7}}
IInputLayout :: struct {
	using id3d11devicechild: IDeviceChild,
}

FILTER :: enum i32 {
	MIN_MAG_MIP_POINT                          = 0,
	MIN_MAG_POINT_MIP_LINEAR                   = 1,
	MIN_POINT_MAG_LINEAR_MIP_POINT             = 4,
	MIN_POINT_MAG_MIP_LINEAR                   = 5,
	MIN_LINEAR_MAG_MIP_POINT                   = 16,
	MIN_LINEAR_MAG_POINT_MIP_LINEAR            = 17,
	MIN_MAG_LINEAR_MIP_POINT                   = 20,
	MIN_MAG_MIP_LINEAR                         = 21,
	ANISOTROPIC                                = 85,
	COMPARISON_MIN_MAG_MIP_POINT               = 128,
	COMPARISON_MIN_MAG_POINT_MIP_LINEAR        = 129,
	COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT  = 132,
	COMPARISON_MIN_POINT_MAG_MIP_LINEAR        = 133,
	COMPARISON_MIN_LINEAR_MAG_MIP_POINT        = 144,
	COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 145,
	COMPARISON_MIN_MAG_LINEAR_MIP_POINT        = 148,
	COMPARISON_MIN_MAG_MIP_LINEAR              = 149,
	COMPARISON_ANISOTROPIC                     = 213,
	MINIMUM_MIN_MAG_MIP_POINT                  = 256,
	MINIMUM_MIN_MAG_POINT_MIP_LINEAR           = 257,
	MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT     = 260,
	MINIMUM_MIN_POINT_MAG_MIP_LINEAR           = 261,
	MINIMUM_MIN_LINEAR_MAG_MIP_POINT           = 272,
	MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR    = 273,
	MINIMUM_MIN_MAG_LINEAR_MIP_POINT           = 276,
	MINIMUM_MIN_MAG_MIP_LINEAR                 = 277,
	MINIMUM_ANISOTROPIC                        = 341,
	MAXIMUM_MIN_MAG_MIP_POINT                  = 384,
	MAXIMUM_MIN_MAG_POINT_MIP_LINEAR           = 385,
	MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT     = 388,
	MAXIMUM_MIN_POINT_MAG_MIP_LINEAR           = 389,
	MAXIMUM_MIN_LINEAR_MAG_MIP_POINT           = 400,
	MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR    = 401,
	MAXIMUM_MIN_MAG_LINEAR_MIP_POINT           = 404,
	MAXIMUM_MIN_MAG_MIP_LINEAR                 = 405,
	MAXIMUM_ANISOTROPIC                        = 469,
}

FILTER_TYPE :: enum i32 {
	POINT  = 0,
	LINEAR = 1,
}

FILTER_REDUCTION_TYPE :: enum i32 {
	STANDARD   = 0,
	COMPARISON = 1,
	MINIMUM    = 2,
	MAXIMUM    = 3,
}

TEXTURE_ADDRESS_MODE :: enum i32 {
	WRAP        = 1,
	MIRROR      = 2,
	CLAMP       = 3,
	BORDER      = 4,
	MIRROR_ONCE = 5,
}

SAMPLER_DESC :: struct {
	Filter:         FILTER,
	AddressU:       TEXTURE_ADDRESS_MODE,
	AddressV:       TEXTURE_ADDRESS_MODE,
	AddressW:       TEXTURE_ADDRESS_MODE,
	MipLODBias:     f32,
	MaxAnisotropy:  u32,
	ComparisonFunc: COMPARISON_FUNC,
	BorderColor:    [4]f32,
	MinLOD:         f32,
	MaxLOD:         f32,
}

CSAMPLER_DESC :: struct {
	using d3d11_sampler_desc: SAMPLER_DESC,
}


ISamplerState_UUID_STRING :: "DA6FEA51-564C-4487-9810-F0D0F9B4E3A5"
ISamplerState_UUID := &IID{0xDA6FEA51, 0x564C, 0x4487, {0x98, 0x10, 0xF0, 0xD0, 0xF9, 0xB4, 0xE3, 0xA5}}
ISamplerState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11samplerstate_vtable: ^ISamplerState_VTable,
}
ISamplerState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "stdcall" (this: ^ISamplerState, pDesc: ^SAMPLER_DESC),
}


FORMAT_SUPPORT :: enum i32 { // TODO: make bit_set
	BUFFER                      = 1,
	IA_VERTEX_BUFFER            = 2,
	IA_INDEX_BUFFER             = 4,
	SO_BUFFER                   = 8,
	TEXTURE1D                   = 16,
	TEXTURE2D                   = 32,
	TEXTURE3D                   = 64,
	TEXTURECUBE                 = 128,
	SHADER_LOAD                 = 256,
	SHADER_SAMPLE               = 512,
	SHADER_SAMPLE_COMPARISON    = 1024,
	SHADER_SAMPLE_MONO_TEXT     = 2048,
	MIP                         = 4096,
	MIP_AUTOGEN                 = 8192,
	RENDER_TARGET               = 16384,
	BLENDABLE                   = 32768,
	DEPTH_STENCIL               = 65536,
	CPU_LOCKABLE                = 131072,
	MULTISAMPLE_RESOLVE         = 262144,
	DISPLAY                     = 524288,
	CAST_WITHIN_BIT_LAYOUT      = 1048576,
	MULTISAMPLE_RENDERTARGET    = 2097152,
	MULTISAMPLE_LOAD            = 4194304,
	SHADER_GATHER               = 8388608,
	BACK_BUFFER_CAST            = 16777216,
	TYPED_UNORDERED_ACCESS_VIEW = 33554432,
	SHADER_GATHER_COMPARISON    = 67108864,
	DECODER_OUTPUT              = 134217728,
	VIDEO_PROCESSOR_OUTPUT      = 268435456,
	VIDEO_PROCESSOR_INPUT       = 536870912,
	VIDEO_ENCODER               = 1073741824,
}

FORMAT_SUPPORT2 :: enum i32 { // TODO: make bit_set
	UAV_ATOMIC_ADD                               = 1,
	UAV_ATOMIC_BITWISE_OPS                       = 2,
	UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE = 4,
	UAV_ATOMIC_EXCHANGE                          = 8,
	UAV_ATOMIC_SIGNED_MIN_OR_MAX                 = 16,
	UAV_ATOMIC_UNSIGNED_MIN_OR_MAX               = 32,
	UAV_TYPED_LOAD                               = 64,
	UAV_TYPED_STORE                              = 128,
	OUTPUT_MERGER_LOGIC_OP                       = 256,
	TILED                                        = 512,
	SHAREABLE                                    = 1024,
	MULTIPLANE_OVERLAY                           = 16384,
}


IAsynchronous_UUID_STRING :: "4B35D0CD-1E15-4258-9C98-1B1333F6DD3B"
IAsynchronous_UUID := &IID{0x4B35D0CD, 0x1E15, 0x4258, {0x9C, 0x98, 0x1B, 0x13, 0x33, 0xF6, 0xDD, 0x3B}}
IAsynchronous :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11asynchronous_vtable: ^IAsynchronous_VTable,
}
IAsynchronous_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDataSize: proc "stdcall" (this: ^IAsynchronous) -> u32,
}


ASYNC_GETDATA_FLAG :: enum u32 { // TODO: make bit_set
	DONOTFLUSH = 0x1,
}

QUERY :: enum i32 {
	EVENT                         = 0,
	OCCLUSION                     = 1,
	TIMESTAMP                     = 2,
	TIMESTAMP_DISJOINT            = 3,
	PIPELINE_STATISTICS           = 4,
	OCCLUSION_PREDICATE           = 5,
	SO_STATISTICS                 = 6,
	SO_OVERFLOW_PREDICATE         = 7,
	SO_STATISTICS_STREAM0         = 8,
	SO_OVERFLOW_PREDICATE_STREAM0 = 9,
	SO_STATISTICS_STREAM1         = 10,
	SO_OVERFLOW_PREDICATE_STREAM1 = 11,
	SO_STATISTICS_STREAM2         = 12,
	SO_OVERFLOW_PREDICATE_STREAM2 = 13,
	SO_STATISTICS_STREAM3         = 14,
	SO_OVERFLOW_PREDICATE_STREAM3 = 15,
}

QUERY_MISC_FLAG :: enum u32 { // TODO: make bit_set
	QUERY_MISC_PREDICATEHINT = 0x1,
}

QUERY_DESC :: struct {
	Query:     QUERY,
	MiscFlags: RESOURCE_MISC_FLAG,
}

CQUERY_DESC :: struct {
	using d3d11_query_desc: QUERY_DESC,
}


IQuery_UUID_STRING :: "D6C00747-87B7-425E-B84D-44D108560AFD"
IQuery_UUID := &IID{0xD6C00747, 0x87B7, 0x425E, {0xB8, 0x4D, 0x44, 0xD1, 0x08, 0x56, 0x0A, 0xFD}}
IQuery :: struct #raw_union {
	#subtype id3d11asynchronous: IAsynchronous,
	using id3d11query_vtable: ^IQuery_VTable,
}
IQuery_VTable :: struct {
	using id3d11asynchronous_vtable: IAsynchronous_VTable,
	GetDesc: proc "stdcall" (this: ^IQuery, pDesc: ^QUERY_DESC),
}



IPredicate_UUID_STRING :: "9EB576DD-9F77-4D86-81AA-8BAB5FE490E2"
IPredicate_UUID := &IID{0x9EB576DD, 0x9F77, 0x4D86, {0x81, 0xAA, 0x8B, 0xAB, 0x5F, 0xE4, 0x90, 0xE2}}
IPredicate :: struct {
	using id3d11query: IQuery,
}

QUERY_DATA_TIMESTAMP_DISJOINT :: struct {
	Frequency: u64,
	Disjoint:  BOOL,
}

QUERY_DATA_PIPELINE_STATISTICS :: struct {
	IAVertices:    u64,
	IAPrimitives:  u64,
	VSInvocations: u64,
	GSInvocations: u64,
	GSPrimitives:  u64,
	CInvocations:  u64,
	CPrimitives:   u64,
	PSInvocations: u64,
	HSInvocations: u64,
	DSInvocations: u64,
	CSInvocations: u64,
}

QUERY_DATA_SO_STATISTICS :: struct {
	NumPrimitivesWritten:    u64,
	PrimitivesStorageNeeded: u64,
}

COUNTER :: enum i32 {
	DEVICE_DEPENDENT_0 = 1073741824,
}

COUNTER_TYPE :: enum i32 {
	FLOAT32 = 0,
	UINT16  = 1,
	UINT32  = 2,
	UINT64  = 3,
}

COUNTER_DESC :: struct {
	Counter:   COUNTER,
	MiscFlags: RESOURCE_MISC_FLAG,
}

CCOUNTER_DESC :: struct {
	using d3d11_counter_desc: COUNTER_DESC,
}

COUNTER_INFO :: struct {
	LastDeviceDependentCounter: COUNTER,
	NumSimultaneousCounters:    u32,
	NumDetectableParallelUnits: u8,
}


ICounter_UUID_STRING :: "6E8C49FB-A371-4770-B440-29086022B741"
ICounter_UUID := &IID{0x6E8C49FB, 0xA371, 0x4770, {0xB4, 0x40, 0x29, 0x08, 0x60, 0x22, 0xB7, 0x41}}
ICounter :: struct #raw_union {
	#subtype id3d11asynchronous: IAsynchronous,
	using id3d11counter_vtable: ^ICounter_VTable,
}
ICounter_VTable :: struct {
	using id3d11asynchronous_vtable: IAsynchronous_VTable,
	GetDesc: proc "stdcall" (this: ^ICounter, pDesc: ^COUNTER_DESC),
}


STANDARD_MULTISAMPLE_QUALITY_LEVELS :: enum i32 {
	STANDARD_MULTISAMPLE_PATTERN = -1,
	CENTER_MULTISAMPLE_PATTERN   = -2,
}

DEVICE_CONTEXT_TYPE :: enum i32 {
	IMMEDIATE = 0,
	DEFERRED  = 1,
}

CLASS_INSTANCE_DESC :: struct {
	InstanceId:               u32,
	InstanceIndex:            u32,
	TypeId:                   u32,
	ConstantBuffer:           u32,
	BaseConstantBufferOffset: u32,
	BaseTexture:              u32,
	BaseSampler:              u32,
	Created:                  BOOL,
}


IClassInstance_UUID_STRING :: "A6CD7FAA-B0B7-4A2F-9436-8662A65797CB"
IClassInstance_UUID := &IID{0xA6CD7FAA, 0xB0B7, 0x4A2F, {0x94, 0x36, 0x86, 0x62, 0xA6, 0x57, 0x97, 0xCB}}
IClassInstance :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11classinstance_vtable: ^IClassInstance_VTable,
}
IClassInstance_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetClassLinkage: proc "stdcall" (this: ^IClassInstance, ppLinkage: ^^IClassLinkage),
	GetDesc:         proc "stdcall" (this: ^IClassInstance, pDesc: ^CLASS_INSTANCE_DESC),
	GetInstanceName: proc "stdcall" (this: ^IClassInstance, pInstanceName: cstring, pBufferLength: ^SIZE_T),
	GetTypeName:     proc "stdcall" (this: ^IClassInstance, pTypeName: cstring, pBufferLength: ^SIZE_T),
}



IClassLinkage_UUID_STRING :: "DDF57CBA-9543-46E4-A12B-F207A0FE7FED"
IClassLinkage_UUID := &IID{0xDDF57CBA, 0x9543, 0x46E4, {0xA1, 0x2B, 0xF2, 0x07, 0xA0, 0xFE, 0x7F, 0xED}}
IClassLinkage :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11classlinkage_vtable: ^IClassLinkage_VTable,
}
IClassLinkage_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetClassInstance:    proc "stdcall" (this: ^IClassLinkage, pClassInstanceName: cstring, InstanceIndex: u32, ppInstance: ^^IClassInstance) -> HRESULT,
	CreateClassInstance: proc "stdcall" (this: ^IClassLinkage, pClassTypeName: cstring, ConstantBufferOffset: u32, ConstantVectorOffset: u32, TextureOffset: u32, SamplerOffset: u32, ppInstance: ^^IClassInstance) -> HRESULT,
}



ICommandList_UUID_STRING :: "A24BC4D1-769E-43F7-8013-98FF566C18E2"
ICommandList_UUID := &IID{0xA24BC4D1, 0x769E, 0x43F7, {0x80, 0x13, 0x98, 0xFF, 0x56, 0x6C, 0x18, 0xE2}}
ICommandList :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11commandlist_vtable: ^ICommandList_VTable,
}
ICommandList_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetContextFlags: proc "stdcall" (this: ^ICommandList) -> u32,
}


FEATURE :: enum i32 {
	THREADING                      = 0,
	DOUBLES                        = 1,
	FORMAT_SUPPORT                 = 2,
	FORMAT_SUPPORT2                = 3,
	D3D10_X_HARDWARE_OPTIONS       = 4,
	OPTIONS                  = 5,
	ARCHITECTURE_INFO              = 6,
	D3D9_OPTIONS                   = 7,
	SHADER_MIN_PRECISION_SUPPORT   = 8,
	D3D9_SHADOW_SUPPORT            = 9,
	OPTIONS1                 = 10,
	D3D9_SIMPLE_INSTANCING_SUPPORT = 11,
	MARKER_SUPPORT                 = 12,
	D3D9_OPTIONS1                  = 13,
	OPTIONS2                 = 14,
	OPTIONS3                 = 15,
	GPU_VIRTUAL_ADDRESS_SUPPORT    = 16,
	OPTIONS4                 = 17,
	SHADER_CACHE                   = 18,
	OPTIONS5                 = 19,
}

FEATURE_DATA_THREADING :: struct {
	DriverConcurrentCreates: BOOL,
	DriverCommandLists:      BOOL,
}

FEATURE_DATA_DOUBLES :: struct {
	DoublePrecisionFloatShaderOps: BOOL,
}

FEATURE_DATA_FORMAT_SUPPORT :: struct {
	InFormat:         dxgi.FORMAT,
	OutFormatSupport: u32,
}

FEATURE_DATA_FORMAT_SUPPORT2 :: struct {
	InFormat:          dxgi.FORMAT,
	OutFormatSupport2: u32,
}

FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS :: struct {
	ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: BOOL,
}

FEATURE_DATA_OPTIONS :: struct {
	OutputMergerLogicOp:                    BOOL,
	UAVOnlyRenderingForcedSampleCount:      BOOL,
	DiscardAPIsSeenByDriver:                BOOL,
	FlagsForUpdateAndCopySeenByDriver:      BOOL,
	ClearView:                              BOOL,
	CopyWithOverlap:                        BOOL,
	ConstantBufferPartialUpdate:            BOOL,
	ConstantBufferOffsetting:               BOOL,
	MapNoOverwriteOnDynamicConstantBuffer:  BOOL,
	MapNoOverwriteOnDynamicBufferSRV:       BOOL,
	MultisampleRTVWithForcedSampleCountOne: BOOL,
	SAD4ShaderInstructions:                 BOOL,
	ExtendedDoublesShaderInstructions:      BOOL,
	ExtendedResourceSharing:                BOOL,
}

FEATURE_DATA_ARCHITECTURE_INFO :: struct {
	TileBasedDeferredRenderer: BOOL,
}

FEATURE_DATA_D3D9_OPTIONS :: struct {
	FullNonPow2TextureSupport: BOOL,
}

FEATURE_DATA_D3D9_SHADOW_SUPPORT :: struct {
	SupportsDepthAsTextureWithLessEqualComparisonFilter: BOOL,
}

SHADER_MIN_PRECISION_SUPPORT :: enum i32 {
	_10_BIT = 1,
	_16_BIT = 2,
}

FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT :: struct {
	PixelShaderMinPrecision:          u32,
	AllOtherShaderStagesMinPrecision: u32,
}

TILED_RESOURCES_TIER :: enum i32 {
	TILED_RESOURCES_NOT_SUPPORTED = 0,
	_1                                  = 1,
	_2                                  = 2,
	_3                                  = 3,
}

FEATURE_DATA_OPTIONS1 :: struct {
	TiledResourcesTier:                    TILED_RESOURCES_TIER,
	MinMaxFiltering:                       BOOL,
	ClearViewAlsoSupportsDepthOnlyFormats: BOOL,
	MapOnDefaultBuffers:                   BOOL,
}

FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT :: struct {
	SimpleInstancingSupported: BOOL,
}

FEATURE_DATA_MARKER_SUPPORT :: struct {
	Profile: BOOL,
}

FEATURE_DATA_D3D9_OPTIONS1 :: struct {
	FullNonPow2TextureSupported:                                 BOOL,
	DepthAsTextureWithLessEqualComparisonFilterSupported:        BOOL,
	SimpleInstancingSupported:                                   BOOL,
	TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported: BOOL,
}

CONSERVATIVE_RASTERIZATION_TIER :: enum i32 {
	CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED = 0,
	_1                                             = 1,
	_2                                             = 2,
	_3                                             = 3,
}

FEATURE_DATA_OPTIONS2 :: struct {
	PSSpecifiedStencilRefSupported: BOOL,
	TypedUAVLoadAdditionalFormats:  BOOL,
	ROVsSupported:                  BOOL,
	ConservativeRasterizationTier:  CONSERVATIVE_RASTERIZATION_TIER,
	TiledResourcesTier:             TILED_RESOURCES_TIER,
	MapOnDefaultTextures:           BOOL,
	StandardSwizzle:                BOOL,
	UnifiedMemoryArchitecture:      BOOL,
}

FEATURE_DATA_OPTIONS3 :: struct {
	VPAndRTArrayIndexFromAnyShaderFeedingRasterizer: BOOL,
}

FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT :: struct {
	MaxGPUVirtualAddressBitsPerResource: u32,
	MaxGPUVirtualAddressBitsPerProcess:  u32,
}

SHADER_CACHE_SUPPORT_FLAGS :: enum u32 { // TODO: make bit_set
	NONE                   = 0x0,
	AUTOMATIC_INPROC_CACHE = 0x1,
	AUTOMATIC_DISK_CACHE   = 0x2,
}

FEATURE_DATA_SHADER_CACHE :: struct {
	SupportFlags: u32,
}

SHARED_RESOURCE_TIER :: enum i32 {
	_0 = 0,
	_1 = 1,
	_2 = 2,
	_3 = 3,
}

FEATURE_DATA_OPTIONS5 :: struct {
	SharedResourceTier: SHARED_RESOURCE_TIER,
}


IDeviceContext_UUID_STRING :: "C0BFA96C-E089-44FB-8EAF-26F8796190DA"
IDeviceContext_UUID := &IID{0xC0BFA96C, 0xE089, 0x44FB, {0x8E, 0xAF, 0x26, 0xF8, 0x79, 0x61, 0x90, 0xDA}}
IDeviceContext :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11devicecontext_vtable: ^IDeviceContext_VTable,
}
IDeviceContext_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	VSSetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	PSSetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	PSSetShader:                               proc "stdcall" (this: ^IDeviceContext, pPixelShader: ^IPixelShader, ppClassInstances: ^^IClassInstance, NumClassInstances: u32),
	PSSetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	VSSetShader:                               proc "stdcall" (this: ^IDeviceContext, pVertexShader: ^IVertexShader, ppClassInstances: ^^IClassInstance, NumClassInstances: u32),
	DrawIndexed:                               proc "stdcall" (this: ^IDeviceContext, IndexCount: u32, StartIndexLocation: u32, BaseVertexLocation: i32),
	Draw:                                      proc "stdcall" (this: ^IDeviceContext, VertexCount: u32, StartVertexLocation: u32),
	Map:                                       proc "stdcall" (this: ^IDeviceContext, pResource: ^IResource, Subresource: u32, MapType: MAP, MapFlags: u32, pMappedResource: ^MAPPED_SUBRESOURCE) -> HRESULT,
	Unmap:                                     proc "stdcall" (this: ^IDeviceContext, pResource: ^IResource, Subresource: u32),
	PSSetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	IASetInputLayout:                          proc "stdcall" (this: ^IDeviceContext, pInputLayout: ^IInputLayout),
	IASetVertexBuffers:                        proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppVertexBuffers: ^^IBuffer, pStrides: ^u32, pOffsets: ^u32),
	IASetIndexBuffer:                          proc "stdcall" (this: ^IDeviceContext, pIndexBuffer: ^IBuffer, Format: dxgi.FORMAT, Offset: u32),
	DrawIndexedInstanced:                      proc "stdcall" (this: ^IDeviceContext, IndexCountPerInstance: u32, InstanceCount: u32, StartIndexLocation: u32, BaseVertexLocation: i32, StartInstanceLocation: u32),
	DrawInstanced:                             proc "stdcall" (this: ^IDeviceContext, VertexCountPerInstance: u32, InstanceCount: u32, StartVertexLocation: u32, StartInstanceLocation: u32),
	GSSetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	GSSetShader:                               proc "stdcall" (this: ^IDeviceContext, pShader: ^IGeometryShader, ppClassInstances: ^^IClassInstance, NumClassInstances: u32),
	IASetPrimitiveTopology:                    proc "stdcall" (this: ^IDeviceContext, Topology: PRIMITIVE_TOPOLOGY),
	VSSetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	VSSetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	Begin:                                     proc "stdcall" (this: ^IDeviceContext, pAsync: ^IAsynchronous),
	End:                                       proc "stdcall" (this: ^IDeviceContext, pAsync: ^IAsynchronous),
	GetData:                                   proc "stdcall" (this: ^IDeviceContext, pAsync: ^IAsynchronous, pData: rawptr, DataSize: u32, GetDataFlags: u32) -> HRESULT,
	SetPredication:                            proc "stdcall" (this: ^IDeviceContext, pPredicate: ^IPredicate, PredicateValue: BOOL),
	GSSetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	GSSetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	OMSetRenderTargets:                        proc "stdcall" (this: ^IDeviceContext, NumViews: u32, ppRenderTargetViews: ^^IRenderTargetView, pDepthStencilView: ^IDepthStencilView),
	OMSetRenderTargetsAndUnorderedAccessViews: proc "stdcall" (this: ^IDeviceContext, NumRTVs: u32, ppRenderTargetViews: ^^IRenderTargetView, pDepthStencilView: ^IDepthStencilView, UAVStartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: ^^IUnorderedAccessView, pUAVInitialCounts: ^u32),
	OMSetBlendState:                           proc "stdcall" (this: ^IDeviceContext, pBlendState: ^IBlendState, BlendFactor: ^[4]f32, SampleMask: u32),
	OMSetDepthStencilState:                    proc "stdcall" (this: ^IDeviceContext, pDepthStencilState: ^IDepthStencilState, StencilRef: u32),
	SOSetTargets:                              proc "stdcall" (this: ^IDeviceContext, NumBuffers: u32, ppSOTargets: ^^IBuffer, pOffsets: ^u32),
	DrawAuto:                                  proc "stdcall" (this: ^IDeviceContext),
	DrawIndexedInstancedIndirect:              proc "stdcall" (this: ^IDeviceContext, pBufferForArgs: ^IBuffer, AlignedByteOffsetForArgs: u32),
	DrawInstancedIndirect:                     proc "stdcall" (this: ^IDeviceContext, pBufferForArgs: ^IBuffer, AlignedByteOffsetForArgs: u32),
	Dispatch:                                  proc "stdcall" (this: ^IDeviceContext, ThreadGroupCountX: u32, ThreadGroupCountY: u32, ThreadGroupCountZ: u32),
	DispatchIndirect:                          proc "stdcall" (this: ^IDeviceContext, pBufferForArgs: ^IBuffer, AlignedByteOffsetForArgs: u32),
	RSSetState:                                proc "stdcall" (this: ^IDeviceContext, pRasterizerState: ^IRasterizerState),
	RSSetViewports:                            proc "stdcall" (this: ^IDeviceContext, NumViewports: u32, pViewports: ^VIEWPORT),
	RSSetScissorRects:                         proc "stdcall" (this: ^IDeviceContext, NumRects: u32, pRects: ^RECT),
	CopySubresourceRegion:                     proc "stdcall" (this: ^IDeviceContext, pDstResource: ^IResource, DstSubresource: u32, DstX: u32, DstY: u32, DstZ: u32, pSrcResource: ^IResource, SrcSubresource: u32, pSrcBox: ^BOX),
	CopyResource:                              proc "stdcall" (this: ^IDeviceContext, pDstResource: ^IResource, pSrcResource: ^IResource),
	UpdateSubresource:                         proc "stdcall" (this: ^IDeviceContext, pDstResource: ^IResource, DstSubresource: u32, pDstBox: ^BOX, pSrcData: rawptr, SrcRowPitch: u32, SrcDepthPitch: u32),
	CopyStructureCount:                        proc "stdcall" (this: ^IDeviceContext, pDstBuffer: ^IBuffer, DstAlignedByteOffset: u32, pSrcView: ^IUnorderedAccessView),
	ClearRenderTargetView:                     proc "stdcall" (this: ^IDeviceContext, pRenderTargetView: ^IRenderTargetView, ColorRGBA: ^[4]f32),
	ClearUnorderedAccessViewUint:              proc "stdcall" (this: ^IDeviceContext, pUnorderedAccessView: ^IUnorderedAccessView, Values: ^[4]u32),
	ClearUnorderedAccessViewFloat:             proc "stdcall" (this: ^IDeviceContext, pUnorderedAccessView: ^IUnorderedAccessView, Values: ^[4]f32),
	ClearDepthStencilView:                     proc "stdcall" (this: ^IDeviceContext, pDepthStencilView: ^IDepthStencilView, ClearFlags: CLEAR_FLAG, Depth: f32, Stencil: u8),
	GenerateMips:                              proc "stdcall" (this: ^IDeviceContext, pShaderResourceView: ^IShaderResourceView),
	SetResourceMinLOD:                         proc "stdcall" (this: ^IDeviceContext, pResource: ^IResource, MinLOD: f32),
	GetResourceMinLOD:                         proc "stdcall" (this: ^IDeviceContext, pResource: ^IResource) -> f32,
	ResolveSubresource:                        proc "stdcall" (this: ^IDeviceContext, pDstResource: ^IResource, DstSubresource: u32, pSrcResource: ^IResource, SrcSubresource: u32, Format: dxgi.FORMAT),
	ExecuteCommandList:                        proc "stdcall" (this: ^IDeviceContext, pCommandList: ^ICommandList, RestoreContextState: BOOL),
	HSSetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	HSSetShader:                               proc "stdcall" (this: ^IDeviceContext, pHullShader: ^IHullShader, ppClassInstances: ^^IClassInstance, NumClassInstances: u32),
	HSSetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	HSSetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	DSSetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	DSSetShader:                               proc "stdcall" (this: ^IDeviceContext, pDomainShader: ^IDomainShader, ppClassInstances: ^^IClassInstance, NumClassInstances: u32),
	DSSetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	DSSetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	CSSetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	CSSetUnorderedAccessViews:                 proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: ^^IUnorderedAccessView, pUAVInitialCounts: ^u32),
	CSSetShader:                               proc "stdcall" (this: ^IDeviceContext, pComputeShader: ^IComputeShader, ppClassInstances: ^^IClassInstance, NumClassInstances: u32),
	CSSetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	CSSetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	VSGetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	PSGetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	PSGetShader:                               proc "stdcall" (this: ^IDeviceContext, ppPixelShader: ^^IPixelShader, ppClassInstances: ^^IClassInstance, pNumClassInstances: ^u32),
	PSGetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	VSGetShader:                               proc "stdcall" (this: ^IDeviceContext, ppVertexShader: ^^IVertexShader, ppClassInstances: ^^IClassInstance, pNumClassInstances: ^u32),
	PSGetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	IAGetInputLayout:                          proc "stdcall" (this: ^IDeviceContext, ppInputLayout: ^^IInputLayout),
	IAGetVertexBuffers:                        proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppVertexBuffers: ^^IBuffer, pStrides: ^u32, pOffsets: ^u32),
	IAGetIndexBuffer:                          proc "stdcall" (this: ^IDeviceContext, pIndexBuffer: ^^IBuffer, Format: ^dxgi.FORMAT, Offset: ^u32),
	GSGetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	GSGetShader:                               proc "stdcall" (this: ^IDeviceContext, ppGeometryShader: ^^IGeometryShader, ppClassInstances: ^^IClassInstance, pNumClassInstances: ^u32),
	IAGetPrimitiveTopology:                    proc "stdcall" (this: ^IDeviceContext, pTopology: ^PRIMITIVE_TOPOLOGY),
	VSGetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	VSGetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	GetPredication:                            proc "stdcall" (this: ^IDeviceContext, ppPredicate: ^^IPredicate, pPredicateValue: ^BOOL),
	GSGetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	GSGetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	OMGetRenderTargets:                        proc "stdcall" (this: ^IDeviceContext, NumViews: u32, ppRenderTargetViews: ^^IRenderTargetView, ppDepthStencilView: ^^IDepthStencilView),
	OMGetRenderTargetsAndUnorderedAccessViews: proc "stdcall" (this: ^IDeviceContext, NumRTVs: u32, ppRenderTargetViews: ^^IRenderTargetView, ppDepthStencilView: ^^IDepthStencilView, UAVStartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: ^^IUnorderedAccessView),
	OMGetBlendState:                           proc "stdcall" (this: ^IDeviceContext, ppBlendState: ^^IBlendState, BlendFactor: ^[4]f32, pSampleMask: ^u32),
	OMGetDepthStencilState:                    proc "stdcall" (this: ^IDeviceContext, ppDepthStencilState: ^^IDepthStencilState, pStencilRef: ^u32),
	SOGetTargets:                              proc "stdcall" (this: ^IDeviceContext, NumBuffers: u32, ppSOTargets: ^^IBuffer),
	RSGetState:                                proc "stdcall" (this: ^IDeviceContext, ppRasterizerState: ^^IRasterizerState),
	RSGetViewports:                            proc "stdcall" (this: ^IDeviceContext, pNumViewports: ^u32, pViewports: ^VIEWPORT),
	RSGetScissorRects:                         proc "stdcall" (this: ^IDeviceContext, pNumRects: ^u32, pRects: ^RECT),
	HSGetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	HSGetShader:                               proc "stdcall" (this: ^IDeviceContext, ppHullShader: ^^IHullShader, ppClassInstances: ^^IClassInstance, pNumClassInstances: ^u32),
	HSGetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	HSGetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	DSGetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	DSGetShader:                               proc "stdcall" (this: ^IDeviceContext, ppDomainShader: ^^IDomainShader, ppClassInstances: ^^IClassInstance, pNumClassInstances: ^u32),
	DSGetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	DSGetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	CSGetShaderResources:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: ^^IShaderResourceView),
	CSGetUnorderedAccessViews:                 proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: ^^IUnorderedAccessView),
	CSGetShader:                               proc "stdcall" (this: ^IDeviceContext, ppComputeShader: ^^IComputeShader, ppClassInstances: ^^IClassInstance, pNumClassInstances: ^u32),
	CSGetSamplers:                             proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: ^^ISamplerState),
	CSGetConstantBuffers:                      proc "stdcall" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: ^^IBuffer),
	ClearState:                                proc "stdcall" (this: ^IDeviceContext),
	Flush:                                     proc "stdcall" (this: ^IDeviceContext),
	GetType:                                   proc "stdcall" (this: ^IDeviceContext) -> DEVICE_CONTEXT_TYPE,
	GetContextFlags:                           proc "stdcall" (this: ^IDeviceContext) -> u32,
	FinishCommandList:                         proc "stdcall" (this: ^IDeviceContext, RestoreDeferredContextState: BOOL, ppCommandList: ^^ICommandList) -> HRESULT,
}


CVIDEO_DEFAULT :: struct {
	_: u8,
}

APP_DEPRECATED_HRESULT :: HRESULT


VIDEO_DECODER_DESC :: struct {
	Guid:         GUID,
	SampleWidth:  u32,
	SampleHeight: u32,
	OutputFormat: dxgi.FORMAT,
}

VIDEO_DECODER_CONFIG :: struct {
	guidConfigBitstreamEncryption:  GUID,
	guidConfigMBcontrolEncryption:  GUID,
	guidConfigResidDiffEncryption:  GUID,
	ConfigBitstreamRaw:             u32,
	ConfigMBcontrolRasterOrder:     u32,
	ConfigResidDiffHost:            u32,
	ConfigSpatialResid8:            u32,
	ConfigResid8Subtraction:        u32,
	ConfigSpatialHost8or9Clipping:  u32,
	ConfigSpatialResidInterleaved:  u32,
	ConfigIntraResidUnsigned:       u32,
	ConfigResidDiffAccelerator:     u32,
	ConfigHostInverseScan:          u32,
	ConfigSpecificIDCT:             u32,
	Config4GroupedCoefs:            u32,
	ConfigMinRenderTargetBuffCount: u16,
	ConfigDecoderSpecific:          u16,
}

VIDEO_DECODER_BUFFER_TYPE :: enum i32 {
	PICTURE_PARAMETERS          = 0,
	MACROBLOCK_CONTROL          = 1,
	RESIDUAL_DIFFERENCE         = 2,
	DEBLOCKING_CONTROL          = 3,
	INVERSE_QUANTIZATION_MATRIX = 4,
	SLICE_CONTROL               = 5,
	BITSTREAM                   = 6,
	MOTION_VECTOR               = 7,
	FILM_GRAIN                  = 8,
}

AES_CTR_IV :: struct {
	IV:    u64,
	Count: u64,
}

ENCRYPTED_BLOCK_INFO :: struct {
	NumEncryptedBytesAtBeginning: u32,
	NumBytesInSkipPattern:        u32,
	NumBytesInEncryptPattern:     u32,
}

VIDEO_DECODER_BUFFER_DESC :: struct {
	BufferType:         VIDEO_DECODER_BUFFER_TYPE,
	BufferIndex:        u32,
	DataOffset:         u32,
	DataSize:           u32,
	FirstMBaddress:     u32,
	NumMBsInBuffer:     u32,
	Width:              u32,
	Height:             u32,
	Stride:             u32,
	ReservedBits:       u32,

	pIV:                rawptr,
	IVSize:             u32,
	PartialEncryption:  BOOL,
	EncryptedBlockInfo: ENCRYPTED_BLOCK_INFO,
}

VIDEO_DECODER_EXTENSION :: struct {
	Function:              u32,

	pPrivateInputData:     rawptr,
	PrivateInputDataSize:  u32,

	pPrivateOutputData:    rawptr,
	PrivateOutputDataSize: u32,
	ResourceCount:         u32,

	ppResourceList:        ^^IResource,
}


IVideoDecoder_UUID_STRING :: "3C9C5B51-995D-48D1-9B8D-FA5CAEDED65C"
IVideoDecoder_UUID := &IID{0x3C9C5B51, 0x995D, 0x48D1, {0x9B, 0x8D, 0xFA, 0x5C, 0xAE, 0xDE, 0xD6, 0x5C}}
IVideoDecoder :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videodecoder_vtable: ^IVideoDecoder_VTable,
}
IVideoDecoder_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetCreationParameters: proc "stdcall" (this: ^IVideoDecoder, pVideoDesc: ^VIDEO_DECODER_DESC, pConfig: ^VIDEO_DECODER_CONFIG) -> HRESULT,
	GetDriverHandle: proc "stdcall" (this: ^IVideoDecoder, pDriverHandle: ^HANDLE) -> HRESULT,
}


VIDEO_PROCESSOR_FORMAT_SUPPORT :: enum i32 {
	INPUT  = 1,
	OUTPUT = 2,
}

VIDEO_PROCESSOR_DEVICE_CAPS :: enum i32 { // TODO: make bit_set
	LINEAR_SPACE            = 1,
	xvYCC                   = 2,
	RGB_RANGE_CONVERSION    = 4,
	YCbCr_MATRIX_CONVERSION = 8,
	NOMINAL_RANGE           = 16,
}

VIDEO_PROCESSOR_FEATURE_CAPS :: enum i32 { // TODO: make bit_set
	ALPHA_FILL         = 1,
	CONSTRICTION       = 2,
	LUMA_KEY           = 4,
	ALPHA_PALETTE      = 8,
	LEGACY             = 16,
	STEREO             = 32,
	ROTATION           = 64,
	ALPHA_STREAM       = 128,
	PIXEL_ASPECT_RATIO = 256,
	MIRROR             = 512,
	SHADER_USAGE       = 1024,
	METADATA_HDR10     = 2048,
}

VIDEO_PROCESSOR_FILTER_CAPS :: enum i32 { // TODO: make bit_set
	BRIGHTNESS         = 1,
	CONTRAST           = 2,
	HUE                = 4,
	SATURATION         = 8,
	NOISE_REDUCTION    = 16,
	EDGE_ENHANCEMENT   = 32,
	ANAMORPHIC_SCALING = 64,
	STEREO_ADJUSTMENT  = 128,
}

VIDEO_PROCESSOR_FORMAT_CAPS :: enum i32 { // TODO: make bit_set
	RGB_INTERLACED     = 1,
	RGB_PROCAMP        = 2,
	RGB_LUMA_KEY       = 4,
	PALETTE_INTERLACED = 8,
}

VIDEO_PROCESSOR_AUTO_STREAM_CAPS :: enum i32 { // TODO: make bit_set
	DENOISE             = 1,
	DERINGING           = 2,
	EDGE_ENHANCEMENT    = 4,
	COLOR_CORRECTION    = 8,
	FLESH_TONE_MAPPING  = 16,
	IMAGE_STABILIZATION = 32,
	SUPER_RESOLUTION    = 64,
	ANAMORPHIC_SCALING  = 128,
}

VIDEO_PROCESSOR_STEREO_CAPS :: enum i32 { // TODO: make bit_set
	MONO_OFFSET        = 1,
	ROW_INTERLEAVED    = 2,
	COLUMN_INTERLEAVED = 4,
	CHECKERBOARD       = 8,
	FLIP_MODE          = 16,
}

VIDEO_PROCESSOR_CAPS :: struct {
	DeviceCaps:              u32,
	FeatureCaps:             u32,
	FilterCaps:              u32,
	InputFormatCaps:         u32,
	AutoStreamCaps:          u32,
	StereoCaps:              u32,
	RateConversionCapsCount: u32,
	MaxInputStreams:         u32,
	MaxStreamStates:         u32,
}

VIDEO_PROCESSOR_PROCESSOR_CAPS :: enum i32 { // TODO: make bit_set
	DEINTERLACE_BLEND               = 1,
	DEINTERLACE_BOB                 = 2,
	DEINTERLACE_ADAPTIVE            = 4,
	DEINTERLACE_MOTION_COMPENSATION = 8,
	INVERSE_TELECINE                = 16,
	FRAME_RATE_CONVERSION           = 32,
}

VIDEO_PROCESSOR_ITELECINE_CAPS :: enum i32 {
	_32           = 1,
	_22           = 2,
	_2224         = 4,
	_2332         = 8,
	_32322        = 16,
	_55           = 32,
	_64           = 64,
	_87           = 128,
	_222222222223 = 256,
	OTHER         = -2147483648,
}

VIDEO_PROCESSOR_RATE_CONVERSION_CAPS :: struct {
	PastFrames:      u32,
	FutureFrames:    u32,
	ProcessorCaps:   u32,
	ITelecineCaps:   u32,
	CustomRateCount: u32,
}

CONTENT_PROTECTION_CAPS :: enum i32 {
	SOFTWARE                                  = 1,
	HARDWARE                                  = 2,
	PROTECTION_ALWAYS_ON                      = 4,
	PARTIAL_DECRYPTION                        = 8,
	CONTENT_KEY                               = 16,
	FRESHEN_SESSION_KEY                       = 32,
	ENCRYPTED_READ_BACK                       = 64,
	ENCRYPTED_READ_BACK_KEY                   = 128,
	SEQUENTIAL_CTR_IV                         = 256,
	ENCRYPT_SLICEDATA_ONLY                    = 512,
	DECRYPTION_BLT                            = 1024,
	HARDWARE_PROTECT_UNCOMPRESSED             = 2048,
	HARDWARE_PROTECTED_MEMORY_PAGEABLE        = 4096,
	HARDWARE_TEARDOWN                         = 8192,
	HARDWARE_DRM_COMMUNICATION                = 16384,
	HARDWARE_DRM_COMMUNICATION_MULTI_THREADED = 32768,
}


VIDEO_CONTENT_PROTECTION_CAPS :: struct {
	Caps:                 u32,
	KeyExchangeTypeCount: u32,
	BlockAlignmentSize:   u32,
	ProtectedMemorySize:  u64,
}

VIDEO_PROCESSOR_CUSTOM_RATE :: struct {
	CustomRate:          dxgi.RATIONAL,
	OutputFrames:        u32,
	InputInterlaced:     BOOL,
	InputFramesOrFields: u32,
}

VIDEO_PROCESSOR_FILTER :: enum i32 {
	BRIGHTNESS         = 0,
	CONTRAST           = 1,
	HUE                = 2,
	SATURATION         = 3,
	NOISE_REDUCTION    = 4,
	EDGE_ENHANCEMENT   = 5,
	ANAMORPHIC_SCALING = 6,
	STEREO_ADJUSTMENT  = 7,
}

VIDEO_PROCESSOR_FILTER_RANGE :: struct {
	Minimum:    i32,
	Maximum:    i32,
	Default:    i32,
	Multiplier: f32,
}

VIDEO_FRAME_FORMAT :: enum i32 {
	PROGRESSIVE                   = 0,
	INTERLACED_TOP_FIELD_FIRST    = 1,
	INTERLACED_BOTTOM_FIELD_FIRST = 2,
}

VIDEO_USAGE :: enum i32 {
	PLAYBACK_NORMAL = 0,
	OPTIMAL_SPEED   = 1,
	OPTIMAL_QUALITY = 2,
}

VIDEO_PROCESSOR_CONTENT_DESC :: struct {
	InputFrameFormat: VIDEO_FRAME_FORMAT,
	InputFrameRate:   dxgi.RATIONAL,
	InputWidth:       u32,
	InputHeight:      u32,
	OutputFrameRate:  dxgi.RATIONAL,
	OutputWidth:      u32,
	OutputHeight:     u32,
	Usage:            VIDEO_USAGE,
}


IVideoProcessorEnumerator_UUID_STRING :: "31627037-53AB-4200-9061-05FAA9AB45F9"
IVideoProcessorEnumerator_UUID := &IID{0x31627037, 0x53AB, 0x4200, {0x90, 0x61, 0x05, 0xFA, 0xA9, 0xAB, 0x45, 0xF9}}
IVideoProcessorEnumerator :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videoprocessorenumerator_vtable: ^IVideoProcessorEnumerator_VTable,
}
IVideoProcessorEnumerator_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetVideoProcessorContentDesc:        proc "stdcall" (this: ^IVideoProcessorEnumerator, pContentDesc: ^VIDEO_PROCESSOR_CONTENT_DESC) -> HRESULT,
	CheckVideoProcessorFormat:           proc "stdcall" (this: ^IVideoProcessorEnumerator, Format: dxgi.FORMAT, pFlags: ^u32) -> HRESULT,
	GetVideoProcessorCaps:               proc "stdcall" (this: ^IVideoProcessorEnumerator, pCaps: ^VIDEO_PROCESSOR_CAPS) -> HRESULT,
	GetVideoProcessorRateConversionCaps: proc "stdcall" (this: ^IVideoProcessorEnumerator, TypeIndex: u32, pCaps: ^VIDEO_PROCESSOR_RATE_CONVERSION_CAPS) -> HRESULT,
	GetVideoProcessorCustomRate:         proc "stdcall" (this: ^IVideoProcessorEnumerator, TypeIndex: u32, CustomRateIndex: u32, pRate: ^VIDEO_PROCESSOR_CUSTOM_RATE) -> HRESULT,
	GetVideoProcessorFilterRange:        proc "stdcall" (this: ^IVideoProcessorEnumerator, Filter: VIDEO_PROCESSOR_FILTER, pRange: ^VIDEO_PROCESSOR_FILTER_RANGE) -> HRESULT,
}


VIDEO_COLOR_RGBA :: struct {
	R: f32,
	G: f32,
	B: f32,
	A: f32,
}

VIDEO_COLOR_YCbCrA :: struct {
	Y:  f32,
	Cb: f32,
	Cr: f32,
	A:  f32,
}

VIDEO_COLOR :: struct {
	using _: struct #raw_union {
		YCbCr: VIDEO_COLOR_YCbCrA,
		RGBA:  VIDEO_COLOR_RGBA,
	},
}

VIDEO_PROCESSOR_NOMINAL_RANGE :: enum i32 {
	UNDEFINED = 0,
	_16_235   = 1,
	_0_255    = 2,
}

VIDEO_PROCESSOR_COLOR_SPACE_FLAG :: enum u32 {
	Usage          = 0,
	RGB_Range      = 1,
	YCbCr_Matrix   = 2,
	YCbCr_xvYCC    = 3,
	Nominal_Range  = 4,
	Reserved       = 6,
}

VIDEO_PROCESSOR_COLOR_SPACE :: distinct bit_set[VIDEO_PROCESSOR_COLOR_SPACE_FLAG; u32]

VIDEO_PROCESSOR_ALPHA_FILL_MODE :: enum i32 {
	OPAQUE        = 0,
	BACKGROUND    = 1,
	DESTINATION   = 2,
	SOURCE_STREAM = 3,
}

VIDEO_PROCESSOR_OUTPUT_RATE :: enum i32 {
	NORMAL = 0,
	HALF   = 1,
	CUSTOM = 2,
}

VIDEO_PROCESSOR_STEREO_FORMAT :: enum i32 {
	MONO               = 0,
	HORIZONTAL         = 1,
	VERTICAL           = 2,
	SEPARATE           = 3,
	MONO_OFFSET        = 4,
	ROW_INTERLEAVED    = 5,
	COLUMN_INTERLEAVED = 6,
	CHECKERBOARD       = 7,
}

VIDEO_PROCESSOR_STEREO_FLIP_MODE :: enum i32 {
	NONE   = 0,
	FRAME0 = 1,
	FRAME1 = 2,
}

VIDEO_PROCESSOR_ROTATION :: enum i32 {
	IDENTITY = 0,
	_90      = 1,
	_180     = 2,
	_270     = 3,
}

VIDEO_PROCESSOR_STREAM :: struct {
	Enable:                BOOL,
	OutputIndex:           u32,
	InputFrameOrField:     u32,
	PastFrames:            u32,
	FutureFrames:          u32,

	ppPastSurfaces:        ^^IVideoProcessorInputView,
	pInputSurface:         ^IVideoProcessorInputView,

	ppFutureSurfaces:      ^^IVideoProcessorInputView,

	ppPastSurfacesRight:   ^^IVideoProcessorInputView,
	pInputSurfaceRight:    ^IVideoProcessorInputView,

	ppFutureSurfacesRight: ^^IVideoProcessorInputView,
}


IVideoProcessor_UUID_STRING :: "1D7B0652-185F-41C6-85CE-0C5BE3D4AE6C"
IVideoProcessor_UUID := &IID{0x1D7B0652, 0x185F, 0x41C6, {0x85, 0xCE, 0x0C, 0x5B, 0xE3, 0xD4, 0xAE, 0x6C}}
IVideoProcessor :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videoprocessor_vtable: ^IVideoProcessor_VTable,
}
IVideoProcessor_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetContentDesc:        proc "stdcall" (this: ^IVideoProcessor, pDesc: ^VIDEO_PROCESSOR_CONTENT_DESC),
	GetRateConversionCaps: proc "stdcall" (this: ^IVideoProcessor, pCaps: ^VIDEO_PROCESSOR_RATE_CONVERSION_CAPS),
}


OMAC :: struct {
	Omac: [16]u8,
}

AUTHENTICATED_CHANNEL_TYPE :: enum i32 {
	D3D11           = 1,
	DRIVER_SOFTWARE = 2,
	DRIVER_HARDWARE = 3,
}


IAuthenticatedChannel_UUID_STRING :: "3015A308-DCBD-47AA-A747-192486D14D4A"
IAuthenticatedChannel_UUID := &IID{0x3015A308, 0xDCBD, 0x47AA, {0xA7, 0x47, 0x19, 0x24, 0x86, 0xD1, 0x4D, 0x4A}}
IAuthenticatedChannel :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11authenticatedchannel_vtable: ^IAuthenticatedChannel_VTable,
}
IAuthenticatedChannel_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetCertificateSize: proc "stdcall" (this: ^IAuthenticatedChannel, pCertificateSize: ^u32) -> HRESULT,
	GetCertificate:     proc "stdcall" (this: ^IAuthenticatedChannel, CertificateSize: u32, pCertificate: cstring) -> HRESULT,
	GetChannelHandle:   proc "stdcall" (this: ^IAuthenticatedChannel, pChannelHandle: ^HANDLE),
}


AUTHENTICATED_QUERY_INPUT :: struct {
	QueryType:      GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
}

AUTHENTICATED_QUERY_OUTPUT :: struct {
	omac:           OMAC,
	QueryType:      GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
	ReturnCode:     HRESULT,
}

AUTHENTICATED_PROTECTION_FLAG :: enum u32 {
	ProtectionEnabled           = 0,
	OverlayOrFullscreenRequired = 1,
	Reserved                    = 2,
}
AUTHENTICATED_PROTECTION_FLAGS :: distinct bit_set[AUTHENTICATED_PROTECTION_FLAG; u32]

AUTHENTICATED_QUERY_PROTECTION_OUTPUT :: struct {
	Output:          AUTHENTICATED_QUERY_OUTPUT,
	ProtectionFlags: AUTHENTICATED_PROTECTION_FLAGS,
}

AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT :: struct {
	Output:      AUTHENTICATED_QUERY_OUTPUT,
	ChannelType: AUTHENTICATED_CHANNEL_TYPE,
}

AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT :: struct {
	Output:       AUTHENTICATED_QUERY_OUTPUT,
	DeviceHandle: HANDLE,
}

AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT :: struct {
	Input:         AUTHENTICATED_QUERY_INPUT,
	DecoderHandle: HANDLE,
}

AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	DecoderHandle:       HANDLE,
	CryptoSessionHandle: HANDLE,
	DeviceHandle:        HANDLE,
}

AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT :: struct {
	Output:                               AUTHENTICATED_QUERY_OUTPUT,
	RestrictedSharedResourceProcessCount: u32,
}

AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT :: struct {
	Input:        AUTHENTICATED_QUERY_INPUT,
	ProcessIndex: u32,
}

AUTHENTICATED_PROCESS_IDENTIFIER_TYPE :: enum i32 {
	UNKNOWN = 0,
	DWM     = 1,
	HANDLE  = 2,
}

AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT :: struct {
	Output:            AUTHENTICATED_QUERY_OUTPUT,
	ProcessIndex:      u32,
	ProcessIdentifier: AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
	ProcessHandle:     HANDLE,
}

AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT :: struct {
	Output:                                   AUTHENTICATED_QUERY_OUTPUT,
	UnrestrictedProtectedSharedResourceCount: u32,
}

AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT :: struct {
	Input:               AUTHENTICATED_QUERY_INPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
}

AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
	OutputIDCount:       u32,
}

AUTHENTICATED_QUERY_OUTPUT_ID_INPUT :: struct {
	Input:               AUTHENTICATED_QUERY_INPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
	OutputIDIndex:       u32,
}

AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
	OutputIDIndex:       u32,
	OutputID:            u64,
}

BUS_TYPE :: enum i32 {
	OTHER                                  = 0,
	PCI                                    = 1,
	PCIX                                   = 2,
	PCIEXPRESS                             = 3,
	AGP                                    = 4,
	NSIDE_OF_CHIPSET                       = 65536,
	RACKS_ON_MOTHER_BOARD_TO_CHIP          = 131072,
	RACKS_ON_MOTHER_BOARD_TO_SOCKET        = 196608,
	AUGHTER_BOARD_CONNECTOR                = 262144,
	AUGHTER_BOARD_CONNECTOR_INSIDE_OF_NUAE = 327680,
	ON_STANDARD                            = -2147483648,
}

AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT :: struct {
	Output:                          AUTHENTICATED_QUERY_OUTPUT,
	BusType:                         BUS_TYPE,
	AccessibleInContiguousBlocks:    BOOL,
	AccessibleInNonContiguousBlocks: BOOL,
}

AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT :: AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT

AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	EncryptionGuidCount: u32,
}

AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT :: struct {
	Input:               AUTHENTICATED_QUERY_INPUT,
	EncryptionGuidIndex: u32,
}

AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	EncryptionGuidIndex: u32,
	EncryptionGuid:      GUID,
}

AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT :: struct {
	Output:         AUTHENTICATED_QUERY_OUTPUT,
	EncryptionGuid: GUID,
}

AUTHENTICATED_CONFIGURE_INPUT :: struct {
	omac:           OMAC,
	ConfigureType:  GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
}

AUTHENTICATED_CONFIGURE_OUTPUT :: struct {
	omac:           OMAC,
	ConfigureType:  GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
	ReturnCode:     HRESULT,
}

AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT :: struct {
	Parameters:             AUTHENTICATED_CONFIGURE_INPUT,
	StartSequenceQuery:     u32,
	StartSequenceConfigure: u32,
}

AUTHENTICATED_CONFIGURE_PROTECTION_INPUT :: struct {
	Parameters:  AUTHENTICATED_CONFIGURE_INPUT,
	Protections: AUTHENTICATED_PROTECTION_FLAGS,
}

AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT :: struct {
	Parameters:          AUTHENTICATED_CONFIGURE_INPUT,
	DecoderHandle:       HANDLE,
	CryptoSessionHandle: HANDLE,
	DeviceHandle:        HANDLE,
}

AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT :: struct {
	Parameters:    AUTHENTICATED_CONFIGURE_INPUT,
	ProcessType:   AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
	ProcessHandle: HANDLE,
	AllowAccess:   BOOL,
}

AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT :: struct {
	Parameters:     AUTHENTICATED_CONFIGURE_INPUT,
	EncryptionGuid: GUID,
}



ICryptoSession_UUID_STRING :: "9B32F9AD-BDCC-40A6-A39D-D5C865845720"
ICryptoSession_UUID := &IID{0x9B32F9AD, 0xBDCC, 0x40A6, {0xA3, 0x9D, 0xD5, 0xC8, 0x65, 0x84, 0x57, 0x20}}
ICryptoSession :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11cryptosession_vtable: ^ICryptoSession_VTable,
}
ICryptoSession_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetCryptoType:          proc "stdcall" (this: ^ICryptoSession, pCryptoType: ^GUID),
	GetDecoderProfile:      proc "stdcall" (this: ^ICryptoSession, pDecoderProfile: ^GUID),
	GetCertificateSize:     proc "stdcall" (this: ^ICryptoSession, pCertificateSize: ^u32) -> HRESULT,
	GetCertificate:         proc "stdcall" (this: ^ICryptoSession, CertificateSize: u32, pCertificate: cstring) -> HRESULT,
	GetCryptoSessionHandle: proc "stdcall" (this: ^ICryptoSession, pCryptoSessionHandle: ^HANDLE),
}


VDOV_DIMENSION :: enum i32 {
	UNKNOWN   = 0,
	TEXTURE2D = 1,
}

TEX2D_VDOV :: struct {
	ArraySlice: u32,
}

VIDEO_DECODER_OUTPUT_VIEW_DESC :: struct {
	DecodeProfile: GUID,
	ViewDimension: VDOV_DIMENSION,
	using _: struct #raw_union {
		Texture2D: TEX2D_VDOV,
	},
}


IVideoDecoderOutputView_UUID_STRING :: "C2931AEA-2A85-4F20-860F-FBA1FD256E18"
IVideoDecoderOutputView_UUID := &IID{0xC2931AEA, 0x2A85, 0x4F20, {0x86, 0x0F, 0xFB, 0xA1, 0xFD, 0x25, 0x6E, 0x18}}
IVideoDecoderOutputView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11videodecoderoutputview_vtable: ^IVideoDecoderOutputView_VTable,
}
IVideoDecoderOutputView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "stdcall" (this: ^IVideoDecoderOutputView, pDesc: ^VIDEO_DECODER_OUTPUT_VIEW_DESC),
}


VPIV_DIMENSION :: enum i32 {
	UNKNOWN   = 0,
	TEXTURE2D = 1,
}

TEX2D_VPIV :: struct {
	MipSlice:   u32,
	ArraySlice: u32,
}

VIDEO_PROCESSOR_INPUT_VIEW_DESC :: struct {
	FourCC:        u32,
	ViewDimension: VPIV_DIMENSION,
	using _: struct #raw_union {
		Texture2D: TEX2D_VPIV,
	},
}


IVideoProcessorInputView_UUID_STRING :: "11EC5A5F-51DC-4945-AB34-6E8C21300EA5"
IVideoProcessorInputView_UUID := &IID{0x11EC5A5F, 0x51DC, 0x4945, {0xAB, 0x34, 0x6E, 0x8C, 0x21, 0x30, 0x0E, 0xA5}}
IVideoProcessorInputView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11videoprocessorinputview_vtable: ^IVideoProcessorInputView_VTable,
}
IVideoProcessorInputView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "stdcall" (this: ^IVideoProcessorInputView, pDesc: ^VIDEO_PROCESSOR_INPUT_VIEW_DESC),
}


VPOV_DIMENSION :: enum i32 {
	UNKNOWN        = 0,
	TEXTURE2D      = 1,
	TEXTURE2DARRAY = 2,
}

TEX2D_VPOV :: struct {
	MipSlice: u32,
}

TEX2D_ARRAY_VPOV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

VIDEO_PROCESSOR_OUTPUT_VIEW_DESC :: struct {
	ViewDimension: VPOV_DIMENSION,
	using _: struct #raw_union {
		Texture2D:      TEX2D_VPOV,
		Texture2DArray: TEX2D_ARRAY_VPOV,
	},
}


IVideoProcessorOutputView_UUID_STRING :: "A048285E-25A9-4527-BD93-D68B68C44254"
IVideoProcessorOutputView_UUID := &IID{0xA048285E, 0x25A9, 0x4527, {0xBD, 0x93, 0xD6, 0x8B, 0x68, 0xC4, 0x42, 0x54}}
IVideoProcessorOutputView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11videoprocessoroutputview_vtable: ^IVideoProcessorOutputView_VTable,
}
IVideoProcessorOutputView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "stdcall" (this: ^IVideoProcessorOutputView, pDesc: ^VIDEO_PROCESSOR_OUTPUT_VIEW_DESC),
}



IVideoContext_UUID_STRING :: "61F21C45-3C0E-4A74-9CEA-67100D9AD5E4"
IVideoContext_UUID := &IID{0x61F21C45, 0x3C0E, 0x4A74, {0x9C, 0xEA, 0x67, 0x10, 0x0D, 0x9A, 0xD5, 0xE4}}
IVideoContext :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videocontext_vtable: ^IVideoContext_VTable,
}
IVideoContext_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDecoderBuffer:                          proc "stdcall" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, Type: VIDEO_DECODER_BUFFER_TYPE, pBufferSize: ^u32, ppBuffer: ^rawptr) -> HRESULT,
	ReleaseDecoderBuffer:                      proc "stdcall" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, Type: VIDEO_DECODER_BUFFER_TYPE) -> HRESULT,
	DecoderBeginFrame:                         proc "stdcall" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, pView: ^IVideoDecoderOutputView, ContentKeySize: u32, pContentKey: rawptr) -> HRESULT,
	DecoderEndFrame:                           proc "stdcall" (this: ^IVideoContext, pDecoder: ^IVideoDecoder) -> HRESULT,
	SubmitDecoderBuffers:                      proc "stdcall" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, NumBuffers: u32, pBufferDesc: ^VIDEO_DECODER_BUFFER_DESC) -> HRESULT,
	DecoderExtension:                          proc "stdcall" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, pExtensionData: ^VIDEO_DECODER_EXTENSION) -> APP_DEPRECATED_HRESULT,
	VideoProcessorSetOutputTargetRect:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enable: BOOL, pRect: ^RECT),
	VideoProcessorSetOutputBackgroundColor:    proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, YCbCr: BOOL, pColor: ^VIDEO_COLOR),
	VideoProcessorSetOutputColorSpace:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorSetOutputAlphaFillMode:      proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, AlphaFillMode: VIDEO_PROCESSOR_ALPHA_FILL_MODE, StreamIndex: u32),
	VideoProcessorSetOutputConstriction:       proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enable: BOOL, Size: SIZE),
	VideoProcessorSetOutputStereoMode:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enable: BOOL),
	VideoProcessorSetOutputExtension:          proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorGetOutputTargetRect:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enabled: ^BOOL, pRect: ^RECT),
	VideoProcessorGetOutputBackgroundColor:    proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pYCbCr: ^BOOL, pColor: ^VIDEO_COLOR),
	VideoProcessorGetOutputColorSpace:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorGetOutputAlphaFillMode:      proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pAlphaFillMode: ^VIDEO_PROCESSOR_ALPHA_FILL_MODE, pStreamIndex: ^u32),
	VideoProcessorGetOutputConstriction:       proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pEnabled: ^BOOL, pSize: ^SIZE),
	VideoProcessorGetOutputStereoMode:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pEnabled: ^BOOL),
	VideoProcessorGetOutputExtension:          proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorSetStreamFrameFormat:        proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, FrameFormat: VIDEO_FRAME_FORMAT),
	VideoProcessorSetStreamColorSpace:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorSetStreamOutputRate:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, OutputRate: VIDEO_PROCESSOR_OUTPUT_RATE, RepeatFrame: BOOL, pCustomRate: ^dxgi.RATIONAL),
	VideoProcessorSetStreamSourceRect:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, pRect: ^RECT),
	VideoProcessorSetStreamDestRect:           proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, pRect: ^RECT),
	VideoProcessorSetStreamAlpha:              proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Alpha: f32),
	VideoProcessorSetStreamPalette:            proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Count: u32, pEntries: ^u32),
	VideoProcessorSetStreamPixelAspectRatio:   proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, pSourceAspectRatio: ^dxgi.RATIONAL, pDestinationAspectRatio: ^dxgi.RATIONAL),
	VideoProcessorSetStreamLumaKey:            proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Lower: f32, Upper: f32),
	VideoProcessorSetStreamStereoFormat:       proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Format: VIDEO_PROCESSOR_STEREO_FORMAT, LeftViewFrame0: BOOL, BaseViewFrame0: BOOL, FlipMode: VIDEO_PROCESSOR_STEREO_FLIP_MODE, MonoOffset: i32),
	VideoProcessorSetStreamAutoProcessingMode: proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL),
	VideoProcessorSetStreamFilter:             proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Filter: VIDEO_PROCESSOR_FILTER, Enable: BOOL, Level: i32),
	VideoProcessorSetStreamExtension:          proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorGetStreamFrameFormat:        proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pFrameFormat: ^VIDEO_FRAME_FORMAT),
	VideoProcessorGetStreamColorSpace:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorGetStreamOutputRate:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pOutputRate: ^VIDEO_PROCESSOR_OUTPUT_RATE, pRepeatFrame: ^BOOL, pCustomRate: ^dxgi.RATIONAL),
	VideoProcessorGetStreamSourceRect:         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pRect: ^RECT),
	VideoProcessorGetStreamDestRect:           proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pRect: ^RECT),
	VideoProcessorGetStreamAlpha:              proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pAlpha: ^f32),
	VideoProcessorGetStreamPalette:            proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Count: u32, pEntries: ^u32),
	VideoProcessorGetStreamPixelAspectRatio:   proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pSourceAspectRatio: ^dxgi.RATIONAL, pDestinationAspectRatio: ^dxgi.RATIONAL),
	VideoProcessorGetStreamLumaKey:            proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pLower: ^f32, pUpper: ^f32),
	VideoProcessorGetStreamStereoFormat:       proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnable: ^BOOL, pFormat: ^VIDEO_PROCESSOR_STEREO_FORMAT, pLeftViewFrame0: ^BOOL, pBaseViewFrame0: ^BOOL, pFlipMode: ^VIDEO_PROCESSOR_STEREO_FLIP_MODE, MonoOffset: ^i32),
	VideoProcessorGetStreamAutoProcessingMode: proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL),
	VideoProcessorGetStreamFilter:             proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Filter: VIDEO_PROCESSOR_FILTER, pEnabled: ^BOOL, pLevel: ^i32),
	VideoProcessorGetStreamExtension:          proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorBlt:                         proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pView: ^IVideoProcessorOutputView, OutputFrame: u32, StreamCount: u32, pStreams: ^VIDEO_PROCESSOR_STREAM) -> HRESULT,
	NegotiateCryptoSessionKeyExchange:         proc "stdcall" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, DataSize: u32, pData: rawptr) -> HRESULT,
	EncryptionBlt:                             proc "stdcall" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, pSrcSurface: ^ITexture2D, pDstSurface: ^ITexture2D, IVSize: u32, pIV: rawptr),
	DecryptionBlt:                             proc "stdcall" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, pSrcSurface: ^ITexture2D, pDstSurface: ^ITexture2D, pEncryptedBlockInfo: ^ENCRYPTED_BLOCK_INFO, ContentKeySize: u32, pContentKey: rawptr, IVSize: u32, pIV: rawptr),
	StartSessionKeyRefresh:                    proc "stdcall" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, RandomNumberSize: u32, pRandomNumber: rawptr),
	FinishSessionKeyRefresh:                   proc "stdcall" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession),
	GetEncryptionBltKey:                       proc "stdcall" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, KeySize: u32, pReadbackKey: rawptr) -> HRESULT,
	NegotiateAuthenticatedChannelKeyExchange:  proc "stdcall" (this: ^IVideoContext, pChannel: ^IAuthenticatedChannel, DataSize: u32, pData: rawptr) -> HRESULT,
	QueryAuthenticatedChannel:                 proc "stdcall" (this: ^IVideoContext, pChannel: ^IAuthenticatedChannel, InputSize: u32, pInput: rawptr, OutputSize: u32, pOutput: rawptr) -> HRESULT,
	ConfigureAuthenticatedChannel:             proc "stdcall" (this: ^IVideoContext, pChannel: ^IAuthenticatedChannel, InputSize: u32, pInput: rawptr, pOutput: ^AUTHENTICATED_CONFIGURE_OUTPUT) -> HRESULT,
	VideoProcessorSetStreamRotation:           proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Rotation: VIDEO_PROCESSOR_ROTATION),
	VideoProcessorGetStreamRotation:           proc "stdcall" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnable: ^BOOL, pRotation: ^VIDEO_PROCESSOR_ROTATION),
}



IVideoDevice_UUID_STRING :: "10EC4D5B-975A-4689-B9E4-D0AAC30FE333"
IVideoDevice_UUID := &IID{0x10EC4D5B, 0x975A, 0x4689, {0xB9, 0xE4, 0xD0, 0xAA, 0xC3, 0x0F, 0xE3, 0x33}}
IVideoDevice :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11videodevice_vtable: ^IVideoDevice_VTable,
}
IVideoDevice_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	CreateVideoDecoder:             proc "stdcall" (this: ^IVideoDevice, pVideoDesc: ^VIDEO_DECODER_DESC, pConfig: ^VIDEO_DECODER_CONFIG, ppDecoder: ^^IVideoDecoder) -> HRESULT,
	CreateVideoProcessor:           proc "stdcall" (this: ^IVideoDevice, pEnum: ^IVideoProcessorEnumerator, RateConversionIndex: u32, ppVideoProcessor: ^^IVideoProcessor) -> HRESULT,
	CreateAuthenticatedChannel:     proc "stdcall" (this: ^IVideoDevice, ChannelType: AUTHENTICATED_CHANNEL_TYPE, ppAuthenticatedChannel: ^^IAuthenticatedChannel) -> HRESULT,
	CreateCryptoSession:            proc "stdcall" (this: ^IVideoDevice, pCryptoType: ^GUID, pDecoderProfile: ^GUID, pKeyExchangeType: ^GUID, ppCryptoSession: ^^ICryptoSession) -> HRESULT,
	CreateVideoDecoderOutputView:   proc "stdcall" (this: ^IVideoDevice, pResource: ^IResource, pDesc: ^VIDEO_DECODER_OUTPUT_VIEW_DESC, ppVDOVView: ^^IVideoDecoderOutputView) -> HRESULT,
	CreateVideoProcessorInputView:  proc "stdcall" (this: ^IVideoDevice, pResource: ^IResource, pEnum: ^IVideoProcessorEnumerator, pDesc: ^VIDEO_PROCESSOR_INPUT_VIEW_DESC, ppVPIView: ^^IVideoProcessorInputView) -> HRESULT,
	CreateVideoProcessorOutputView: proc "stdcall" (this: ^IVideoDevice, pResource: ^IResource, pEnum: ^IVideoProcessorEnumerator, pDesc: ^VIDEO_PROCESSOR_OUTPUT_VIEW_DESC, ppVPOView: ^^IVideoProcessorOutputView) -> HRESULT,
	CreateVideoProcessorEnumerator: proc "stdcall" (this: ^IVideoDevice, pDesc: ^VIDEO_PROCESSOR_CONTENT_DESC, ppEnum: ^^IVideoProcessorEnumerator) -> HRESULT,
	GetVideoDecoderProfileCount:    proc "stdcall" (this: ^IVideoDevice) -> u32,
	GetVideoDecoderProfile:         proc "stdcall" (this: ^IVideoDevice, Index: u32, pDecoderProfile: ^GUID) -> HRESULT,
	CheckVideoDecoderFormat:        proc "stdcall" (this: ^IVideoDevice, pDecoderProfile: ^GUID, Format: dxgi.FORMAT, pSupported: ^BOOL) -> HRESULT,
	GetVideoDecoderConfigCount:     proc "stdcall" (this: ^IVideoDevice, pDesc: ^VIDEO_DECODER_DESC, pCount: ^u32) -> HRESULT,
	GetVideoDecoderConfig:          proc "stdcall" (this: ^IVideoDevice, pDesc: ^VIDEO_DECODER_DESC, Index: u32, pConfig: ^VIDEO_DECODER_CONFIG) -> HRESULT,
	GetContentProtectionCaps:       proc "stdcall" (this: ^IVideoDevice, pCryptoType: ^GUID, pDecoderProfile: ^GUID, pCaps: ^VIDEO_CONTENT_PROTECTION_CAPS) -> HRESULT,
	CheckCryptoKeyExchange:         proc "stdcall" (this: ^IVideoDevice, pCryptoType: ^GUID, pDecoderProfile: ^GUID, Index: u32, pKeyExchangeType: ^GUID) -> HRESULT,
	SetPrivateData:                 proc "stdcall" (this: ^IVideoDevice, guid: ^GUID, DataSize: u32, pData: rawptr) -> HRESULT,
	SetPrivateDataInterface:        proc "stdcall" (this: ^IVideoDevice, guid: ^GUID, pData: ^IUnknown) -> HRESULT,
}



IDevice_UUID_STRING :: "DB6F6DDB-AC77-4E88-8253-819DF9BBF140"
IDevice_UUID := &IID{0xDB6F6DDB, 0xAC77, 0x4E88, {0x82, 0x53, 0x81, 0x9D, 0xF9, 0xBB, 0xF1, 0x40}}
IDevice :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11device_vtable: ^IDevice_VTable,
}
IDevice_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	CreateBuffer:                         proc "stdcall" (this: ^IDevice, pDesc: ^BUFFER_DESC, pInitialData: ^SUBRESOURCE_DATA, ppBuffer: ^^IBuffer) -> HRESULT,
	CreateTexture1D:                      proc "stdcall" (this: ^IDevice, pDesc: ^TEXTURE1D_DESC, pInitialData: ^SUBRESOURCE_DATA, ppTexture1D: ^^ITexture1D) -> HRESULT,
	CreateTexture2D:                      proc "stdcall" (this: ^IDevice, pDesc: ^TEXTURE2D_DESC, pInitialData: ^SUBRESOURCE_DATA, ppTexture2D: ^^ITexture2D) -> HRESULT,
	CreateTexture3D:                      proc "stdcall" (this: ^IDevice, pDesc: ^TEXTURE3D_DESC, pInitialData: ^SUBRESOURCE_DATA, ppTexture3D: ^^ITexture3D) -> HRESULT,
	CreateShaderResourceView:             proc "stdcall" (this: ^IDevice, pResource: ^IResource, pDesc: ^SHADER_RESOURCE_VIEW_DESC, ppSRView: ^^IShaderResourceView) -> HRESULT,
	CreateUnorderedAccessView:            proc "stdcall" (this: ^IDevice, pResource: ^IResource, pDesc: ^UNORDERED_ACCESS_VIEW_DESC, ppUAView: ^^IUnorderedAccessView) -> HRESULT,
	CreateRenderTargetView:               proc "stdcall" (this: ^IDevice, pResource: ^IResource, pDesc: ^RENDER_TARGET_VIEW_DESC, ppRTView: ^^IRenderTargetView) -> HRESULT,
	CreateDepthStencilView:               proc "stdcall" (this: ^IDevice, pResource: ^IResource, pDesc: ^DEPTH_STENCIL_VIEW_DESC, ppDepthStencilView: ^^IDepthStencilView) -> HRESULT,
	CreateInputLayout:                    proc "stdcall" (this: ^IDevice, pInputElementDescs: ^INPUT_ELEMENT_DESC, NumElements: u32, pShaderBytecodeWithInputSignature: rawptr, BytecodeLength: SIZE_T, ppInputLayout: ^^IInputLayout) -> HRESULT,
	CreateVertexShader:                   proc "stdcall" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppVertexShader: ^^IVertexShader) -> HRESULT,
	CreateGeometryShader:                 proc "stdcall" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppGeometryShader: ^^IGeometryShader) -> HRESULT,
	CreateGeometryShaderWithStreamOutput: proc "stdcall" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pSODeclaration: ^SO_DECLARATION_ENTRY, NumEntries: u32, pBufferStrides: ^u32, NumStrides: u32, RasterizedStream: u32, pClassLinkage: ^IClassLinkage, ppGeometryShader: ^^IGeometryShader) -> HRESULT,
	CreatePixelShader:                    proc "stdcall" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppPixelShader: ^^IPixelShader) -> HRESULT,
	CreateHullShader:                     proc "stdcall" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppHullShader: ^^IHullShader) -> HRESULT,
	CreateDomainShader:                   proc "stdcall" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppDomainShader: ^^IDomainShader) -> HRESULT,
	CreateComputeShader:                  proc "stdcall" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppComputeShader: ^^IComputeShader) -> HRESULT,
	CreateClassLinkage:                   proc "stdcall" (this: ^IDevice, ppLinkage: ^^IClassLinkage) -> HRESULT,
	CreateBlendState:                     proc "stdcall" (this: ^IDevice, pBlendStateDesc: ^BLEND_DESC, ppBlendState: ^^IBlendState) -> HRESULT,
	CreateDepthStencilState:              proc "stdcall" (this: ^IDevice, pDepthStencilDesc: ^DEPTH_STENCIL_DESC, ppDepthStencilState: ^^IDepthStencilState) -> HRESULT,
	CreateRasterizerState:                proc "stdcall" (this: ^IDevice, pRasterizerDesc: ^RASTERIZER_DESC, ppRasterizerState: ^^IRasterizerState) -> HRESULT,
	CreateSamplerState:                   proc "stdcall" (this: ^IDevice, pSamplerDesc: ^SAMPLER_DESC, ppSamplerState: ^^ISamplerState) -> HRESULT,
	CreateQuery:                          proc "stdcall" (this: ^IDevice, pQueryDesc: ^QUERY_DESC, ppQuery: ^^IQuery) -> HRESULT,
	CreatePredicate:                      proc "stdcall" (this: ^IDevice, pPredicateDesc: ^QUERY_DESC, ppPredicate: ^^IPredicate) -> HRESULT,
	CreateCounter:                        proc "stdcall" (this: ^IDevice, pCounterDesc: ^COUNTER_DESC, ppCounter: ^^ICounter) -> HRESULT,
	CreateDeferredContext:                proc "stdcall" (this: ^IDevice, ContextFlags: u32, ppDeferredContext: ^^IDeviceContext) -> HRESULT,
	OpenSharedResource:                   proc "stdcall" (this: ^IDevice, hResource: HANDLE, ReturnedInterface: ^IID, ppResource: ^rawptr) -> HRESULT,
	CheckFormatSupport:                   proc "stdcall" (this: ^IDevice, Format: dxgi.FORMAT, pFormatSupport: ^u32) -> HRESULT,
	CheckMultisampleQualityLevels:        proc "stdcall" (this: ^IDevice, Format: dxgi.FORMAT, SampleCount: u32, pNumQualityLevels: ^u32) -> HRESULT,
	CheckCounterInfo:                     proc "stdcall" (this: ^IDevice, pCounterInfo: ^COUNTER_INFO),
	CheckCounter:                         proc "stdcall" (this: ^IDevice, pDesc: ^COUNTER_DESC, pType: ^COUNTER_TYPE, pActiveCounters: ^u32, szName: cstring, pNameLength: ^u32, szUnits: ^u8, pUnitsLength: ^u32, szDescription: cstring, pDescriptionLength: ^u32) -> HRESULT,
	CheckFeatureSupport:                  proc "stdcall" (this: ^IDevice, Feature: FEATURE, pFeatureSupportData: rawptr, FeatureSupportDataSize: u32) -> HRESULT,
	GetPrivateData:                       proc "stdcall" (this: ^IDevice, guid: ^GUID, pDataSize: ^u32, pData: rawptr) -> HRESULT,
	SetPrivateData:                       proc "stdcall" (this: ^IDevice, guid: ^GUID, DataSize: u32, pData: rawptr) -> HRESULT,
	SetPrivateDataInterface:              proc "stdcall" (this: ^IDevice, guid: ^GUID, pData: ^IUnknown) -> HRESULT,
	GetFeatureLevel:                      proc "stdcall" (this: ^IDevice) -> FEATURE_LEVEL,
	GetCreationFlags:                     proc "stdcall" (this: ^IDevice) -> u32,
	GetDeviceRemovedReason:               proc "stdcall" (this: ^IDevice) -> HRESULT,
	GetImmediateContext:                  proc "stdcall" (this: ^IDevice, ppImmediateContext: ^^IDeviceContext),
	SetExceptionMode:                     proc "stdcall" (this: ^IDevice, RaiseFlags: u32) -> HRESULT,
	GetExceptionMode:                     proc "stdcall" (this: ^IDevice) -> u32,
}


CREATE_DEVICE_FLAGS :: distinct bit_set[CREATE_DEVICE_FLAG; u32]
CREATE_DEVICE_FLAG :: enum u32 { // TODO: make bit_set
	SINGLETHREADED                                = 0,
	DEBUG                                         = 1,
	SWITCH_TO_REF                                 = 2,
	PREVENT_INTERNAL_THREADING_OPTIMIZATIONS      = 3,
	BGRA_SUPPORT                                  = 5,
	DEBUGGABLE                                    = 6,
	PREVENT_ALTERING_LAYER_SETTINGS_FROM_REGISTRY = 7,
	DISABLE_GPU_TIMEOUT                           = 8,
	VIDEO_SUPPORT                                 = 12,
}

PFN_CREATE_DEVICE :: #type proc "c" (a0: ^dxgi.IAdapter, a1: DRIVER_TYPE, a2: HMODULE, a3: u32, a4: ^FEATURE_LEVEL, a5: u32, a6: u32, a7: ^^IDevice, a8: ^FEATURE_LEVEL, a9: ^^IDeviceContext) -> HRESULT
PFN_CREATE_DEVICE_AND_SWAP_CHAIN :: #type proc "c" (a0: ^dxgi.IAdapter, a1: DRIVER_TYPE, a2: HMODULE, a3: u32, a4: ^FEATURE_LEVEL, a5: u32, a6: u32, a7: ^dxgi.SWAP_CHAIN_DESC, a8: ^^dxgi.ISwapChain, a9: ^^IDevice, a10: ^FEATURE_LEVEL, a11: ^^IDeviceContext) -> HRESULT

SHADER_VERSION_TYPE :: enum i32 {
	PIXEL_SHADER    = 0,
	VERTEX_SHADER   = 1,
	GEOMETRY_SHADER = 2,

	HULL_SHADER     = 3,
	DOMAIN_SHADER   = 4,
	COMPUTE_SHADER  = 5,

	RESERVED0       = 65520,
}

SIGNATURE_PARAMETER_DESC :: struct {
	SemanticName:    cstring,
	SemanticIndex:   u32,
	Register:        u32,
	SystemValueType: NAME,
	ComponentType:   REGISTER_COMPONENT_TYPE,
	Mask:            u8,

	ReadWriteMask:   u8,

	Stream:          u32,
	MinPrecision:    MIN_PRECISION,
}

SHADER_BUFFER_DESC :: struct {
	Name:      cstring,
	Type:      CBUFFER_TYPE,
	Variables: u32,
	Size:      u32,
	uFlags:    u32,
}

SHADER_VARIABLE_DESC :: struct {
	Name:         cstring,
	StartOffset:  u32,
	Size:         u32,
	uFlags:       u32,
	DefaultValue: rawptr,
	StartTexture: u32,
	TextureSize:  u32,
	StartSampler: u32,
	SamplerSize:  u32,
}

SHADER_TYPE_DESC :: struct {
	Class:    SHADER_VARIABLE_CLASS,
	Type:     SHADER_VARIABLE_TYPE,
	Rows:     u32,
	Columns:  u32,
	Elements: u32,
	Members:  u32,
	Offset:   u32,
	Name:     cstring,
}

SHADER_DESC :: struct {
	Version:                     u32,
	Creator:                     cstring,
	Flags:                       u32,

	ConstantBuffers:             u32,
	BoundResources:              u32,
	InputParameters:             u32,
	OutputParameters:            u32,

	InstructionCount:            u32,
	TempRegisterCount:           u32,
	TempArrayCount:              u32,
	DefCount:                    u32,
	DclCount:                    u32,
	TextureNormalInstructions:   u32,
	TextureLoadInstructions:     u32,
	TextureCompInstructions:     u32,
	TextureBiasInstructions:     u32,
	TextureGradientInstructions: u32,
	FloatInstructionCount:       u32,
	IntInstructionCount:         u32,
	UintInstructionCount:        u32,
	StaticFlowControlCount:      u32,
	DynamicFlowControlCount:     u32,
	MacroInstructionCount:       u32,
	ArrayInstructionCount:       u32,
	CutInstructionCount:         u32,
	EmitInstructionCount:        u32,
	GSOutputTopology:            PRIMITIVE_TOPOLOGY,
	GSMaxOutputVertexCount:      u32,
	InputPrimitive:              PRIMITIVE,
	PatchConstantParameters:     u32,
	cGSInstanceCount:            u32,
	cControlPoints:              u32,
	HSOutputPrimitive:           TESSELLATOR_OUTPUT_PRIMITIVE,
	HSPartitioning:              TESSELLATOR_PARTITIONING,
	TessellatorDomain:           TESSELLATOR_DOMAIN,

	cBarrierInstructions:        u32,
	cInterlockedInstructions:    u32,
	cTextureStoreInstructions:   u32,
}

SHADER_INPUT_BIND_DESC :: struct {
	Name:       cstring,
	Type:       SHADER_INPUT_TYPE,
	BindPoint:  u32,
	BindCount:  u32,

	uFlags:     u32,
	ReturnType: RESOURCE_RETURN_TYPE,
	Dimension:  SRV_DIMENSION,
	NumSamples: u32,
}

LIBRARY_DESC :: struct {
	Creator:       cstring,
	Flags:         u32,
	FunctionCount: u32,
}

FUNCTION_DESC :: struct {
	Version:                     u32,
	Creator:                     cstring,
	Flags:                       u32,

	ConstantBuffers:             u32,
	BoundResources:              u32,

	InstructionCount:            u32,
	TempRegisterCount:           u32,
	TempArrayCount:              u32,
	DefCount:                    u32,
	DclCount:                    u32,
	TextureNormalInstructions:   u32,
	TextureLoadInstructions:     u32,
	TextureCompInstructions:     u32,
	TextureBiasInstructions:     u32,
	TextureGradientInstructions: u32,
	FloatInstructionCount:       u32,
	IntInstructionCount:         u32,
	UintInstructionCount:        u32,
	StaticFlowControlCount:      u32,
	DynamicFlowControlCount:     u32,
	MacroInstructionCount:       u32,
	ArrayInstructionCount:       u32,
	MovInstructionCount:         u32,
	MovcInstructionCount:        u32,
	ConversionInstructionCount:  u32,
	BitwiseInstructionCount:     u32,
	MinFeatureLevel:             FEATURE_LEVEL,
	RequiredFeatureFlags:        u64,

	Name:                        cstring,
	FunctionParameterCount:      i32,
	HasReturn:                   BOOL,
	Has10Level9VertexShader:     BOOL,
	Has10Level9PixelShader:      BOOL,
}

PARAMETER_DESC :: struct {
	Name:              cstring,
	SemanticName:      cstring,
	Type:              SHADER_VARIABLE_TYPE,
	Class:             SHADER_VARIABLE_CLASS,
	Rows:              u32,
	Columns:           u32,
	InterpolationMode: INTERPOLATION_MODE,
	Flags:             PARAMETER_FLAGS,

	FirstInRegister:   u32,
	FirstInComponent:  u32,
	FirstOutRegister:  u32,
	FirstOutComponent: u32,
}

IShaderReflectionType :: struct {
	using vtable: ^IShaderReflectionType_VTable,
}
IShaderReflectionType_VTable :: struct {
	GetDesc:              proc "stdcall" (this: ^IShaderReflectionType, pDesc: ^SHADER_TYPE_DESC) -> HRESULT,
	GetMemberTypeByIndex: proc "stdcall" (this: ^IShaderReflectionType, Index: u32) -> ^IShaderReflectionType,
	GetMemberTypeByName:  proc "stdcall" (this: ^IShaderReflectionType, Name: cstring) -> ^IShaderReflectionType,
	GetMemberTypeName:    proc "stdcall" (this: ^IShaderReflectionType, Index: u32) -> cstring,
	IsEqual:              proc "stdcall" (this: ^IShaderReflectionType, pType: ^IShaderReflectionType) -> HRESULT,
	GetSubType:           proc "stdcall" (this: ^IShaderReflectionType) -> ^IShaderReflectionType,
	GetBaseClass:         proc "stdcall" (this: ^IShaderReflectionType) -> ^IShaderReflectionType,
	GetNumInterfaces:     proc "stdcall" (this: ^IShaderReflectionType) -> u32,
	GetInterfaceByIndex:  proc "stdcall" (this: ^IShaderReflectionType, uIndex: u32) -> ^IShaderReflectionType,
	IsOfType:             proc "stdcall" (this: ^IShaderReflectionType, pType: ^IShaderReflectionType) -> HRESULT,
	ImplementsInterface:  proc "stdcall" (this: ^IShaderReflectionType, pBase: ^IShaderReflectionType) -> HRESULT,
}

IShaderReflectionVariable :: struct {
	using vtable: ^IShaderReflectionVariable_VTable,
}
IShaderReflectionVariable_VTable :: struct {
	GetDesc:          proc "stdcall" (this: ^IShaderReflectionVariable, pDesc: ^SHADER_VARIABLE_DESC) -> HRESULT,
	GetType:          proc "stdcall" (this: ^IShaderReflectionVariable) -> ^IShaderReflectionType,
	GetBuffer:        proc "stdcall" (this: ^IShaderReflectionVariable) -> ^IShaderReflectionConstantBuffer,
	GetInterfaceSlot: proc "stdcall" (this: ^IShaderReflectionVariable, uArrayIndex: u32) -> u32,
}

IShaderReflectionConstantBuffer :: struct {
	using vtable: ^IShaderReflectionConstantBuffer_VTable,
}
IShaderReflectionConstantBuffer_VTable :: struct {
	GetDesc: proc "stdcall" (this: ^IShaderReflectionConstantBuffer, pDesc: ^SHADER_BUFFER_DESC) -> HRESULT,
	GetVariableByIndex: proc "stdcall" (this: ^IShaderReflectionConstantBuffer, Index: u32) -> ^IShaderReflectionVariable,
	GetVariableByName: proc "stdcall" (this: ^IShaderReflectionConstantBuffer, Name: cstring) -> ^IShaderReflectionVariable,
}


IShaderReflection :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11shaderreflection_vtable: ^IShaderReflection_VTable,
}
IShaderReflection_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	GetDesc:                       proc "stdcall" (this: ^IShaderReflection, pDesc: ^SHADER_DESC) -> HRESULT,
	GetConstantBufferByIndex:      proc "stdcall" (this: ^IShaderReflection, Index: u32) -> ^IShaderReflectionConstantBuffer,
	GetConstantBufferByName:       proc "stdcall" (this: ^IShaderReflection, Name: cstring) -> ^IShaderReflectionConstantBuffer,
	GetResourceBindingDesc:        proc "stdcall" (this: ^IShaderReflection, ResourceIndex: u32, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetInputParameterDesc:         proc "stdcall" (this: ^IShaderReflection, ParameterIndex: u32, pDesc: ^SIGNATURE_PARAMETER_DESC) -> HRESULT,
	GetOutputParameterDesc:        proc "stdcall" (this: ^IShaderReflection, ParameterIndex: u32, pDesc: ^SIGNATURE_PARAMETER_DESC) -> HRESULT,
	GetPatchConstantParameterDesc: proc "stdcall" (this: ^IShaderReflection, ParameterIndex: u32, pDesc: ^SIGNATURE_PARAMETER_DESC) -> HRESULT,
	GetVariableByName:             proc "stdcall" (this: ^IShaderReflection, Name: cstring) -> ^IShaderReflectionVariable,
	GetResourceBindingDescByName:  proc "stdcall" (this: ^IShaderReflection, Name: cstring, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetMovInstructionCount:        proc "stdcall" (this: ^IShaderReflection) -> u32,
	GetMovcInstructionCount:       proc "stdcall" (this: ^IShaderReflection) -> u32,
	GetConversionInstructionCount: proc "stdcall" (this: ^IShaderReflection) -> u32,
	GetBitwiseInstructionCount:    proc "stdcall" (this: ^IShaderReflection) -> u32,
	GetGSInputPrimitive:           proc "stdcall" (this: ^IShaderReflection) -> PRIMITIVE,
	IsSampleFrequencyShader:       proc "stdcall" (this: ^IShaderReflection) -> BOOL,
	GetNumInterfaceSlots:          proc "stdcall" (this: ^IShaderReflection) -> u32,
	GetMinFeatureLevel:            proc "stdcall" (this: ^IShaderReflection, pLevel: ^FEATURE_LEVEL) -> HRESULT,
	GetThreadGroupSize:            proc "stdcall" (this: ^IShaderReflection, pSizeX: ^u32, pSizeY: ^u32, pSizeZ: ^u32) -> u32,
	GetRequiresFlags:              proc "stdcall" (this: ^IShaderReflection) -> u64,
}


ILibraryReflection :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11libraryreflection_vtable: ^ILibraryReflection_VTable,
}
ILibraryReflection_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	GetDesc:            proc "stdcall" (this: ^ILibraryReflection, pDesc: ^LIBRARY_DESC) -> HRESULT,
	GetFunctionByIndex: proc "stdcall" (this: ^ILibraryReflection, FunctionIndex: i32) -> ^IFunctionReflection,
}

IFunctionReflection :: struct {
	using vtable: ^IFunctionReflection_VTable,
}
IFunctionReflection_VTable :: struct {
	GetDesc:                      proc "stdcall" (this: ^IFunctionReflection, pDesc: ^FUNCTION_DESC) -> HRESULT,
	GetConstantBufferByIndex:     proc "stdcall" (this: ^IFunctionReflection, BufferIndex: u32) -> ^IShaderReflectionConstantBuffer,
	GetConstantBufferByName:      proc "stdcall" (this: ^IFunctionReflection, Name: cstring) -> ^IShaderReflectionConstantBuffer,
	GetResourceBindingDesc:       proc "stdcall" (this: ^IFunctionReflection, ResourceIndex: u32, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetVariableByName:            proc "stdcall" (this: ^IFunctionReflection, Name: cstring) -> ^IShaderReflectionVariable,
	GetResourceBindingDescByName: proc "stdcall" (this: ^IFunctionReflection, Name: cstring, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetFunctionParameter:         proc "stdcall" (this: ^IFunctionReflection, ParameterIndex: i32) -> ^IFunctionParameterReflection,
}

IFunctionParameterReflection :: struct {
	using vtable: ^IFunctionParameterReflection_VTable,
}
IFunctionParameterReflection_VTable :: struct {
	GetDesc: proc "stdcall" (this: ^IFunctionParameterReflection, pDesc: ^PARAMETER_DESC) -> HRESULT,
}


ILinkingNode :: struct {
	using iunknown: IUnknown,
}

IFunctionLinkingGraph :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11functionlinkinggraph_vtable: ^IFunctionLinkingGraph_VTable,
}
IFunctionLinkingGraph_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	CreateModuleInstance: proc "stdcall" (this: ^IFunctionLinkingGraph, ppModuleInstance: ^^IModuleInstance, ppErrorBuffer: ^^IBlob) -> HRESULT,
	SetInputSignature:    proc "stdcall" (this: ^IFunctionLinkingGraph, pInputParameters: ^PARAMETER_DESC, cInputParameters: u32, ppInputNode: ^^ILinkingNode) -> HRESULT,
	SetOutputSignature:   proc "stdcall" (this: ^IFunctionLinkingGraph, pOutputParameters: ^PARAMETER_DESC, cOutputParameters: u32, ppOutputNode: ^^ILinkingNode) -> HRESULT,
	CallFunction:         proc "stdcall" (this: ^IFunctionLinkingGraph, pModuleInstanceNamespace: cstring, pModuleWithFunctionPrototype: ^IModule, pFunctionName: cstring, ppCallNode: ^^ILinkingNode) -> HRESULT,
	PassValue:            proc "stdcall" (this: ^IFunctionLinkingGraph, pSrcNode: ^ILinkingNode, SrcParameterIndex: i32, pDstNode: ^ILinkingNode, DstParameterIndex: i32) -> HRESULT,
	PassValueWithSwizzle: proc "stdcall" (this: ^IFunctionLinkingGraph, pSrcNode: ^ILinkingNode, SrcParameterIndex: i32, pSrcSwizzle: ^u8, pDstNode: ^ILinkingNode, DstParameterIndex: i32, pDstSwizzle: ^u8) -> HRESULT,
	GetLastError:         proc "stdcall" (this: ^IFunctionLinkingGraph, ppErrorBuffer: ^^IBlob) -> HRESULT,
	GenerateHlsl:         proc "stdcall" (this: ^IFunctionLinkingGraph, uFlags: u32, ppBuffer: ^^IBlob) -> HRESULT,
}
