package test_internal

@(require) import "core:log"
import "core:math"
import "core:testing"

@test
pow_test :: proc(t: ^testing.T) {
	for exp in -2000..=2000 {
		{
			v1 := math.pow(2, f64(exp))
			v2 := math.pow2_f64(exp)
			_v1 := transmute(u64)v1
			_v2 := transmute(u64)v2
			if exp == -1075 && ODIN_OS == .Windows {
				// LLVM on Windows returns 0h00000000_00000001 for pow(2, -1075),
				// unlike macOS and Linux where it returns 0h00000000_00000000
				// pow2_f64 returns the same float on all platforms because it isn't this stupid
				_v1 = 0h00000000_00000000
			}
			testing.expectf(t,  _v1 == _v2, "Expected math.pow2_f64(%d) == math.pow(2, %d) (= %16x), got %16x", exp, exp, _v1, _v2)
		}
		{
			v1 := math.pow(2, f32(exp))
			v2 := math.pow2_f32(exp)
			_v1 := transmute(u32)v1
			_v2 := transmute(u32)v2
			testing.expectf(t,  _v1 == _v2, "Expected math.pow2_f32(%d) == math.pow(2, %d) (= %08x), got %08x", exp, exp, _v1, _v2)
		}
		{
			v1 := math.pow(2, f16(exp))
			v2 := math.pow2_f16(exp)
			_v2 := transmute(u16)v2
			_v1 := transmute(u16)v1

			when ODIN_ARCH == .arm64 {
				if exp == -25 {
					log.info("skipping known test failure on arm64, Expected math.pow2_f16(-25) == math.pow(2, -25) (= 0000), got 0001")
					_v2 = 0
				}
			}
			testing.expectf(t,  _v1 == _v2, "Expected math.pow2_f16(%d) == math.pow(2, %d) (= %04x), got %04x", exp, exp, _v1, _v2)
		}
	}
}
