/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "",
               "heure d\u2019\u00e9t\u00e9 de Moscou",
               "",
               "heure de Moscou",
               "",
            };
        final String[] Pakistan = new String[] {
               "heure normale du Pakistan",
               "",
               "heure d\u2019\u00e9t\u00e9 du Pakistan",
               "",
               "heure du Pakistan",
               "",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "",
               "heure d\u2019\u00e9t\u00e9 de Magadan",
               "",
               "heure de Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "heure normale d\u2019Europe centrale",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe centrale",
               "",
               "heure d\u2019Europe centrale",
               "",
            };
        final String[] Acre = new String[] {
               "heure normale de l\u2019Acre",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Acre",
               "",
               "heure de l\u2019Acre",
               "",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l\u2019Est nord-am\u00e9ricain",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est",
               "",
               "heure de l\u2019Est nord-am\u00e9ricain",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "",
               "heure d\u2019\u00e9t\u00e9 de Lord Howe",
               "",
               "heure de Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de la Nouvelle-Z\u00e9lande",
               "",
               "heure d\u2019\u00e9t\u00e9 de la Nouvelle-Z\u00e9lande",
               "",
               "heure de la Nouvelle-Z\u00e9lande",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "heure de l\u2019Oc\u00e9an Indien",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakoutsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Iakoutsk",
               "",
               "heure de Iakoutsk",
               "",
            };
        final String[] East_Timor = new String[] {
               "heure du Timor oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "heure de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale d\u2019Europe de l\u2019Est",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe de l\u2019Est",
               "",
               "heure d\u2019Europe de l\u2019Est",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "heure normale de l\u2019Ouest argentin",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouest argentin",
               "",
               "heure de l\u2019Ouest argentin",
               "",
            };
        final String[] Ponape = new String[] {
               "heure de l\u2019\u00eele de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "heure de Bolivie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "heure normale de Saint-Pierre-et-Miquelon",
               "",
               "heure d\u2019\u00e9t\u00e9 de Saint-Pierre-et-Miquelon",
               "",
               "heure de Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "heure d\u2019Indochine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale d\u2019Ekaterinbourg",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Ekaterinbourg",
               "",
               "heure d\u2019Ekaterinbourg",
               "",
            };
        final String[] Maldives = new String[] {
               "heure des Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "heure de Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "heure de Wallis-et-Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d\u2019Afrique m\u00e9ridionale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "heure de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "heure des \u00eeles de la Ligne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "heure normale de l\u2019Ouzb\u00e9kistan",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouzb\u00e9kistan",
               "",
               "heure de l\u2019Ouzb\u00e9kistan",
               "",
            };
        final String[] Mongolia = new String[] {
               "heure normale d\u2019Oulan-Bator",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Oulan-Bator",
               "",
               "heure d\u2019Oulan-Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "heure normale du centre nord-am\u00e9ricain",
               "",
               "heure d\u2019\u00e9t\u00e9 du Centre",
               "",
               "heure du centre nord-am\u00e9ricain",
               "",
            };
        final String[] Niue = new String[] {
               "heure de Niou\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "heure de l\u2019\u00eele Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "heure normale des \u00eeles Malouines",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Malouines",
               "",
               "heure des \u00eeles Malouines",
               "",
            };
        final String[] Apia = new String[] {
               "heure normale d\u2019Apia",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Apia",
               "",
               "heure d\u2019Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "heure du Bhoutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "heure de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "heure de l\u2019Ouest du Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "heure de l\u2019\u00eele Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "heure de La R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "heure des \u00eeles Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "heure normale des \u00eeles Chatham",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Chatham",
               "",
               "heure des \u00eeles Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "heure de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "heure normale d\u2019Argentine",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Argentine",
               "",
               "heure de l\u2019Argentine",
               "",
            };
        final String[] Gambier = new String[] {
               "heure des \u00eeles Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "heure des \u00eeles Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "heure du Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "heure des \u00eeles Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "",
               "heure d\u2019\u00e9t\u00e9 du Cap-Vert",
               "",
               "heure du Cap-Vert",
               "",
            };
        final String[] Norfolk = new String[] {
               "heure de l\u2019\u00eele Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "heure normale des Samoa",
               "",
               "heure d\u2019\u00e9t\u00e9 des Samoa",
               "",
               "heure des Samoa",
               "",
            };
        final String[] Davis = new String[] {
               "heure de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "",
               "heure d\u2019\u00e9t\u00e9 de Cuba",
               "",
               "heure de Cuba",
               "",
            };
        final String[] GMT = new String[] {
               "heure moyenne de Greenwich",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "heure normale des Philippines",
               "",
               "heure d\u2019\u00e9t\u00e9 des Philippines",
               "",
               "heure des Philippines",
               "",
            };
        final String[] French_Southern = new String[] {
               "heure des Terres australes et antarctiques fran\u00e7aises",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de la Nouvelle-Cal\u00e9donie",
               "",
               "heure d\u2019\u00e9t\u00e9 de Nouvelle-Cal\u00e9donie",
               "",
               "heure de la Nouvelle-Cal\u00e9donie",
               "",
            };
        final String[] Brunei = new String[] {
               "heure du Brun\u00e9i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "heure normale d\u2019Iran",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Iran",
               "",
               "heure de l\u2019Iran",
               "",
            };
        final String[] Tajikistan = new String[] {
               "heure du Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "heure normale des Tonga",
               "",
               "heure d\u2019\u00e9t\u00e9 de Tonga",
               "",
               "heure des Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "",
               "heure d\u2019\u00e9t\u00e9 du Bangladesh",
               "",
               "heure du Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "heure normale du P\u00e9rou",
               "",
               "heure d\u2019\u00e9t\u00e9 du P\u00e9rou",
               "",
               "heure du P\u00e9rou",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "heure normale de l\u2019Est du Groenland",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est du Groenland",
               "",
               "heure de l\u2019Est du Groenland",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "heure de l\u2019Est indon\u00e9sien",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "heure du Kirghizistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l\u2019Est de l\u2019Australie",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est de l\u2019Australie",
               "",
               "heure de l\u2019Est de l\u2019Australie",
               "",
            };
        final String[] French_Guiana = new String[] {
               "heure de la Guyane fran\u00e7aise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "",
               "heure d\u2019\u00e9t\u00e9 de Colombie",
               "",
               "heure de Colombie",
               "",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "",
               "heure d\u2019\u00e9t\u00e9 du Chili",
               "",
               "heure du Chili",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "heure des \u00eeles Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d\u2019Irkoutsk",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Irkoutsk",
               "",
               "heure d\u2019Irkoutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "heure normale de la G\u00e9orgie",
               "",
               "heure d\u2019\u00e9t\u00e9 de G\u00e9orgie",
               "",
               "heure de la G\u00e9orgie",
               "",
            };
        final String[] Choibalsan = new String[] {
               "heure normale de Choibalsan",
               "",
               "heure d\u2019\u00e9t\u00e9 de Choibalsan",
               "",
               "heure de Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "heure normale de la Chine",
               "",
               "heure d\u2019\u00e9t\u00e9 de Chine",
               "",
               "heure de la Chine",
               "",
            };
        final String[] Armenia = new String[] {
               "heure normale de l\u2019Arm\u00e9nie",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Arm\u00e9nie",
               "",
               "heure de l\u2019Arm\u00e9nie",
               "",
            };
        final String[] Africa_Central = new String[] {
               "heure normale d\u2019Afrique centrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "",
               "heure d\u2019\u00e9t\u00e9 du Japon",
               "",
               "heure du Japon",
               "",
            };
        final String[] Taipei = new String[] {
               "heure normale de Taipei",
               "",
               "heure d\u2019\u00e9t\u00e9 de Taipei",
               "",
               "heure de Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "",
               "heure d\u2019\u00e9t\u00e9 de Hovd",
               "",
               "heure de Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale du centre-ouest de l\u2019Australie",
               "",
               "heure d\u2019\u00e9t\u00e9 du centre-ouest de l\u2019Australie",
               "",
               "heure du centre-ouest de l\u2019Australie",
               "",
            };
        final String[] Sakhalin = new String[] {
               "heure normale de Sakhaline",
               "",
               "heure d\u2019\u00e9t\u00e9 de Sakhaline",
               "",
               "heure de Sakhaline",
               "",
            };
        final String[] Paraguay = new String[] {
               "heure normale du Paraguay",
               "",
               "heure d\u2019\u00e9t\u00e9 du Paraguay",
               "",
               "heure du Paraguay",
               "",
            };
        final String[] Malaysia = new String[] {
               "heure de la Malaisie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "",
               "heure d\u2019\u00e9t\u00e9 de Maurice",
               "",
               "heure de Maurice",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "heure normale d\u2019Afrique de l\u2019Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "heure des \u00eeles Salomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "heure des \u00eeles Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "",
               "heure d\u2019\u00e9t\u00e9 de Terre-Neuve",
               "",
               "heure de Terre-Neuve",
               "",
            };
        final String[] Afghanistan = new String[] {
               "heure de l\u2019Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "",
               "heure d\u2019\u00e9t\u00e9 de Hong Kong",
               "",
               "heure de Hong Kong",
               "",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l\u2019Atlantique",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Atlantique",
               "",
               "heure de l\u2019Atlantique",
               "",
            };
        final String[] Israel = new String[] {
               "heure normale d\u2019Isra\u00ebl",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Isra\u00ebl",
               "",
               "heure d\u2019Isra\u00ebl",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "heure du Centre indon\u00e9sien",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "heure normale de Omsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Omsk",
               "",
               "heure de Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "heure des Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "heure normale de l\u2019Uruguay",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Uruguay",
               "",
               "heure de l\u2019Uruguay",
               "",
            };
        final String[] Nepal = new String[] {
               "heure du N\u00e9pal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "heure de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "heure normale du Vanuatu",
               "",
               "heure d\u2019\u00e9t\u00e9 de Vanuatu",
               "",
               "heure du Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "heure normale de Novossibirsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Novossibirsk",
               "",
               "heure de Novossibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "heure de Singapour",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "heure normale des A\u00e7ores",
               "",
               "heure d\u2019\u00e9t\u00e9 des A\u00e7ores",
               "",
               "heure des A\u00e7ores",
               "",
            };
        final String[] Suriname = new String[] {
               "heure du Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasno\u00efarsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Krasno\u00efarsk",
               "",
               "heure de Krasno\u00efarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "heure du Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "heure normale de l\u2019Amazonie",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Amazonie",
               "",
               "heure de l\u2019Amazonie",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "heure de l\u2019Est du Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "heure normale des \u00eeles Fidji",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Fidji",
               "",
               "heure des \u00eeles Fidji",
               "",
            };
        final String[] Kamchatka = new String[] {
               "heure normale de Petropavlovsk-Kamchatski",
               "",
               "heure d\u2019\u00e9t\u00e9 de Petropavlovsk-Kamchatski",
               "",
               "heure de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Tuvalu = new String[] {
               "heure des Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "heure de l\u2019\u00eele Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d\u2019Hawaii - Al\u00e9outiennes",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Hawaii - Al\u00e9outiennes",
               "",
               "heure d\u2019Hawaii - Al\u00e9outiennes",
               "",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du centre de l\u2019Australie",
               "",
               "heure d\u2019\u00e9t\u00e9 du centre de l\u2019Australie",
               "",
               "heure du centre de l\u2019Australie",
               "",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique nord-am\u00e9ricain",
               "",
               "heure d\u2019\u00e9t\u00e9 du Pacifique",
               "",
               "heure du Pacifique nord-am\u00e9ricain",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "heure normale du Turkm\u00e9nistan",
               "",
               "heure d\u2019\u00e9t\u00e9 du Turkm\u00e9nistan",
               "",
               "heure du Turkm\u00e9nistan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "heure normale d\u2019Europe de l\u2019Ouest",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe de l\u2019Ouest",
               "",
               "heure d\u2019Europe de l\u2019Ouest",
               "",
            };
        final String[] Guyana = new String[] {
               "heure du Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "heure des \u00eeles Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "heure de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "heure des Palaos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale de l\u2019Azerba\u00efdjan",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Azerba\u00efdjan",
               "",
               "heure de l\u2019Azerba\u00efdjan",
               "",
            };
        final String[] Mawson = new String[] {
               "heure de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "heure normale du Pacifique mexicain",
               "",
               "heure d\u2019\u00e9t\u00e9 du Pacifique mexicain",
               "",
               "heure du Pacifique mexicain",
               "",
            };
        final String[] Africa_Western = new String[] {
               "heure normale d\u2019Afrique de l\u2019Ouest",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Afrique de l\u2019Ouest",
               "",
               "heure d\u2019Afrique de l\u2019Ouest",
               "",
            };
        final String[] South_Georgia = new String[] {
               "heure de G\u00e9orgie du Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "heure normale de Volgograd",
               "",
               "heure d\u2019\u00e9t\u00e9 de Volgograd",
               "",
               "heure de Volgograd",
               "",
            };
        final String[] Easter = new String[] {
               "heure normale de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure de l\u2019\u00eele de P\u00e2ques",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "heure normale du Nord-Ouest du Mexique",
               "",
               "heure d\u2019\u00e9t\u00e9 du Nord-Ouest du Mexique",
               "",
               "heure du Nord-Ouest du Mexique",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "heure de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "heure normale de l\u2019Ouest du Groenland",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouest du Groenland",
               "",
               "heure de l\u2019Ouest du Groenland",
               "",
            };
        final String[] Ecuador = new String[] {
               "heure de l\u2019\u00c9quateur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "heure du Golfe",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "heure normale de la Cor\u00e9e",
               "",
               "heure d\u2019\u00e9t\u00e9 de Cor\u00e9e",
               "",
               "heure de la Cor\u00e9e",
               "",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l\u2019Ouest de l\u2019Australie",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouest de l\u2019Australie",
               "",
               "heure de l\u2019Ouest de l\u2019Australie",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "heure de l\u2019Ouest indon\u00e9sien",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "",
               "heure d\u2019\u00e9t\u00e9 des Rocheuses",
               "",
               "heure des Rocheuses",
               "",
            };
        final String[] Marquesas = new String[] {
               "heure des \u00eeles Marquises",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "heure normale de l\u2019Arabie",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Arabie",
               "",
               "heure de l\u2019Arabie",
               "",
            };
        final String[] Alaska = new String[] {
               "heure normale de l\u2019Alaska",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Alaska",
               "",
               "heure de l\u2019Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "",
               "heure d\u2019\u00e9t\u00e9 de Vladivostok",
               "",
               "heure de Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "heure des Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "heure de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "heure de la Papouasie-Nouvelle-Guin\u00e9e",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "",
               "heure d\u2019\u00e9t\u00e9 de Fernando de Noronha",
               "",
               "heure de Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "",
               "heure d\u2019\u00e9t\u00e9 de Brasilia",
               "",
               "heure de Brasilia",
               "",
            };
        final String[] Anadyr = new String[] {
               "heure normale d\u2019Anadyr",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Anadyr",
               "",
               "heure d\u2019Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "heure normale de Samara",
               "",
               "heure d\u2019\u00e9t\u00e9 de Samara",
               "",
               "heure de Samara",
               "",
            };
        final String[] India = new String[] {
               "heure de l\u2019Inde",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "heure normale des \u00eeles Cook",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Cook",
               "",
               "heure des \u00eeles Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "Katmandou" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquises" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "heure moyenne de Greenwich",
                    "",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah (Dakota du Nord)" },
            { "timezone.excity.Pacific/Fiji", "Fidji" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis-Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Douchanb\u00e9" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londres" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasno\u00efarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Tcho\u00efbalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Sainte-Lucie" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "T\u00e9gucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushua\u00efa" },
            { "timezone.excity.America/North_Dakota/Center", "Center (Dakota du Nord)" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "G\u00e9orgie du Sud" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "La Havane" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "D\u00e9troit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenade" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "Rome" },
            { "timezone.excity.Asia/Hebron", "H\u00e9bron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "La\u00e2youne" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem (Dakota du Nord)" },
            { "timezone.excity.Asia/Atyrau", "Atyraou" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bichkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Zurich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "ville inconnue" },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.America/Thule", "Thul\u00e9" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg [Indiana]" },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Oujgorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Bakou" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Oulianovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "heure moyenne de Greenwich",
                    "",
                    "heure d\u2019\u00e9t\u00e9 irlandaise",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktioubinsk" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Sainte-H\u00e9l\u00e8ne" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Ouagadougou", GMT },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxembourg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahre\u00efn" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "\u00cele de Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Paris" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay [Indiana]" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port-d\u2019Espagne" },
            { "timezone.excity.Asia/Chita", "Tchita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kowe\u00eft" },
            { "timezone.excity.America/Santo_Domingo", "Saint-Domingue" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "heure moyenne de Greenwich",
                    "",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagouste" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello [Kentucky]" },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Oulan-Bator" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novossibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "timezone.excity.America/Indiana/Marengo", "Marengo [Indiana]" },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cap-Vert" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "A\u00e7ores" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaos" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktaou" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Qostanay", "Kostana\u00ef" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Prague" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Temps universel coordonn\u00e9",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "Saint-Marin" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkoutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "timezone.excity.America/Indiana/Winamac", "Winamac [Indiana]" },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamtchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Iakoutsk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Tachkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "\u00cele de P\u00e2ques" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "\u00celes Canaries" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Le Caire" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Varsovie" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City [Indiana]" },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Le Vatican" },
            { "timezone.excity.Asia/Almaty", "Alma Ata" },
            { "timezone.excity.Asia/Tbilisi", "Tbilissi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorre" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beyrouth" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Saint-Vincent" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli (Libye)" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Ath\u00e8nes" },
            { "Africa/Djibouti", Africa_Eastern },
            { "timezone.excity.America/Indiana/Knox", "Knox [Indiana]" },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "J\u00e9rusalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damas" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "T\u00e9h\u00e9ran" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.America/St_Kitts", "Saint-Christophe" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "H\u00f4-Chi-Minh-Ville" },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Macassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinbourg" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrade" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Mexico" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisbonne" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporojie" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominique" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sakhaline" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernesey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malte" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kzyl Orda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Maurice" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Johns", "Saint-Jean de Terre-Neuve" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Ouralsk" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manille" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "S\u00e9oul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Saint-Thomas" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "timezone.excity.Asia/Samarkand", "Samarcande" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Ad\u00e9la\u00efde" },
            { "timezone.excity.Asia/Singapore", "Singapour" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Vienne" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Ca\u00efmans" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "La Barbade" },
            { "timezone.excity.Asia/Nicosia", "Nicosie" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e9ro\u00e9" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Achgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.America/Jamaica", "Jama\u00efque" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "La R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangoun" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Duba\u00ef" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kaboul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudes" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes [Indiana]" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Mad\u00e8re" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldives" },
        };
        return data;
    }
}
