/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.le;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.le.Caa32Template;
import com.ibm.dtfj.corereaders.zos.le.Caa32_11Template;
import com.ibm.dtfj.corereaders.zos.le.Caa64Template;
import com.ibm.dtfj.corereaders.zos.le.Caa64_11Template;
import com.ibm.dtfj.corereaders.zos.le.CaaNotFound;
import com.ibm.dtfj.corereaders.zos.le.CaaTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeedsaTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeelcaTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexhcom32Template;
import com.ibm.dtfj.corereaders.zos.le.CeexlaaTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexstkhTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeextvbTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeextvbeTemplate;
import com.ibm.dtfj.corereaders.zos.le.DsaStackFrame;
import com.ibm.dtfj.corereaders.zos.le.Edb;
import com.ibm.dtfj.corereaders.zos.le.SmcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Ihartm2aTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhastcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lse;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import com.ibm.dtfj.corereaders.zos.mvs.Tcb;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class Caa {
    private long address;
    private Tcb tcb;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Edb edb;
    private DsaStackFrame currentFrame;
    private int stackdirection;
    private CaaTemplate caaTemplate;
    private static int hcomLength = new Ceexhcom32Template().length();
    private String whereFound;
    static final int CEECAASTACK_UP = 0;
    static final int CEECAASTACK_DOWN = 1;
    private static final int WARNING = 4;
    private static final int ERROR = 8;
    private static final long F1SA = -420355391L;
    private static Logger log = Logger.getLogger(Caa.class.getName());
    private long laa;
    private boolean is64bit;

    public static Caa[] getCaas(AddressSpace addressSpace) {
        Tcb[] tcbArray = Tcb.getTcbs(addressSpace);
        if (tcbArray == null) {
            log.fine("no tcbs found in address space " + addressSpace);
            return new Caa[0];
        }
        log.fine("found " + tcbArray.length + " tcbs for address space " + addressSpace);
        Vector<Caa> vector = new Vector<Caa>();
        for (int i = 0; i < tcbArray.length; ++i) {
            try {
                vector.add(new Caa(tcbArray[i]));
                continue;
            }
            catch (CaaNotFound caaNotFound) {
                // empty catch block
            }
        }
        return vector.toArray(new Caa[0]);
    }

    public Caa(Tcb tcb) throws CaaNotFound {
        log.finer("creating Caa for Tcb at address " + Caa.hex(tcb.address()));
        this.tcb = tcb;
        this.space = tcb.space();
        this.inputStream = this.space.getImageInputStream();
        this.space.setIs64bit(false);
        if (this.is32bitCaa()) {
            int n;
            this.caaTemplate = new Caa32Template();
            String string = this.space.getDump().getProductRelease();
            if (string != null && (n = Integer.parseInt(string)) >= 11) {
                this.caaTemplate = new Caa32_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 32-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()));
            return;
        }
        this.space.setIs64bit(true);
        if (this.is64bitCaa()) {
            int n;
            this.is64bit = true;
            this.caaTemplate = new Caa64Template();
            String string = this.space.getDump().getProductRelease();
            if (string != null && (n = Integer.parseInt(string)) >= 11) {
                this.caaTemplate = new Caa64_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 64-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()));
            return;
        }
        this.space.setIs64bit(false);
        if (this.is32bitCaaLastDitch()) {
            int n;
            this.caaTemplate = new Caa32Template();
            String string = this.space.getDump().getProductRelease();
            if (string != null && (n = Integer.parseInt(string)) >= 11) {
                this.caaTemplate = new Caa32_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 32-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()) + " (last ditch)");
            return;
        }
        throw new CaaNotFound();
    }

    private boolean is32bitCaa() {
        try {
            long l = this.tcb.tcbcelap();
            log.finer("celap = 0x" + Caa.hex(l));
            int n = this.space.readInt(l);
            log.finer("celap0 = 0x" + Caa.hex(n));
            if (n == 0) {
                return false;
            }
            this.address = this.space.readInt(n + 32);
            int n2 = this.space.readInt(n + 8);
            log.finer("caa address = " + Caa.hex(this.address));
            return this.validate();
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
            return false;
        }
    }

    private boolean is64bitCaa() {
        try {
            long l = this.tcb.tcbstcb();
            log.finer("stcb = 0x" + Caa.hex(l));
            this.laa = IhastcbTemplate.getStcblaa(this.inputStream, l);
            log.finer("laa = 0x" + Caa.hex(this.laa));
            long l2 = CeexlaaTemplate.getCeelaa_lca64(this.inputStream, this.laa);
            log.finer("lca = 0x" + Caa.hex(l2));
            this.address = CeelcaTemplate.getCeelca_caa(this.inputStream, l2);
            log.finer("caa address = " + Caa.hex(this.address));
            return this.validate();
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
            return false;
        }
    }

    private boolean is32bitCaaLastDitch() {
        try {
            this.address = this.space.readInt(this.tcb.address() + 96L);
            log.finer("tcb caa address = " + Caa.hex(this.address));
            if (this.address == 0L) {
                throw new IOException("oh");
            }
            return this.validate();
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
            return false;
        }
    }

    public String whereFound() {
        return this.whereFound;
    }

    private boolean validate() {
        try {
            int n = this.space.readInt(this.address - 24L);
            int n2 = this.space.readInt(this.address - 20L) & 0xFFFF0000;
            if (n == -1010448957 && n2 == -1044316160) {
                log.fine("found valid caa at " + Caa.hex(this.address));
                return true;
            }
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
        }
        return false;
    }

    public DsaStackFrame getCurrentFrame() {
        if (this.currentFrame == null) {
            log.fine("about to get top dsa for caa " + Caa.hex(this.address));
            Cel4rreg cel4rreg = new Cel4rreg();
            assert (cel4rreg.p_dsafmt != -1);
            RegisterSet registerSet = cel4rreg.regs;
            boolean bl = cel4rreg.p_dsafmt == 1;
            long l = cel4rreg.p_dsaptr;
            if (l == 0L) {
                log.fine("dsa is zero for caa " + Caa.hex(this.address));
                return null;
            }
            try {
                this.currentFrame = new DsaStackFrame(l, bl, registerSet, this.space, this);
            }
            catch (IOException iOException) {
                log.fine("exception getting top dsa: " + iOException);
            }
        }
        return this.currentFrame;
    }

    public int getPThreadID() throws IOException {
        return this.caaTemplate.getCeecaathdid(this.inputStream, this.address);
    }

    public boolean hasFailed() {
        throw new Error("tbc");
    }

    public RegisterSet getRegisterSet() {
        throw new Error("tbc");
    }

    public Edb getEdb() {
        if (this.edb == null) {
            try {
                this.edb = new Edb(this.ceecaaedb(), this.space);
            }
            catch (Exception exception) {
                throw new Error("oops: " + exception);
            }
        }
        return this.edb;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb getTcb() {
        return this.tcb;
    }

    public int ceecaalevel() throws IOException {
        return (int)this.caaTemplate.getCeecaalevel(this.inputStream, this.address);
    }

    public int ceecaa_stackdirection() throws IOException {
        if (this.ceecaalevel() < 13) {
            throw new Error("ceecaa_stackdirection is not available in this level of LE! " + this.ceecaalevel());
        }
        return (int)this.caaTemplate.getCeecaa_stackdirection(this.inputStream, this.address);
    }

    public long ceecaasmcb() throws IOException {
        return ((Caa32Template)this.caaTemplate).getCeecaasmcb(this.inputStream, this.address);
    }

    public long ceecaarcb() throws IOException {
        return this.caaTemplate.getCeecaarcb(this.inputStream, this.address);
    }

    public long ceecaavba() throws IOException {
        return this.caaTemplate.getCeecaavba(this.inputStream, this.address);
    }

    public long pthread_getspecific_d8_np(long l) throws IOException {
        long l2 = this.ceecaavba();
        if (l2 == 0L) {
            log.fine("ceecaavba is zero!");
            return 0L;
        }
        long l3 = this.space.readInt(l2);
        if (l3 == -471481792L) {
            long l4 = this.getEdb().ceeedbdba();
            log.fine("ceeedbdba = " + Caa.hex(l4));
            assert (this.space.readInt(l4) == -758857152);
            long l5 = this.space.readInt(l4 + 8L);
            long l6 = (l - l5) / 16L;
            int n = (int)l6 / 32;
            int n2 = (int)l6 % 32;
            assert (n < 32);
            long l7 = this.space.readInt(l2 + 4L + (long)(n * 4));
            if (l7 == 0L) {
                return 0L;
            }
            log.fine("bucket = " + Caa.hex(l7));
            long l8 = this.space.readInt(l7 + 4L + (long)(n2 * 4));
            log.fine("value = " + Caa.hex(l8));
            return l8;
        }
        long l9 = CeextvbTemplate.getCeetvbcount(this.inputStream, l2);
        log.fine("eye = " + Caa.hex(this.space.readInt(l2)));
        long l10 = l2 + (long)CeextvbTemplate.length();
        int n = 0;
        while ((long)n < l9) {
            long l11 = CeextvbeTemplate.getCeetvbekey(this.inputStream, l10);
            if (l == l11) {
                return CeextvbeTemplate.getCeetvbevalue(this.inputStream, l10);
            }
            l10 += (long)CeextvbeTemplate.length();
            ++n;
        }
        return 0L;
    }

    public long ceecaaddsa() {
        try {
            return this.caaTemplate.getCeecaaddsa(this.inputStream, this.address);
        }
        catch (IOException iOException) {
            throw new Error("oops");
        }
    }

    public long ceecaaedb() throws IOException {
        return this.caaTemplate.getCeecaaedb(this.inputStream, this.address);
    }

    public long ceecaaerrcm() throws IOException {
        return this.caaTemplate.getCeecaaerrcm(this.inputStream, this.address);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    public String toString() {
        return Caa.hex(this.address);
    }

    class Cel4rreg {
        long seghigh;
        long seglow;
        int p_dsafmt = -1;
        long p_dsaptr;
        RegisterSet regs;

        Cel4rreg() {
            try {
                this.regs = this.getRegistersFromRTM2();
                if (this.regs != null) {
                    Caa.this.whereFound = "RTM2";
                    return;
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
            try {
                this.regs = this.getRegistersFromBPXGMSTA();
                if (this.regs != null) {
                    Caa.this.whereFound = this.regs.whereFound();
                    if (Caa.this.whereFound == null) {
                        Caa.this.whereFound = "BPXGMSTA";
                    }
                    return;
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
            try {
                this.regs = this.getRegistersFromLinkageStack();
                if (this.regs != null) {
                    Caa.this.whereFound = "Linkage";
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new Error("oops: " + iOException);
            }
            try {
                this.regs = this.getRegistersFromTCB();
                if (this.regs != null) {
                    Caa.this.whereFound = "TCB";
                    return;
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
            try {
                if (Caa.this.is64bit) {
                    long l = CeexlaaTemplate.getCeelaa_lca64(Caa.this.inputStream, Caa.this.laa);
                    this.p_dsaptr = CeelcaTemplate.getCeelca_savstack(Caa.this.inputStream, l);
                    log.fine("p_dsaptr from lca = " + Caa.hex(this.p_dsaptr));
                    this.p_dsafmt = Caa.this.stackdirection = 1;
                    if (this.validateDSA() == 0) {
                        Caa.this.whereFound = "LCA";
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
            Caa.this.whereFound = "not found";
        }

        private RegisterSet getRegistersFromRTM2() throws IOException {
            long l;
            int n = Caa.this.ceecaalevel();
            log.finer("caa level is " + n);
            if (n >= 13) {
                Caa.this.stackdirection = Caa.this.ceecaa_stackdirection();
                log.finer("stack direction is " + (Caa.this.stackdirection == 0 ? "up" : "down"));
            } else {
                Caa.this.stackdirection = 0;
                log.finer("stack direction is up");
            }
            if (Caa.this.stackdirection == 1) {
                try {
                    l = Caa.this.ceecaasmcb();
                    this.seghigh = SmcbTemplate.getSmcb_dsbos(Caa.this.inputStream, l);
                    this.seglow = CeexstkhTemplate.getStkh_stackfloor(Caa.this.inputStream, this.seghigh);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if ((l = Caa.this.tcb.tcbrtwa()) != 0L) {
                try {
                    log.fine("found some rtm2 registers");
                    RegisterSet registerSet = new RegisterSet();
                    long l2 = l + (long)Ihartm2aTemplate.getRtm2ereg$offset();
                    for (int i = 0; i < 16; ++i) {
                        registerSet.setRegister(i, Caa.this.space.readUnsignedInt(l2 + (long)(i * 4)));
                    }
                    long l3 = l + (long)Ihartm2aTemplate.getRtm2apsw$offset();
                    registerSet.setPSW(Caa.this.space.readLong(l3));
                    if (this.registersValid(registerSet)) {
                        log.fine("found good dsa in rtm2");
                        return registerSet;
                    }
                    log.fine("bad dsa in rtm2");
                    return null;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new Error("oops: " + exception);
                }
            }
            log.finer("failed to get registers from rtm2");
            return null;
        }

        private boolean registersValid(RegisterSet registerSet) throws IOException {
            this.p_dsafmt = Caa.this.stackdirection;
            if (this.p_dsafmt == 1) {
                this.p_dsaptr = registerSet.getRegisterAsAddress(4);
                log.fine("p_dsaptr from reg 4 = " + Caa.hex(this.p_dsaptr));
            } else {
                this.p_dsaptr = registerSet.getRegisterAsAddress(13);
                log.fine("p_dsaptr from reg 13 = " + Caa.hex(this.p_dsaptr));
            }
            int n = this.validateDSA();
            if (n == 0) {
                log.fine("found valid dsa");
                return true;
            }
            if (Caa.this.stackdirection == 1) {
                this.p_dsaptr = registerSet.getRegisterAsAddress(13);
                log.fine("p_dsaptr from reg 13 (again) = " + Caa.hex(this.p_dsaptr));
                this.p_dsafmt = 0;
                n = this.validateDSA();
                if (n == 4 && (n = this.validateDSA()) == 0) {
                    log.fine("found valid dsa");
                    return true;
                }
            }
            log.fine("p_dsaptr invalid so reset: " + Caa.hex(this.p_dsaptr));
            this.p_dsaptr = 0L;
            return false;
        }

        private RegisterSet getRegistersFromBPXGMSTA() throws IOException {
            RegisterSet registerSet = Caa.this.tcb.getRegistersFromBPXGMSTA();
            if (Caa.this.space.is64bit()) {
                Caa.this.stackdirection = 1;
                log.fine("forced stack direction down as 64-bit");
            }
            if (this.registersValid(registerSet)) {
                log.fine("found good dsa in BPXGMSTA");
                return registerSet;
            }
            return null;
        }

        private RegisterSet getRegistersFromLinkageStack() throws IOException {
            log.fine("enter getRegistersFromLinkageStack");
            try {
                Lse[] lseArray = Caa.this.tcb.getLinkageStack();
                if (lseArray.length == 0) {
                    log.fine("empty linkage stack");
                    return null;
                }
                for (int i = 0; i < lseArray.length; ++i) {
                    Lse lse = lseArray[i];
                    if (lse.lses1pasn() == Caa.this.space.getAsid()) {
                        int n;
                        RegisterSet registerSet = new RegisterSet();
                        if (lse.isZArchitecture() && (lse.lses1typ7() == 13 || lse.lses1typ7() == 12)) {
                            log.fine("found some z arch registers");
                            registerSet.setPSW(lse.lses1pswh());
                            for (n = 0; n < 16; ++n) {
                                registerSet.setRegister(n, lse.lses1grs(n));
                            }
                        } else {
                            log.fine("found some non z arch registers");
                            registerSet.setPSW(lse.lsespsw());
                            for (n = 0; n < 16; ++n) {
                                registerSet.setRegister(n, lse.lsesgrs(n));
                            }
                        }
                        if (!this.registersValid(registerSet)) continue;
                        log.fine("found good dsa in linkage stack");
                        return registerSet;
                    }
                    log.fine("different asid: " + Caa.hex(lse.lses1pasn()));
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new Error("oops: " + exception);
            }
            log.fine("could not find registers in linkage stack");
            return null;
        }

        private RegisterSet getRegistersFromTCB() throws IOException {
            log.fine("getRegistersFromTCB");
            RegisterSet registerSet = Caa.this.tcb.getRegisters();
            if (this.registersValid(registerSet)) {
                log.fine("found good dsa in TCB");
                return registerSet;
            }
            return null;
        }

        private int validateDSA() {
            log.fine("attempt to validate " + Caa.hex(this.p_dsaptr) + " on " + (this.p_dsafmt == 1 ? "down" : "up") + " stack");
            try {
                long l;
                if (this.p_dsafmt != 1) {
                    if (Caa.this.space.is64bit()) {
                        return 8;
                    }
                    l = Caa.this.ceecaaerrcm();
                    if (this.p_dsaptr < l + (long)hcomLength && this.p_dsaptr >= l && (this.p_dsaptr & 7L) == 0L) {
                        log.fine("upstack dsa " + Caa.hex(this.p_dsaptr) + " is inside hcom");
                        return 0;
                    }
                }
                l = Caa.this.ceecaaddsa();
                long l2 = this.p_dsaptr;
                int n = this.p_dsafmt;
                long l3 = this.p_dsaptr;
                int n2 = this.p_dsafmt;
                boolean bl = false;
                while (true) {
                    long l4;
                    DsaStackFrame.Ceexdsaf ceexdsaf = new DsaStackFrame.Ceexdsaf(Caa.this.space, l2, n);
                    if (Caa.this.stackdirection == 1 && this.p_dsafmt == 0 && l2 < this.seghigh && l2 >= this.seglow) {
                        this.p_dsaptr = CeedsaTemplate.getCeedsar4(Caa.this.inputStream, l2);
                        this.p_dsafmt = 1;
                        log.fine("warning, try switching to down stack");
                        return 4;
                    }
                    long l5 = ceexdsaf.DSA_Prev;
                    n = ceexdsaf.DSA_Format;
                    if (l5 == 0L || l5 == -420355391L) {
                        log.fine("cannot backchain futher because " + (l5 == 0L ? "zero" : "linkage stack") + " found");
                        return 8;
                    }
                    if (l5 == l) {
                        log.fine("dummy dsa reached");
                        return 0;
                    }
                    if (n != this.p_dsafmt) {
                        log.fine("backchained across a stack transition");
                        return 0;
                    }
                    if (n == 0 && (l4 = CeedsaTemplate.getCeedsanab(Caa.this.inputStream, l5)) == l2) {
                        log.fine("upstack DSA is good");
                        return 0;
                    }
                    l2 = l5;
                    if (bl) {
                        ceexdsaf = new DsaStackFrame.Ceexdsaf(Caa.this.space, l3, n2);
                        l3 = ceexdsaf.DSA_Prev;
                        n2 = ceexdsaf.DSA_Format;
                    }
                    if (l2 == l3) {
                        log.fine("loop detected in DSA chain");
                        return 8;
                    }
                    bl = !bl;
                }
            }
            catch (IOException iOException) {
                log.fine("bad read: " + iOException);
                return 8;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("oops: " + exception);
            }
        }
    }
}

