/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandParser;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.commands.PluginCommand;
import com.ibm.java.diagnostics.utils.commands.QuitCommand;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Context
implements IContext {
    protected final ArrayList<ICommand> globalCommands = new ArrayList();
    protected final ArrayList<ICommand> commands = new ArrayList();
    protected ICommand lastExecutedCommand = null;
    protected Exception lastException = null;
    public static final Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    protected PluginManager loader;

    public Context() {
        this.globalCommands.add(new QuitCommand());
        this.globalCommands.add(new PluginCommand());
    }

    public PluginManager getPluginManager() {
        return this.loader;
    }

    @Override
    public boolean isCommandRecognised(String string) {
        for (ICommand iCommand : this.commands) {
            if (!iCommand.recognises(string, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute(String string, String[] stringArray, PrintStream printStream) {
        try {
            this.execute(new CommandParser(string, stringArray), printStream);
        }
        catch (ParseException parseException) {
            printStream.println("Error executing command: " + parseException.getMessage());
        }
    }

    @Override
    public void execute(CommandParser commandParser, PrintStream printStream) {
        for (ICommand iCommand : this.commands) {
            if (!this.tryCommand(commandParser, iCommand, printStream)) continue;
            return;
        }
        printStream.println("Unrecognised command: " + commandParser.getCommand());
    }

    @Override
    public void execute(String string, PrintStream printStream) {
        string = string.trim();
        try {
            this.execute(new CommandParser(string), printStream);
        }
        catch (ParseException parseException) {
            printStream.println("Error executing command: " + parseException.getMessage());
        }
    }

    private boolean tryCommand(CommandParser commandParser, ICommand iCommand, PrintStream printStream) {
        this.lastExecutedCommand = null;
        this.lastException = null;
        if (iCommand.recognises(commandParser.getCommand(), this)) {
            PrintStream printStream2 = null;
            this.lastExecutedCommand = iCommand;
            try {
                if (commandParser.isRedirectedToFile()) {
                    printStream2 = commandParser.getOutputFile();
                    iCommand.run(commandParser.getCommand(), commandParser.getArguments(), this, printStream2);
                    printStream2.flush();
                    printStream2.close();
                } else {
                    iCommand.run(commandParser.getCommand(), commandParser.getArguments(), this, printStream);
                }
            }
            catch (Exception exception) {
                this.lastException = exception;
                logger.log(Level.FINE, "Problem running command: ", exception);
                printStream.println("Problem running command: ");
                printStream.println(exception.getMessage());
            }
            printStream.flush();
            if (printStream2 != null) {
                printStream2.flush();
                printStream2.close();
            }
            return true;
        }
        return false;
    }

    public Vector<String> getCommandNames() {
        Vector<String> vector = new Vector<String>();
        for (ICommand iCommand : this.commands) {
            if (iCommand.getCommandNames() == null) continue;
            vector.addAll(iCommand.getCommandNames());
        }
        return vector;
    }

    @Override
    public List<ICommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    protected void addGlobalCommandsToContext() {
        for (ICommand iCommand : this.globalCommands) {
            this.commands.add(iCommand);
        }
    }

    @Override
    public ICommand getLastExecutedCommand() {
        return this.lastExecutedCommand;
    }

    @Override
    public Exception getLastCommandException() {
        return this.lastException;
    }
}

