/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class MethodHandleInfoImpl
implements MethodHandleInfo {
    private final PrimitiveHandle mh;

    MethodHandleInfoImpl(PrimitiveHandle primitiveHandle) {
        this.mh = primitiveHandle;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.mh.defc;
    }

    @Override
    public String getName() {
        return this.mh.name;
    }

    @Override
    public MethodType getMethodType() {
        if (this.requiresReceiver()) {
            return this.mh.type.dropParameterTypes(0, 1);
        }
        if (this.isConstructor()) {
            return this.mh.type.changeReturnType(Void.TYPE);
        }
        return this.mh.type;
    }

    @Override
    public int getModifiers() {
        if (this.isMethod() || this.isConstructor()) {
            return this.mh.rawModifiers & (Modifier.methodModifiers() | 0x80 | 0x40 | 0x1000);
        }
        if (this.isField()) {
            return this.mh.rawModifiers & (Modifier.fieldModifiers() | 0x1000);
        }
        return -1;
    }

    @Override
    public int getReferenceKind() {
        if (this.mh.directHandleOriginatedInFindVirtual() || 11 == this.mh.kind || 12 == this.mh.kind) {
            return 5;
        }
        return this.mh.kind;
    }

    @Override
    public <T extends Member> T reflectAs(Class<T> clazz, MethodHandles.Lookup lookup) throws NullPointerException, IllegalArgumentException, ClassCastException {
        if (null == clazz || null == lookup) {
            throw new NullPointerException();
        }
        try {
            lookup.checkAccess(this.mh, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Msg.getString("K0583"));
            illegalArgumentException.initCause(illegalAccessException);
            throw illegalArgumentException;
        }
        if (11 == this.mh.kind || 12 == this.mh.kind) {
            throw new IllegalArgumentException(Msg.getString("K0590", this));
        }
        Member member = null;
        final Class<?> clazz2 = this.getDeclaringClass();
        final boolean bl = Modifier.isPublic(this.getModifiers());
        member = AccessController.doPrivileged(new PrivilegedAction<Member>(){

            @Override
            public Member run() {
                AccessibleObject accessibleObject = null;
                try {
                    if (MethodHandleInfoImpl.this.isField()) {
                        accessibleObject = bl ? clazz2.getField(MethodHandleInfoImpl.this.getName()) : clazz2.getDeclaredField(MethodHandleInfoImpl.this.getName());
                    } else if (MethodHandleInfoImpl.this.isMethod()) {
                        accessibleObject = bl ? clazz2.getMethod(MethodHandleInfoImpl.this.getName(), MethodHandleInfoImpl.this.getMethodType().arguments) : clazz2.getDeclaredMethod(MethodHandleInfoImpl.this.getName(), MethodHandleInfoImpl.this.getMethodType().arguments);
                    } else if (MethodHandleInfoImpl.this.isConstructor()) {
                        accessibleObject = bl ? clazz2.getConstructor(MethodHandleInfoImpl.this.getMethodType().arguments) : clazz2.getDeclaredConstructor(MethodHandleInfoImpl.this.getMethodType().arguments);
                    }
                }
                catch (NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
                    throw new IllegalArgumentException(reflectiveOperationException);
                }
                if (null == accessibleObject) {
                    throw new InternalError("Unable to get the underlying Member due to invalid reference kind");
                }
                return accessibleObject;
            }
        });
        clazz.cast(member);
        return (T)member;
    }

    private boolean requiresReceiver() {
        int n = this.getReferenceKind();
        return 1 == n || 3 == n || 9 == n || 7 == n || 5 == n;
    }

    boolean isMethod() {
        return this.getReferenceKind() >= 5 && !this.isConstructor();
    }

    boolean isField() {
        return this.getReferenceKind() <= 4;
    }

    boolean isConstructor() {
        return this.getReferenceKind() == 8;
    }

    public String toString() {
        return MethodHandleInfo.toString(this.getReferenceKind(), this.getDeclaringClass(), this.getName(), this.getMethodType());
    }
}

