/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFARM32DumpReader
extends ELFDumpReader {
    ELFARM32DumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        super(eLFFileReader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readShort() & 0xFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "arm";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator(this));
        for (int i = 0; i < 13; ++i) {
            treeMap.put("r" + i, (long)this._reader.readInt() & 0xFFFFFFFFL);
        }
        treeMap.put("sp", (long)this._reader.readInt() & 0xFFFFFFFFL);
        treeMap.put("lr", (long)this._reader.readInt() & 0xFFFFFFFFL);
        treeMap.put("pc", (long)this._reader.readInt() & 0xFFFFFFFFL);
        treeMap.put("spsr", (long)this._reader.readInt() & 0xFFFFFFFFL);
        return treeMap;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "sp";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> map) {
        return this.getStackPointerFrom(map);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return map.get("pc").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return map.get("lr").longValue();
    }

    @Override
    protected void readHighwordRegisters(DataEntry dataEntry, Map<String, Number> map) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in ARM ELF dump");
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] stringArray = new String[16];
        for (int i = 0; i < 13; ++i) {
            stringArray[i] = "r" + i;
        }
        stringArray[13] = "sp";
        stringArray[14] = "lr";
        stringArray[15] = "pc";
        stringArray[16] = "spsr";
        return stringArray;
    }
}

