/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.vm29.structure.DDRAlgorithmVersions;
import java.lang.reflect.Field;
import java.util.HashMap;

public class AlgorithmVersion {
    private static final String VM_MAJOR_VERSION = "VM_MAJOR_VERSION";
    private static final String VM_MINOR_VERSION = "VM_MINOR_VERSION";
    public static final String AVL_TREE_VERSION = "ALG_AVL_TREE_VERSION";
    public static final String DEBUG_LOCAL_MAP_VERSION = "ALG_DEBUG_LOCAL_MAP_VERSION";
    public static final String HASH_TABLE_VERSION = "VM_HASHTABLE_VERSION";
    public static final String JIT_STACK_WALKER_VERSION = "ALG_JIT_STACK_WALKER_VERSION";
    public static final String LOCAL_MAP_VERSION = "ALG_LOCAL_MAP_VERSION";
    public static final String METHOD_META_DATA_VERSION = "ALG_METHOD_META_DATA_VERSION";
    public static final String MONITOR_HASH_FUNCTION_VERSION = "ALG_MONITOR_HASH_FUNCTION_VERSION";
    public static final String MONITOR_EQUAL_FUNCTION_VERSION = "ALG_MONITOR_EQUAL_FUNCTION_VERSION";
    public static final String OBJECT_FIELD_OFFSET = "ALG_OBJECT_FIELD_OFFSET_VERSION";
    public static final String OBJECT_MONITOR_VERSION = "OBJECT_MONITOR_VERSION";
    public static final String OPT_INFO_VERSION = "OPT_INFO_VERSION";
    public static final String POOL_VERSION = "ALG_POOL_VERSION";
    public static final String ROM_HELP_VERSION = "ALG_ROM_HELP_VERSION";
    public static final String STACK_MAP_VERSION = "ALG_STACK_MAP_VERSION";
    public static final String STACK_WALKER_VERSION = "ALG_STACKWALKER_VERSION";
    public static final String FOUR_BYTE_OFFSETS_VERSION = "FOUR_BYTE_OFFSETS_VERSION";
    public static final String VTABLE_VERSION = "ALG_VM_VTABLE_VERSION";
    public static final String ITABLE_VERSION = "ALG_VM_ITABLE_VERSION";
    public static final String BYTECODE_VERSION = "ALG_VM_BYTECODE_VERSION";
    public static final String GC_ARRAYLET_OBJECT_MODEL_VERSION = "ALG_GC_ARRAYLET_OBJECT_MODEL_VERSION";
    public static final String GC_CLASS_MODEL_VERSION = "ALG_GC_CLASS_MODEL_VERSION";
    public static final String GC_CONTIGUOUS_ARRAY_OBJECT_MODEL_VERSION = "ALG_GC_CONTIGUOUS_ARRAY_OBJECT_MODEL_VERSION";
    public static final String GC_EMPTY_OBJECT_ITERATOR_VERSION = "ALG_GC_EMPTY_OBJECT_ITERATOR_VERSION";
    public static final String GC_HEAP_LINKED_FREE_HEADER_VERSION = "ALG_GC_HEAP_LINKED_FREE_HEADER_VERSION";
    public static final String GC_HEAP_REGION_DESCRIPTOR_VERSION = "ALG_GC_HEAP_REGION_DESCRIPTOR_VERSION";
    public static final String GC_MIXED_OBJECT_ITERATOR_VERSION = "ALG_GC_MIXED_OBJECT_ITERATOR_VERSION";
    public static final String GC_MIXED_OBJECT_MODEL_VERSION = "ALG_GC_MIXED_OBJECT_MODEL_VERSION";
    public static final String GC_OBJECT_HEAP_ITERATOR_ADDRESS_ORDERED_LIST_VERSION = "ALG_GC_OBJECT_HEAP_ITERATOR_ADDRESS_ORDERED_LIST_VERSION";
    public static final String GC_OBJECT_HEAP_ITERATOR_MARK_MAP_VERSION = "ALG_GC_OBJECT_HEAP_ITERATOR_MARK_MAP_VERSION";
    public static final String GC_OBJECT_HEAP_ITERATOR_SEGREGATED_VERSION = "ALG_GC_OBJECT_HEAP_ITERATOR_SEGREGATED_ORDERED_LIST_VERSION";
    public static final String GC_OBJECT_MODEL_VERSION = "ALG_GC_OBJECT_MODEL_VERSION";
    public static final String GC_POINTER_ARRAY_ITERATOR_VERSION = "ALG_GC_POINTER_ARRAY_ITERATOR_VERSION";
    public static final String GC_POINTER_ARRAYLET_ITERATOR_VERSION = "ALG_GC_POINTER_ARRAYLET_ITERATOR_VERSION";
    public static final String GC_SCAVENGER_FORWARDED_HEADER_VERSION = "ALG_GC_SCAVENGER_FORWARDED_HEADER_VERSION";
    public static final String MM_OBJECT_ACCESS_BARRIER_VERSION = "ALG_MM_OBJECT_ACCESS_BARRIER_VERSION";
    private static AlgorithmVersion DEFAULT_VERSION;
    private static int vmMajorVersion;
    private static int vmMinorVersion;
    private static HashMap<String, AlgorithmVersion> versionCache;
    private int algVersion;

    private AlgorithmVersion(int n) {
        this.algVersion = n;
    }

    public static AlgorithmVersion getVersionOf(String string) {
        AlgorithmVersion algorithmVersion;
        if (versionCache == null) {
            AlgorithmVersion.init();
        }
        if ((algorithmVersion = versionCache.get(string)) == null) {
            return DEFAULT_VERSION;
        }
        return algorithmVersion;
    }

    private static void init() {
        versionCache = new HashMap();
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = DDRAlgorithmVersions.class.getFields()) {
                if (!field.getType().equals(Long.TYPE)) continue;
                String string = field.getName();
                long l = field.getLong(null);
                if (string.equals(VM_MAJOR_VERSION)) {
                    vmMajorVersion = (int)l;
                    continue;
                }
                if (string.equals(VM_MINOR_VERSION)) {
                    vmMinorVersion = (int)l;
                    continue;
                }
                AlgorithmVersion algorithmVersion = new AlgorithmVersion((int)l);
                versionCache.put(field.getName(), algorithmVersion);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            vmMajorVersion = 2;
            vmMinorVersion = 30;
        }
        DEFAULT_VERSION = new AlgorithmVersion(0);
    }

    public static int getVMMajorVersion() {
        if (versionCache == null) {
            AlgorithmVersion.init();
        }
        return vmMajorVersion;
    }

    public static int getVMMinorVersion() {
        if (versionCache == null) {
            AlgorithmVersion.init();
        }
        return vmMinorVersion;
    }

    public int getAlgorithmVersion() {
        return this.algVersion;
    }

    public String toString() {
        return "AlgorithmVersion. VM: " + AlgorithmVersion.getVMMajorVersion() + "." + AlgorithmVersion.getVMMinorVersion() + " algorithm version: " + this.getAlgorithmVersion();
    }
}

