/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoJitmCommand
extends BaseJdmpviewCommand {
    public InfoJitmCommand() {
        this.addCommand("info jitm", "", "Displays JIT'ed methods and their addresses");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length != 0) {
            printStream.println("\"info jitm\" command does not take any parameters");
            return;
        }
        this.showJITdMethods();
    }

    private void showJITdMethods() {
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Iterator iterator = javaRuntime.getJavaClassLoaders();
        while (iterator.hasNext()) {
            JavaClassLoader javaClassLoader = (JavaClassLoader)iterator.next();
            Iterator iterator2 = javaClassLoader.getDefinedClasses();
            while (iterator2.hasNext()) {
                String string;
                JavaClass javaClass = (JavaClass)iterator2.next();
                Iterator iterator3 = javaClass.getDeclaredMethods();
                try {
                    string = javaClass.getName();
                }
                catch (CorruptDataException corruptDataException) {
                    string = Exceptions.getCorruptDataExceptionString();
                }
                while (iterator3.hasNext()) {
                    String string2;
                    String string3;
                    JavaMethod javaMethod = (JavaMethod)iterator3.next();
                    try {
                        string3 = javaMethod.getName();
                    }
                    catch (CorruptDataException corruptDataException) {
                        string3 = Exceptions.getCorruptDataExceptionString();
                    }
                    try {
                        string2 = javaMethod.getSignature();
                    }
                    catch (CorruptDataException corruptDataException) {
                        string2 = Exceptions.getCorruptDataExceptionString();
                    }
                    if (!javaMethod.getCompiledSections().hasNext()) continue;
                    Iterator iterator4 = javaMethod.getCompiledSections();
                    while (iterator4.hasNext()) {
                        ImageSection imageSection = (ImageSection)iterator4.next();
                        long l = imageSection.getBaseAddress().getAddress();
                        long l2 = imageSection.getSize();
                        long l3 = l + l2;
                        this.out.print("\n\tstart=" + Utils.toHex(l) + "  end=" + Utils.toHex(l3) + "   " + string + "::" + string3 + string2);
                    }
                }
            }
        }
        this.out.print("\n");
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays JIT'ed methods and their addresses\n\nparameters: none\n\nprints the following information about each JIT'ed method\n\n  - method name and signature\n  - method start address\n  - method end address\n");
    }
}

