/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.OperatingSystemMXBeanImpl;
import com.ibm.java.lang.management.internal.RuntimeMXBeanImpl;
import com.ibm.lang.management.MemoryUsage;
import com.ibm.lang.management.MemoryUsageRetrievalException;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.lang.management.ProcessorUsage;
import com.ibm.lang.management.ProcessorUsageRetrievalException;
import com.ibm.lang.management.internal.CpuUtilizationHelper;
import com.ibm.lang.management.internal.OperatingSystemNotificationThread;
import com.ibm.lang.management.internal.UnixExtendedOperatingSystem;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.util.Objects;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import openj9.internal.tools.attach.target.IPC;

public class ExtendedOperatingSystemMXBeanImpl
extends OperatingSystemMXBeanImpl
implements OperatingSystemMXBean {
    private static final ExtendedOperatingSystemMXBeanImpl instance = new ExtendedOperatingSystemMXBeanImpl();
    private static long oldTime = -1L;
    private static long oldCpuTime = -1L;
    private static long interimTime = -1L;
    private static long interimCpuTime = -1L;
    private static long latestTime = -1L;
    private static long latestCpuTime = -1L;
    private final CpuUtilizationHelper cpuUtilizationHelper = new CpuUtilizationHelper();
    private HwEmulResult isHwEmulated = HwEmulResult.UNKNOWN;

    public static ExtendedOperatingSystemMXBeanImpl getInstance() {
        if (ManagementUtils.isRunningOnUnix()) {
            return UnixExtendedOperatingSystem.getInstance();
        }
        return instance;
    }

    private static boolean isZosHardwareEmulated(String string) {
        if (string.equalsIgnoreCase("1090") || string.equalsIgnoreCase("1091")) {
            return true;
        }
        String string2 = VM.getVMLangAccess().internalGetProperties().getProperty("com.ibm.lang.management.OperatingSystemMXBean.zos.emulatedHardwareModels");
        if (null != string2) {
            for (String string3 : string2.split("[;,]")) {
                if (!string.equalsIgnoreCase(string3)) continue;
                return true;
            }
        }
        return false;
    }

    ExtendedOperatingSystemMXBeanImpl() {
        if (this.isDLPAREnabled()) {
            OperatingSystemNotificationThread operatingSystemNotificationThread = new OperatingSystemNotificationThread(this);
            operatingSystemNotificationThread.setDaemon(true);
            operatingSystemNotificationThread.setName("OperatingSystemMXBean notification dispatcher");
            operatingSystemNotificationThread.setPriority(6);
            operatingSystemNotificationThread.start();
        }
    }

    private native boolean isDLPAREnabled();

    private double calculateProcessCpuLoad(long l, long l2, long l3, long l4) {
        double d = l - l3;
        double d2 = l2 - l4;
        if (d <= 0.0 || d2 < 0.0) {
            return -1.0;
        }
        return Math.min(d2 / ((double)this.getOnlineProcessorsImpl() * d), 1.0);
    }

    @Override
    public final long getFreePhysicalMemorySize() {
        return this.getFreePhysicalMemorySizeImpl();
    }

    private native long getFreePhysicalMemorySizeImpl();

    @Override
    public final long getFreeSwapSpaceSize() {
        try {
            MemoryUsage memoryUsage = this.retrieveMemoryUsage(new MemoryUsage());
            return memoryUsage.getSwapFree();
        }
        catch (MemoryUsageRetrievalException memoryUsageRetrievalException) {
            return -1L;
        }
    }

    @Override
    public final String getHardwareModel() throws UnsupportedOperationException {
        return this.getHardwareModelImpl();
    }

    private native String getHardwareModelImpl() throws UnsupportedOperationException;

    private native MemoryUsage getMemoryUsageImpl(MemoryUsage var1);

    private native int getOnlineProcessorsImpl();

    @Override
    public final synchronized double getProcessCpuLoad() {
        double d = -1.0;
        latestTime = System.nanoTime();
        latestCpuTime = this.getProcessCpuTimeByNS();
        if (-1L == oldTime) {
            oldTime = interimTime = latestTime;
            oldCpuTime = interimCpuTime = latestCpuTime;
            return -1.0;
        }
        if (latestTime - interimTime >= 10000000L) {
            d = this.calculateProcessCpuLoad(latestTime, latestCpuTime, interimTime, interimCpuTime);
            if (d >= 0.0) {
                oldTime = interimTime;
                oldCpuTime = interimCpuTime;
                interimTime = latestTime;
                interimCpuTime = latestCpuTime;
                return d;
            }
            interimTime = latestTime;
            interimCpuTime = latestCpuTime;
        }
        if (latestTime - oldTime >= 10000000L && (d = this.calculateProcessCpuLoad(latestTime, latestCpuTime, oldTime, oldCpuTime)) < 0.0) {
            oldTime = latestTime;
            oldCpuTime = latestCpuTime;
        }
        return d;
    }

    @Override
    public final long getProcessCpuTime() {
        return this.getProcessCpuTimeImpl() * (long)CpuTimePrecisionHolder.precision;
    }

    @Override
    @Deprecated
    public final long getProcessCpuTimeByNS() {
        long l = this.getProcessCpuTime();
        if (CpuTimePrecisionHolder.precision == 1) {
            l *= 100L;
        }
        return l;
    }

    private native long getProcessCpuTimeImpl();

    @Override
    public final int getProcessingCapacity() {
        return this.getProcessingCapacityImpl();
    }

    private native int getProcessingCapacityImpl();

    private native ProcessorUsage[] getProcessorUsageImpl(ProcessorUsage[] var1);

    @Override
    public final long getProcessPhysicalMemorySize() {
        return this.getProcessPhysicalMemorySizeImpl();
    }

    private native long getProcessPhysicalMemorySizeImpl();

    @Override
    public final long getProcessPrivateMemorySize() {
        return this.getProcessPrivateMemorySizeImpl();
    }

    private native long getProcessPrivateMemorySizeImpl();

    @Override
    public long getCommittedVirtualMemorySize() {
        return this.getProcessVirtualMemorySizeImpl();
    }

    @Override
    @Deprecated
    public final long getProcessVirtualMemorySize() {
        return this.getProcessVirtualMemorySizeImpl();
    }

    private native long getProcessVirtualMemorySizeImpl();

    @Override
    public final double getSystemCpuLoad() {
        return this.cpuUtilizationHelper.getSystemCpuLoad();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        return this.getTotalPhysicalMemoryImpl();
    }

    @Override
    @Deprecated
    public final long getTotalPhysicalMemory() {
        return this.getTotalPhysicalMemoryImpl();
    }

    private native long getTotalPhysicalMemoryImpl();

    private native ProcessorUsage getTotalProcessorUsageImpl(ProcessorUsage var1);

    @Override
    public final long getTotalSwapSpaceSize() {
        try {
            MemoryUsage memoryUsage = this.retrieveMemoryUsage(new MemoryUsage());
            return memoryUsage.getSwapTotal();
        }
        catch (MemoryUsageRetrievalException memoryUsageRetrievalException) {
            return -1L;
        }
    }

    @Override
    public final boolean isHardwareEmulated() throws UnsupportedOperationException {
        if (HwEmulResult.UNKNOWN == this.isHwEmulated) {
            String string = VM.getVMLangAccess().internalGetProperties().getProperty("os.name");
            String string2 = this.getHardwareModel();
            if (null != string && null != string2) {
                boolean bl = false;
                if (string.equalsIgnoreCase("z/OS")) {
                    bl = ExtendedOperatingSystemMXBeanImpl.isZosHardwareEmulated(string2);
                }
                this.isHwEmulated = bl ? HwEmulResult.YES : HwEmulResult.NO;
            } else {
                if (null == string2) {
                    String string3 = Msg.getString("K05db");
                    throw new UnsupportedOperationException(string3);
                }
                throw new UnsupportedOperationException();
            }
        }
        return HwEmulResult.YES == this.isHwEmulated;
    }

    @Override
    public final MemoryUsage retrieveMemoryUsage() throws MemoryUsageRetrievalException {
        return this.getMemoryUsageImpl(new MemoryUsage());
    }

    @Override
    public final MemoryUsage retrieveMemoryUsage(MemoryUsage memoryUsage) throws NullPointerException, MemoryUsageRetrievalException {
        return this.getMemoryUsageImpl(Objects.requireNonNull(memoryUsage));
    }

    @Override
    public final ProcessorUsage[] retrieveProcessorUsage() throws ProcessorUsageRetrievalException {
        return this.getProcessorUsageImpl(null);
    }

    @Override
    public final ProcessorUsage[] retrieveProcessorUsage(ProcessorUsage[] processorUsageArray) throws NullPointerException, ProcessorUsageRetrievalException, IllegalArgumentException {
        if (null == processorUsageArray) {
            throw new NullPointerException(Msg.getString("K056B"));
        }
        for (ProcessorUsage processorUsage : processorUsageArray) {
            if (null != processorUsage) continue;
            throw new NullPointerException(Msg.getString("K056C"));
        }
        return this.getProcessorUsageImpl(processorUsageArray);
    }

    @Override
    public final ProcessorUsage retrieveTotalProcessorUsage() throws ProcessorUsageRetrievalException {
        return this.getTotalProcessorUsageImpl(new ProcessorUsage());
    }

    @Override
    public final ProcessorUsage retrieveTotalProcessorUsage(ProcessorUsage processorUsage) throws NullPointerException, ProcessorUsageRetrievalException {
        return this.getTotalProcessorUsageImpl(Objects.requireNonNull(processorUsage));
    }

    @Override
    public final MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{ExtendedOperatingSystemMXBeanImpl.makeNotificationInfo("com.ibm.management.processing.capacity.change", "Processing Capacity Notification"), ExtendedOperatingSystemMXBeanImpl.makeNotificationInfo("com.ibm.management.total.physical.memory.change", "Total Physical Memory Notification"), ExtendedOperatingSystemMXBeanImpl.makeNotificationInfo("com.ibm.management.available.processors.change", "Available Processors Notification")};
    }

    private static MBeanNotificationInfo makeNotificationInfo(String string, String string2) {
        return new MBeanNotificationInfo(new String[]{string}, Notification.class.getName(), string2);
    }

    @Override
    public boolean isProcessRunning(long l) {
        RuntimeMXBeanImpl.checkMonitorPermission();
        return IPC.processExists(l);
    }

    private static final class CpuTimePrecisionHolder {
        static final int precision = CpuTimePrecisionHolder.getPrecision();
        static final int NS_SCALE_FACTOR = 100;
        static final int NO_SCALE_FACTOR = 1;

        private CpuTimePrecisionHolder() {
        }

        private static int getPrecision() {
            boolean bl = Boolean.getBoolean("com.ibm.lang.management.OperatingSystemMXBean.isCpuTime100ns");
            int n = bl ? 1 : 100;
            return n;
        }
    }

    private static enum HwEmulResult {
        NO,
        UNKNOWN,
        YES;

    }
}

