/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.jca.JCAUtil;

public abstract class SignatureSpi {
    protected SecureRandom appRandom = null;

    protected abstract void engineInitVerify(PublicKey var1) throws InvalidKeyException;

    protected abstract void engineInitSign(PrivateKey var1) throws InvalidKeyException;

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.appRandom = secureRandom;
        this.engineInitSign(privateKey);
    }

    protected abstract void engineUpdate(byte var1) throws SignatureException;

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws SignatureException;

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        try {
            if (byteBuffer.hasArray()) {
                byte[] byArray = byteBuffer.array();
                int n = byteBuffer.arrayOffset();
                int n2 = byteBuffer.position();
                int n3 = byteBuffer.limit();
                this.engineUpdate(byArray, n + n2, n3 - n2);
                byteBuffer.position(n3);
            } else {
                int n;
                int n4;
                byte[] byArray = new byte[JCAUtil.getTempArraySize(n4)];
                for (n4 = byteBuffer.remaining(); n4 > 0; n4 -= n) {
                    n = Math.min(n4, byArray.length);
                    byteBuffer.get(byArray, 0, n);
                    this.engineUpdate(byArray, 0, n);
                }
            }
        }
        catch (SignatureException signatureException) {
            throw new ProviderException("update() failed", signatureException);
        }
    }

    protected abstract byte[] engineSign() throws SignatureException;

    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.engineSign();
        if (n2 < byArray2.length) {
            throw new SignatureException("partial signatures not returned");
        }
        if (byArray.length - n < byArray2.length) {
            throw new SignatureException("insufficient space in the output buffer to store the signature");
        }
        System.arraycopy((Object)byArray2, 0, (Object)byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected abstract boolean engineVerify(byte[] var1) throws SignatureException;

    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy((Object)byArray, n, (Object)byArray2, 0, n2);
        return this.engineVerify(byArray2);
    }

    @Deprecated
    protected abstract void engineSetParameter(String var1, Object var2) throws InvalidParameterException;

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    protected AlgorithmParameters engineGetParameters() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected abstract Object engineGetParameter(String var1) throws InvalidParameterException;

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

