/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassOutput {
    public static void printStaticFields(JavaClass javaClass, PrintStream printStream) {
        String string;
        try {
            if (javaClass.isArray()) {
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print("\t  <can't determine if class is array; assuming it's not>\n\n");
        }
        try {
            string = javaClass.getName();
        }
        catch (CorruptDataException corruptDataException) {
            string = null;
        }
        boolean bl = false;
        Iterator iterator = javaClass.getDeclaredFields();
        while (iterator.hasNext()) {
            boolean bl2;
            JavaField javaField = (JavaField)iterator.next();
            try {
                bl2 = Modifier.isStatic(javaField.getModifiers());
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("\t   <error while getting modifier for field \"");
                try {
                    printStream.print(javaField.getName());
                }
                catch (CorruptDataException corruptDataException2) {
                    printStream.print(Exceptions.getCorruptDataExceptionString());
                }
                printStream.print("\", " + Exceptions.getCorruptDataExceptionString() + ">");
                bl2 = false;
            }
            if (!bl2) continue;
            if (!bl) {
                printStream.print("\t  static fields for \"" + string + "\"\n");
            }
            bl = true;
            ClassOutput.printStaticFieldData(javaField, printStream);
        }
        if (bl) {
            printStream.print("\n");
        } else {
            printStream.print("\t  \"" + string + "\" has no static fields\n\n");
        }
    }

    public static void printNonStaticFields(JavaClass javaClass, PrintStream printStream) {
        String string;
        try {
            if (javaClass.isArray()) {
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print("\t  <can't determine if class is array; assuming it's not>\n\n");
        }
        try {
            string = javaClass.getName();
        }
        catch (CorruptDataException corruptDataException) {
            string = null;
        }
        boolean bl = false;
        Iterator iterator = javaClass.getDeclaredFields();
        while (iterator.hasNext()) {
            boolean bl2;
            JavaField javaField = (JavaField)iterator.next();
            try {
                bl2 = Modifier.isStatic(javaField.getModifiers());
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("\t   <error while getting modifier for field \"");
                try {
                    printStream.print(javaField.getName());
                }
                catch (CorruptDataException corruptDataException2) {
                    printStream.print(Exceptions.getCorruptDataExceptionString());
                }
                printStream.print("\", " + Exceptions.getCorruptDataExceptionString() + ">");
                bl2 = false;
            }
            if (bl2) continue;
            if (!bl) {
                printStream.print("\t  non-static fields for \"" + string + "\"\n");
            }
            bl = true;
            ClassOutput.printNonStaticFieldData(null, javaField, printStream);
        }
        if (bl) {
            printStream.print("\n");
        } else {
            printStream.print("\t  \"" + string + "\" has no non-static fields\n\n");
        }
    }

    public static void printFields(JavaObject javaObject, JavaClass javaClass, JavaRuntime javaRuntime, PrintStream printStream) {
        boolean bl;
        try {
            bl = javaObject.isArray();
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print("\t   <cannot determine if above object is array (" + Exceptions.getCorruptDataExceptionString() + "); we will assume it is not an array>\n");
            bl = false;
        }
        if (bl) {
            int n;
            String string;
            try {
                string = javaClass.getComponentType().getName();
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("\t   <cannot determine what type of array this is (" + Exceptions.getCorruptDataExceptionString() + ")>\n");
                return;
            }
            try {
                n = javaObject.getArraySize();
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("\t   <cannot determine the size of the array (" + Exceptions.getCorruptDataExceptionString() + ")>\n");
                return;
            }
            Object[] objectArray = null;
            objectArray = string.equals("boolean") ? new boolean[n] : (string.equals("byte") ? (Object[])new byte[n] : (string.equals("char") ? (Object[])new char[n] : (string.equals("short") ? (Object[])new short[n] : (string.equals("int") ? (Object[])new int[n] : (string.equals("long") ? (Object[])new long[n] : (string.equals("float") ? (Object[])new float[n] : (string.equals("double") ? (Object[])new double[n] : (Object[])new JavaObject[n])))))));
            try {
                javaObject.arraycopy(0, (Object)objectArray, 0, n);
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("\t   <cannot copy data from the array (" + Exceptions.getCorruptDataExceptionString() + ")>\n");
                return;
            }
            catch (MemoryAccessException memoryAccessException) {
                printStream.print("\t   <cannot copy data from the array (" + Exceptions.getMemoryAccessExceptionString() + ")>\n");
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                printStream.print("\t    This is an array of size " + n + " elements\n");
                return;
            }
            for (int i = 0; i < n; ++i) {
                printStream.print("\t   " + i + ":\t");
                if (string.equals("boolean")) {
                    printStream.print(Utils.getVal(objectArray[i]));
                } else if (string.equals("byte")) {
                    printStream.print(Utils.getVal(((byte[])objectArray)[i]));
                } else if (string.equals("char")) {
                    printStream.print(Utils.getVal(Character.valueOf(((char[])objectArray)[i])));
                } else if (string.equals("short")) {
                    printStream.print(Utils.getVal(((short[])objectArray)[i]));
                } else if (string.equals("int")) {
                    printStream.print(Utils.getVal(((int[])objectArray)[i]));
                } else if (string.equals("long")) {
                    printStream.print(Utils.getVal(((long[])objectArray)[i]));
                } else if (string.equals("float")) {
                    printStream.print(Utils.getVal(Float.valueOf(((float[])objectArray)[i])));
                } else if (string.equals("double")) {
                    printStream.print(Utils.getVal(((double[])objectArray)[i]));
                } else {
                    printStream.print(Utils.getVal(((JavaObject[])objectArray)[i]));
                }
                printStream.print("\n");
            }
        } else {
            JavaClass javaClass2 = javaClass;
            ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
            while (javaClass != null) {
                arrayList.add(javaClass);
                try {
                    javaClass = javaClass.getSuperclass();
                }
                catch (CorruptDataException corruptDataException) {
                    javaClass = null;
                }
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                javaClass = (JavaClass)arrayList.get(i);
                Iterator iterator = javaClass.getDeclaredFields();
                if (iterator.hasNext()) {
                    if (javaClass.equals((Object)javaClass2)) {
                        printStream.print("\t   declared fields:\n");
                    } else {
                        printStream.print("\t   fields inherited from \"");
                        try {
                            printStream.print(javaClass.getName() + "\":\n");
                        }
                        catch (CorruptDataException corruptDataException) {
                            printStream.print(Exceptions.getCorruptDataExceptionString());
                        }
                    }
                }
                while (iterator.hasNext()) {
                    boolean bl2;
                    JavaField javaField = (JavaField)iterator.next();
                    try {
                        bl2 = Modifier.isStatic(javaField.getModifiers());
                    }
                    catch (CorruptDataException corruptDataException) {
                        printStream.print("\t   <error while getting modifier for field \"");
                        try {
                            printStream.print(javaField.getName());
                        }
                        catch (CorruptDataException corruptDataException2) {
                            printStream.print(Exceptions.getCorruptDataExceptionString());
                        }
                        printStream.print("\", " + Exceptions.getCorruptDataExceptionString() + ">");
                        bl2 = true;
                    }
                    if (bl2) continue;
                    ClassOutput.printNonStaticFieldData(javaObject, javaField, printStream);
                }
            }
        }
        printStream.print("\n");
    }

    private static void printStaticFieldData(JavaField javaField, PrintStream printStream) {
        ClassOutput.printFieldData(null, javaField, printStream, true);
    }

    private static void printNonStaticFieldData(JavaObject javaObject, JavaField javaField, PrintStream printStream) {
        ClassOutput.printFieldData(javaObject, javaField, printStream, false);
    }

    private static void printFieldData(JavaObject javaObject, JavaField javaField, PrintStream printStream, boolean bl) {
        String string;
        String string2;
        printStream.print("\t    ");
        try {
            string2 = Utils.getFieldModifierString(javaField);
            printStream.print(string2);
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print(Exceptions.getCorruptDataExceptionString());
        }
        try {
            string = javaField.getSignature();
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print(Exceptions.getCorruptDataExceptionString());
            string = null;
        }
        if (null != string) {
            string2 = Utils.getSignatureName(string);
            if (null == string2) {
                printStream.print("<unknown>");
            } else {
                printStream.print(string2);
            }
        }
        printStream.print(" ");
        try {
            printStream.print(javaField.getName());
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print(Exceptions.getCorruptDataExceptionString());
        }
        if (bl || null != javaObject) {
            printStream.print(" = ");
            printStream.print(Utils.getVal(javaObject, javaField));
        }
        printStream.print("\n");
    }

    public static void printMethods(Iterator iterator, PrintStream printStream) {
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            try {
                Object object;
                printStream.print("Bytecode range(s): ");
                Iterator iterator2 = javaMethod.getBytecodeSections();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    object = (ImageSection)iterator2.next();
                    long l = object.getBaseAddress().getAddress();
                    long l2 = l + object.getSize();
                    if (bl) {
                        printStream.print(", ");
                    }
                    printStream.print(Long.toHexString(l) + " -- " + Long.toHexString(l2));
                    bl = true;
                }
                printStream.print(":  ");
                try {
                    printStream.print(Utils.getMethodModifierString(javaMethod));
                }
                catch (CorruptDataException corruptDataException) {
                    printStream.print(Exceptions.getCorruptDataExceptionString());
                }
                try {
                    object = javaMethod.getSignature();
                }
                catch (CorruptDataException corruptDataException) {
                    printStream.print(Exceptions.getCorruptDataExceptionString());
                    object = null;
                }
                if (null != object) {
                    String string = Utils.getReturnValueName((String)object);
                    if (null == string) {
                        printStream.print("<unknown>");
                    } else {
                        printStream.print(string);
                    }
                }
                printStream.print(" ");
                printStream.print(javaMethod.getName());
                if (null != object) {
                    String string = Utils.getMethodSignatureName((String)object);
                    if (null == string) {
                        printStream.print("<unknown>");
                    } else {
                        printStream.print(string);
                    }
                }
                printStream.print("\n");
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("N/A (CorruptDataException occurred)");
            }
        }
    }

    public static String printRuntimeClassAndLoader(JavaClass javaClass, PrintStream printStream) {
        String string;
        String string2;
        Object object;
        String string3 = "N/A (CorruptDataException occurred)";
        try {
            object = javaClass.getClassLoader();
            string2 = "0x" + Long.toHexString(object.getObject().getID().getAddress());
            string = object.getObject().getJavaClass().getName();
        }
        catch (CorruptDataException corruptDataException) {
            string2 = null;
            string = string3;
        }
        object = "    ";
        printStream.print((String)object);
        printStream.print("Class ID = 0x" + Long.toHexString(javaClass.getID().getAddress()));
        printStream.print((String)object);
        printStream.print("Class Loader " + string + "(" + string2 + ")");
        printStream.print("\n");
        return string2;
    }
}

