/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm29.structure.J9PortLibrary;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9MemTagIterator
implements Iterator<J9MemTagPointer> {
    private final long topAddress;
    private final byte[] headerEyecatcherBytes;
    private final long headerEyecatcher;
    private final long footerEyecatcher;
    private J9MemTagPointer current;
    private long currentSearchAddress;
    private boolean isFooterCorrupted;
    private boolean lookingForFreedCallSites;

    private J9MemTagIterator(long l, long l2, long l3, long l4) {
        this(l, l2, l3, l4, false);
    }

    private J9MemTagIterator(long l, long l2, long l3, long l4, boolean bl) {
        this.topAddress = l2;
        this.headerEyecatcherBytes = this.longToByteString(l3);
        this.headerEyecatcher = l3;
        this.footerEyecatcher = l4;
        this.currentSearchAddress = l;
        this.isFooterCorrupted = false;
        this.lookingForFreedCallSites = bl;
    }

    private byte[] longToByteString(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(DataType.getProcess().getByteOrder());
        byteBuffer.putLong(l);
        byteBuffer.flip();
        byte[] byArray = new byte[4];
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.position(4);
        }
        byteBuffer.get(byArray, 0, 4);
        return byArray;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        this.current = this.internalNext();
        return this.current != null;
    }

    public void moveCurrentSearchAddress(long l) {
        if (l > (long)UDATA.SIZEOF) {
            this.currentSearchAddress += l - (long)UDATA.SIZEOF;
        }
    }

    public boolean isFooterCorrupted() {
        return this.isFooterCorrupted;
    }

    private J9MemTagPointer internalNext() {
        long l;
        this.isFooterCorrupted = false;
        while (true) {
            if ((l = DataType.getProcess().findPattern(this.headerEyecatcherBytes, UDATA.SIZEOF, this.currentSearchAddress)) == -1L) {
                return null;
            }
            if (Addresses.greaterThan(l, this.topAddress)) {
                return null;
            }
            this.currentSearchAddress = l + (long)UDATA.SIZEOF;
            VoidPointer voidPointer = J9MemTagHelper.j9mem_get_memory_base(J9MemTagPointer.cast(l));
            try {
                IDATA iDATA = J9MemTagHelper.j9mem_check_tags(VoidPointer.cast(voidPointer), this.headerEyecatcher, this.footerEyecatcher);
                if (iDATA.allBitsIn(J9MemTagHelper.J9PORT_MEMTAG_NOT_A_TAG.longValue())) continue;
                if ((iDATA.allBitsIn(J9MemTagHelper.J9PORT_MEMTAG_FOOTER_TAG_CORRUPTED.longValue()) || iDATA.allBitsIn(J9MemTagHelper.J9PORT_MEMTAG_FOOTER_PADDING_CORRUPTED.longValue())) && this.headerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER && this.footerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER) {
                    this.isFooterCorrupted = true;
                    return J9MemTagPointer.cast(l);
                }
            }
            catch (J9MemTagHelper.J9MemTagCheckError j9MemTagCheckError) {
                if (this.lookingForFreedCallSites) continue;
                EventManager.raiseCorruptDataEvent("Corrupt memory section found", j9MemTagCheckError, false);
                continue;
            }
            break;
        }
        return J9MemTagPointer.cast(l);
    }

    @Override
    public J9MemTagPointer next() {
        if (this.hasNext()) {
            J9MemTagPointer j9MemTagPointer = this.current;
            this.current = null;
            return j9MemTagPointer;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static J9MemTagIterator iterateHeaders(long l, long l2, long l3, long l4) {
        return new J9MemTagIterator(l, l2, l3, l4);
    }

    public static J9MemTagIterator iterateHeaders(long l, long l2, long l3, long l4, boolean bl) {
        return new J9MemTagIterator(l, l2, l3, l4, bl);
    }

    public static J9MemTagIterator iterateAllocatedHeaders(long l, long l2) {
        return J9MemTagIterator.iterateHeaders(l, l2, J9PortLibrary.J9MEMTAG_EYECATCHER_ALLOC_HEADER, J9PortLibrary.J9MEMTAG_EYECATCHER_ALLOC_FOOTER);
    }

    public static J9MemTagIterator iterateAllocatedHeaders() {
        return J9MemTagIterator.iterateAllocatedHeaders(0L, UDATA.MASK);
    }

    public static J9MemTagIterator iterateFreedHeaders() {
        return J9MemTagIterator.iterateFreedHeaders(0L, UDATA.MASK);
    }

    public static J9MemTagIterator iterateFreedHeaders(long l) {
        return J9MemTagIterator.iterateFreedHeaders(l, UDATA.MASK);
    }

    public static J9MemTagIterator iterateFreedHeaders(long l, long l2) {
        return J9MemTagIterator.iterateHeaders(l, l2, J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER, J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER, true);
    }
}

