/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.PackageHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpModuleExportsCommand
extends Command {
    public DumpModuleExportsCommand() {
        this.addCommand("dumpmoduleexports", "<targetModuleAddress>", "display all j9packages exported by the target module");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            CommandUtils.dbgPrint(printStream, "Usage: !dumpmoduleexports <targetModuleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
                GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
                String string2 = stringArray[0];
                while (gCClassLoaderIterator.hasNext()) {
                    J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                    HashTable<J9PackagePointer> hashTable = PackageHashTable.fromJ9HashTable(j9ClassLoaderPointer.packageHashTable());
                    Iterator iterator = hashTable.iterator();
                    while (iterator.hasNext()) {
                        J9PackagePointer j9PackagePointer = (J9PackagePointer)iterator.next();
                        if (!j9PackagePointer.module().getHexAddress().equals(string2)) continue;
                        String string3 = J9UTF8Helper.stringValue(j9PackagePointer.packageName());
                        String string4 = j9PackagePointer.getHexAddress();
                        printStream.printf("%-45s !j9package %s%n", string3, string4);
                    }
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

