/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.LiveSetWalker;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_AllocationContextTarokPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorVLHGCPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class ObjectRefsCommand
extends Command {
    public ObjectRefsCommand() {
        this.addCommand("objectrefs", "<address> [ heapWalk ] [ rootWalk ]", "Find and list all references to specified object");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (stringArray.length < 1) {
                throw new DDRInteractiveCommandException("This debug extension takes an address argument \" !objectrefs <address> [ heapWalk ] [ rootWalk ]\"");
            }
            long l = Long.decode(stringArray[0]);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
            boolean bl = false;
            boolean bl2 = false;
            if (1 == stringArray.length) {
                bl = true;
                bl2 = true;
            } else {
                for (int i = 1; i < stringArray.length; ++i) {
                    if ("heapWalk".equals(stringArray[i])) {
                        bl = true;
                        continue;
                    }
                    if (!"rootWalk".equals(stringArray[i])) continue;
                    bl2 = true;
                }
            }
            if (bl) {
                try {
                    this.dumpHeapReferences(j9JavaVMPointer, j9ObjectPointer, printStream);
                }
                catch (CorruptDataException corruptDataException) {
                    corruptDataException.printStackTrace();
                }
            }
            if (bl2) {
                try {
                    this.dumpLiveReferences(j9JavaVMPointer, j9ObjectPointer, printStream);
                }
                catch (CorruptDataException corruptDataException) {
                    corruptDataException.printStackTrace();
                }
            }
        }
        catch (DDRInteractiveCommandException dDRInteractiveCommandException) {
            throw dDRInteractiveCommandException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printStream);
            throw new DDRInteractiveCommandException(throwable);
        }
    }

    private void dumpHeapReferences(J9JavaVMPointer j9JavaVMPointer, J9ObjectPointer j9ObjectPointer, PrintStream printStream) throws CorruptDataException {
        if (GCExtensions.isVLHGC()) {
            Table table = new Table("On Heap References");
            table.row("object (!j9object)", "field (!j9object)", "!mm_heapregiondescriptorvlhgc", "AC (type)");
            GCHeapRegionIterator gCHeapRegionIterator = GCHeapRegionIterator.from();
            while (gCHeapRegionIterator.hasNext()) {
                GCHeapRegionDescriptor gCHeapRegionDescriptor = gCHeapRegionIterator.next();
                if (!gCHeapRegionDescriptor.containsObjects()) continue;
                MM_HeapRegionDescriptorVLHGCPointer mM_HeapRegionDescriptorVLHGCPointer = MM_HeapRegionDescriptorVLHGCPointer.cast(gCHeapRegionDescriptor.getHeapRegionDescriptorPointer());
                MM_AllocationContextTarokPointer mM_AllocationContextTarokPointer = mM_HeapRegionDescriptorVLHGCPointer._allocateData()._owningContext();
                GCObjectHeapIterator gCObjectHeapIterator = gCHeapRegionDescriptor.objectIterator(true, false);
                while (gCObjectHeapIterator.hasNext()) {
                    J9ObjectPointer j9ObjectPointer2 = gCObjectHeapIterator.next();
                    GCObjectIterator gCObjectIterator = GCObjectIterator.fromJ9Object(j9ObjectPointer2, false);
                    while (gCObjectIterator.hasNext()) {
                        J9ObjectPointer j9ObjectPointer3 = gCObjectIterator.next();
                        if (!j9ObjectPointer3.eq(j9ObjectPointer)) continue;
                        J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer2);
                        String string = J9ClassHelper.getJavaName(j9ClassPointer);
                        table.row(j9ObjectPointer2.getHexAddress() + " //" + string, j9ObjectPointer3.getHexAddress(), mM_HeapRegionDescriptorVLHGCPointer.getHexAddress(), mM_AllocationContextTarokPointer.getHexAddress() + " (" + mM_AllocationContextTarokPointer._allocationContextType() + ")");
                    }
                }
            }
            table.render(printStream);
        }
    }

    private void dumpLiveReferences(J9JavaVMPointer j9JavaVMPointer, J9ObjectPointer j9ObjectPointer, PrintStream printStream) throws CorruptDataException {
        MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = MM_GCExtensionsPointer.cast(j9JavaVMPointer.gcExtensions()).heapRegionManager();
        GCHeapRegionManager gCHeapRegionManager = GCHeapRegionManager.fromHeapRegionManager(mM_HeapRegionManagerPointer);
        Table table = new Table("All Live Objects That Refer To !j9object " + j9ObjectPointer.getHexAddress());
        table.row("Object");
        LiveSetWalker.walkLiveSet(new LiveReferenceVisitor(gCHeapRegionManager, j9ObjectPointer, table));
        table.render(printStream);
    }

    class LiveReferenceVisitor
    implements LiveSetWalker.ObjectVisitor {
        GCHeapRegionManager heapRegionManager;
        J9ObjectPointer mainObject;
        Table table;

        public LiveReferenceVisitor(GCHeapRegionManager gCHeapRegionManager, J9ObjectPointer j9ObjectPointer, Table table) {
            this.heapRegionManager = gCHeapRegionManager;
            this.mainObject = j9ObjectPointer;
            this.table = table;
        }

        @Override
        public boolean visit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            try {
                GCObjectIterator gCObjectIterator = GCObjectIterator.fromJ9Object(j9ObjectPointer, false);
                while (gCObjectIterator.hasNext()) {
                    J9ObjectPointer j9ObjectPointer2 = gCObjectIterator.next();
                    if (!this.mainObject.eq(j9ObjectPointer2)) continue;
                    J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
                    String string = J9ClassHelper.getJavaName(j9ClassPointer);
                    this.table.row("!j9object " + j9ObjectPointer.getHexAddress() + " //" + string);
                }
            }
            catch (CorruptDataException corruptDataException) {
                return false;
            }
            return true;
        }

        @Override
        public void finishVisit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        }
    }
}

