/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.walkers.MemorySegmentIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgROMClassBuilderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgStringInternTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9InternHashTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9TranslationBufferSetPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.structure.J9ClassInitFlags;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.io.PrintStream;

public class VmCheckCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public VmCheckCommand() {
        this.addCommand("vmcheck", "", "Run VM state sanity checks");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            try {
                this.checkJ9VMThreadSanity(j9JavaVMPointer, printStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
            try {
                this.checkJ9ClassSanity(j9JavaVMPointer, printStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
            try {
                this.checkJ9ROMClassSanity(j9JavaVMPointer, printStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
            try {
                this.checkJ9MethodSanity(j9JavaVMPointer, printStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
            try {
                this.checkLocalInternTableSanity(j9JavaVMPointer, printStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void appendLine(PrintStream printStream, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        printStream.append(string2);
        printStream.append(nl);
    }

    private void reportError(PrintStream printStream, String string, Object ... objectArray) {
        this.appendLine(printStream, "<vm check: FAILED - Error %s>", String.format(string, objectArray));
    }

    private void reportMessage(PrintStream printStream, String string, Object ... objectArray) {
        this.appendLine(printStream, "<vm check: %s>", String.format(string, objectArray));
    }

    private void checkJ9VMThreadSanity(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
        int n = 0;
        int n2 = 0;
        boolean bl = j9JavaVMPointer.exclusiveAccessState().eq(J9Consts.J9_XACCESS_EXCLUSIVE);
        this.reportMessage(printStream, "Checking threads", new Object[0]);
        while (gCVMThreadListIterator.hasNext()) {
            J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
            this.verifyJ9VMThread(printStream, j9VMThreadPointer, j9JavaVMPointer);
            if (j9VMThreadPointer.inNative().eq(0L) && j9VMThreadPointer.publicFlags().allBitsIn(J9Consts.J9_PUBLIC_FLAGS_VM_ACCESS)) {
                ++n2;
            }
            ++n;
        }
        if (bl && n2 > 1) {
            this.reportError(printStream, "numberOfThreadsWithVMAccess (%d) > 1 with vm->exclusiveAccessState == J9_XACCESS_EXCLUSIVE", n2);
        }
        this.reportMessage(printStream, "Checking %d threads done", n);
    }

    private void verifyJ9VMThread(PrintStream printStream, J9VMThreadPointer j9VMThreadPointer, J9JavaVMPointer j9JavaVMPointer) throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer2 = j9VMThreadPointer.javaVM();
        if (!j9JavaVMPointer2.eq(j9JavaVMPointer)) {
            this.reportError(printStream, "vm (0x%s) != thread->javaVM (0x%s) for thread=0x%s", Long.toHexString(j9JavaVMPointer.getAddress()), Long.toHexString(j9JavaVMPointer2.getAddress()), Long.toHexString(j9VMThreadPointer.getAddress()));
        } else {
            J9JavaVMPointer j9JavaVMPointer3 = j9JavaVMPointer2.javaVM();
            if (!j9JavaVMPointer3.eq(j9JavaVMPointer)) {
                this.reportError(printStream, "thread->javaVM (0x%s) != thread->javaVM->javaVM (0x%s) for thread=0x%s", Long.toHexString(j9JavaVMPointer2.getAddress()), Long.toHexString(j9JavaVMPointer3.getAddress()), Long.toHexString(j9VMThreadPointer.getAddress()));
            }
        }
    }

    private void checkJ9ClassSanity(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        this.reportMessage(printStream, "Checking classes", new Object[0]);
        GCSegmentIterator gCSegmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(j9JavaVMPointer.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        int n = 0;
        int n2 = 0;
        while (gCSegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = gCSegmentIterator.next();
            GCClassHeapIterator gCClassHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(j9MemorySegmentPointer);
            while (gCClassHeapIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = gCClassHeapIterator.next();
                if (!J9ClassHelper.isObsolete(j9ClassPointer)) {
                    this.verifyJ9Class(j9JavaVMPointer, printStream, j9ClassPointer);
                } else {
                    this.verifyObsoleteJ9Class(j9JavaVMPointer, printStream, j9ClassPointer);
                    ++n2;
                }
                ++n;
            }
        }
        this.reportMessage(printStream, "Checking %d classes (%d obsolete) done", n, n2);
    }

    private boolean verifyJ9Class(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        boolean bl = this.verifyJ9ClassHeader(j9JavaVMPointer, printStream, j9ClassPointer);
        if (!j9ClassPointer.classLoader().isNull()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = j9ClassPointer.classLoader().classSegments();
            if ((j9MemorySegmentPointer = this.findSegmentInClassLoaderForAddress(j9ClassPointer, j9MemorySegmentPointer)).isNull()) {
                this.reportError(printStream, "class=0x%s not found in classLoader=0x%s", Long.toHexString(j9ClassPointer.getAddress()), Long.toHexString(j9ClassPointer.classLoader().getAddress()));
                bl = false;
            }
        }
        if (!this.verifyJ9ClassSubclassHierarchy(j9JavaVMPointer, printStream, j9ClassPointer)) {
            bl = false;
        }
        return bl;
    }

    private boolean verifyJ9ClassHeader(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        J9ConstantPoolPointer j9ConstantPoolPointer;
        J9ClassPointer j9ClassPointer2;
        long l;
        boolean bl = true;
        J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
        String string = "java.lang.Object";
        if (!J9ClassHelper.hasValidEyeCatcher(j9ClassPointer)) {
            this.reportError(printStream, "0x99669966 != eyecatcher (0x%s) for class=0x%s", Long.toHexString(j9ClassPointer.eyecatcher().longValue()), Long.toHexString(j9ClassPointer.getAddress()));
            bl = false;
        }
        if (j9ROMClassPointer.isNull()) {
            this.reportError(printStream, "NULL == romClass for class=0x%s", Long.toHexString(j9ClassPointer.getAddress()));
            bl = false;
        }
        if (j9ClassPointer.classLoader().isNull()) {
            this.reportError(printStream, "NULL == classLoader for class=0x%s", Long.toHexString(j9ClassPointer.getAddress()));
            bl = false;
        }
        if ((l = J9ClassHelper.classDepth(j9ClassPointer).longValue()) > 0L) {
            if (j9ClassPointer.superclasses().isNull()) {
                this.reportError(printStream, "NULL == superclasses for non-" + string + " class=0x%s", Long.toHexString(j9ClassPointer.getAddress()));
                bl = false;
            } else {
                for (long i = 0L; i < l; ++i) {
                    if (!j9ClassPointer.superclasses().at(i).isNull()) continue;
                    this.reportError(printStream, "superclasses[%d] is NULL for class=0x%s", Long.toHexString(j9ClassPointer.getAddress()));
                    bl = false;
                    break;
                }
            }
        } else if (j9ClassPointer.superclasses().at(-1L).notNull()) {
            this.reportError(printStream, "superclasses[-1] should be NULL for class=0x%s", Long.toHexString(j9ClassPointer.getAddress()));
            bl = false;
        }
        if (j9ClassPointer.initializeStatus().eq(J9ClassInitFlags.J9ClassInitSucceeded) && j9ClassPointer.classObject().isNull()) {
            this.reportError(printStream, "NULL == class->classObject for initialized class=0x%s", Long.toHexString(j9ClassPointer.getAddress()));
            bl = false;
        }
        if (J9ClassHelper.isObsolete(j9ClassPointer)) {
            this.reportError(printStream, "clazz=0x%s is obsolete", Long.toHexString(j9ClassPointer.getAddress()));
            bl = false;
        }
        if (!(j9ROMClassPointer.isNull() || j9ROMClassPointer.romConstantPoolCount().eq(0L) || j9ClassPointer.eq(j9ClassPointer2 = (j9ConstantPoolPointer = J9ConstantPoolPointer.cast(j9ClassPointer.ramConstantPool())).ramClass()))) {
            this.reportError(printStream, "clazz=0x%s not equal clazz->ramConstantPool->ramClass=0x%s", Long.toHexString(j9ClassPointer.getAddress()), Long.toHexString(j9ClassPointer2.getAddress()));
            bl = false;
        }
        return bl;
    }

    private boolean verifyObsoleteJ9Class(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        boolean bl = true;
        J9ClassPointer j9ClassPointer2 = J9ClassHelper.currentClass(j9ClassPointer);
        this.verifyJ9ClassHeader(j9JavaVMPointer, printStream, j9ClassPointer2);
        J9ClassPointer j9ClassPointer3 = j9ClassPointer2.replacedClass();
        while (!j9ClassPointer3.isNull() && !j9ClassPointer3.eq(j9ClassPointer)) {
            j9ClassPointer3 = j9ClassPointer3.replacedClass();
        }
        if (j9ClassPointer3.isNull()) {
            this.reportError(printStream, "obsolete class=0x%s is not in replaced list on currentClass=0x%s", Long.toHexString(j9ClassPointer.getAddress()), Long.toHexString(j9ClassPointer2.getAddress()));
            bl = false;
        }
        return bl;
    }

    private boolean verifyJ9ClassSubclassHierarchy(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        int n = 0;
        UDATA uDATA = J9ClassHelper.classDepth(j9ClassPointer);
        J9ClassPointer j9ClassPointer2 = j9ClassPointer;
        boolean bl = false;
        while (!bl) {
            J9ClassPointer j9ClassPointer3 = j9ClassPointer2.subclassTraversalLink();
            if (j9ClassPointer3.isNull()) {
                this.reportError(printStream, "class=0x%s had NULL entry in subclassTraversalLink list at index=%d following class=0x%s", Long.toHexString(j9ClassPointer.getAddress()), n, Long.toHexString(j9ClassPointer2.getAddress()));
                return false;
            }
            if (!this.verifyJ9ClassHeader(j9JavaVMPointer, printStream, j9ClassPointer3)) {
                return false;
            }
            if (J9ClassHelper.classDepth(j9ClassPointer3).lte(uDATA)) {
                bl = true;
                continue;
            }
            j9ClassPointer2 = j9ClassPointer3;
            ++n;
        }
        return true;
    }

    private J9MemorySegmentPointer findSegmentInClassLoaderForAddress(J9ClassPointer j9ClassPointer, J9MemorySegmentPointer j9MemorySegmentPointer) throws CorruptDataException {
        long l;
        while (!(j9MemorySegmentPointer.isNull() || (l = j9ClassPointer.getAddress()) >= j9MemorySegmentPointer.heapBase().longValue() && l < j9MemorySegmentPointer.heapAlloc().longValue())) {
            j9MemorySegmentPointer = j9MemorySegmentPointer.nextSegment();
        }
        return j9MemorySegmentPointer;
    }

    private void checkJ9ROMClassSanity(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        this.reportMessage(printStream, "Checking ROM classes", new Object[0]);
        GCSegmentIterator gCSegmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(j9JavaVMPointer.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        int n = 0;
        while (gCSegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = gCSegmentIterator.next();
            GCClassHeapIterator gCClassHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(j9MemorySegmentPointer);
            while (gCClassHeapIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = gCClassHeapIterator.next();
                this.verifyJ9ROMClass(printStream, j9JavaVMPointer, j9ClassPointer);
                ++n;
            }
        }
        this.reportMessage(printStream, "Checking %d ROM classes done", n);
    }

    private void verifyJ9ROMClass(PrintStream printStream, J9JavaVMPointer j9JavaVMPointer, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        AbstractPointer abstractPointer;
        J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
        J9ClassLoaderPointer j9ClassLoaderPointer = j9ClassPointer.classLoader();
        J9MemorySegmentPointer j9MemorySegmentPointer = this.findSegmentInClassLoaderForAddress(j9ClassLoaderPointer, j9ROMClassPointer);
        if (!j9MemorySegmentPointer.isNull()) {
            long l;
            if (j9ROMClassPointer.interfaceCount().longValue() != 0L) {
                l = j9ROMClassPointer.interfaces().getAddress();
                this.verifyAddressInSegment(printStream, j9JavaVMPointer, j9MemorySegmentPointer, l, "romClass->interfaces");
            }
            if (j9ROMClassPointer.romMethodCount().longValue() != 0L) {
                l = j9ROMClassPointer.romMethods().longValue();
                this.verifyAddressInSegment(printStream, j9JavaVMPointer, j9MemorySegmentPointer, l, "romClass->romMethods");
            }
            if (j9ROMClassPointer.romFieldCount().longValue() != 0L) {
                l = j9ROMClassPointer.romFields().longValue();
                this.verifyAddressInSegment(printStream, j9JavaVMPointer, j9MemorySegmentPointer, l, "romClass->romFields");
            }
            if (j9ROMClassPointer.innerClassCount().longValue() != 0L) {
                l = j9ROMClassPointer.innerClasses().longValue();
                this.verifyAddressInSegment(printStream, j9JavaVMPointer, j9MemorySegmentPointer, l, "romClass->innerClasses");
            }
            if (!(abstractPointer = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer)).isNull()) {
                l = abstractPointer.getAddress();
                this.verifyAddressInSegment(printStream, j9JavaVMPointer, j9MemorySegmentPointer, l, "romClass->cpShapeDescription");
            }
        }
        DataType dataType = j9ROMClassPointer.className();
        DataType dataType2 = j9ROMClassPointer.superclassName();
        abstractPointer = j9ROMClassPointer.outerClassName();
        if (((AbstractPointer)dataType).isNull() || !this.verifyUTF8((J9UTF8Pointer)dataType)) {
            this.reportError(printStream, "invalid className=0x%s utf8 for romClass=0x%s", Long.toHexString(((AbstractPointer)dataType).getAddress()), Long.toHexString(j9ROMClassPointer.getAddress()));
        }
        if (!((AbstractPointer)dataType2).isNull() && !this.verifyUTF8((J9UTF8Pointer)dataType2)) {
            this.reportError(printStream, "invalid superclassName=0x%s utf8 for romClass=0x%s", Long.toHexString(((AbstractPointer)dataType2).getAddress()), Long.toHexString(j9ROMClassPointer.getAddress()));
        }
        if (!abstractPointer.isNull() && !this.verifyUTF8((J9UTF8Pointer)abstractPointer)) {
            this.reportError(printStream, "invalid outerclassName=0x%s utf8 for romClass=0x%s", Long.toHexString(abstractPointer.getAddress()), Long.toHexString(j9ROMClassPointer.getAddress()));
        }
        if (((UScalar)(dataType = j9ROMClassPointer.ramConstantPoolCount())).gt((Scalar)(dataType2 = j9ROMClassPointer.romConstantPoolCount()))) {
            this.reportError(printStream, "ramConstantPoolCount=%d > romConstantPoolCount=%d for romClass=0x%s", ((Scalar)dataType).longValue(), ((Scalar)dataType2).longValue(), Long.toHexString(j9ROMClassPointer.getAddress()));
        }
    }

    private boolean verifyUTF8(J9UTF8Pointer j9UTF8Pointer) throws CorruptDataException {
        if (j9UTF8Pointer.isNull()) {
            return false;
        }
        UDATA uDATA = new UDATA(j9UTF8Pointer.length());
        U8Pointer u8Pointer = j9UTF8Pointer.dataEA();
        while (uDATA.longValue() > 0L) {
            U16 u16 = new U16(0L);
            U32 u32 = this.decodeUTF8CharN(u8Pointer, u16, uDATA);
            if (u32.eq(0L)) {
                return false;
            }
            uDATA = uDATA.sub(u32);
            u8Pointer = u8Pointer.addOffset(u32);
        }
        return true;
    }

    U32 decodeUTF8CharN(U8Pointer u8Pointer, U16 u16, UDATA uDATA) throws CorruptDataException {
        U8Pointer u8Pointer2 = u8Pointer;
        if (uDATA.longValue() < 1L) {
            return new U32(0L);
        }
        U8 u8 = u8Pointer2.at(0L);
        u8Pointer2 = u8Pointer2.add(1L);
        if (u8.eq(0L)) {
            return new U32(0L);
        }
        if (u8.bitAnd(128).eq(0L)) {
            return new U32(1L);
        }
        if (u8.bitAnd(224).eq(192L)) {
            if (uDATA.lt(2)) {
                return new U32(0L);
            }
            U16 u162 = new U16(u8.bitAnd(31).leftShift(6));
            u8 = u8Pointer2.at(0L);
            u8Pointer2 = u8Pointer2.add(1L);
            u162 = u162.add(new U16(u162.add(u8.bitAnd(63))));
            if (!u8.bitAnd(192).eq(128L)) {
                return new U32(0L);
            }
            return new U32(2L);
        }
        if (u8.bitAnd(240).eq(224L)) {
            if (uDATA.lt(3)) {
                return new U32(0L);
            }
            U16 u163 = new U16(u8.bitAnd(15).leftShift(12));
            u8 = u8Pointer2.at(0L);
            u8Pointer2 = u8Pointer2.add(1L);
            u163 = u163.add(new U16(u8.bitAnd(63).leftShift(6)));
            if (!u8.bitAnd(192).eq(128L)) {
                return new U32(0L);
            }
            u8 = u8Pointer2.at(0L);
            u8Pointer2 = u8Pointer2.add(1L);
            u163 = u163.add(new U16(u8.bitAnd(63)));
            if (!u8.bitAnd(192).eq(128L)) {
                return new U32(0L);
            }
            return new U32(3L);
        }
        return new U32(0L);
    }

    private void verifyAddressInSegment(PrintStream printStream, J9JavaVMPointer j9JavaVMPointer, J9MemorySegmentPointer j9MemorySegmentPointer, long l, String string) throws CorruptDataException {
        U8Pointer u8Pointer = j9MemorySegmentPointer.heapBase();
        U8Pointer u8Pointer2 = j9MemorySegmentPointer.heapAlloc();
        if (l < u8Pointer.getAddress() || l >= u8Pointer2.getAddress()) {
            this.reportError(printStream, "address 0x%s (%s) not in segment [heapBase=0x%s, heapAlloc=0x%s]", l, string, Long.toHexString(u8Pointer.getAddress()), Long.toHexString(u8Pointer2.getAddress()));
        }
    }

    public J9MemorySegmentPointer findSegmentInClassLoaderForAddress(J9ClassLoaderPointer j9ClassLoaderPointer, J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        MemorySegmentIterator memorySegmentIterator = new MemorySegmentIterator(j9ClassLoaderPointer.classSegments(), -1, true);
        J9MemorySegmentPointer j9MemorySegmentPointer = J9MemorySegmentPointer.NULL;
        J9MemorySegmentPointer j9MemorySegmentPointer2 = J9MemorySegmentPointer.NULL;
        while (memorySegmentIterator.hasNext()) {
            Object object = memorySegmentIterator.next();
            j9MemorySegmentPointer = (J9MemorySegmentPointer)object;
            if (j9ROMClassPointer.getAddress() < j9MemorySegmentPointer.heapBase().longValue() || j9ROMClassPointer.getAddress() >= j9MemorySegmentPointer.heapAlloc().longValue()) continue;
            j9MemorySegmentPointer2 = j9MemorySegmentPointer;
            break;
        }
        return j9MemorySegmentPointer2;
    }

    private void checkJ9MethodSanity(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        this.reportMessage(printStream, "Checking methods", new Object[0]);
        GCSegmentIterator gCSegmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(j9JavaVMPointer.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        int n = 0;
        while (gCSegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = gCSegmentIterator.next();
            GCClassHeapIterator gCClassHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(j9MemorySegmentPointer);
            while (gCClassHeapIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = gCClassHeapIterator.next();
                if (J9ClassHelper.isObsolete(j9ClassPointer)) continue;
                n += this.verifyClassMethods(j9JavaVMPointer, printStream, j9ClassPointer);
            }
        }
        this.reportMessage(printStream, "Checking %d methods done", n);
    }

    private int verifyClassMethods(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        int n = 0;
        J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
        int n2 = j9ROMClassPointer.romMethodCount().intValue();
        J9MethodPointer j9MethodPointer = j9ClassPointer.ramMethods();
        boolean bl = J9ROMClassHelper.isInterface(j9ROMClassPointer);
        J9ConstantPoolPointer j9ConstantPoolPointer = J9ConstantPoolPointer.cast(j9ClassPointer.ramConstantPool());
        for (int i = 0; i < n2; ++i) {
            J9MethodPointer j9MethodPointer2 = j9MethodPointer.add(i);
            J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(j9MethodPointer2);
            boolean bl2 = J9ROMMethodHelper.hasVTable(j9ROMMethodPointer);
            if (!this.findROMMethodInClass(j9JavaVMPointer, j9ROMClassPointer, j9ROMMethodPointer, n2)) {
                this.reportError(printStream, "romMethod=0x%s (ramMethod=0x%s) not found in romClass=0x%s", Long.toHexString(j9ROMMethodPointer.getAddress()), Long.toHexString(j9MethodPointer2.getAddress()), Long.toHexString(j9ROMClassPointer.getAddress()));
            }
            if (!bl && bl2 && !this.findMethodInVTable(j9MethodPointer2, j9ClassPointer)) {
                this.reportError(printStream, "romMethod=0x%s (ramMethod=0x%s) not found in vTable of ramClass=0x%s", Long.toHexString(j9ROMMethodPointer.getAddress()), Long.toHexString(j9MethodPointer2.getAddress()), Long.toHexString(j9ClassPointer.getAddress()));
            }
            if (!j9ConstantPoolPointer.eq(ConstantPoolHelpers.J9_CP_FROM_METHOD(j9MethodPointer2))) {
                this.reportError(printStream, "ramConstantPool=0x%s on ramMethod=0x%s not equal to ramConstantPool=0x%s on ramClass=0x%s", Long.toHexString(ConstantPoolHelpers.J9_CP_FROM_METHOD(j9MethodPointer2).getAddress()), Long.toHexString(j9MethodPointer2.getAddress()), Long.toHexString(j9ConstantPoolPointer.getAddress()), Long.toHexString(j9ClassPointer.getAddress()));
            }
            ++n;
        }
        return n;
    }

    private boolean findMethodInVTable(J9MethodPointer j9MethodPointer, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        long l;
        UDATAPointer uDATAPointer;
        long l2;
        if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
            J9VTableHeaderPointer j9VTableHeaderPointer = J9ClassHelper.vTableHeader(j9ClassPointer);
            l2 = j9VTableHeaderPointer.size().longValue();
            uDATAPointer = J9ClassHelper.vTable(j9VTableHeaderPointer);
            l = 0L;
        } else {
            uDATAPointer = J9ClassHelper.oldVTable(j9ClassPointer);
            l2 = uDATAPointer.at(0L).longValue() + 1L;
            l = 2L;
        }
        while (l < l2) {
            if (j9MethodPointer.eq(J9MethodPointer.cast(uDATAPointer.at(l)))) {
                return true;
            }
            ++l;
        }
        return false;
    }

    private boolean findROMMethodInClass(J9JavaVMPointer j9JavaVMPointer, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, int n) throws CorruptDataException {
        J9ROMMethodPointer j9ROMMethodPointer2 = j9ROMClassPointer.romMethods();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                j9ROMMethodPointer2 = ROMHelp.nextROMMethod(j9ROMMethodPointer2);
            }
            if (!j9ROMMethodPointer.eq(j9ROMMethodPointer2)) continue;
            return true;
        }
        return false;
    }

    private void checkLocalInternTableSanity(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        J9DbgROMClassBuilderPointer j9DbgROMClassBuilderPointer;
        int n = 0;
        this.reportMessage(printStream, "Checking ROM intern string nodes", new Object[0]);
        J9TranslationBufferSetPointer j9TranslationBufferSetPointer = j9JavaVMPointer.dynamicLoadBuffers();
        if (j9TranslationBufferSetPointer.notNull() && (j9DbgROMClassBuilderPointer = J9DbgROMClassBuilderPointer.cast(j9TranslationBufferSetPointer.romClassBuilder())).notNull()) {
            J9DbgStringInternTablePointer j9DbgStringInternTablePointer = j9DbgROMClassBuilderPointer.stringInternTable();
            J9InternHashTableEntryPointer j9InternHashTableEntryPointer = j9DbgStringInternTablePointer.headNode();
            while (j9InternHashTableEntryPointer.notNull()) {
                J9UTF8Pointer j9UTF8Pointer = j9InternHashTableEntryPointer.utf8();
                J9ClassLoaderPointer j9ClassLoaderPointer = j9InternHashTableEntryPointer.classLoader();
                if (!this.verifyUTF8(j9UTF8Pointer)) {
                    this.reportError(printStream, "invalid utf8=0x%s for node=0x%s", Long.toHexString(j9UTF8Pointer.getAddress()), Long.toHexString(j9InternHashTableEntryPointer.getAddress()));
                }
                if (!this.verifyJ9ClassLoader(j9JavaVMPointer, j9ClassLoaderPointer)) {
                    this.reportError(printStream, "invalid classLoader=0x%s for node=0x%s", Long.toHexString(j9ClassLoaderPointer.getAddress()), Long.toHexString(j9InternHashTableEntryPointer.getAddress()));
                }
                ++n;
                j9InternHashTableEntryPointer = j9InternHashTableEntryPointer.nextNode();
            }
        }
        this.reportMessage(printStream, "Checking %d ROM intern string nodes done", n);
    }

    private boolean verifyJ9ClassLoader(J9JavaVMPointer j9JavaVMPointer, J9ClassLoaderPointer j9ClassLoaderPointer) throws CorruptDataException {
        GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
        while (gCClassLoaderIterator.hasNext()) {
            J9ClassLoaderPointer j9ClassLoaderPointer2 = gCClassLoaderIterator.next();
            if (!j9ClassLoaderPointer2.eq(j9ClassLoaderPointer)) continue;
            return true;
        }
        return false;
    }
}

