/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;

public class JCJavaLocation
implements JavaLocation {
    private final JavaMethod fMethod;
    private ImagePointer fAddress;
    private int fCompilationLevel;
    private String fFileName;
    private int fLineNumber;

    public JCJavaLocation(JavaMethod javaMethod) throws JCInvalidArgumentsException {
        if (javaMethod == null) {
            throw new JCInvalidArgumentsException("A java location must be associated with a java method");
        }
        this.fMethod = javaMethod;
        this.fAddress = null;
        this.fCompilationLevel = -1;
        this.fFileName = null;
        this.fLineNumber = -1;
    }

    @Override
    public ImagePointer getAddress() throws CorruptDataException {
        if (this.fAddress == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fAddress;
    }

    public void setAddress(ImagePointer imagePointer) {
        this.fAddress = imagePointer;
    }

    @Override
    public int getCompilationLevel() throws CorruptDataException {
        if (this.fCompilationLevel == -1) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fCompilationLevel;
    }

    public void setCompilation(String string) {
        this.fCompilationLevel = "compiled".equals(string) ? 1 : 0;
    }

    @Override
    public String getFilename() throws DataUnavailable, CorruptDataException {
        if (this.fFileName == null) {
            throw new DataUnavailable();
        }
        return this.fFileName;
    }

    public void setFilename(String string) {
        this.fFileName = string;
    }

    @Override
    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        if (this.fLineNumber == -1) {
            throw new DataUnavailable();
        }
        return this.fLineNumber;
    }

    public void setLineNumber(int n) {
        this.fLineNumber = n;
    }

    @Override
    public JavaMethod getMethod() throws CorruptDataException {
        if (this.fMethod == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fMethod;
    }

    @Override
    public String toString() {
        String string = null;
        try {
            String string2 = this.getMethod().getDeclaringClass().getName();
            string2 = string2.replace('/', '.');
            String string3 = this.getMethod().getName();
            String string4 = null;
            try {
                String string5 = this.getFilename();
                int n = this.getLineNumber();
                string4 = "(" + string5 + ":" + n + ")";
            }
            catch (DTFJException dTFJException) {
                string4 = "()";
            }
            string = string2 + "." + string3 + string4;
        }
        catch (CorruptDataException corruptDataException) {
            string = "(corrupt)";
        }
        catch (DataUnavailable dataUnavailable) {
            string = "(data unavailable)";
        }
        return string;
    }
}

