/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapBaseCommand;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePoint;
import com.ibm.jvm.trace.format.api.TracePointImpl;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SnapFormatCommand
extends SnapBaseCommand {
    private TraceContext traceContext = null;
    private final List<InputStream> messageFiles = new ArrayList<InputStream>();
    private boolean outputHeader = true;
    private static final String[] MESSAGEFILENAMES = new String[]{"TraceFormat.dat", "J9TraceFormat.dat", "OMRTraceFormat.dat"};
    private static final String[] DEFAULTMESSAGEFILEPATHS = new String[]{System.getProperty("user.dir"), System.getProperty("java.home") + File.separator + "lib"};

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        void var14_44;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        TraceFilterExpression traceFilterExpression = null;
        if (stringArray.length == 0) {
            string2 = null;
        } else if (stringArray.length == 1) {
            string2 = stringArray[0];
        } else {
            void object;
            boolean n = false;
            while (object < stringArray.length - 1) {
                String string6 = stringArray[object++];
                String string7 = stringArray[object++];
                if ("-f".equals(string6)) {
                    string2 = string7;
                    continue;
                }
                if ("-d".equals(string6)) {
                    string3 = string7;
                    continue;
                }
                if ("-t".equals(string6)) {
                    string4 = string7;
                    this.outputHeader = false;
                    continue;
                }
                if (!"-s".equals(string6)) continue;
                traceFilterExpression = TraceFilterExpression.parseExpression(string7);
                this.outputHeader = false;
            }
        }
        if (string3 != null) {
            string5 = string3;
            for (String string8 : MESSAGEFILENAMES) {
                File file = new File(string3, string8);
                if (!file.exists()) continue;
                try {
                    this.messageFiles.add(new FileInputStream(file));
                    arrayList.add(string8);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        } else {
            for (String string9 : MESSAGEFILENAMES) {
                InputStream inputStream = TraceContext.class.getResourceAsStream('/' + string9);
                if (inputStream == null) continue;
                this.messageFiles.add(inputStream);
                arrayList.add(TraceContext.class.getResource('/' + string9).toString());
            }
            if (this.messageFiles.isEmpty()) {
                for (String string10 : DEFAULTMESSAGEFILEPATHS) {
                    for (String string11 : MESSAGEFILENAMES) {
                        File file = new File(string10, string11);
                        if (!file.exists()) continue;
                        try {
                            this.messageFiles.add(new FileInputStream(file));
                            arrayList.add(string11);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (this.messageFiles.isEmpty()) continue;
                    string5 = string10;
                    break;
                }
            }
        }
        if (this.messageFiles.isEmpty()) {
            void var14_41;
            String string12 = "Unable to find any of";
            String[] stringArray2 = MESSAGEFILENAMES;
            int n = stringArray2.length;
            boolean bl = false;
            while (var14_41 < n) {
                void var11_18;
                String string13 = stringArray2[var14_41];
                printStream.printf("%s %s", var11_18, string13);
                String string14 = ",";
                ++var14_41;
            }
            if (string5 != null) {
                printStream.printf(" in %s%n", string5);
            } else {
                printStream.printf(" in %s or %s%n", DEFAULTMESSAGEFILEPATHS[0], DEFAULTMESSAGEFILEPATHS[1]);
            }
            return;
        }
        String string15 = "Formatting trace using format dat files";
        for (String string16 : arrayList) {
            void var11_21;
            printStream.printf("%s %s", var11_21, string16);
            String string17 = ",";
        }
        if (string5 != null) {
            printStream.printf(" from %s%n", string5);
        } else {
            printStream.println();
        }
        if (this.outputHeader) {
            this.extractTraceData(context, printStream);
        } else {
            PrintStream printStream2 = new PrintStream(new OutputStream(){

                @Override
                public void write(int n) {
                }
            });
            this.extractTraceData(context, printStream2);
        }
        if (this.traceContext == null) {
            printStream.println("Unable to create trace context, command failed.");
            return;
        }
        long l = 0L;
        if (string4 != null) {
            boolean bl = context.process.bytesPerPointer() == 8;
            l = CommandUtils.parsePointer(string4, bl);
        }
        PrintStream printStream3 = printStream;
        Object var14_42 = null;
        if (string2 != null) {
            try {
                PrintStream printStream4;
                printStream3 = printStream4 = new PrintStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                printStream.printf("Unable to write formatted trace to file %s\n", string2);
            }
        }
        if (this.outputHeader) {
            printStream3.println(this.traceContext.summary());
        }
        try {
            void var15_58;
            Object var15_54 = null;
            if (string4 != null) {
                Iterator iterator = this.traceContext.getThreads();
                int n = 0;
                while (iterator.hasNext()) {
                    String string11;
                    string11 = (TraceThread)iterator.next();
                    if (string11.getThreadID() != l) continue;
                    n = 1;
                    Iterator iterator2 = string11.getIterator();
                }
                if (n == 0) {
                    printStream.printf("Unable to find thread %s in trace data\n", string4);
                }
            } else {
                Iterator iterator = this.traceContext.getTracepoints();
            }
            if (var15_58 != null) {
                int n = this.printTracePoints(printStream3, (Iterator<TracePoint>)var15_58, traceFilterExpression);
                printStream.printf("Completed processing of %d tracepoints with %d warnings and %d errors\n", this.traceContext.getTotalTracePoints(), this.traceContext.getWarningCount(), this.traceContext.getErrorCount());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (var14_44 != null) {
            printStream.println("Snap trace written to: " + string2);
            var14_44.close();
        }
    }

    private int printTracePoints(PrintStream printStream, Iterator<TracePoint> iterator, TraceFilterExpression traceFilterExpression) {
        int n = 0;
        TraceThread traceThread = null;
        while (iterator.hasNext()) {
            TracePoint tracePoint = iterator.next();
            TracePointImpl tracePointImpl = null;
            if (tracePoint instanceof TracePointImpl) {
                tracePointImpl = (TracePointImpl)tracePoint;
            }
            if (tracePointImpl == null || traceFilterExpression != null && !traceFilterExpression.matches((TracePoint)tracePointImpl)) continue;
            TraceThread traceThread2 = tracePointImpl.getThread();
            String string = tracePointImpl.getComponentName();
            int n2 = tracePointImpl.getID();
            String string2 = tracePointImpl.getContainerComponent();
            ++n;
            String string3 = "";
            try {
                string3 = tracePointImpl.getFormattedParameters();
                if (string3 == null || string3.length() == 0) {
                    this.traceContext.error((Object)this.traceContext, (Object)("null parameter data for trace point " + string + "." + n2));
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                this.traceContext.error((Object)this.traceContext, (Object)("Underflow accessing parameter data for trace point " + string + "." + n2));
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(tracePointImpl.getFormattedTime());
            stringBuilder.append(" ").append(traceThread2 != traceThread ? "*" : " ");
            stringBuilder.append(String.format("0x%X", traceThread2.getThreadID()));
            stringBuilder.append(" ");
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append(string2 != null ? "(" + string2 + ")" : "").append(".").append(n2);
            stringBuilder.append(String.format("%-20s", stringBuilder2.toString()));
            stringBuilder.append(" ");
            stringBuilder.append(tracePointImpl.getType());
            stringBuilder.append(string3.length() > 0 ? (string3.charAt(0) == '*' ? " " : "") + string3 : "");
            traceThread = traceThread2;
            printStream.println(stringBuilder.toString());
        }
        return n;
    }

    @Override
    protected void writeHeaderBytesToTrace(Context context, byte[] byArray, PrintStream printStream) {
        try {
            this.traceContext = TraceContext.getContext((byte[])byArray, (int)byArray.length, (InputStream)this.messageFiles.get(0));
            int n = this.messageFiles.size();
            for (int i = 1; i < n; ++i) {
                this.traceContext.addMessageData(this.messageFiles.get(i));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    protected void writeBytesToTrace(Context context, long l, int n, PrintStream printStream) {
        if (this.traceContext == null) {
            printStream.println("Error - trace buffer passed before context created.");
            return;
        }
        byte[] byArray = new byte[n];
        try {
            context.process.getBytesAt(l, byArray);
        }
        catch (CorruptDataException corruptDataException) {
            printStream.println("Problem reading " + n + " bytes from 0x" + Long.toHexString(l) + ". Trace file may contain partial or damaged data.");
        }
        this.traceContext.addData(byArray);
    }

    private static final class TraceFilter
    extends TraceFilterExpression {
        private String component = null;
        private String type = null;
        private int idLow = -1;
        private int idHigh = -1;

        public TraceFilter(String string) {
            int n = 0;
            int n2 = string.indexOf(123, n);
            if (-1 == n2) {
                int n3 = string.indexOf(46, n);
                if (-1 == n3) {
                    this.component = string.substring(n);
                } else {
                    this.component = string.substring(n, n3);
                    int n4 = string.indexOf(45, n3);
                    if (-1 == n4) {
                        this.idHigh = this.idLow = Integer.parseInt(string.substring(n3 + 1));
                    } else {
                        this.idLow = Integer.parseInt(string.substring(n3 + 1, n4));
                        this.idHigh = Integer.parseInt(string.substring(n4 + 1));
                    }
                }
            } else {
                this.component = string.substring(n, n2);
                this.type = string.substring(n2 + 1, string.length() - 1);
            }
            if (null != this.component && (0 == this.component.length() || this.component.equalsIgnoreCase("all"))) {
                this.component = null;
            }
        }

        @Override
        public boolean matches(TracePoint tracePoint) {
            boolean bl = true;
            if (null != this.component) {
                if (this.component.equals(tracePoint.getComponent())) {
                    int n;
                    if (-1 != this.idLow && ((n = tracePoint.getID()) < this.idLow || n > this.idHigh)) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            if (bl && null != this.type && !this.type.equalsIgnoreCase(tracePoint.getType().trim())) {
                bl = false;
                String[] stringArray = tracePoint.getGroups();
                if (null != stringArray) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!this.type.equalsIgnoreCase(stringArray[i])) continue;
                        bl = true;
                        break;
                    }
                }
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (null != this.component) {
                stringBuilder.append(this.component);
                if (-1 != this.idLow) {
                    stringBuilder.append(".");
                    stringBuilder.append(this.idLow);
                    if (this.idLow != this.idHigh) {
                        stringBuilder.append("-");
                        stringBuilder.append(this.idHigh);
                    }
                }
            } else {
                stringBuilder.append("all");
            }
            if (null != this.type) {
                stringBuilder.append("{");
                stringBuilder.append(this.type);
                stringBuilder.append("}");
            }
            return stringBuilder.toString();
        }
    }

    private static final class TraceFilterNotExpression
    extends TraceFilterExpression {
        private final TraceFilterExpression expression;

        public TraceFilterNotExpression(TraceFilterExpression traceFilterExpression) {
            this.expression = traceFilterExpression;
        }

        @Override
        public boolean matches(TracePoint tracePoint) {
            return !this.expression.matches(tracePoint);
        }

        public String toString() {
            return "!" + this.expression;
        }
    }

    private static final class TraceFilterAndExpression
    extends TraceFilterExpression {
        private final TraceFilterExpression lhs;
        private final TraceFilterExpression rhs;

        public TraceFilterAndExpression(TraceFilterExpression traceFilterExpression, TraceFilterExpression traceFilterExpression2) {
            this.lhs = traceFilterExpression;
            this.rhs = traceFilterExpression2;
        }

        @Override
        public boolean matches(TracePoint tracePoint) {
            if (this.lhs.matches(tracePoint)) {
                return this.rhs.matches(tracePoint);
            }
            return false;
        }

        public String toString() {
            return "(" + this.lhs + "&" + this.rhs + ")";
        }
    }

    private static final class TraceFilterOrExpression
    extends TraceFilterExpression {
        private final TraceFilterExpression lhs;
        private final TraceFilterExpression rhs;

        public TraceFilterOrExpression(TraceFilterExpression traceFilterExpression, TraceFilterExpression traceFilterExpression2) {
            this.lhs = traceFilterExpression;
            this.rhs = traceFilterExpression2;
        }

        @Override
        public boolean matches(TracePoint tracePoint) {
            return this.lhs.matches(tracePoint) || this.rhs.matches(tracePoint);
        }

        public String toString() {
            return "(" + this.lhs + "|" + this.rhs + ")";
        }
    }

    private static abstract class TraceFilterExpression {
        TraceFilterExpression() {
        }

        public abstract boolean matches(TracePoint var1);

        public static TraceFilterExpression parseExpression(String string) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "()&|!,", true);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (0 == ((String)object).length()) continue;
                if (((String)object).equals(",")) {
                    arrayList.add("|");
                    continue;
                }
                arrayList.add((String)object);
            }
            object = TraceFilterExpression.parseExpression(arrayList);
            if (!arrayList.isEmpty()) {
                throw new IllegalArgumentException("Failed to parse filter expression: unparsed text");
            }
            return object;
        }

        private static TraceFilterExpression parseExpression(List<String> list) {
            String string;
            TraceFilterExpression traceFilterExpression = TraceFilterExpression.parseTerm(list);
            while (!list.isEmpty() && ((string = list.get(0)).equals("|") || string.equals(","))) {
                list.remove(0);
                TraceFilterExpression traceFilterExpression2 = traceFilterExpression;
                TraceFilterExpression traceFilterExpression3 = TraceFilterExpression.parseTerm(list);
                traceFilterExpression = new TraceFilterOrExpression(traceFilterExpression2, traceFilterExpression3);
            }
            return traceFilterExpression;
        }

        private static TraceFilterExpression parseTerm(List<String> list) {
            String string;
            TraceFilterExpression traceFilterExpression = TraceFilterExpression.parsePrimary(list);
            while (!list.isEmpty() && (string = list.get(0)).equals("&")) {
                list.remove(0);
                TraceFilterExpression traceFilterExpression2 = traceFilterExpression;
                TraceFilterExpression traceFilterExpression3 = TraceFilterExpression.parsePrimary(list);
                traceFilterExpression = new TraceFilterAndExpression(traceFilterExpression2, traceFilterExpression3);
            }
            return traceFilterExpression;
        }

        private static TraceFilterExpression parsePrimary(List<String> list) {
            TraceFilterExpression traceFilterExpression = null;
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Failed to parse filter expression: expected expression");
            }
            String string = list.get(0);
            if (string.equals("(")) {
                list.remove(0);
                traceFilterExpression = TraceFilterExpression.parseExpression(list);
                if (list.isEmpty() || !list.get(0).equals(")")) {
                    throw new IllegalArgumentException("Failed to parse filter expression: expected closing parenthesis");
                }
                list.remove(0);
            } else if (string.equals("!")) {
                list.remove(0);
                traceFilterExpression = TraceFilterExpression.parsePrimary(list);
                traceFilterExpression = new TraceFilterNotExpression(traceFilterExpression);
            } else {
                if (string.equals(")") || string.equals("&") || string.equals("|") || string.equals(",")) {
                    throw new IllegalArgumentException("Failed to parse filter expression: expected expression, found " + string);
                }
                list.remove(0);
                traceFilterExpression = new TraceFilter(string);
            }
            return traceFilterExpression;
        }
    }
}

