/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import java.util.NoSuchElementException;

public class GCClassHeapIterator
extends GCIterator {
    private J9ClassPointer classPointer;

    protected GCClassHeapIterator(J9MemorySegmentPointer j9MemorySegmentPointer) throws CorruptDataException {
        this.classPointer = J9ClassPointer.cast(PointerPointer.cast(j9MemorySegmentPointer.heapBase()).at(0L));
    }

    public static GCClassHeapIterator fromJ9MemorySegment(J9MemorySegmentPointer j9MemorySegmentPointer) throws CorruptDataException {
        return new GCClassHeapIterator(j9MemorySegmentPointer);
    }

    @Override
    public boolean hasNext() {
        return this.classPointer.notNull();
    }

    @Override
    public J9ClassPointer next() {
        try {
            if (this.hasNext()) {
                J9ClassPointer j9ClassPointer = this.classPointer;
                this.classPointer = this.classPointer.nextClassInSegment();
                return j9ClassPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Could not set the current class", corruptDataException, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

