/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.IAlgorithm;
import com.ibm.j9ddr.vm29.j9.J9ConfigFlags;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.DebugLocalMap;
import com.ibm.j9ddr.vm29.j9.stackmap.LocalMap;
import com.ibm.j9ddr.vm29.j9.stackmap.StackMap;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.JITStackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9I2JStatePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITDecompilationInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFJ2IFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFJITResolveFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFJNICallInFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFMethodFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFMethodTypeFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFSpecialFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFStackFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMEntryLocalStoragePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaVM;
import com.ibm.j9ddr.vm29.structure.J9SFJ2IFrame;
import com.ibm.j9ddr.vm29.structure.J9SFJNICallInFrame;
import com.ibm.j9ddr.vm29.structure.J9SFStackFrame;
import com.ibm.j9ddr.vm29.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm29.structure.J9StackWalkState;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.LinkedList;

public class StackWalker {
    private static final long LOCALS_ARRAY_UBOUND = 65792L;
    private static IStackWalker impl;
    private static final AlgorithmPicker<IStackWalker> picker;

    public static StackWalkResult walkStackFrames(WalkState walkState) {
        return StackWalker.getImpl().walkStackFrames(walkState);
    }

    public static StackWalkResult walkStackFrames(WalkState walkState, UDATAPointer uDATAPointer, UDATAPointer uDATAPointer2, U8Pointer u8Pointer, J9MethodPointer j9MethodPointer, J9VMEntryLocalStoragePointer j9VMEntryLocalStoragePointer) {
        return StackWalker.getImpl().walkStackFrames(walkState, uDATAPointer, uDATAPointer2, u8Pointer, j9MethodPointer, j9VMEntryLocalStoragePointer);
    }

    static FrameCallbackResult walkFrame(WalkState walkState) throws CorruptDataException {
        return StackWalker.getImpl().walkFrame(walkState);
    }

    public static void walkBytecodeFrameSlots(WalkState walkState, J9MethodPointer j9MethodPointer, UDATA uDATA, UDATAPointer uDATAPointer, UDATA uDATA2, UDATAPointer uDATAPointer2, UDATA uDATA3) throws CorruptDataException {
        StackWalker.getImpl().walkBytecodeFrameSlots(walkState, j9MethodPointer, uDATA, uDATAPointer, uDATA2, uDATAPointer2, uDATA3);
    }

    private static IStackWalker getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    static {
        picker = new AlgorithmPicker<IStackWalker>("ALG_STACKWALKER_VERSION"){

            @Override
            protected Iterable<? extends IStackWalker> allAlgorithms() {
                LinkedList<StackWalker_29_V0> linkedList = new LinkedList<StackWalker_29_V0>();
                linkedList.add(new StackWalker_29_V0());
                return linkedList;
            }
        };
    }

    private static class StackWalker_29_V0
    extends BaseAlgorithm
    implements IStackWalker {
        protected StackWalker_29_V0() {
            super(90, 0);
        }

        @Override
        public StackWalkResult walkStackFrames(WalkState walkState) {
            try {
                return this.walkStackFrames(walkState, walkState.walkThread.sp(), walkState.walkThread.arg0EA(), walkState.walkThread.pc(), walkState.walkThread.literals(), walkState.walkThread.entryLocalStorage());
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CDE thrown extracting initial stack walk state. walkThread = " + walkState.walkThread.getHexAddress(), corruptDataException, true);
                return StackWalkResult.STACK_CORRUPT;
            }
        }

        @Override
        public StackWalkResult walkStackFrames(WalkState walkState, UDATAPointer uDATAPointer, UDATAPointer uDATAPointer2, U8Pointer u8Pointer, J9MethodPointer j9MethodPointer, J9VMEntryLocalStoragePointer j9VMEntryLocalStoragePointer) {
            Object object;
            UDATAPointer uDATAPointer3 = null;
            U8Pointer u8Pointer2 = null;
            StackWalkResult stackWalkResult = null;
            try {
                stackWalkResult = walkState.walkThread.privateFlags().anyBitsIn(J9Consts.J9_PRIVATE_FLAGS_STACK_CORRUPT) ? StackWalkResult.STACK_CORRUPT : StackWalkResult.NONE;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CDE thrown extracting walkThread privateFlags. walkThread = " + walkState.walkThread.getHexAddress(), corruptDataException, true);
                return StackWalkResult.STACK_CORRUPT;
            }
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            StackWalkerUtils.resetOSlotsCorruptionThreshold();
            if ((walkState.flags & J9Consts.J9_STACKWALK_SAVE_STACKED_REGISTERS) != 0L) {
                throw new UnsupportedOperationException("J9_STACKWALK_SAVE_STACKED_REGISTERS not supported by offline walker");
            }
            try {
                walkState.framesWalked = 0L;
                walkState.previousFrameFlags = new UDATA(0L);
                walkState.searchFrameFound = false;
                walkState.arg0EA = uDATAPointer2;
                walkState.pc = u8Pointer;
                walkState.pcAddress = walkState.walkThread.pcEA();
                walkState.walkSP = uDATAPointer;
                walkState.literals = j9MethodPointer;
                walkState.argCount = new UDATA(0L);
                walkState.frameFlags = new UDATA(0L);
                if (J9BuildFlags.interp_nativeSupport) {
                    walkState.jitInfo = J9JITExceptionTablePointer.NULL;
                    walkState.inlineDepth = 0L;
                    walkState.inlinerMap = null;
                    walkState.walkedEntryLocalStorage = j9VMEntryLocalStoragePointer;
                    walkState.i2jState = walkState.walkedEntryLocalStorage.notNull() ? walkState.walkedEntryLocalStorage.i2jState() : null;
                    walkState.j2iFrame = walkState.walkThread.j2iFrame();
                    if (J9BuildFlags.jit_fullSpeedDebug) {
                        walkState.decompilationStack = walkState.walkThread.decompilationStack();
                        walkState.decompilationRecord = J9JITDecompilationInfoPointer.NULL;
                        walkState.resolveFrameFlags = new UDATA(0L);
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CDE thrown extracting initial stack walk state. walkThread = " + walkState.walkThread.getHexAddress(), corruptDataException, true);
                return StackWalkResult.STACK_CORRUPT;
            }
            try {
                long l;
                J9JITExceptionTablePointer j9JITExceptionTablePointer;
                object = J9ThreadHelper.getOSThread(walkState.walkThread.osThread());
                if (object != null && !(j9JITExceptionTablePointer = JITStackWalker.jitGetExceptionTableFromPC(walkState.walkThread, U8Pointer.cast(l = object.getInstructionPointer()))).isNull()) {
                    UDATAPointer uDATAPointer4 = UDATAPointer.NULL;
                    String string = "";
                    if (J9ConfigFlags.arch_power) {
                        string = "gpr14";
                    } else if (J9ConfigFlags.arch_s390) {
                        string = "r5";
                    } else if (J9ConfigFlags.arch_x86) {
                        string = J9BuildFlags.env_data64 ? "rsp" : "esp";
                    } else if (J9ConfigFlags.arch_aarch64) {
                        string = "r20";
                    } else {
                        throw new IllegalArgumentException("Unsupported platform");
                    }
                    for (IRegister iRegister : object.getRegisters()) {
                        if (!iRegister.getName().equalsIgnoreCase(string)) continue;
                        uDATAPointer4 = UDATAPointer.cast(iRegister.getValue().longValue());
                        break;
                    }
                    if (!uDATAPointer4.isNull()) {
                        walkState.sp = walkState.walkSP = uDATAPointer4;
                        walkState.pc = U8Pointer.cast(l);
                        walkState.flags = walkState.flags | J9Consts.J9_STACKWALK_START_AT_JIT_FRAME | J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
                    }
                }
            }
            catch (Exception exception) {
                corruptDataException = null;
                corruptDataException = exception instanceof CorruptDataException ? (CorruptDataException)exception : new CorruptDataException(exception);
                EventManager.raiseCorruptDataEvent("CDE thrown while checking or fixing up JIT frames, attempting to walk without fixup", corruptDataException, true);
                return StackWalkResult.STACK_CORRUPT;
            }
            StackWalkerUtils.swPrintf(walkState, 1, "*** BEGIN STACK WALK, flags = {0} walkThread = {1} ***", String.format("%08X", walkState.flags), walkState.walkThread.getHexAddress());
            if ((walkState.flags & J9Consts.J9_STACKWALK_START_AT_JIT_FRAME) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tSTART_AT_JIT_FRAME", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tCOUNT_SPECIFIED", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_ARRAYLET_LEAVES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tINCLUDE_ARRAYLET_LEAVES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_NATIVES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tINCLUDE_NATIVES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_CALL_IN_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tINCLUDE_CALL_IN_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_HIDDEN_JIT_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_HIDDEN_JIT_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_O_SLOTS", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tITERATE_METHOD_CLASS_SLOTS", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tMAINTAIN_REGISTER_MAP", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_SKIP_INLINES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tSKIP_INLINES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_VISIBLE_ONLY) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tVISIBLE_ONLY", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_HIDE_EXCEPTION_FRAMES) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tHIDE_EXCEPTION_FRAMES", new Object[0]);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET) != 0L) {
                StackWalkerUtils.swPrintf(walkState, 2, "\tRECORD_BYTECODE_PC_OFFSET", new Object[0]);
            }
            StackWalkerUtils.swPrintf(walkState, 2, "Initial values: walkSP = " + walkState.walkSP.getHexAddress() + ", PC = " + walkState.pc.getHexAddress() + ", literals = " + walkState.literals.getHexAddress() + ", A0 = " + walkState.arg0EA.getHexAddress() + ", j2iFrame = " + (J9BuildFlags.interp_nativeSupport ? walkState.j2iFrame.getHexAddress() : "0") + ", ELS = " + (J9BuildFlags.interp_nativeSupport ? walkState.walkedEntryLocalStorage.getHexAddress() : "0") + ", decomp = " + (J9BuildFlags.jit_fullSpeedDebug ? walkState.decompilationStack.getHexAddress() : "0"), new Object[0]);
            if ((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) != 0L && walkState.maxFrames == 0L) {
                bl2 = false;
            }
            if (J9BuildFlags.interp_nativeSupport) {
                if (walkState.flags == J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) {
                    walkState.flags |= J9Consts.J9_STACKWALK_SKIP_INLINES;
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    walkState.flags |= J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP;
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_START_AT_JIT_FRAME) != 0L) {
                    bl3 = true;
                }
            }
            if ((walkState.flags & (J9Consts.J9_STACKWALK_ITERATE_FRAMES | J9Consts.J9_STACKWALK_ITERATE_O_SLOTS)) != 0L && walkState.callBacks == null) {
                throw new NullPointerException("User requested iterate frames or slots and didn't provide a callback. See WalkState.callBacks.");
            }
            try {
                while (bl2) {
                    StackWalkerUtils.swPrintf(walkState, 200, "Top of WALKING_LOOP", new Object[0]);
                    if (!bl3) {
                        walkState.constantPool = J9ConstantPoolPointer.NULL;
                        walkState.unwindSP = UDATAPointer.NULL;
                        walkState.method = J9MethodPointer.NULL;
                        walkState.sp = walkState.walkSP.sub(walkState.argCount);
                        walkState.outgoingArgCount = walkState.argCount;
                        walkState.bytecodePCOffset = U8Pointer.cast(-1L);
                        if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_END_OF_STACK) {
                            StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: End of Stack", new Object[0]);
                            bl = true;
                            break;
                        }
                        if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_GENERIC_SPECIAL) {
                            StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: Generic Special", new Object[0]);
                            this.walkGenericSpecialFrame(walkState);
                        } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_METHOD || walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_NATIVE_METHOD || walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD) {
                            StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: walkMethodFrame", new Object[0]);
                            this.walkMethodFrame(walkState);
                        } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_METHODTYPE) {
                            StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: MethodType", new Object[0]);
                            this.walkMethodTypeFrame(walkState);
                        } else if (J9BuildFlags.interp_nativeSupport && walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JIT_RESOLVE) {
                            StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: JIT Resolve", new Object[0]);
                            this.walkJITResolveFrame(walkState);
                        } else if (J9BuildFlags.interp_nativeSupport && walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JIT_JNI_CALLOUT) {
                            StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: JIT_JNI_CALLOUT", new Object[0]);
                            this.walkJITJNICalloutFrame(walkState);
                        } else {
                            StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: default", new Object[0]);
                            if (new UDATA(walkState.pc.getAddress()).lte(new U8(J9SFStackFrame.J9SF_MAX_SPECIAL_FRAME_TYPE))) {
                                this.printFrameType(walkState, "Unknown");
                                StackWalkerUtils.swPrintf(walkState, 0, "Aborting walk due to unknown special frame type", new Object[0]);
                                break;
                            }
                            if (walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC()) || walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC().addOffset(3L))) {
                                StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: default: walkJNICallInFrame", new Object[0]);
                                this.walkJNICallInFrame(walkState);
                            } else {
                                StackWalkerUtils.swPrintf(walkState, 200, "PC Switch: default: walkBytecodeFrame", new Object[0]);
                                this.walkBytecodeFrame(walkState);
                            }
                        }
                        UDATA uDATA = new UDATA(walkState.bp.getAddress());
                        uDATA = uDATA.sub(J9SFStackFrame.SIZEOF);
                        uDATA = uDATA.add(UDATA.SIZEOF);
                        J9SFStackFramePointer j9SFStackFramePointer = J9SFStackFramePointer.cast(uDATA);
                        u8Pointer2 = j9SFStackFramePointer.savedPC();
                        if (this.walkFrame(walkState) != FrameCallbackResult.KEEP_ITERATING) break;
                        walkState.previousFrameFlags = walkState.frameFlags;
                        walkState.resolveFrameFlags = new UDATA(0L);
                    }
                    if (J9BuildFlags.interp_nativeSupport && (bl3 || (walkState.frameFlags.longValue() & J9StackWalkConstants.J9_STACK_FLAGS_JIT_TRANSITION_TO_INTERPRETER_MASK) != 0L)) {
                        bl3 = false;
                        if (JITStackWalker.jitWalkStackFrames(walkState) == FrameCallbackResult.KEEP_ITERATING) {
                            walkState.decompilationRecord = J9JITDecompilationInfoPointer.NULL;
                            continue;
                        }
                        break;
                    }
                    object = J9SFStackFramePointer.cast(walkState.bp.subOffset(J9SFStackFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                    J9MethodPointer j9MethodPointer2 = ((J9SFStackFramePointer)object).savedCP();
                    uDATAPointer3 = UDATAPointer.cast(((J9SFStackFramePointer)object).savedA0()).untag();
                    walkState.pcAddress = ((J9SFStackFramePointer)object).savedPCEA();
                    walkState.walkSP = walkState.arg0EA.add(1L);
                    walkState.pc = u8Pointer2;
                    walkState.literals = j9MethodPointer2;
                    walkState.arg0EA = uDATAPointer3;
                }
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CorruptDataException thrown walking stack. walkThread = " + walkState.walkThread.getHexAddress(), corruptDataException, false);
                return StackWalkResult.STACK_CORRUPT;
            }
            if (bl) {
                StackWalkerUtils.swPrintf(walkState, 2, "<end of stack>", new Object[0]);
            }
            if (StackWalkerUtils.oSlotsCorruptionThresholdReached() && stackWalkResult == StackWalkResult.NONE) {
                stackWalkResult = StackWalkResult.STACK_CORRUPT;
            }
            StackWalkerUtils.swPrintf(walkState, 1, "*** END STACK WALK (rc = {0}) ***", new Object[]{stackWalkResult});
            return stackWalkResult;
        }

        private void walkMethodFrame(WalkState walkState) throws CorruptDataException {
            block21: {
                J9SFMethodFramePointer j9SFMethodFramePointer = J9SFMethodFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
                walkState.bp = UDATAPointer.cast(j9SFMethodFramePointer.savedA0EA());
                walkState.frameFlags = j9SFMethodFramePointer.specialFrameFlags();
                walkState.method = j9SFMethodFramePointer.method();
                walkState.unwindSP = UDATAPointer.cast(j9SFMethodFramePointer);
                try {
                    if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_METHOD) {
                        this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT generic transition" : "Generic method");
                    } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_NATIVE_METHOD) {
                        this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT INL transition" : "INL native method");
                    } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD) {
                        this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT JNI transition" : "JNI native method");
                    } else {
                        this.printFrameType(walkState, walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_NATIVE_TRANSITION) ? "JIT unknown transition" : "Unknown method");
                    }
                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L && walkState.literals.notNull()) {
                        if (walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_JNI_REFS_REDIRECTED)) {
                            this.walkPushedJNIRefs(walkState);
                        } else {
                            this.walkObjectPushes(walkState);
                        }
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkMethodFrame", corruptDataException);
                }
                if (walkState.method.notNull()) {
                    J9ROMMethodPointer j9ROMMethodPointer = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(walkState.method);
                    walkState.constantPool = ConstantPoolHelpers.J9_CP_FROM_METHOD(walkState.method);
                    walkState.argCount = new UDATA(j9ROMMethodPointer.argCount());
                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                        try {
                            StackWalkerUtils.WALK_METHOD_CLASS(walkState);
                            if (walkState.argCount.longValue() == 0L) break block21;
                            int[] nArray = new int[8];
                            StackWalkerUtils.swPrintf(walkState, 4, "\tUsing signature mapper", new Object[0]);
                            LocalMap.j9localmap_ArgBitsForPC0(j9ROMMethodPointer, nArray);
                            StackWalkerUtils.swPrintf(walkState, 4, "\tArguments starting at {0} for {1} slots", walkState.arg0EA.getHexAddress(), walkState.argCount);
                            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
                            walkState.slotIndex = 0;
                            if (walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_JNI_REFS_REDIRECTED)) {
                                this.walkIndirectDescribedPushes(walkState, walkState.arg0EA, walkState.argCount.intValue(), nArray);
                                break block21;
                            }
                            this.walkDescribedPushes(walkState, walkState.arg0EA, walkState.argCount.intValue(), nArray, walkState.argCount.intValue());
                        }
                        catch (CorruptDataException corruptDataException) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkMethodFrame", corruptDataException);
                        }
                    }
                } else {
                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L && !walkState.arg0EA.eq(walkState.bp)) {
                        try {
                            this.walkJNIRefs(walkState, walkState.bp.add(1L), walkState.arg0EA.sub(walkState.bp).intValue());
                        }
                        catch (CorruptDataException corruptDataException) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkMethodFrame", corruptDataException);
                        }
                        catch (InvalidDataTypeException invalidDataTypeException) {
                            CorruptDataException corruptDataException = new CorruptDataException("Corruption walking JNI references", invalidDataTypeException);
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkMethodFrame", corruptDataException);
                        }
                    }
                    walkState.constantPool = null;
                    walkState.argCount = new UDATA(0L);
                }
            }
        }

        private void walkMethodTypeFrame(WalkState walkState) throws CorruptDataException {
            J9SFMethodTypeFramePointer j9SFMethodTypeFramePointer = J9SFMethodTypeFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
            walkState.bp = UDATAPointer.cast(j9SFMethodTypeFramePointer.savedA0EA());
            walkState.frameFlags = j9SFMethodTypeFramePointer.specialFrameFlags();
            this.printFrameType(walkState, "MethodType");
            walkState.method = J9MethodPointer.NULL;
            walkState.unwindSP = UDATAPointer.cast(j9SFMethodTypeFramePointer);
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                int[] nArray = new int[8];
                U32Pointer u32Pointer = U32Pointer.cast(walkState.bp.add(1L));
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = u32Pointer.at(0L).intValue();
                    u32Pointer.add(1L);
                }
                if (walkState.literals.notNull()) {
                    this.walkObjectPushes(walkState);
                }
                StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(j9SFMethodTypeFramePointer.methodType()));
                walkState.argCount = j9SFMethodTypeFramePointer.argStackSlots().add(1L);
                walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
                walkState.slotIndex = 0;
                this.walkDescribedPushes(walkState, walkState.arg0EA, walkState.argCount.intValue(), nArray, walkState.argCount.intValue());
            }
        }

        private void walkJNIRefs(WalkState walkState, UDATAPointer uDATAPointer, int n) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 4, "\tJNI local ref pushes starting at {0} for {1} slots", uDATAPointer.getHexAddress(), n);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_JNI_LOCAL;
            walkState.slotIndex = 0;
            do {
                if (uDATAPointer.at(0L).anyBitsIn(1L)) {
                    PointerPointer pointerPointer = PointerPointer.cast(uDATAPointer.at(0L).bitAnd(new UDATA(1L).bitNot()));
                    StackWalkerUtils.WALK_NAMED_INDIRECT_O_SLOT(walkState, pointerPointer, VoidPointer.cast(uDATAPointer), "Indir-Lcl-JNI-Ref");
                } else {
                    StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(uDATAPointer), "Lcl-JNI-Ref");
                }
                uDATAPointer = uDATAPointer.add(1L);
                ++walkState.slotIndex;
            } while (--n > 0);
        }

        private void walkIndirectDescribedPushes(WalkState walkState, UDATAPointer uDATAPointer, int n, int[] nArray) throws CorruptDataException {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n > 0) {
                if (n2 == 0) {
                    n3 = nArray[n4++];
                    n2 = 32;
                }
                if (n3 & true) {
                    StackWalkerUtils.WALK_INDIRECT_O_SLOT(walkState, PointerPointer.cast(uDATAPointer.at(0L).bitAnd(new UDATA(1L).bitNot())), VoidPointer.cast(uDATAPointer));
                } else if (AlgorithmVersion.getVersionOf("VM_STACK_GROW_VERSION").getAlgorithmVersion() >= 1) {
                    StackWalkerUtils.WALK_I_SLOT(walkState, PointerPointer.cast(uDATAPointer));
                } else {
                    StackWalkerUtils.WALK_INDIRECT_I_SLOT(walkState, PointerPointer.cast(uDATAPointer.at(0L).bitAnd(new UDATA(1L).bitNot())), VoidPointer.cast(uDATAPointer));
                }
                n3 >>= 1;
                --n2;
                uDATAPointer = uDATAPointer.sub(1L);
                --n;
                ++walkState.slotIndex;
            }
        }

        private void walkObjectPushes(WalkState walkState) throws CorruptDataException {
            UDATA uDATA = UDATA.cast(walkState.literals);
            PointerPointer pointerPointer = PointerPointer.cast(walkState.walkSP);
            StackWalkerUtils.swPrintf(walkState, 4, "\tObject pushes starting at {0} for {1} slots", pointerPointer.getHexAddress(), uDATA.longValue() / (long)UDATA.SIZEOF);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
            walkState.slotIndex = 0;
            while (!uDATA.eq(0L)) {
                StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, pointerPointer, "Push");
                pointerPointer = pointerPointer.add(1L);
                uDATA = uDATA.sub(UDATA.SIZEOF);
                ++walkState.slotIndex;
            }
        }

        private void walkPushedJNIRefs(WalkState walkState) throws CorruptDataException {
            UDATA uDATA = walkState.frameFlags.bitAnd(J9Consts.J9_SSF_JNI_PUSHED_REF_COUNT_MASK);
            UDATA uDATA2 = new UDATA(walkState.literals.getAddress() / (long)UDATA.SIZEOF).sub(uDATA);
            if (!uDATA2.eq(0L)) {
                walkState.literals = J9MethodPointer.cast(uDATA2.longValue() * (long)UDATA.SIZEOF);
                this.walkObjectPushes(walkState);
            }
            if (!uDATA.eq(0L)) {
                this.walkJNIRefs(walkState, walkState.walkSP.add(uDATA2), uDATA.intValue());
            }
        }

        @Override
        public FrameCallbackResult walkFrame(WalkState walkState) throws CorruptDataException {
            Object object;
            if ((walkState.flags & J9Consts.J9_STACKWALK_VISIBLE_ONLY) != 0L) {
                if ((UDATA.cast(walkState.pc).eq(J9SFStackFrame.J9SF_FRAME_TYPE_NATIVE_METHOD) || UDATA.cast(walkState.pc).eq(J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD)) && (walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_NATIVES) == 0L) {
                    return FrameCallbackResult.KEEP_ITERATING;
                }
                if (!(J9BuildFlags.interp_nativeSupport && !walkState.jitInfo.isNull() || !walkState.bp.at(0L).anyBitsIn(J9SFStackFrame.J9SF_A0_INVISIBLE_TAG) || (walkState.flags & J9Consts.J9_STACKWALK_INCLUDE_CALL_IN_FRAMES) != 0L && walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC()))) {
                    return FrameCallbackResult.KEEP_ITERATING;
                }
                if (walkState.skipCount > 0) {
                    --walkState.skipCount;
                    return FrameCallbackResult.KEEP_ITERATING;
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_HIDE_EXCEPTION_FRAMES) != 0L && !(object = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(walkState.method)).modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic)) {
                    if (J9UTF8Helper.stringValue(object.nameAndSignature().name()).charAt(0) == '<' && walkState.arg0EA.at(0L).eq(UDATA.cast(walkState.restartException))) {
                        return FrameCallbackResult.KEEP_ITERATING;
                    }
                    walkState.flags &= J9Consts.J9_STACKWALK_HIDE_EXCEPTION_FRAMES ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            ++walkState.framesWalked;
            if (((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) == 0L || walkState.framesWalked != walkState.maxFrames) && (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_FRAMES) == 0L) {
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_FRAMES) != 0L) {
                object = walkState.callBacks.frameWalkFunction(walkState.walkThread, walkState);
                if ((walkState.flags & J9Consts.J9_STACKWALK_COUNT_SPECIFIED) != 0L && walkState.framesWalked == walkState.maxFrames) {
                    object = FrameCallbackResult.STOP_ITERATING;
                }
                return object;
            }
            return FrameCallbackResult.STOP_ITERATING;
        }

        @Override
        public void walkBytecodeFrameSlots(WalkState walkState, J9MethodPointer j9MethodPointer, UDATA uDATA, UDATAPointer uDATAPointer, UDATA uDATA2, UDATAPointer uDATAPointer2, UDATA uDATA3) throws CorruptDataException {
            J9ROMClassPointer j9ROMClassPointer = walkState.constantPool.ramClass().romClass();
            J9ROMMethodPointer j9ROMMethodPointer = ROMHelp.getOriginalROMMethod(walkState.method);
            UDATA uDATA4 = uDATA3;
            UDATAPointer uDATAPointer3 = uDATAPointer2.sub(uDATA3);
            StackWalkerUtils.swPrintf(walkState, 3, "\tBytecode index = {0}", uDATA.longValue());
            if (j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccSynchronized)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tSync object for synchronized method", new Object[0]);
                walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
                walkState.slotIndex = -1;
                StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(uDATAPointer3.add(1L)), "Sync O-Slot");
                uDATA4 = uDATA4.sub(1L);
            } else if (J9ROMMethodHelper.isNonEmptyObjectConstructor(j9ROMMethodPointer)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tReceiver object for java.lang.Object.<init>\n", new Object[0]);
                walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
                walkState.slotIndex = -1;
                StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(uDATAPointer3.add(1L)), "Receiver O-Slot");
                uDATA4 = uDATA4.sub(1L);
            }
            StackWalkerUtils.swPrintf(walkState, 200, "numberOfMappedLocals={0}, pendingStackHeight={1}", uDATA4.getHexValue(), uDATA2.getHexValue());
            int n = 0;
            if (uDATA4.gt(32) || uDATA2.gt(32)) {
                UDATA uDATA5 = uDATA4.gt(uDATA2) ? uDATA4 : uDATA2;
                n = uDATA5.add(31L).rightShift(5).intValue();
                if (n <= 0 || (long)n > 65792L) {
                    throw new CorruptDataException("Corrupt frame detected : " + walkState.pc.longValue());
                }
            } else {
                n = 1;
            }
            StackWalkerUtils.swPrintf(walkState, 200, "Result array size = {0}", n);
            int[] nArray = new int[n];
            if (uDATA4.intValue() != 0) {
                StackWalker_29_V0.getLocalsMap(walkState, j9ROMClassPointer, j9ROMMethodPointer, U8Pointer.cast(uDATA), nArray, uDATA4);
                StackWalkerUtils.swPrintf(walkState, 4, "\tLocals starting at {0} for {1} slots", uDATAPointer2.getHexAddress(), uDATA4.getHexValue());
                walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
                walkState.slotIndex = 0;
                this.walkDescribedPushes(walkState, uDATAPointer2, uDATA4.intValue(), nArray, j9ROMMethodPointer.argCount().intValue());
            }
            if (uDATA2.intValue() != 0) {
                this.getStackMap(walkState, j9ROMClassPointer, j9ROMMethodPointer, uDATA, uDATA2, nArray);
                StackWalkerUtils.swPrintf(walkState, 4, "\tPending stack starting at {0} for {1} slots", uDATAPointer.getHexAddress(), uDATA2);
                walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_PENDING;
                walkState.slotIndex = 0;
                this.walkDescribedPushes(walkState, uDATAPointer, uDATA2.intValue(), nArray, 0);
            }
        }

        private void walkBytecodeFrame(WalkState walkState) throws CorruptDataException {
            walkState.method = walkState.literals;
            if (walkState.method.isNull()) {
                walkState.constantPool = J9ConstantPoolPointer.NULL;
                walkState.bytecodePCOffset = U8Pointer.cast(-1L);
                walkState.argCount = new UDATA(0L);
                if (walkState.arg0EA.eq(walkState.j2iFrame)) {
                    walkState.bp = walkState.arg0EA;
                    walkState.unwindSP = walkState.bp.subOffset(J9SFJ2IFrame.SIZEOF).addOffset(UDATA.SIZEOF);
                    walkState.frameFlags = J9SFJ2IFramePointer.cast(walkState.unwindSP).specialFrameFlags();
                    this.printFrameType(walkState, "invokeExact J2I");
                } else {
                    walkState.bp = UDATAPointer.NULL;
                    walkState.unwindSP = UDATAPointer.NULL;
                    walkState.frameFlags = new UDATA(0L);
                    this.printFrameType(walkState, "BAD bytecode (expect crash)");
                }
            } else {
                J9JavaVMPointer j9JavaVMPointer = walkState.walkThread.javaVM();
                walkState.constantPool = ConstantPoolHelpers.J9_CP_FROM_METHOD(walkState.method);
                walkState.bytecodePCOffset = walkState.pc != j9JavaVMPointer.impdep1PC() && walkState.pc != j9JavaVMPointer.impdep1PC().addOffset(3L) ? walkState.pc.sub(walkState.method.bytecodes().getAddress()) : U8Pointer.cast(new UDATA(0L));
                J9ROMMethodPointer j9ROMMethodPointer = ROMHelp.getOriginalROMMethod(walkState.method);
                walkState.argCount = new UDATA(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer));
                UDATA uDATA = new UDATA(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer)).add(walkState.argCount);
                walkState.bp = UDATAPointer.cast(walkState.arg0EA).sub(uDATA);
                if (j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccSynchronized)) {
                    uDATA = uDATA.add(1L);
                    walkState.bp = walkState.bp.sub(1L);
                } else if (J9ROMMethodHelper.isNonEmptyObjectConstructor(j9ROMMethodPointer)) {
                    uDATA = uDATA.add(1L);
                    walkState.bp = walkState.bp.sub(1L);
                }
                if (J9BuildFlags.interp_nativeSupport && walkState.bp.eq(walkState.j2iFrame)) {
                    walkState.unwindSP = walkState.bp.subOffset(J9SFJ2IFrame.SIZEOF).addOffset(UDATA.SIZEOF);
                    walkState.frameFlags = J9SFJ2IFramePointer.cast(walkState.unwindSP).specialFrameFlags();
                } else {
                    walkState.unwindSP = walkState.bp.subOffset(J9SFStackFrame.SIZEOF).addOffset(UDATA.SIZEOF);
                    walkState.frameFlags = new UDATA(0L);
                }
                try {
                    this.printFrameType(walkState, walkState.frameFlags.intValue() != 0 ? "J2I" : "Bytecode");
                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                        StackWalkerUtils.WALK_METHOD_CLASS(walkState);
                        this.walkBytecodeFrameSlots(walkState, walkState.method, new UDATA(walkState.bytecodePCOffset.longValue()), walkState.unwindSP.sub(1L), new UDATA(walkState.unwindSP.sub(walkState.walkSP)), walkState.arg0EA, uDATA);
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkBytecodeFrame", corruptDataException);
                }
            }
        }

        private void getStackMap(WalkState walkState, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, UDATA uDATA, UDATA uDATA2, int[] nArray) throws CorruptDataException {
            int n = StackMap.j9stackmap_StackBitsForPC(uDATA, j9ROMClassPointer, j9ROMMethodPointer, nArray, uDATA2.intValue());
            if (n < 0) {
                throw new AddressedCorruptDataException(j9ROMMethodPointer.getAddress(), "Stack map failed, result = " + n);
            }
        }

        private void walkDescribedPushes(WalkState walkState, UDATAPointer uDATAPointer, int n, int[] nArray, int n2) throws CorruptDataException {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n > 0) {
                if (n3 == 0) {
                    n4 = nArray[n5++];
                    n3 = 32;
                }
                String string = (long)walkState.slotType == J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL ? String.format("%s-Slot: %s%d", (n4 & 1) != 0 ? "O" : "I", walkState.slotIndex >= n2 ? "t" : "a", walkState.slotIndex) : String.format("%s-Slot: p%d", (n4 & 1) != 0 ? "O" : "I", walkState.slotIndex);
                if ((n4 & 1) != 0) {
                    StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(uDATAPointer), string);
                } else {
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(uDATAPointer), string);
                }
                n4 >>= 1;
                --n3;
                uDATAPointer = uDATAPointer.sub(1L);
                --n;
                ++walkState.slotIndex;
            }
        }

        private static void getLocalsMap(WalkState walkState, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, U8Pointer u8Pointer, int[] nArray, UDATA uDATA) throws CorruptDataException {
            int n;
            if (walkState.bp.at(0L).anyBitsIn(J9SFStackFrame.J9SF_A0_INVISIBLE_TAG) || walkState.previousFrameFlags.anyBitsIn(J9Consts.J9_SSF_METHOD_ENTRY)) {
                if (walkState.bp.at(0L).anyBitsIn(J9SFStackFrame.J9SF_A0_INVISIBLE_TAG)) {
                    StackWalkerUtils.swPrintf(walkState, 4, "\tAt method entry (hidden bytecode frame = monitor enter/stack grow), using signature mapper", new Object[0]);
                } else {
                    StackWalkerUtils.swPrintf(walkState, 4, "\tAt method entry (previous frame = report monitor enter), using signature mapper", new Object[0]);
                }
                LocalMap.j9localmap_ArgBitsForPC0(j9ROMMethodPointer, nArray);
                return;
            }
            long l = J9JavaVM.J9VM_DEBUG_ATTRIBUTE_LOCAL_VARIABLE_TABLE;
            if (AlgorithmVersion.getVersionOf("VM_CAN_ACCESS_LOCALS_VERSION").getAlgorithmVersion() >= 1) {
                l = J9JavaVM.J9VM_DEBUG_ATTRIBUTE_CAN_ACCESS_LOCALS;
            }
            if (walkState.walkThread.javaVM().requiredDebugAttributes().anyBitsIn(l)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tUsing debug local mapper", new Object[0]);
                n = DebugLocalMap.j9localmap_DebugLocalBitsForPC(j9ROMMethodPointer, UDATA.cast(u8Pointer), nArray);
            } else {
                StackWalkerUtils.swPrintf(walkState, 4, "\tUsing local mapper", new Object[0]);
                n = LocalMap.j9localmap_LocalBitsForPC(j9ROMMethodPointer, UDATA.cast(u8Pointer), nArray);
            }
            if (n < 0) {
                StackWalkerUtils.swPrintf(walkState, 3, "Local map failed, result = {0}", n);
                throw new CorruptDataException("Local map failed thread " + walkState.walkThread.getHexAddress() + ", romMethod = " + j9ROMMethodPointer.getHexAddress() + ", result - " + n);
            }
        }

        private void walkJNICallInFrame(WalkState walkState) throws CorruptDataException {
            walkState.bp = walkState.arg0EA;
            J9SFJNICallInFramePointer j9SFJNICallInFramePointer = J9SFJNICallInFramePointer.cast(walkState.bp.subOffset(J9SFJNICallInFrame.SIZEOF).addOffset(UDATA.SIZEOF));
            walkState.unwindSP = UDATAPointer.cast(j9SFJNICallInFramePointer.subOffset(UDATA.cast(walkState.literals)));
            walkState.frameFlags = j9SFJNICallInFramePointer.specialFrameFlags();
            this.printFrameType(walkState, "JNI call-in");
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    if (!walkState.walkSP.eq(walkState.unwindSP)) {
                        if (!walkState.pc.eq(walkState.walkThread.javaVM().callInReturnPC().add(3L))) {
                            StackWalkerUtils.swPrintf(walkState, 0, "Error: PC should have been advanced in order to push return value, pc = {0}, cipc = {1} !!!", walkState.pc.getHexAddress(), walkState.walkThread.javaVM().callInReturnPC().getHexAddress());
                        }
                        if (walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_RETURNS_OBJECT)) {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (return value from call-in method)", new Object[0]);
                            StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.walkSP));
                        } else {
                            StackWalkerUtils.swPrintf(walkState, 2, "\tCall-in return value (non-object) takes {0} slots at {1}", UDATA.cast(walkState.unwindSP).sub(UDATA.cast(walkState.walkSP)), walkState.walkSP.getHexAddress());
                        }
                        walkState.walkSP = walkState.unwindSP;
                    }
                    if (walkState.literals.notNull()) {
                        this.walkObjectPushes(walkState);
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkJNICallInFrame", corruptDataException);
                }
            }
            if (J9BuildFlags.interp_nativeSupport) {
                walkState.walkedEntryLocalStorage = walkState.walkedEntryLocalStorage.oldEntryLocalStorage();
                walkState.i2jState = walkState.walkedEntryLocalStorage.getAddress() != 0L ? J9I2JStatePointer.cast(walkState.walkedEntryLocalStorage.i2jStateEA()) : J9I2JStatePointer.cast(0L);
                StackWalkerUtils.swPrintf(walkState, 2, "\tNew ELS = {0}", walkState.walkedEntryLocalStorage.getHexAddress());
            }
            walkState.argCount = new UDATA(0L);
        }

        private void printFrameType(WalkState walkState, String string) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 2, "{0} frame: bp = {1}, sp = {2}, pc = {3}, cp = {4}, arg0EA = {5}, flags = {6}", string, walkState.bp.getHexAddress(), walkState.walkSP.getHexAddress(), walkState.pc.getHexAddress(), walkState.constantPool.getHexAddress(), walkState.arg0EA.getHexAddress(), walkState.frameFlags.getHexValue());
            StackWalkerUtils.swPrintMethod(walkState);
        }

        private void walkJITJNICalloutFrame(WalkState walkState) throws CorruptDataException {
            J9SFMethodFramePointer j9SFMethodFramePointer = J9SFMethodFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
            walkState.argCount = new UDATA(0L);
            walkState.bp = UDATAPointer.cast(j9SFMethodFramePointer.savedA0EA());
            walkState.frameFlags = j9SFMethodFramePointer.specialFrameFlags();
            walkState.method = j9SFMethodFramePointer.method();
            walkState.constantPool = ConstantPoolHelpers.J9_CP_FROM_METHOD(walkState.method);
            this.printFrameType(walkState, "JIT JNI call-out");
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    StackWalkerUtils.WALK_METHOD_CLASS(walkState);
                    if (walkState.literals.notNull()) {
                        this.walkPushedJNIRefs(walkState);
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkJITJNICalloutFrame", corruptDataException);
                }
            }
        }

        private void walkJITResolveFrame(WalkState walkState) throws CorruptDataException {
            J9SFJITResolveFramePointer j9SFJITResolveFramePointer = J9SFJITResolveFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
            walkState.argCount = new UDATA(0L);
            walkState.bp = UDATAPointer.cast(j9SFJITResolveFramePointer.taggedRegularReturnSPEA());
            walkState.frameFlags = j9SFJITResolveFramePointer.specialFrameFlags();
            try {
                this.printFrameType(walkState, "JIT resolve");
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    PointerPointer pointerPointer = j9SFJITResolveFramePointer.savedJITExceptionEA();
                    StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (savedJITException)", new Object[0]);
                    StackWalkerUtils.WALK_O_SLOT(walkState, pointerPointer);
                    if (walkState.literals.notNull()) {
                        this.walkObjectPushes(walkState);
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkJITResolveFrame", corruptDataException);
            }
        }

        private void walkGenericSpecialFrame(WalkState walkState) throws CorruptDataException {
            J9SFSpecialFramePointer j9SFSpecialFramePointer = J9SFSpecialFramePointer.cast(walkState.walkSP.addOffset(UDATA.cast(walkState.literals)));
            walkState.bp = UDATAPointer.cast(j9SFSpecialFramePointer.savedA0EA());
            walkState.frameFlags = j9SFSpecialFramePointer.specialFrameFlags();
            this.printFrameType(walkState, "Generic special");
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L && walkState.literals.notNull()) {
                try {
                    this.walkObjectPushes(walkState);
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "StackWalker_29_V0", "walkGenericSpecialFrame", corruptDataException);
                }
            }
            walkState.argCount = new UDATA(0L);
        }
    }

    private static interface IStackWalker
    extends IAlgorithm {
        public StackWalkResult walkStackFrames(WalkState var1);

        public void walkBytecodeFrameSlots(WalkState var1, J9MethodPointer var2, UDATA var3, UDATAPointer var4, UDATA var5, UDATAPointer var6, UDATA var7) throws CorruptDataException;

        public StackWalkResult walkStackFrames(WalkState var1, UDATAPointer var2, UDATAPointer var3, U8Pointer var4, J9MethodPointer var5, J9VMEntryLocalStoragePointer var6);

        public FrameCallbackResult walkFrame(WalkState var1) throws CorruptDataException;
    }
}

