/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9PortControlDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategoryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategorySetPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRPortLibraryGlobalDataPointer;
import com.ibm.j9ddr.vm29.pointer.helper.OMRMemCategoryHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class MemoryCategoryIterator
implements Iterator<OMRMemCategoryPointer> {
    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public static Iterator<OMRMemCategoryPointer> iterateAllCategories(J9PortLibraryPointer j9PortLibraryPointer) throws CorruptDataException {
        J9PortControlDataPointer j9PortControlDataPointer = j9PortLibraryPointer.omrPortLibrary().portGlobals().control();
        OMRMemCategorySetPointer oMRMemCategorySetPointer = j9PortControlDataPointer.omr_memory_categories();
        OMRMemCategorySetPointer oMRMemCategorySetPointer2 = j9PortControlDataPointer.language_memory_categories();
        if (oMRMemCategorySetPointer.notNull() && oMRMemCategorySetPointer2.notNull()) {
            return IteratorHelpers.combineIterators(new MemoryCategorySetIterator(oMRMemCategorySetPointer), new MemoryCategorySetIterator(oMRMemCategorySetPointer2));
        }
        if (oMRMemCategorySetPointer.notNull()) {
            return new MemoryCategorySetIterator(oMRMemCategorySetPointer);
        }
        if (oMRMemCategorySetPointer2.notNull()) {
            return new MemoryCategorySetIterator(oMRMemCategorySetPointer2);
        }
        return new PortLibraryCategoryIterator(j9PortLibraryPointer);
    }

    public static Iterator<? extends OMRMemCategoryPointer> iterateCategoryRootSet(J9PortLibraryPointer j9PortLibraryPointer) throws CorruptDataException {
        OMRMemCategoryPointer oMRMemCategoryPointer;
        HashMap<UDATA, OMRMemCategoryPointer> hashMap = new HashMap<UDATA, OMRMemCategoryPointer>();
        Iterator<OMRMemCategoryPointer> iterator = MemoryCategoryIterator.iterateAllCategories(j9PortLibraryPointer);
        while (iterator.hasNext()) {
            oMRMemCategoryPointer = iterator.next();
            hashMap.put(oMRMemCategoryPointer.categoryCode(), oMRMemCategoryPointer);
        }
        iterator = MemoryCategoryIterator.iterateAllCategories(j9PortLibraryPointer);
        while (iterator.hasNext()) {
            oMRMemCategoryPointer = iterator.next();
            int n = oMRMemCategoryPointer.numberOfChildren().intValue();
            for (int i = 0; i < n; ++i) {
                UDATA uDATA = oMRMemCategoryPointer.children().at(i);
                hashMap.remove(uDATA);
            }
        }
        return Collections.unmodifiableCollection(hashMap.values()).iterator();
    }

    private static class PortLibraryCategoryIterator
    extends MemoryCategoryIterator {
        protected final J9PortLibraryPointer portLib;
        private State state;

        public PortLibraryCategoryIterator(J9PortLibraryPointer j9PortLibraryPointer) throws CorruptDataException {
            this.portLib = j9PortLibraryPointer;
            this.state = State.PORT_LIBRARY_CATEGORY;
        }

        @Override
        public boolean hasNext() {
            return this.state != State.TERMINAL_STATE;
        }

        private OMRPortLibraryGlobalDataPointer getPortGlobals() throws CorruptDataException {
            return this.portLib.omrPortLibrary().portGlobals();
        }

        @Override
        public OMRMemCategoryPointer next() {
            OMRMemCategoryPointer oMRMemCategoryPointer = null;
            while (oMRMemCategoryPointer == null) {
                try {
                    switch (this.state) {
                        case PORT_LIBRARY_CATEGORY: {
                            oMRMemCategoryPointer = this.getPortGlobals().portLibraryMemoryCategory();
                            break;
                        }
                        case UNKNOWN_CATEGORY: {
                            oMRMemCategoryPointer = this.getPortGlobals().unknownMemoryCategory();
                            break;
                        }
                        case UNUSED_SLAB_CATEGORY: {
                            oMRMemCategoryPointer = OMRMemCategoryHelper.getUnusedAllocate32HeapRegionsMemoryCategory(this.getPortGlobals());
                            break;
                        }
                        case TERMINAL_STATE: {
                            return null;
                        }
                        default: {
                            throw new IllegalStateException("Unknown state: " + (Object)((Object)this.state));
                        }
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("CorruptData encountered walking port library memory categories.", corruptDataException, false);
                }
                this.state = this.state.getNextState();
            }
            return oMRMemCategoryPointer;
        }

        private static enum State {
            TERMINAL_STATE(null),
            UNUSED_SLAB_CATEGORY(TERMINAL_STATE),
            UNKNOWN_CATEGORY(J9BuildFlags.env_data64 ? UNUSED_SLAB_CATEGORY : TERMINAL_STATE),
            PORT_LIBRARY_CATEGORY(UNKNOWN_CATEGORY);

            private final State nextState;

            private State(State state) {
                this.nextState = state;
            }

            public State getNextState() {
                if (this.nextState == null) {
                    return this;
                }
                return this.nextState;
            }
        }
    }

    private static class MemoryCategorySetIterator
    extends MemoryCategoryIterator {
        private int index = 0;
        private final OMRMemCategorySetPointer categorySet;
        private OMRMemCategoryPointer next;

        MemoryCategorySetIterator(OMRMemCategorySetPointer oMRMemCategorySetPointer) throws CorruptDataException {
            this.categorySet = oMRMemCategorySetPointer;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.internalNext();
            return this.next != null;
        }

        private OMRMemCategoryPointer internalNext() {
            try {
                if (this.index >= this.categorySet.numberOfCategories().intValue()) {
                    return null;
                }
            }
            catch (CorruptDataException corruptDataException) {
                return null;
            }
            try {
                VoidPointer voidPointer = this.categorySet.categories().at(this.index++);
                while (voidPointer.isNull() && this.index < this.categorySet.numberOfCategories().intValue()) {
                    voidPointer = this.categorySet.categories().at(this.index++);
                }
                return OMRMemCategoryPointer.cast(voidPointer);
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CorruptData encountered walking port library memory category set.", corruptDataException, false);
                return null;
            }
        }

        @Override
        public OMRMemCategoryPointer next() {
            if (this.hasNext()) {
                OMRMemCategoryPointer oMRMemCategoryPointer = this.next;
                this.next = null;
                return oMRMemCategoryPointer;
            }
            throw new NoSuchElementException();
        }
    }
}

