/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class PointerPointer
extends Pointer {
    public static final PointerPointer NULL = new PointerPointer(0L);

    protected PointerPointer(long l) {
        super(l);
    }

    public static PointerPointer cast(AbstractPointer abstractPointer) {
        return PointerPointer.cast(abstractPointer.getAddress());
    }

    public static PointerPointer cast(UDATA uDATA) {
        return PointerPointer.cast(uDATA.longValue());
    }

    public static PointerPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new PointerPointer(l);
    }

    @Override
    public VoidPointer at(long l) throws CorruptDataException {
        return new VoidPointer(this.getPointerAtOffset(l * SIZEOF));
    }

    @Override
    public VoidPointer at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public PointerPointer untag() {
        return this.untag(SIZEOF - 1L);
    }

    @Override
    public PointerPointer untag(long l) {
        return new PointerPointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public PointerPointer add(long l) {
        return new PointerPointer(this.address + SIZEOF * l);
    }

    @Override
    public PointerPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public PointerPointer addOffset(long l) {
        return new PointerPointer(this.address + l);
    }

    @Override
    public PointerPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public PointerPointer sub(long l) {
        return new PointerPointer(this.address - SIZEOF * l);
    }

    @Override
    public PointerPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public PointerPointer subOffset(long l) {
        return new PointerPointer(this.address - l);
    }

    @Override
    public PointerPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return DataType.process.bytesPerPointer();
    }
}

