/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.util.HashMap;
import java.util.Iterator;

public class J9ClassLoaderHelper {
    private static HashMap<Character, J9ClassPointer> PRIMITIVE_TO_CLASS;

    public static J9ClassPointer findClass(J9ClassLoaderPointer j9ClassLoaderPointer, String string) throws CorruptDataException {
        J9ClassPointer j9ClassPointer;
        J9ClassPointer j9ClassPointer2 = null;
        Iterator<J9ClassPointer> iterator = ClassIterator.fromJ9Classloader(j9ClassLoaderPointer);
        int n = J9ClassLoaderHelper.calculateClassArity(string);
        if (n > 0 && string.charAt(n) != 'L') {
            return PRIMITIVE_TO_CLASS.get(Character.valueOf(string.charAt(n)));
        }
        while (iterator.hasNext() && null == (j9ClassPointer2 = J9ClassLoaderHelper.match(string, n, j9ClassPointer = iterator.next()))) {
        }
        return j9ClassPointer2;
    }

    private static J9ClassPointer match(String string, int n, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        String string2 = J9ClassHelper.getSignature(j9ClassPointer);
        J9ClassPointer j9ClassPointer2 = null;
        if (J9ClassLoaderHelper.matchLeafComponentType(string, n, string2)) {
            j9ClassPointer2 = J9ClassLoaderHelper.getArrayClassWithArity(j9ClassPointer, n);
        }
        return j9ClassPointer2;
    }

    private static J9ClassPointer getArrayClassWithArity(J9ClassPointer j9ClassPointer, int n) throws CorruptDataException {
        J9ClassPointer j9ClassPointer2 = j9ClassPointer;
        for (int i = 0; i < n; ++i) {
            if (!(j9ClassPointer2 = j9ClassPointer2.arrayClass()).isNull()) continue;
            return null;
        }
        return j9ClassPointer2;
    }

    private static boolean matchLeafComponentType(String string, int n, String string2) {
        return string2.regionMatches(0, string, n, string.length() - n);
    }

    private static int calculateClassArity(String string) {
        int n = string.lastIndexOf(91);
        return n + 1;
    }

    static {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            PRIMITIVE_TO_CLASS = new HashMap();
            PRIMITIVE_TO_CLASS.put(Character.valueOf('V'), j9JavaVMPointer.voidReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('Z'), j9JavaVMPointer.booleanReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('B'), j9JavaVMPointer.byteReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('C'), j9JavaVMPointer.charReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('S'), j9JavaVMPointer.shortReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('I'), j9JavaVMPointer.intReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('J'), j9JavaVMPointer.longReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('F'), j9JavaVMPointer.floatReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('D'), j9JavaVMPointer.doubleReflectClass());
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corrupt VM pointer", corruptDataException, true);
        }
    }
}

