/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class ClassloadersSummaryCommand
extends Command {
    public ClassloadersSummaryCommand() {
        this.addCommand("classloaderssummary", "[segs]", "Display classloaders summary, optionally including the RAM and ROM segment breakdown");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            Collection<ClassloadersSummaryNode> collection = this.getStat();
            this.printStat(collection, printStream, stringArray.length > 0 && stringArray[0].equalsIgnoreCase("segs"));
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    public void printStat(Collection<ClassloadersSummaryNode> collection, PrintStream printStream, boolean bl) throws CorruptDataException {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (ClassloadersSummaryNode object2 : collection) {
            n2 = (int)((long)n2 + object2.numClassloaders);
            n = Math.max(n, object2.name.length());
        }
        printStream.println();
        printStream.println("[Classloaders Summary]");
        CommandUtils.dbgPrint(printStream, "<num, %-" + n + "s, # Classloaders, # Loaded Classes", "Classloader name");
        if (bl) {
            CommandUtils.dbgPrint(printStream, ", # RAM Segments, RAM Segment memory, # ROM Segments, ROM Segment memory, Total Segments, Segments memory>" + nl);
        } else {
            CommandUtils.dbgPrint(printStream, ", Total Segments, Segments memory>" + nl);
        }
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        LinkedHashMap<Long, String> linkedHashMap = new LinkedHashMap<Long, String>();
        int n3 = 0;
        for (ClassloadersSummaryNode classloadersSummaryNode : collection) {
            long l5 = classloadersSummaryNode.romSegmentCounter + classloadersSummaryNode.ramSegmentCounter;
            long l6 = classloadersSummaryNode.totalROMSegmentAllocatedMemory + classloadersSummaryNode.totalRAMSegmentAllocatedMemory;
            CommandUtils.dbgPrint(printStream, "%3d)  %-" + n + "s, %-14d, %-16d", n3, classloadersSummaryNode.name, classloadersSummaryNode.numClassloaders, classloadersSummaryNode.numLoadedClasses);
            if (bl) {
                CommandUtils.dbgPrint(printStream, ", %-14d, %-18d, %-14d, %-18d, %-14d, %d" + nl, classloadersSummaryNode.ramSegmentCounter, classloadersSummaryNode.totalRAMSegmentAllocatedMemory, classloadersSummaryNode.romSegmentCounter, classloadersSummaryNode.totalROMSegmentAllocatedMemory, l5, l6);
            } else {
                CommandUtils.dbgPrint(printStream, ", %-14d, %d" + nl, l5, l6);
            }
            l += classloadersSummaryNode.romSegmentCounter;
            l2 += classloadersSummaryNode.ramSegmentCounter;
            l3 += classloadersSummaryNode.totalROMSegmentAllocatedMemory;
            l4 += classloadersSummaryNode.totalRAMSegmentAllocatedMemory;
            Long l7 = (Long)treeMap.get(classloadersSummaryNode.numLoadedClasses);
            if (l7 != null) {
                Long l8 = new Long(l7 + classloadersSummaryNode.numClassloaders);
                treeMap.put(classloadersSummaryNode.numLoadedClasses, l8);
                String string = (String)((HashMap)linkedHashMap).get(classloadersSummaryNode.numLoadedClasses);
                linkedHashMap.put(classloadersSummaryNode.numLoadedClasses, string + ", " + classloadersSummaryNode.name);
            } else {
                treeMap.put(classloadersSummaryNode.numLoadedClasses, classloadersSummaryNode.numClassloaders);
                linkedHashMap.put(classloadersSummaryNode.numLoadedClasses, classloadersSummaryNode.name);
            }
            ++n3;
        }
        if (!treeMap.isEmpty()) {
            printStream.println("\n<# Loaded Classes, # Classloaders, Classloader Names>");
            for (Map.Entry entry : treeMap.entrySet()) {
                CommandUtils.dbgPrint(printStream, "%-17d, %-14d, %s" + nl, entry.getKey(), entry.getValue(), ((HashMap)linkedHashMap).get(entry.getKey()));
            }
        }
        printStream.println();
        printStream.println("Number of Classloaders: " + n2);
        printStream.println();
        printStream.println("Segment Totals: ");
        printStream.println("\n<# RAM Segments, RAM Segments memory, # ROM Segments, ROM Segments memory, Total Segments, Segments memory>");
        CommandUtils.dbgPrint(printStream, " %-14d, %-19d, %-14d, %-19d, %-14d, %d", l2, l4, l, l3, l2 + l, l4 + l3);
        printStream.println();
    }

    public Collection<ClassloadersSummaryNode> getStat() throws CorruptDataException {
        Object object;
        StructurePointer structurePointer;
        Object object2;
        HashMap<J9ClassLoaderPointer, Counter> hashMap = new HashMap<J9ClassLoaderPointer, Counter>();
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
        while (gCClassLoaderIterator.hasNext()) {
            object2 = gCClassLoaderIterator.next();
            hashMap.put((J9ClassLoaderPointer)object2, new Counter(0L));
        }
        object2 = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
        while (((ClassSegmentIterator)object2).hasNext()) {
            structurePointer = (J9ClassPointer)((ClassSegmentIterator)object2).next();
            object = (Counter)hashMap.get(((J9ClassPointer)structurePointer).classLoader());
            if (object != null) {
                ((Counter)object).addOne();
                continue;
            }
            hashMap.put(((J9ClassPointer)structurePointer).classLoader(), new Counter(1L));
        }
        structurePointer = j9JavaVMPointer.systemClassLoader().classLoaderObject();
        object = new UDATA(J9MemorySegment.MEMORY_TYPE_ROM_CLASS);
        UDATA uDATA = new UDATA(J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        LinkedHashMap<String, ClassloadersSummaryNode> linkedHashMap = new LinkedHashMap<String, ClassloadersSummaryNode>();
        for (Map.Entry entry : hashMap.entrySet()) {
            J9ObjectPointer j9ObjectPointer = ((J9ClassLoaderPointer)entry.getKey()).classLoaderObject();
            boolean bl = j9ObjectPointer.equals(structurePointer);
            String string = bl ? "*System*" : J9ObjectHelper.getClassName(j9ObjectPointer);
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            J9MemorySegmentPointer j9MemorySegmentPointer = ((J9ClassLoaderPointer)entry.getKey()).classSegments();
            while (j9MemorySegmentPointer.notNull()) {
                if (j9MemorySegmentPointer.type().bitAnd((UScalar)object).equals(object)) {
                    ++l;
                    l3 += j9MemorySegmentPointer.size().longValue();
                } else if (j9MemorySegmentPointer.type().bitAnd(uDATA).equals(uDATA)) {
                    ++l2;
                    l4 += j9MemorySegmentPointer.size().longValue();
                }
                j9MemorySegmentPointer = j9MemorySegmentPointer.nextSegmentInClassLoader();
            }
            ClassloadersSummaryNode classloadersSummaryNode = (ClassloadersSummaryNode)linkedHashMap.get(string);
            if (classloadersSummaryNode == null) {
                linkedHashMap.put(string, new ClassloadersSummaryNode(string, 1L, ((Counter)entry.getValue()).getCount(), l2, l, l3, l4));
                continue;
            }
            ClassloadersSummaryNode classloadersSummaryNode2 = classloadersSummaryNode;
            Long.valueOf(classloadersSummaryNode2.numClassloaders + 1L);
            classloadersSummaryNode2.numClassloaders = classloadersSummaryNode2.numClassloaders;
            classloadersSummaryNode.numLoadedClasses += ((Counter)entry.getValue()).getCount();
            classloadersSummaryNode.ramSegmentCounter += l2;
            classloadersSummaryNode.romSegmentCounter += l;
            classloadersSummaryNode.totalROMSegmentAllocatedMemory += l3;
            classloadersSummaryNode.totalRAMSegmentAllocatedMemory += l4;
        }
        return linkedHashMap.values();
    }

    public class ClassloadersSummaryNode {
        public String name;
        public Long numClassloaders;
        public long numLoadedClasses;
        public long romSegmentCounter;
        public long ramSegmentCounter;
        public long totalROMSegmentAllocatedMemory;
        public long totalRAMSegmentAllocatedMemory;

        public ClassloadersSummaryNode(String string, Long l, long l2, long l3, long l4, long l5, long l6) {
            this.name = string;
            this.numClassloaders = l;
            this.numLoadedClasses = l2;
            this.romSegmentCounter = l4;
            this.ramSegmentCounter = l3;
            this.totalROMSegmentAllocatedMemory = l5;
            this.totalRAMSegmentAllocatedMemory = l6;
        }
    }

    static final class Counter {
        long count;

        Counter(long l) {
            this.count = l;
        }

        Counter addOne() {
            ++this.count;
            return this;
        }

        long getCount() {
            return this.count;
        }
    }
}

