/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class FindMethodFromPcCommand
extends Command {
    public FindMethodFromPcCommand() {
        this.addCommand("findmethodfrompc", "<pc>", "find the method corresponding to pc");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.env_data64);
            U8Pointer u8Pointer = U8Pointer.cast(l);
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (u8Pointer.isNull()) {
                CommandUtils.dbgPrint(printStream, "bad or missing PC\n");
                return;
            }
            CommandUtils.dbgPrint(printStream, "Searching for PC=%s in VM=%s...\n", u8Pointer.getHexAddress(), j9JavaVMPointer.getHexAddress());
            J9MethodPointer j9MethodPointer = J9JavaVMHelper.getMethodFromPC(j9JavaVMPointer, u8Pointer);
            if (!j9MethodPointer.isNull()) {
                CommandUtils.dbgPrint(printStream, "!j9method %s %s\n", j9MethodPointer.getHexAddress(), J9MethodHelper.getName(j9MethodPointer));
                CommandUtils.dbgPrint(printStream, "Bytecode PC offset = %s\n", u8Pointer.sub(j9MethodPointer.bytecodes()).getHexValue());
            } else {
                CommandUtils.dbgPrint(printStream, "Not found\n");
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

