/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.Iterator;
import java.util.LinkedList;

public class JUCMonitorNode
extends MonitorNode {
    private JavaObject lock;
    private JavaRuntime jr;

    public JUCMonitorNode(JavaObject javaObject, JavaRuntime javaRuntime) {
        this.lock = javaObject;
        this.jr = javaRuntime;
    }

    @Override
    public Iterator getEnterWaiters() {
        LinkedList<JavaThread> linkedList = new LinkedList<JavaThread>();
        Iterator iterator = this.jr.getThreads();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                JavaObject javaObject;
                JavaThread javaThread;
                if (!(e instanceof JavaThread) || ((javaThread = (JavaThread)e).getState() & 0x200) == 0 || (javaObject = javaThread.getBlockingObject()) == null || !javaObject.equals((Object)this.lock)) continue;
                linkedList.add(javaThread);
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailable dataUnavailable) {}
        }
        return linkedList.iterator();
    }

    @Override
    public JavaThread getOwner() throws CorruptDataException, MemoryAccessException {
        return Utils.getParkBlockerOwner(this.lock, this.jr);
    }

    @Override
    public JavaObject getObject() {
        return this.lock;
    }

    @Override
    public String getType() {
        try {
            return this.lock.getJavaClass().getName();
        }
        catch (CorruptDataException corruptDataException) {
            return "<unknown>";
        }
    }
}

