/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.classloader;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.ClassLoaderLineRule;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.ClassLoaderPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.IClassLoaderTypes;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;

public class ClassLoaderTagParser
extends TagParser
implements IClassLoaderTypes {
    public ClassLoaderTagParser() {
        super("CLASSES");
    }

    @Override
    protected void initTagAttributeRules() {
        this.addTag("1CLTEXTCLLOS", null);
        this.addTag("1CLTEXTCLLSS", null);
        this.addTextCLLoader();
        this.addNumberLoadedLib();
        this.addNumberLoadedClasses();
        this.addTag("1CLTEXTCLLIB", null);
        this.addTextCLLib2();
        this.addTextLib();
        this.addTag("1CLTEXTCLLOD", null);
        this.addTextCLLoad();
        this.addTextClass();
    }

    private void addTextCLLoader() {
        ClassLoaderLineRule classLoaderLineRule = new ClassLoaderLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addAllCharactersAsTokenUntilFirstMatch("cl_access_permissions", CommonPatternMatchers.whitespace);
                this.matchLoaderAndAddAttNameAndAddress(ClassLoaderPatternMatchers.system, CommonPatternMatchers.java_absolute_name, "cl_name");
                this.addPrefixedHexToken("cl_address");
                if (this.consumeUntilFirstMatch(ClassLoaderPatternMatchers.shadow)) {
                    this.addPrefixedHexToken("cl_shadow_address");
                } else if (this.consumeUntilFirstMatch(ClassLoaderPatternMatchers.parent)) {
                    this.addAttributeNameAndAddress(ClassLoaderPatternMatchers.none, CommonPatternMatchers.java_absolute_name, "cl_parent_name");
                    this.addPrefixedHexToken("cl_parent_address");
                }
            }
        };
        this.addTag("2CLTEXTCLLOADER", classLoaderLineRule);
    }

    private void addNumberLoadedLib() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addToken("cl_nmbr_ld_lb", CommonPatternMatchers.dec);
            }
        };
        this.addTag("3CLNMBRLOADEDLIB", lineRule);
    }

    private void addNumberLoadedClasses() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addToken("cl_nmbr_ld_cl", CommonPatternMatchers.dec);
            }
        };
        this.addTag("3CLNMBRLOADEDCL", lineRule);
    }

    private void addTextCLLib2() {
        ClassLoaderLineRule classLoaderLineRule = new ClassLoaderLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.matchLoaderAndAddAttNameAndAddress(ClassLoaderPatternMatchers.system, CommonPatternMatchers.java_absolute_name, "cl_name");
                this.addPrefixedHexToken("cl_address");
            }
        };
        this.addTag("2CLTEXTCLLIB", classLoaderLineRule);
    }

    private void addTextLib() {
        ClassLoaderLineRule classLoaderLineRule = new ClassLoaderLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("cl_att_lib_name", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("3CLTEXTLIB", classLoaderLineRule);
    }

    private void addTextCLLoad() {
        ClassLoaderLineRule classLoaderLineRule = new ClassLoaderLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.matchLoaderAndAddAttNameAndAddress(ClassLoaderPatternMatchers.system, CommonPatternMatchers.java_absolute_name, "cl_name");
                this.addPrefixedHexToken("cl_address");
            }
        };
        this.addTag("2CLTEXTCLLOAD", classLoaderLineRule);
    }

    private void addTextClass() {
        ClassLoaderLineRule classLoaderLineRule = new ClassLoaderLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addAttributeNameAndAddress(ClassLoaderPatternMatchers.locked, CommonPatternMatchers.java_absolute_name_array, "class_name");
                this.addPrefixedHexToken("class_address");
            }
        };
        this.addTag("3CLTEXTCLASS", classLoaderLineRule);
    }
}

