/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.phd.PHDCorruptJavaClass;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDJavaClass;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.stream.ImageInputStream;

class PHDJavaClassLoader
implements JavaClassLoader {
    private final Map<Long, JavaClass> classes = new LinkedHashMap<Long, JavaClass>();
    private final Map<Long, JavaClass> arrayClasses = new LinkedHashMap<Long, JavaClass>();
    long maxAddress = Long.MIN_VALUE;
    long minAddress = Long.MAX_VALUE;
    long maxObjClass;
    int maxObjLen;
    long bitsAddress = 0L;
    long maxClassAddress = Long.MIN_VALUE;
    long minClassAddress = Long.MAX_VALUE;
    int minInstanceSize = Integer.MAX_VALUE;
    private final HashMap<String, JavaClass> classNameCache = new LinkedHashMap<String, JavaClass>();
    private final LinkedHashSet<JavaClass> allClasses = new LinkedHashSet();
    private final HashSet<String> duplicateClassNames = new HashSet();
    private JavaObject obj;
    private long jlo;

    PHDJavaClassLoader(ImageInputStream imageInputStream, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime) throws IOException {
        HeapdumpReader heapdumpReader = new HeapdumpReader(imageInputStream, pHDImage);
        this.processData(heapdumpReader, pHDImage, imageAddressSpace, pHDJavaRuntime);
    }

    PHDJavaClassLoader(File file, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime) throws IOException {
        HeapdumpReader heapdumpReader = new HeapdumpReader(file, pHDImage);
        this.processData(heapdumpReader, pHDImage, imageAddressSpace, pHDJavaRuntime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processData(HeapdumpReader heapdumpReader, PHDImage pHDImage, final ImageAddressSpace imageAddressSpace, final PHDJavaRuntime pHDJavaRuntime) throws IOException {
        JavaClass javaClass;
        int n;
        Object object;
        final PHDJavaClassLoader pHDJavaClassLoader = this;
        final int n2 = heapdumpReader.version() == 4 && heapdumpReader.isJ9() ? 1 : 0;
        final int[] nArray = new int[1];
        try {
            heapdumpReader.parse(new PortableHeapDumpListener(){
                long prevAddress;
                PHDJavaClass prevObjClass;

                private void updateSizes(long l) {
                    if (this.prevObjClass != null) {
                        this.prevObjClass.updateSize(this.prevAddress, l);
                    }
                    this.prevObjClass = null;
                    this.prevAddress = l;
                }

                @Override
                public void classDump(long l, long l2, String string, int n, int n22, int n3, LongEnumeration longEnumeration) throws Exception {
                    this.updateSizes(l);
                    PHDJavaClassLoader.this.classes.put(l, new PHDJavaClass.Builder(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, l, l2, string).size(n).flags(n22).hashCode(n3).refs(longEnumeration).build());
                    PHDJavaClassLoader.this.updateAddresses(l, n, string);
                    nArray[0] = nArray[0] + 1;
                }

                @Override
                public void objectArrayDump(long l, long l2, int n, int n22, LongEnumeration longEnumeration, int n3, long l3) throws Exception {
                    int n4 = longEnumeration.numberOfElements();
                    int n5 = Math.min(n2, n4);
                    this.updateSizes(l);
                    PHDJavaClassLoader.this.updateAddresses(l, l2, n3 - n5);
                    long l4 = n5 == 1 ? longEnumeration.nextLong() : 0L;
                    this.genArrayClasses(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, n5, l2, l4);
                }

                @Override
                public void objectDump(long l, long l2, int n, int n22, LongEnumeration longEnumeration, long l3) throws Exception {
                    this.updateSizes(l);
                    PHDJavaClassLoader.this.updateAddresses(l, l2, -1);
                    this.genObjectClass(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, l2, n22);
                }

                @Override
                public void primitiveArrayDump(long l, int n, int n22, int n3, int n4, long l2) throws Exception {
                    this.updateSizes(l);
                    PHDJavaClassLoader.this.updateAddresses(l, n, n22);
                }

                private void genObjectClass(ImageAddressSpace imageAddressSpace2, PHDJavaRuntime pHDJavaRuntime2, JavaClassLoader javaClassLoader, long l, int n) {
                    if (!PHDJavaClassLoader.this.classes.containsKey(l)) {
                        PHDJavaClass pHDJavaClass = new PHDJavaClass.Builder(imageAddressSpace2, pHDJavaRuntime2, javaClassLoader, l, -1L, "]").build();
                        PHDJavaClassLoader.this.classes.put(l, pHDJavaClass);
                        PHDJavaClassLoader.this.updateAddresses(l, 100, null);
                    }
                    this.prevObjClass = (PHDJavaClass)PHDJavaClassLoader.this.findClass(l);
                }

                private PHDJavaClass genArrayClass(ImageAddressSpace imageAddressSpace2, PHDJavaRuntime pHDJavaRuntime2, JavaClassLoader javaClassLoader, long l, long l2, String string) {
                    int n = 100;
                    PHDJavaClass pHDJavaClass = new PHDJavaClass.Builder(imageAddressSpace2, pHDJavaRuntime2, javaClassLoader, l, l2, string).build();
                    PHDJavaClassLoader.this.classes.put(l, pHDJavaClass);
                    PHDJavaClassLoader.this.updateAddresses(l, n, string);
                    return pHDJavaClass;
                }

                private void genArrayClasses(ImageAddressSpace imageAddressSpace2, PHDJavaRuntime pHDJavaRuntime2, JavaClassLoader javaClassLoader, int n, long l, long l2) {
                    if (n == 1) {
                        JavaClass javaClass;
                        String string;
                        if (!PHDJavaClassLoader.this.classes.containsKey(l2)) {
                            string = "[";
                            javaClass = this.genArrayClass(imageAddressSpace2, pHDJavaRuntime2, javaClassLoader, l2, PHDJavaClassLoader.this.jlo, string);
                        } else {
                            javaClass = PHDJavaClassLoader.this.findClass(l2);
                        }
                        PHDJavaClassLoader.this.arrayClasses.put(l, javaClass);
                        if (!PHDJavaClassLoader.this.classes.containsKey(l)) {
                            string = "]";
                            this.genArrayClass(imageAddressSpace2, pHDJavaRuntime2, javaClassLoader, l, -1L, string);
                        }
                    } else {
                        PHDJavaClassLoader.this.arrayClasses.put(l, null);
                    }
                }
            });
        }
        catch (EOFException eOFException) {
            this.classes.put(pHDJavaRuntime.nextDummyClassAddr(), new PHDCorruptJavaClass("Truncated dump found building class " + nArray[0], null, eOFException));
        }
        catch (IOException iOException) {
            this.classes.put(pHDJavaRuntime.nextDummyClassAddr(), new PHDCorruptJavaClass("Corrupted dump found building class " + nArray[0], null, iOException));
        }
        catch (Exception exception) {
            this.classes.put(pHDJavaRuntime.nextDummyClassAddr(), new PHDCorruptJavaClass("Building class " + nArray[0], null, exception));
        }
        finally {
            heapdumpReader.close();
            heapdumpReader = null;
        }
        this.jlo = 0L;
        JavaClass javaClass2 = this.findClassUncached("java/lang/Object");
        if (javaClass2 != null) {
            object = javaClass2.getID();
            if (object != null) {
                this.jlo = object.getAddress();
            }
        } else {
            javaClass2 = new PHDJavaClass.Builder(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, 0L, 0L, "java/lang/Object").build();
            this.jlo = pHDJavaRuntime.nextDummyClassAddr();
            this.classes.put(this.jlo, javaClass2);
        }
        object = this.findClassUncached("java/lang/Class");
        if (object == null) {
            object = new PHDJavaClass.Builder(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, 0L, this.jlo, "java/lang/Class").build();
            this.classes.put(pHDJavaRuntime.nextDummyClassAddr(), (JavaClass)object);
        }
        for (n = 0; n < PHDJavaRuntime.arrayTypeName.length; ++n) {
            Object object2 = this.findClassUncached(PHDJavaRuntime.arrayTypeName[n]);
            if (object2 != null) continue;
            object2 = new PHDJavaClass.Builder(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, 0L, this.jlo, PHDJavaRuntime.arrayTypeName[n]).build();
            this.classes.put(pHDJavaRuntime.nextDummyClassAddr(), (JavaClass)object2);
        }
        n = 1;
        for (Long l : this.arrayClasses.keySet()) {
            javaClass = this.findClass(l);
            if (javaClass == null) continue;
            try {
                if (javaClass.isArray()) continue;
                n = 0;
            }
            catch (CorruptDataException corruptDataException) {
                n = 0;
            }
        }
        for (Long l : this.arrayClasses.keySet()) {
            Object object3;
            Object object4;
            ImagePointer imagePointer;
            Object object5;
            javaClass = this.findClass(l);
            if (javaClass == null) {
                object5 = n != 0 ? "[" : null;
                long l2 = n != 0 ? this.jlo : -1L;
                javaClass = new PHDJavaClass.Builder(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, l, l2, (String)object5).build();
                this.classes.put(l, javaClass);
            }
            if ((object5 = this.arrayClasses.get(l)) != null && (imagePointer = object5.getID()) != null && (object4 = this.findClass(imagePointer.getAddress())) != null) {
                object5 = object4;
            }
            if (n != 0) {
                object3 = javaClass;
            } else if (object5 != null) {
                object3 = object5;
            } else {
                block31: {
                    try {
                        object4 = javaClass.getName();
                        String string = this.arrayName((String)object4);
                        Set<JavaClass> set = this.findClasses(string);
                        if (set.size() == 0) {
                            object3 = new PHDJavaClass.Builder(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, 0L, this.jlo, string).componentType(javaClass).build();
                            break block31;
                        }
                        if (set.size() == 1) {
                            object3 = set.iterator().next();
                            break block31;
                        }
                        object3 = null;
                        for (JavaClass javaClass3 : set) {
                            if (!PHDJavaClass.referencesClass(javaClass3, javaClass)) continue;
                            object3 = javaClass3;
                            break;
                        }
                    }
                    catch (CorruptDataException corruptDataException) {
                        object3 = new PHDJavaClass.Builder(imageAddressSpace, pHDJavaRuntime, pHDJavaClassLoader, 0L, this.jlo, "[").componentType(javaClass).build();
                    }
                }
                if (object3 instanceof PHDJavaClass) {
                    ((PHDJavaClass)object3).setComponentType(javaClass);
                }
            }
            this.arrayClasses.put(l, (JavaClass)object3);
        }
        this.initCache();
    }

    JavaClass setArrayType(PHDJavaRuntime pHDJavaRuntime, PHDJavaClassLoader pHDJavaClassLoader, JavaClass javaClass) {
        long l;
        boolean bl = false;
        JavaClass javaClass2 = null;
        ImagePointer imagePointer = javaClass.getID();
        if (imagePointer != null && this.arrayClasses.containsKey(l = imagePointer.getAddress()) && (javaClass2 = this.arrayClasses.get(l)) == null) {
            Object object;
            block9: {
                try {
                    object = javaClass.getName();
                    String string = this.arrayName((String)object);
                    Set<JavaClass> set = this.findClasses(string);
                    boolean bl2 = bl = set.size() == 0;
                    if (bl) {
                        set = pHDJavaClassLoader.findClasses(string);
                    }
                    if (set.size() == 0) {
                        javaClass2 = new PHDJavaClass.Builder(javaClass.getID().getAddressSpace(), pHDJavaRuntime, this, 0L, this.jlo, string).componentType(javaClass).build();
                        break block9;
                    }
                    if (set.size() == 1) {
                        javaClass2 = set.iterator().next();
                        break block9;
                    }
                    for (JavaClass javaClass3 : set) {
                        if (javaClass2 == null) {
                            javaClass2 = javaClass3;
                        }
                        if (!(javaClass3 instanceof PHDJavaClass) || ((PHDJavaClass)javaClass3).setComponentType(null) != null) continue;
                        javaClass2 = javaClass3;
                        break;
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    javaClass2 = new PHDJavaClass.Builder(javaClass.getID().getAddressSpace(), pHDJavaRuntime, this, 0L, this.jlo, "[").componentType(javaClass).build();
                }
            }
            if (javaClass2 instanceof PHDJavaClass) {
                object = ((PHDJavaClass)javaClass2).setComponentType(javaClass);
            }
            this.arrayClasses.put(l, javaClass2);
        }
        return bl ? javaClass2 : null;
    }

    private String arrayName(String string) {
        String string2 = string.startsWith("[") ? "[" + string : (string.equals("byte") ? "[B" : (string.equals("short") ? "[S" : (string.equals("int") ? "[I" : (string.equals("long") ? "[J" : (string.equals("boolean") ? "[Z" : (string.equals("char") ? "[C" : (string.equals("float") ? "[F" : (string.equals("double") ? "[D" : "[L" + string + ";"))))))));
        return string2;
    }

    PHDJavaClassLoader(JavaObject javaObject) {
        this.obj = javaObject;
    }

    @Override
    public JavaClass findClass(String string) throws CorruptDataException {
        JavaClass javaClass = this.classNameCache.get(string);
        if (javaClass == null && (javaClass = this.findClassUncached(string)) != null) {
            this.classNameCache.put(string, javaClass);
        }
        return javaClass;
    }

    JavaClass findClassUncached(String string) {
        for (JavaClass javaClass : this.classes.values()) {
            try {
                if (!javaClass.getName().equals(string)) continue;
                return javaClass;
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        for (JavaClass javaClass : this.arrayClasses.values()) {
            try {
                if (javaClass == null || !javaClass.getName().equals(string)) continue;
                return javaClass;
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        return null;
    }

    JavaClass findClassUnique(String string) throws CorruptDataException {
        JavaClass javaClass = null;
        if (!this.duplicateClassNames.contains(string)) {
            javaClass = this.classNameCache.get(string);
        }
        return javaClass;
    }

    private Set<JavaClass> findClasses(String string) {
        LinkedHashSet<JavaClass> linkedHashSet = new LinkedHashSet<JavaClass>();
        for (JavaClass javaClass : this.classes.values()) {
            try {
                if (!javaClass.getName().equals(string)) continue;
                linkedHashSet.add(javaClass);
            }
            catch (CorruptDataException corruptDataException) {}
        }
        return linkedHashSet;
    }

    void initCache() {
        this.allClasses.clear();
        this.classNameCache.clear();
        for (JavaClass javaClass : this.classes.values()) {
            this.cacheClass(javaClass);
        }
        for (JavaClass javaClass : this.arrayClasses.values()) {
            if (javaClass == null) continue;
            this.cacheClass(javaClass);
        }
    }

    private void cacheClass(JavaClass javaClass) {
        this.allClasses.add(javaClass);
        try {
            String string = javaClass.getName();
            if (this.classNameCache.containsKey(string)) {
                this.duplicateClassNames.add(string);
            } else {
                this.classNameCache.put(string, javaClass);
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    JavaClass findClass(long l) {
        return this.classes.get(l);
    }

    JavaClass findArrayOfClass(long l) {
        return this.arrayClasses.get(l);
    }

    @Override
    public Iterator<JavaClass> getCachedClasses() {
        return this.getDefinedClasses();
    }

    @Override
    public Iterator<JavaClass> getDefinedClasses() {
        return this.allClasses.iterator();
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        if (this.obj != null && this.obj.getID().getAddress() == 0L) {
            return null;
        }
        return this.obj;
    }

    void prepareToMove(PHDJavaClassLoader pHDJavaClassLoader, JavaClass javaClass) {
        long l;
        JavaClass javaClass2;
        this.setLoader(javaClass);
        ImagePointer imagePointer = javaClass.getID();
        if (imagePointer != null && (javaClass2 = pHDJavaClassLoader.arrayClasses.get(l = imagePointer.getAddress())) != null) {
            this.setLoader(javaClass2);
        }
    }

    private void setLoader(JavaClass javaClass) {
        if (javaClass instanceof PHDJavaClass) {
            PHDJavaClass pHDJavaClass = (PHDJavaClass)javaClass;
            pHDJavaClass.setClassLoader(this);
        }
    }

    void move(PHDJavaClassLoader pHDJavaClassLoader, JavaClass javaClass, long l) {
        ImagePointer imagePointer = javaClass.getID();
        long l2 = 0L;
        if (imagePointer != null) {
            l2 = imagePointer.getAddress();
        } else {
            for (long i = 1L; i <= l; ++i) {
                if (!javaClass.equals(pHDJavaClassLoader.findClass(i))) continue;
                l2 = i;
                break;
            }
        }
        if (l2 != 0L) {
            this.classes.put(l2, javaClass);
            pHDJavaClassLoader.classes.remove(l2);
            if (pHDJavaClassLoader.arrayClasses.containsKey(l2)) {
                this.arrayClasses.put(l2, pHDJavaClassLoader.arrayClasses.remove(l2));
            }
        }
    }

    private void updateAddresses(long l, long l2, int n) {
        if (l > this.maxAddress) {
            this.maxObjClass = l2;
            this.maxObjLen = n;
        }
        this.maxAddress = Math.max(this.maxAddress, l);
        this.minAddress = Math.min(this.minAddress, l);
        this.bitsAddress |= l;
    }

    private void updateAddresses(long l, int n, String string) {
        this.maxClassAddress = Math.max(this.maxClassAddress, l);
        this.minClassAddress = Math.min(this.minClassAddress, l);
        if (string != null && !string.startsWith("[")) {
            this.minInstanceSize = Math.min(this.minInstanceSize, n);
        }
        this.bitsAddress |= l;
    }

    @Override
    public int hashCode() {
        if (this.obj != null) {
            return this.obj.hashCode();
        }
        return (int)(this.minClassAddress ^ this.maxClassAddress);
    }
}

