/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.memory.AbstractMemory;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.SymbolUtil;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;

public abstract class ProcessAddressSpace
extends AbstractMemory
implements IProcess,
IAddressSpace {
    private final int bytesPerPointer;
    private static final int addressSpaceID = 0;
    private final String id;

    public ProcessAddressSpace(int n, ByteOrder byteOrder, ICore iCore) {
        super(byteOrder);
        this.bytesPerPointer = n;
        this.id = iCore.getDumpFormat() + " : 0";
    }

    @Override
    public int bytesPerPointer() {
        return this.bytesPerPointer;
    }

    @Override
    public long getPointerAt(long l) throws MemoryFault {
        if (this.bytesPerPointer() == 8) {
            return this.getLongAt(l);
        }
        return 0xFFFFFFFFL & (long)this.getIntAt(l);
    }

    @Override
    public int getAddressSpaceId() {
        return 0;
    }

    @Override
    public IAddressSpace getAddressSpace() {
        return this;
    }

    public List<IProcess> getProcesses() {
        LinkedList<IProcess> linkedList = new LinkedList<IProcess>();
        linkedList.add(this);
        return linkedList;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public final String getProcedureNameForAddress(long l) throws CorruptDataException {
        return this.getProcedureNameForAddress(l, false);
    }

    @Override
    public String getProcedureNameForAddress(long l, boolean bl) throws CorruptDataException {
        try {
            return SymbolUtil.getProcedureNameForAddress(this, l, bl);
        }
        catch (DataUnavailableException dataUnavailableException) {
            return "<unknown: " + dataUnavailableException.getMessage() + ">";
        }
    }
}

