/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.heapdump.HeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.HeapDumpSettings;
import com.ibm.jvm.dtfjview.heapdump.LongListReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.classic.ClassicHeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpFormatter;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DTFJPlugin(version="1.*", runtime=false)
public class HeapdumpCommand
extends BaseJdmpviewCommand {
    public static final String COMMAND_NAME = "heapdump";
    public static final String DESCRIPTION = "generates a PHD or classic format heapdump";
    public static final String LONG_DESCRIPTION = "Parameters: [heapname+]\n\n\t[heapname+] - space-separated name of heap or heaps to dump. Use \"info heap\" to get the list of heap names. Default: all heaps are dumped.\n\nWrites a heapdump from the memory image.\nThe file name and format are controlled using the \"set heapdump\" command; the current settings can be displayed using \"show heapdump\".\n";
    private static final String PROTECTION_DOMAIN_FIELD_NAME = "protectionDomain";
    private static final Pattern J9_VERSION_PATTERN = Pattern.compile("(IBM J9 VM.*?\\))");
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "char", "float", "double", "byte", "short", "int", "long", "void"};
    private int _numberOfObjects = 0;
    private int _numberOfClasses = 0;
    private int _numberOfErrors = 0;
    private boolean _verbose = false;
    private boolean _is32BitHash;
    private long pdSkipCount;

    public HeapdumpCommand() {
        this.addCommand(COMMAND_NAME, "", DESCRIPTION);
        this.pdSkipCount = 0L;
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        this.doCommand(stringArray);
    }

    public void doCommand(String[] stringArray) {
        HashSet hashSet = new HashSet();
        this._numberOfObjects = 0;
        this._numberOfErrors = 0;
        this._numberOfClasses = 0;
        if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
            this._verbose = true;
        }
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        while (javaRuntime != null) {
            ImageAddressSpace imageAddressSpace = null;
            try {
                imageAddressSpace = javaRuntime.getJavaVM().getAddressSpace();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            if (imageAddressSpace == null) {
                this.out.println("Couldn't get handle on address space");
                break;
            }
            if (!this.heapArgumentsAreValid(javaRuntime, hashSet)) break;
            String string = this.getVersionString(javaRuntime);
            this._is32BitHash = !string.contains("IBM J9 2.3") && !string.contains("IBM J9 2.4") && !string.contains("IBM J9 2.5");
            boolean bl = imageAddressSpace.getCurrentProcess().getPointerSize() == 64;
            String string2 = HeapDumpSettings.getFileName(this.ctx.getProperties());
            boolean bl2 = HeapDumpSettings.areHeapDumpsPHD(this.ctx.getProperties());
            try {
                if (HeapDumpSettings.multipleHeapsInMultipleFiles(this.ctx.getProperties())) {
                    this.dumpMultipleHeapsInSeparateFiles(javaRuntime, string, bl, bl2, string2, hashSet);
                } else {
                    this.dumpMultipleHeapsInOneFile(javaRuntime, string, bl, bl2, string2, hashSet);
                }
                if (this._numberOfErrors == 0) {
                    this.out.print("\nSuccessfully wrote " + this._numberOfObjects + " objects and " + this._numberOfClasses + " classes\n");
                } else {
                    this.out.print("\nWrote " + this._numberOfObjects + " objects and " + this._numberOfClasses + " classes and encountered " + this._numberOfErrors + " errors.\n");
                }
            }
            catch (IOException iOException) {
                this.out.println("I/O error writing dump:\n");
                StringWriter stringWriter = new StringWriter();
                iOException.printStackTrace(new PrintWriter(stringWriter));
                this.out.println(stringWriter.toString());
            }
            javaRuntime = null;
        }
    }

    private boolean heapArgumentsAreValid(JavaRuntime javaRuntime, Set set) {
        Object object;
        Object object2;
        if (set.size() == 0) {
            return true;
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        Iterator iterator = javaRuntime.getHeaps();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof JavaHeap) {
                object = (JavaHeap)object2;
                hashSet.remove(object.getName());
                continue;
            }
            if (object2 instanceof CorruptData) {
                this.reportError("Corrupt heap found. Address = " + ((CorruptData)object2).getAddress(), null);
                ++this._numberOfErrors;
                continue;
            }
            ++this._numberOfErrors;
            this.reportError("Unexpected type " + object2.getClass().getName() + " found in heap iterator", null);
        }
        if (hashSet.isEmpty()) {
            return true;
        }
        object2 = new StringBuffer();
        ((StringBuffer)object2).append("These specified heaps do not exist:\n");
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append("\t\t" + object.next() + "\n");
        }
        ((StringBuffer)object2).append("\tUse \"info heap\" to see list of heap names");
        this.out.println(((StringBuffer)object2).toString());
        return false;
    }

    private String getVersionString(JavaRuntime javaRuntime) {
        try {
            String string = javaRuntime.getVersion();
            Matcher matcher = J9_VERSION_PATTERN.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                return string2;
            }
            return string;
        }
        catch (CorruptDataException corruptDataException) {
            ++this._numberOfErrors;
            this.out.println("Could not read version string from dump: data corrupted at " + corruptDataException.getCorruptData().getAddress());
            return "*Corrupt*";
        }
    }

    private void dumpMultipleHeapsInOneFile(JavaRuntime javaRuntime, String string, boolean bl, boolean bl2, String string2, Set set) throws IOException {
        Iterator iterator = javaRuntime.getHeaps();
        HeapDumpFormatter heapDumpFormatter = this.getFormatter(string2, string, bl, bl2);
        this.out.println("Writing " + (bl2 ? "PHD" : "Classic") + " format heapdump into " + string2);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.out.println("Corrupt heap data found at: " + ((CorruptData)e).getAddress());
                ++this._numberOfErrors;
                continue;
            }
            JavaHeap javaHeap = (JavaHeap)e;
            if (set.size() > 0 && !set.contains(javaHeap.getName())) continue;
            this.dumpHeap(heapDumpFormatter, javaHeap);
        }
        this.dumpClasses(heapDumpFormatter, javaRuntime);
        heapDumpFormatter.close();
    }

    private void dumpMultipleHeapsInSeparateFiles(JavaRuntime javaRuntime, String string, boolean bl, boolean bl2, String string2, Set set) throws IOException {
        Iterator iterator = javaRuntime.getHeaps();
        HeapDumpFormatter heapDumpFormatter = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.out.println("Heap corrupted at: " + ((CorruptData)e).getAddress());
                ++this._numberOfErrors;
                continue;
            }
            JavaHeap javaHeap = (JavaHeap)e;
            if (heapDumpFormatter != null) {
                heapDumpFormatter.close();
            }
            if (set.size() > 0 && !set.contains(javaHeap.getName())) continue;
            String string3 = this.getFileNameForHeap(javaHeap, string2);
            this.out.print("Writing " + (bl2 ? "PHD" : "Classic") + " format heapdump for heap " + javaHeap.getName() + " into " + string3 + "\n");
            heapDumpFormatter = this.getFormatter(string3, string, bl, bl2);
            this.dumpClasses(heapDumpFormatter, javaRuntime);
            this.dumpHeap(heapDumpFormatter, javaHeap);
        }
        if (heapDumpFormatter != null) {
            heapDumpFormatter.close();
        }
    }

    private void dumpClasses(HeapDumpFormatter heapDumpFormatter, JavaRuntime javaRuntime) throws IOException {
        Iterator iterator = javaRuntime.getJavaClassLoaders();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("CorruptData found in classloader list at address: " + ((CorruptData)e).getAddress(), null);
                continue;
            }
            JavaClassLoader javaClassLoader = (JavaClassLoader)e;
            Iterator iterator2 = javaClassLoader.getDefinedClasses();
            while (iterator2.hasNext()) {
                e = iterator2.next();
                ++n;
                try {
                    if (e instanceof CorruptData) {
                        ++this._numberOfErrors;
                        this.reportError("CorruptData found in class list for classloader " + Long.toHexString(javaClassLoader.getObject().getID().getAddress()) + " at address: " + ((CorruptData)e).getAddress(), null);
                        continue;
                    }
                    JavaClass javaClass = (JavaClass)e;
                    JavaClass javaClass2 = javaClass.getSuperclass();
                    JavaObject javaObject = javaClass.getObject();
                    long l = javaClass.isArray() ? 0L : javaClass.getInstanceSize();
                    int n2 = 0;
                    if (this._is32BitHash) {
                        try {
                            n2 = javaObject != null ? (int)javaObject.getPersistentHashcode() : 0;
                        }
                        catch (DataUnavailable dataUnavailable) {}
                    } else {
                        n2 = javaObject != null ? (int)javaObject.getHashcode() : 0;
                    }
                    heapDumpFormatter.addClass(javaObject.getID().getAddress(), javaClass.getName(), javaClass2 != null ? javaClass2.getID().getAddress() : 0L, javaObject != null ? (int)javaObject.getSize() : 0, l, n2, this.getClassReferences(javaClass));
                }
                catch (DTFJException dTFJException) {
                    ++this._numberOfErrors;
                    this.reportError(null, dTFJException);
                }
            }
        }
        this._numberOfClasses = n;
        if (this.pdSkipCount > 0L && this._verbose) {
            this.out.println("Warning : The protection domain information was not available for " + this.pdSkipCount + " classes");
        }
    }

    private void dumpHeap(HeapDumpFormatter heapDumpFormatter, JavaHeap javaHeap) throws IOException {
        Iterator iterator = javaHeap.getObjects();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ++this._numberOfObjects;
            if (e instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("Corrupt object data found at " + ((CorruptData)e).getAddress() + " while walking heap " + javaHeap.getName(), null);
                continue;
            }
            try {
                JavaObject javaObject = (JavaObject)e;
                if (javaObject.getJavaClass().getName().equals("java/lang/Class")) continue;
                JavaClass javaClass = javaObject.getJavaClass();
                JavaObject javaObject2 = javaClass.getObject();
                int n = 0;
                if (this._is32BitHash) {
                    try {
                        n = (int)javaObject.getPersistentHashcode();
                    }
                    catch (DataUnavailable dataUnavailable) {}
                } else {
                    try {
                        n = (int)javaObject.getHashcode();
                    }
                    catch (DataUnavailable dataUnavailable) {
                        ++this._numberOfErrors;
                        this.reportError("Failed to get hashcode for object: " + javaObject.getID(), dataUnavailable);
                    }
                }
                if (javaObject.isArray()) {
                    if (HeapdumpCommand.isPrimitive(javaClass.getComponentType())) {
                        heapDumpFormatter.addPrimitiveArray(javaObject.getID().getAddress(), javaObject2.getID().getAddress(), this.getPrimitiveTypeCode(javaClass.getComponentType()), javaObject.getSize(), n, javaObject.getArraySize());
                        continue;
                    }
                    heapDumpFormatter.addObjectArray(javaObject.getID().getAddress(), javaObject2.getID().getAddress(), javaClass.getName(), javaClass.getComponentType().getObject().getID().getAddress(), javaClass.getComponentType().getName(), javaObject.getSize(), javaObject.getArraySize(), n, this.getObjectReferences(javaObject));
                    continue;
                }
                heapDumpFormatter.addObject(javaObject.getID().getAddress(), javaObject2.getID().getAddress(), javaClass.getName(), (int)javaObject.getSize(), n, this.getObjectReferences(javaObject));
            }
            catch (CorruptDataException corruptDataException) {
                ++this._numberOfErrors;
                this.reportError(null, corruptDataException);
            }
        }
    }

    private ReferenceIterator getClassReferences(JavaClass javaClass) {
        LinkedList<Long> linkedList = new LinkedList<Long>();
        try {
            JavaClass javaClass2;
            Object object;
            this.addReferences(javaClass.getObject(), linkedList);
            this.addStaticReferences(javaClass, linkedList);
            this.addProtectionDomainReference(javaClass, linkedList);
            Iterator iterator = javaClass.getConstantPoolReferences();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof JavaClass)) continue;
                javaClass2 = (JavaClass)object;
                linkedList.add(javaClass2.getObject().getID().getAddress());
            }
            for (object = javaClass.getSuperclass(); null != object; object = object.getSuperclass()) {
                linkedList.add(object.getObject().getID().getAddress());
            }
            javaClass2 = javaClass.getClassLoader();
            if (javaClass2 != null) {
                JavaObject javaObject = javaClass2.getObject();
                if (javaObject != null) {
                    linkedList.add(javaObject.getID().getAddress());
                } else {
                    this.reportError("Null loader object returned for class: " + javaClass.getName() + "(" + javaClass.getID() + ")", null);
                    ++this._numberOfErrors;
                }
            } else {
                this.reportError("Null classloader returned for class: " + javaClass.getName() + "(" + javaClass.getID() + ")", null);
                ++this._numberOfErrors;
            }
        }
        catch (DTFJException dTFJException) {
            this.reportError(null, dTFJException);
            ++this._numberOfErrors;
        }
        return new LongListReferenceIterator(linkedList);
    }

    private void addProtectionDomainReference(JavaClass javaClass, List list) throws CorruptDataException, MemoryAccessException {
        try {
            JavaObject javaObject = javaClass.getProtectionDomain();
            if (javaObject != null) {
                list.add(javaObject.getID().getAddress());
            }
        }
        catch (DataUnavailable dataUnavailable) {
            ++this.pdSkipCount;
        }
    }

    private void addStaticReferences(JavaClass javaClass, List list) throws CorruptDataException, MemoryAccessException {
        Iterator iterator = javaClass.getDeclaredFields();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.reportError("Corrupt field found in class " + javaClass.getName() + "(" + javaClass.getID() + ") at " + ((CorruptData)e).getAddress(), null);
                ++this._numberOfErrors;
                continue;
            }
            JavaField javaField = (JavaField)e;
            if (!Modifier.isStatic(javaField.getModifiers())) continue;
            Object object = javaField.get(javaClass.getObject());
            if (object instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("Corrupt referent found in class " + javaClass.getName() + "(" + javaClass.getID() + ") from field " + javaField.getName() + " at address " + ((CorruptData)e).getAddress(), null);
                continue;
            }
            if (object instanceof JavaObject) {
                JavaObject javaObject = (JavaObject)object;
                list.add(javaObject.getID().getAddress());
                continue;
            }
            if (object == null) {
                list.add(0L);
                continue;
            }
            if (object instanceof Number || object instanceof Boolean || object instanceof Character) continue;
            this.reportError("Unexpected type: " + object.getClass().getName() + " returned from field " + javaField.getName() + " from class " + javaClass.getName() + "(" + javaClass.getID() + ")", null);
            ++this._numberOfErrors;
        }
    }

    private ReferenceIterator getObjectReferences(JavaObject javaObject) {
        LinkedList<Long> linkedList = new LinkedList<Long>();
        try {
            this.addReferences(javaObject, linkedList);
            if (javaObject.getJavaClass().isArray()) {
                Long[] longArray = linkedList.toArray(new Long[0]);
                linkedList.clear();
                for (int i = longArray.length - 1; i >= 0; --i) {
                    linkedList.add(longArray[i]);
                }
            }
        }
        catch (DTFJException dTFJException) {
            ++this._numberOfErrors;
            this.reportError(null, dTFJException);
        }
        return new LongListReferenceIterator(linkedList);
    }

    private void addReferences(JavaObject javaObject, List<Long> list) throws CorruptDataException, MemoryAccessException {
        Iterator iterator = javaObject.getReferences();
        Object object = null;
        if (iterator.hasNext()) {
            object = iterator.next();
        }
        while (iterator.hasNext()) {
            Object object2;
            object = iterator.next();
            if (object instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("Corrupt data found at address " + ((CorruptData)object).getAddress() + " getting references from object at address: " + Long.toHexString(javaObject.getID().getAddress()) + " of class " + javaObject.getJavaClass().getName() + "(" + javaObject.getJavaClass().getID() + ")", null);
                continue;
            }
            if (!(object instanceof JavaReference)) {
                ++this._numberOfErrors;
                this.reportError("Object of unexpected type " + object.getClass() + " found within references from object at address: " + javaObject.getID().getAddress() + " of class " + javaObject.getJavaClass().getName() + "(" + javaObject.getJavaClass().getID() + ")", null);
                continue;
            }
            try {
                object2 = ((JavaReference)object).getTarget();
            }
            catch (DataUnavailable dataUnavailable) {
                ++this._numberOfErrors;
                this.reportError("DataUnavailable thrown from call to getTarget() on reference: " + object, null);
                continue;
            }
            if (object2 instanceof JavaObject) {
                list.add(((JavaObject)object2).getID().getAddress());
                continue;
            }
            if (object2 instanceof JavaClass) {
                list.add(((JavaClass)object2).getID().getAddress());
                continue;
            }
            ++this._numberOfErrors;
            this.reportError("Object of unexpected type " + object2.getClass() + " returned from call to getTarget() on reference " + object, null);
        }
    }

    private static boolean isPrimitive(JavaClass javaClass) throws CorruptDataException {
        String string = javaClass.getName();
        if (string.indexOf("/") != -1) {
            return false;
        }
        for (int i = 0; i != PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private int getPrimitiveTypeCode(JavaClass javaClass) throws CorruptDataException {
        String string = javaClass.getName();
        for (int i = 0; i != PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("Class: " + string + " is not primitive");
    }

    private HeapDumpFormatter getFormatter(String string, String string2, boolean bl, boolean bl2) throws IOException {
        if (bl2) {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            return new PortableHeapDumpFormatter(dataOutputStream, string2, bl, this._is32BitHash);
        }
        return new ClassicHeapDumpFormatter(new FileWriter(string), string2, bl);
    }

    private String getFileNameForHeap(JavaHeap javaHeap, String string) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n) + "." + javaHeap.getName() + string.substring(n);
        }
        return string + "." + javaHeap.getName();
    }

    private void reportError(String string, Throwable throwable) {
        if (!this._verbose) {
            return;
        }
        if (string != null) {
            this.out.println(string);
        }
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.out.println(stringWriter.toString());
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(LONG_DESCRIPTION);
    }
}

